// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_NACL_COMMON_NACL_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_NACL_COMMON_NACL_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace nacl {
namespace mojom {
namespace internal {
using NaClErrorCode_Data =
    mojo::internal::NativeEnum_Data;

#pragma pack(push, 1)
constexpr uint32_t kNaClRendererHost_ReportExitStatus_Name = 0;
class NaClRendererHost_ReportExitStatus_Params_Data {
 public:
  static NaClRendererHost_ReportExitStatus_Params_Data* New(mojo::internal::Buffer* buf) {
    return new (buf->Allocate(sizeof(NaClRendererHost_ReportExitStatus_Params_Data))) NaClRendererHost_ReportExitStatus_Params_Data();
  }

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t exit_status;
  uint8_t padfinal_[4];

 private:
  NaClRendererHost_ReportExitStatus_Params_Data() : header_({sizeof(*this), 0}) {
  }
  ~NaClRendererHost_ReportExitStatus_Params_Data() = delete;
};
static_assert(sizeof(NaClRendererHost_ReportExitStatus_Params_Data) == 16,
              "Bad sizeof(NaClRendererHost_ReportExitStatus_Params_Data)");
class NaClRendererHost_ReportExitStatus_ResponseParams_Data {
 public:
  static NaClRendererHost_ReportExitStatus_ResponseParams_Data* New(mojo::internal::Buffer* buf) {
    return new (buf->Allocate(sizeof(NaClRendererHost_ReportExitStatus_ResponseParams_Data))) NaClRendererHost_ReportExitStatus_ResponseParams_Data();
  }

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  NaClRendererHost_ReportExitStatus_ResponseParams_Data() : header_({sizeof(*this), 0}) {
  }
  ~NaClRendererHost_ReportExitStatus_ResponseParams_Data() = delete;
};
static_assert(sizeof(NaClRendererHost_ReportExitStatus_ResponseParams_Data) == 8,
              "Bad sizeof(NaClRendererHost_ReportExitStatus_ResponseParams_Data)");
constexpr uint32_t kNaClRendererHost_ReportLoadStatus_Name = 1;
class NaClRendererHost_ReportLoadStatus_Params_Data {
 public:
  static NaClRendererHost_ReportLoadStatus_Params_Data* New(mojo::internal::Buffer* buf) {
    return new (buf->Allocate(sizeof(NaClRendererHost_ReportLoadStatus_Params_Data))) NaClRendererHost_ReportLoadStatus_Params_Data();
  }

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t load_status;
  uint8_t padfinal_[4];

 private:
  NaClRendererHost_ReportLoadStatus_Params_Data() : header_({sizeof(*this), 0}) {
  }
  ~NaClRendererHost_ReportLoadStatus_Params_Data() = delete;
};
static_assert(sizeof(NaClRendererHost_ReportLoadStatus_Params_Data) == 16,
              "Bad sizeof(NaClRendererHost_ReportLoadStatus_Params_Data)");
class NaClRendererHost_ReportLoadStatus_ResponseParams_Data {
 public:
  static NaClRendererHost_ReportLoadStatus_ResponseParams_Data* New(mojo::internal::Buffer* buf) {
    return new (buf->Allocate(sizeof(NaClRendererHost_ReportLoadStatus_ResponseParams_Data))) NaClRendererHost_ReportLoadStatus_ResponseParams_Data();
  }

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  NaClRendererHost_ReportLoadStatus_ResponseParams_Data() : header_({sizeof(*this), 0}) {
  }
  ~NaClRendererHost_ReportLoadStatus_ResponseParams_Data() = delete;
};
static_assert(sizeof(NaClRendererHost_ReportLoadStatus_ResponseParams_Data) == 8,
              "Bad sizeof(NaClRendererHost_ReportLoadStatus_ResponseParams_Data)");
constexpr uint32_t kNaClRendererHost_ProvideExitControl_Name = 2;
class NaClRendererHost_ProvideExitControl_Params_Data {
 public:
  static NaClRendererHost_ProvideExitControl_Params_Data* New(mojo::internal::Buffer* buf) {
    return new (buf->Allocate(sizeof(NaClRendererHost_ProvideExitControl_Params_Data))) NaClRendererHost_ProvideExitControl_Params_Data();
  }

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data exit_control;

 private:
  NaClRendererHost_ProvideExitControl_Params_Data() : header_({sizeof(*this), 0}) {
  }
  ~NaClRendererHost_ProvideExitControl_Params_Data() = delete;
};
static_assert(sizeof(NaClRendererHost_ProvideExitControl_Params_Data) == 16,
              "Bad sizeof(NaClRendererHost_ProvideExitControl_Params_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace nacl

#endif  // COMPONENTS_NACL_COMMON_NACL_MOJOM_SHARED_INTERNAL_H_