// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#elif defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4056)
#pragma warning(disable:4065)
#pragma warning(disable:4756)
#endif

#include "components/nacl/common/nacl.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/logging.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/message_builder.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "components/nacl/common/nacl_types_param_traits.h"
namespace nacl {
namespace mojom {
const char NaClRendererHost::Name_[] = "nacl::mojom::NaClRendererHost";
bool NaClRendererHost::ReportExitStatus(int32_t exit_status) {
  NOTREACHED();
  return false;
}
bool NaClRendererHost::ReportLoadStatus(::NaClErrorCode load_status) {
  NOTREACHED();
  return false;
}
class NaClRendererHost_ReportExitStatus_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NaClRendererHost_ReportExitStatus_HandleSyncResponse(
      scoped_refptr<mojo::AssociatedGroupController> group_controller,
      bool* result)
      : serialization_context_(std::move(group_controller)), result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  mojo::internal::SerializationContext serialization_context_;
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NaClRendererHost_ReportExitStatus_HandleSyncResponse);
};
bool NaClRendererHost_ReportExitStatus_HandleSyncResponse::Accept(
    mojo::Message* message) {
  internal::NaClRendererHost_ReportExitStatus_ResponseParams_Data* params =
      reinterpret_cast<internal::NaClRendererHost_ReportExitStatus_ResponseParams_Data*>(
          message->mutable_payload());
  
  (&serialization_context_)->handles.Swap((message)->mutable_handles());
  bool success = true;
  NaClRendererHost_ReportExitStatus_ResponseParamsDataView input_data_view(params,
                                          &serialization_context_);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        "NaClRendererHost::ReportExitStatus response deserializer");
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

class NaClRendererHost_ReportExitStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NaClRendererHost_ReportExitStatus_ForwardToCallback(
      const NaClRendererHost::ReportExitStatusCallback& callback,
      scoped_refptr<mojo::AssociatedGroupController> group_controller)
      : callback_(std::move(callback)),
        serialization_context_(std::move(group_controller)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NaClRendererHost::ReportExitStatusCallback callback_;
  mojo::internal::SerializationContext serialization_context_;
  DISALLOW_COPY_AND_ASSIGN(NaClRendererHost_ReportExitStatus_ForwardToCallback);
};
bool NaClRendererHost_ReportExitStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  internal::NaClRendererHost_ReportExitStatus_ResponseParams_Data* params =
      reinterpret_cast<internal::NaClRendererHost_ReportExitStatus_ResponseParams_Data*>(
          message->mutable_payload());
  
  (&serialization_context_)->handles.Swap((message)->mutable_handles());
  bool success = true;
  NaClRendererHost_ReportExitStatus_ResponseParamsDataView input_data_view(params,
                                          &serialization_context_);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        "NaClRendererHost::ReportExitStatus response deserializer");
    return false;
  }
  if (!callback_.is_null()) {
    mojo::internal::MessageDispatchContext context(message);
    std::move(callback_).Run();
  }
  return true;
}
class NaClRendererHost_ReportLoadStatus_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NaClRendererHost_ReportLoadStatus_HandleSyncResponse(
      scoped_refptr<mojo::AssociatedGroupController> group_controller,
      bool* result)
      : serialization_context_(std::move(group_controller)), result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  mojo::internal::SerializationContext serialization_context_;
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NaClRendererHost_ReportLoadStatus_HandleSyncResponse);
};
bool NaClRendererHost_ReportLoadStatus_HandleSyncResponse::Accept(
    mojo::Message* message) {
  internal::NaClRendererHost_ReportLoadStatus_ResponseParams_Data* params =
      reinterpret_cast<internal::NaClRendererHost_ReportLoadStatus_ResponseParams_Data*>(
          message->mutable_payload());
  
  (&serialization_context_)->handles.Swap((message)->mutable_handles());
  bool success = true;
  NaClRendererHost_ReportLoadStatus_ResponseParamsDataView input_data_view(params,
                                          &serialization_context_);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        "NaClRendererHost::ReportLoadStatus response deserializer");
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

class NaClRendererHost_ReportLoadStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NaClRendererHost_ReportLoadStatus_ForwardToCallback(
      const NaClRendererHost::ReportLoadStatusCallback& callback,
      scoped_refptr<mojo::AssociatedGroupController> group_controller)
      : callback_(std::move(callback)),
        serialization_context_(std::move(group_controller)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NaClRendererHost::ReportLoadStatusCallback callback_;
  mojo::internal::SerializationContext serialization_context_;
  DISALLOW_COPY_AND_ASSIGN(NaClRendererHost_ReportLoadStatus_ForwardToCallback);
};
bool NaClRendererHost_ReportLoadStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  internal::NaClRendererHost_ReportLoadStatus_ResponseParams_Data* params =
      reinterpret_cast<internal::NaClRendererHost_ReportLoadStatus_ResponseParams_Data*>(
          message->mutable_payload());
  
  (&serialization_context_)->handles.Swap((message)->mutable_handles());
  bool success = true;
  NaClRendererHost_ReportLoadStatus_ResponseParamsDataView input_data_view(params,
                                          &serialization_context_);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        "NaClRendererHost::ReportLoadStatus response deserializer");
    return false;
  }
  if (!callback_.is_null()) {
    mojo::internal::MessageDispatchContext context(message);
    std::move(callback_).Run();
  }
  return true;
}

NaClRendererHostProxy::NaClRendererHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NaClRendererHostProxy::ReportExitStatus(
    int32_t param_exit_status) {
   mojo::internal::SerializationContext serialization_context(
      group_controller_);
  size_t size = sizeof(::nacl::mojom::internal::NaClRendererHost_ReportExitStatus_Params_Data);

  mojo::internal::RequestMessageBuilder builder(internal::kNaClRendererHost_ReportExitStatus_Name, size,
                                                mojo::Message::kFlagIsSync);

  auto params =
      ::nacl::mojom::internal::NaClRendererHost_ReportExitStatus_Params_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  params->exit_status = param_exit_status;
  (&serialization_context)->handles.Swap(
      builder.message()->mutable_handles());

  bool result = false;
  mojo::MessageReceiver* responder =
      new NaClRendererHost_ReportExitStatus_HandleSyncResponse(
          group_controller_, &result);
  if (!receiver_->AcceptWithResponder(builder.message(), responder))
    delete responder;
  return result;
}

void NaClRendererHostProxy::ReportExitStatus(
    int32_t in_exit_status, const ReportExitStatusCallback& callback) {
   mojo::internal::SerializationContext serialization_context(
      group_controller_);
  size_t size = sizeof(::nacl::mojom::internal::NaClRendererHost_ReportExitStatus_Params_Data);
  mojo::internal::RequestMessageBuilder builder(internal::kNaClRendererHost_ReportExitStatus_Name, size);

  auto params =
      ::nacl::mojom::internal::NaClRendererHost_ReportExitStatus_Params_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  params->exit_status = in_exit_status;
  (&serialization_context)->handles.Swap(
      builder.message()->mutable_handles());
  mojo::MessageReceiver* responder =
      new NaClRendererHost_ReportExitStatus_ForwardToCallback(
          std::move(callback), group_controller_);
  if (!receiver_->AcceptWithResponder(builder.message(), responder))
    delete responder;
}
bool NaClRendererHostProxy::ReportLoadStatus(
    ::NaClErrorCode param_load_status) {
   mojo::internal::SerializationContext serialization_context(
      group_controller_);
  size_t size = sizeof(::nacl::mojom::internal::NaClRendererHost_ReportLoadStatus_Params_Data);

  mojo::internal::RequestMessageBuilder builder(internal::kNaClRendererHost_ReportLoadStatus_Name, size,
                                                mojo::Message::kFlagIsSync);

  auto params =
      ::nacl::mojom::internal::NaClRendererHost_ReportLoadStatus_Params_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  mojo::internal::Serialize<::nacl::mojom::NaClErrorCode>(
      param_load_status, &params->load_status);
  (&serialization_context)->handles.Swap(
      builder.message()->mutable_handles());

  bool result = false;
  mojo::MessageReceiver* responder =
      new NaClRendererHost_ReportLoadStatus_HandleSyncResponse(
          group_controller_, &result);
  if (!receiver_->AcceptWithResponder(builder.message(), responder))
    delete responder;
  return result;
}

void NaClRendererHostProxy::ReportLoadStatus(
    ::NaClErrorCode in_load_status, const ReportLoadStatusCallback& callback) {
   mojo::internal::SerializationContext serialization_context(
      group_controller_);
  size_t size = sizeof(::nacl::mojom::internal::NaClRendererHost_ReportLoadStatus_Params_Data);
  mojo::internal::RequestMessageBuilder builder(internal::kNaClRendererHost_ReportLoadStatus_Name, size);

  auto params =
      ::nacl::mojom::internal::NaClRendererHost_ReportLoadStatus_Params_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  mojo::internal::Serialize<::nacl::mojom::NaClErrorCode>(
      in_load_status, &params->load_status);
  (&serialization_context)->handles.Swap(
      builder.message()->mutable_handles());
  mojo::MessageReceiver* responder =
      new NaClRendererHost_ReportLoadStatus_ForwardToCallback(
          std::move(callback), group_controller_);
  if (!receiver_->AcceptWithResponder(builder.message(), responder))
    delete responder;
}

void NaClRendererHostProxy::ProvideExitControl(
    NaClExitControlPtr in_exit_control) {
   mojo::internal::SerializationContext serialization_context(
      group_controller_);
  size_t size = sizeof(::nacl::mojom::internal::NaClRendererHost_ProvideExitControl_Params_Data);
  mojo::internal::MessageBuilder builder(internal::kNaClRendererHost_ProvideExitControl_Name, size);

  auto params =
      ::nacl::mojom::internal::NaClRendererHost_ProvideExitControl_Params_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  mojo::internal::Serialize<::nacl::mojom::NaClExitControlPtrDataView>(
      in_exit_control, &params->exit_control, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->exit_control),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid exit_control in NaClRendererHost.ProvideExitControl request");
  (&serialization_context)->handles.Swap(
      builder.message()->mutable_handles());
  bool ok = receiver_->Accept(builder.message());
  // This return value may be ignored as !ok implies the Connector has
  // encountered an error, which will be visible through other means.
  ALLOW_UNUSED_LOCAL(ok);
}
class NaClRendererHost_ReportExitStatus_ProxyToResponder {
 public:
  static NaClRendererHost::ReportExitStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      mojo::MessageReceiverWithStatus* responder,
      scoped_refptr<mojo::AssociatedGroupController>
          group_controller) {
    std::unique_ptr<NaClRendererHost_ReportExitStatus_ProxyToResponder> proxy(
        new NaClRendererHost_ReportExitStatus_ProxyToResponder(
            request_id, is_sync, responder, group_controller));
    return base::Bind(&NaClRendererHost_ReportExitStatus_ProxyToResponder::Run,
                      base::Passed(&proxy));
  }

  ~NaClRendererHost_ReportExitStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // Is the Service destroying the callback without running it
      // and without first closing the pipe?
      responder_->DCheckInvalid("The callback passed to "
          "NaClRendererHost::ReportExitStatus() was never run.");
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    delete responder_;
  }

 private:
  NaClRendererHost_ReportExitStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      mojo::MessageReceiverWithStatus* responder,
      scoped_refptr<mojo::AssociatedGroupController> group_controller)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(responder),
        serialization_context_(std::move(group_controller)) {
  }

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  mojo::MessageReceiverWithStatus* responder_;
  // TODO(yzshen): maybe I should use a ref to the original one?
  mojo::internal::SerializationContext serialization_context_;

  DISALLOW_COPY_AND_ASSIGN(NaClRendererHost_ReportExitStatus_ProxyToResponder);
};

void NaClRendererHost_ReportExitStatus_ProxyToResponder::Run(
    ) {
  size_t size = sizeof(::nacl::mojom::internal::NaClRendererHost_ReportExitStatus_ResponseParams_Data);
  mojo::internal::ResponseMessageBuilder builder(
      internal::kNaClRendererHost_ReportExitStatus_Name, size, request_id_,
      is_sync_ ? mojo::Message::kFlagIsSync : 0);
  auto params =
      ::nacl::mojom::internal::NaClRendererHost_ReportExitStatus_ResponseParams_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  (&serialization_context_)->handles.Swap(
      builder.message()->mutable_handles());
  bool ok = responder_->Accept(builder.message());
  ALLOW_UNUSED_LOCAL(ok);
  // TODO(darin): !ok returned here indicates a malformed message, and that may
  // be good reason to close the connection. However, we don't have a way to do
  // that from here. We should add a way.
  delete responder_;
  responder_ = nullptr;
}
class NaClRendererHost_ReportLoadStatus_ProxyToResponder {
 public:
  static NaClRendererHost::ReportLoadStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      mojo::MessageReceiverWithStatus* responder,
      scoped_refptr<mojo::AssociatedGroupController>
          group_controller) {
    std::unique_ptr<NaClRendererHost_ReportLoadStatus_ProxyToResponder> proxy(
        new NaClRendererHost_ReportLoadStatus_ProxyToResponder(
            request_id, is_sync, responder, group_controller));
    return base::Bind(&NaClRendererHost_ReportLoadStatus_ProxyToResponder::Run,
                      base::Passed(&proxy));
  }

  ~NaClRendererHost_ReportLoadStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // Is the Service destroying the callback without running it
      // and without first closing the pipe?
      responder_->DCheckInvalid("The callback passed to "
          "NaClRendererHost::ReportLoadStatus() was never run.");
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    delete responder_;
  }

 private:
  NaClRendererHost_ReportLoadStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      mojo::MessageReceiverWithStatus* responder,
      scoped_refptr<mojo::AssociatedGroupController> group_controller)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(responder),
        serialization_context_(std::move(group_controller)) {
  }

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  mojo::MessageReceiverWithStatus* responder_;
  // TODO(yzshen): maybe I should use a ref to the original one?
  mojo::internal::SerializationContext serialization_context_;

  DISALLOW_COPY_AND_ASSIGN(NaClRendererHost_ReportLoadStatus_ProxyToResponder);
};

void NaClRendererHost_ReportLoadStatus_ProxyToResponder::Run(
    ) {
  size_t size = sizeof(::nacl::mojom::internal::NaClRendererHost_ReportLoadStatus_ResponseParams_Data);
  mojo::internal::ResponseMessageBuilder builder(
      internal::kNaClRendererHost_ReportLoadStatus_Name, size, request_id_,
      is_sync_ ? mojo::Message::kFlagIsSync : 0);
  auto params =
      ::nacl::mojom::internal::NaClRendererHost_ReportLoadStatus_ResponseParams_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  (&serialization_context_)->handles.Swap(
      builder.message()->mutable_handles());
  bool ok = responder_->Accept(builder.message());
  ALLOW_UNUSED_LOCAL(ok);
  // TODO(darin): !ok returned here indicates a malformed message, and that may
  // be good reason to close the connection. However, we don't have a way to do
  // that from here. We should add a way.
  delete responder_;
  responder_ = nullptr;
}

// static
bool NaClRendererHostStubDispatch::Accept(
    NaClRendererHost* impl,
    mojo::internal::SerializationContext* context,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNaClRendererHost_ReportExitStatus_Name: {
      break;
    }
    case internal::kNaClRendererHost_ReportLoadStatus_Name: {
      break;
    }
    case internal::kNaClRendererHost_ProvideExitControl_Name: {
      internal::NaClRendererHost_ProvideExitControl_Params_Data* params =
          reinterpret_cast<internal::NaClRendererHost_ProvideExitControl_Params_Data*>(
              message->mutable_payload());
      
      (context)->handles.Swap((message)->mutable_handles());
      bool success = true;
      NaClExitControlPtr p_exit_control{};
      NaClRendererHost_ProvideExitControl_ParamsDataView input_data_view(params,
                                              context);
      
      p_exit_control =
          input_data_view.TakeExitControl<decltype(p_exit_control)>();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "NaClRendererHost::ProvideExitControl deserializer");
        return false;
      }
      // A null |impl| means no implementation was bound.
      assert(impl);
      TRACE_EVENT0("mojom", "NaClRendererHost::ProvideExitControl");
      mojo::internal::MessageDispatchContext context(message);
      impl->ProvideExitControl(
std::move(p_exit_control));
      return true;
    }
  }
  return false;
}

// static
bool NaClRendererHostStubDispatch::AcceptWithResponder(
    NaClRendererHost* impl,
    mojo::internal::SerializationContext* context,
    mojo::Message* message,
    mojo::MessageReceiverWithStatus* responder) {
  switch (message->header()->name) {
    case internal::kNaClRendererHost_ReportExitStatus_Name: {
      internal::NaClRendererHost_ReportExitStatus_Params_Data* params =
          reinterpret_cast<internal::NaClRendererHost_ReportExitStatus_Params_Data*>(
              message->mutable_payload());
      
      (context)->handles.Swap((message)->mutable_handles());
      bool success = true;
      int32_t p_exit_status{};
      NaClRendererHost_ReportExitStatus_ParamsDataView input_data_view(params,
                                              context);
      
      p_exit_status = input_data_view.exit_status();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "NaClRendererHost::ReportExitStatus deserializer");
        return false;
      }
      NaClRendererHost::ReportExitStatusCallback callback =
          NaClRendererHost_ReportExitStatus_ProxyToResponder::CreateCallback(
              message->request_id(),
              message->has_flag(mojo::Message::kFlagIsSync), responder,
              context->group_controller);
      // A null |impl| means no implementation was bound.
      assert(impl);
      TRACE_EVENT0("mojom", "NaClRendererHost::ReportExitStatus");
      mojo::internal::MessageDispatchContext context(message);
      impl->ReportExitStatus(
std::move(p_exit_status), std::move(callback));
      return true;
    }
    case internal::kNaClRendererHost_ReportLoadStatus_Name: {
      internal::NaClRendererHost_ReportLoadStatus_Params_Data* params =
          reinterpret_cast<internal::NaClRendererHost_ReportLoadStatus_Params_Data*>(
              message->mutable_payload());
      
      (context)->handles.Swap((message)->mutable_handles());
      bool success = true;
      ::NaClErrorCode p_load_status{};
      NaClRendererHost_ReportLoadStatus_ParamsDataView input_data_view(params,
                                              context);
      
      if (!input_data_view.ReadLoadStatus(&p_load_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "NaClRendererHost::ReportLoadStatus deserializer");
        return false;
      }
      NaClRendererHost::ReportLoadStatusCallback callback =
          NaClRendererHost_ReportLoadStatus_ProxyToResponder::CreateCallback(
              message->request_id(),
              message->has_flag(mojo::Message::kFlagIsSync), responder,
              context->group_controller);
      // A null |impl| means no implementation was bound.
      assert(impl);
      TRACE_EVENT0("mojom", "NaClRendererHost::ReportLoadStatus");
      mojo::internal::MessageDispatchContext context(message);
      impl->ReportLoadStatus(
std::move(p_load_status), std::move(callback));
      return true;
    }
    case internal::kNaClRendererHost_ProvideExitControl_Name: {
      break;
    }
  }
  return false;
}

bool NaClRendererHostRequestValidator::Accept(mojo::Message* message) {
  if (mojo::internal::ControlMessageHandler::IsControlMessage(message))
    return true;

  mojo::internal::ValidationContext validation_context(
    message->data(), message->data_num_bytes(), message->handles()->size(),
    message, "NaClRendererHost RequestValidator");

  switch (message->header()->name) {
    case internal::kNaClRendererHost_ReportExitStatus_Name: {
      if (!mojo::internal::ValidateMessageIsRequestExpectingResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::NaClRendererHost_ReportExitStatus_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    case internal::kNaClRendererHost_ReportLoadStatus_Name: {
      if (!mojo::internal::ValidateMessageIsRequestExpectingResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::NaClRendererHost_ReportLoadStatus_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    case internal::kNaClRendererHost_ProvideExitControl_Name: {
      if (!mojo::internal::ValidateMessageIsRequestWithoutResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::NaClRendererHost_ProvideExitControl_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}

bool NaClRendererHostResponseValidator::Accept(mojo::Message* message) {
  if (mojo::internal::ControlMessageHandler::IsControlMessage(message))
    return true;

  mojo::internal::ValidationContext validation_context(
    message->data(), message->data_num_bytes(), message->handles()->size(),
    message, "NaClRendererHost ResponseValidator");

  if (!mojo::internal::ValidateMessageIsResponse(message, &validation_context))
    return false;
  switch (message->header()->name) {
    case internal::kNaClRendererHost_ReportExitStatus_Name: {
      if (!mojo::internal::ValidateMessagePayload<
               internal::NaClRendererHost_ReportExitStatus_ResponseParams_Data>(
                    message, &validation_context)) {
        return false;
      }
      return true;
    }
    case internal::kNaClRendererHost_ReportLoadStatus_Name: {
      if (!mojo::internal::ValidateMessagePayload<
               internal::NaClRendererHost_ReportLoadStatus_ResponseParams_Data>(
                    message, &validation_context)) {
        return false;
      }
      return true;
    }
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}
const char NaClExitControl::Name_[] = "nacl::mojom::NaClExitControl";

NaClExitControlProxy::NaClExitControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool NaClExitControlStubDispatch::Accept(
    NaClExitControl* impl,
    mojo::internal::SerializationContext* context,
    mojo::Message* message) {
  return false;
}

// static
bool NaClExitControlStubDispatch::AcceptWithResponder(
    NaClExitControl* impl,
    mojo::internal::SerializationContext* context,
    mojo::Message* message,
    mojo::MessageReceiverWithStatus* responder) {
  return false;
}

bool NaClExitControlRequestValidator::Accept(mojo::Message* message) {
  if (mojo::internal::ControlMessageHandler::IsControlMessage(message))
    return true;

  mojo::internal::ValidationContext validation_context(
    message->data(), message->data_num_bytes(), message->handles()->size(),
    message, "NaClExitControl RequestValidator");

  switch (message->header()->name) {
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}

}  // namespace mojom
}  // namespace nacl

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#elif defined(_MSC_VER)
#pragma warning(pop)
#endif