// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_NACL_COMMON_NACL_MOJOM_H_
#define COMPONENTS_NACL_COMMON_NACL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/union_accessor.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/no_interface.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/nacl/common/nacl.mojom-shared.h"
#include <string>
#include <vector>
#include "native_client/src/trusted/service_runtime/nacl_error_code.h"


namespace nacl {
namespace mojom {
class NaClRendererHost;
using NaClRendererHostPtr = mojo::InterfacePtr<NaClRendererHost>;
using NaClRendererHostPtrInfo = mojo::InterfacePtrInfo<NaClRendererHost>;
using ThreadSafeNaClRendererHostPtr =
    mojo::ThreadSafeInterfacePtr<NaClRendererHost>;
using NaClRendererHostRequest = mojo::InterfaceRequest<NaClRendererHost>;
using NaClRendererHostAssociatedPtr =
    mojo::AssociatedInterfacePtr<NaClRendererHost>;
using ThreadSafeNaClRendererHostAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<NaClRendererHost>;
using NaClRendererHostAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<NaClRendererHost>;
using NaClRendererHostAssociatedRequest =
    mojo::AssociatedInterfaceRequest<NaClRendererHost>;

class NaClExitControl;
using NaClExitControlPtr = mojo::InterfacePtr<NaClExitControl>;
using NaClExitControlPtrInfo = mojo::InterfacePtrInfo<NaClExitControl>;
using ThreadSafeNaClExitControlPtr =
    mojo::ThreadSafeInterfacePtr<NaClExitControl>;
using NaClExitControlRequest = mojo::InterfaceRequest<NaClExitControl>;
using NaClExitControlAssociatedPtr =
    mojo::AssociatedInterfacePtr<NaClExitControl>;
using ThreadSafeNaClExitControlAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<NaClExitControl>;
using NaClExitControlAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<NaClExitControl>;
using NaClExitControlAssociatedRequest =
    mojo::AssociatedInterfaceRequest<NaClExitControl>;


class NaClRendererHostProxy;

template <typename ImplRefTraits>
class NaClRendererHostStub;

class NaClRendererHostRequestValidator;
class NaClRendererHostResponseValidator;

class  NaClRendererHost
    : public NaClRendererHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Proxy_ = NaClRendererHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = NaClRendererHostStub<ImplRefTraits>;

  using RequestValidator_ = NaClRendererHostRequestValidator;
  using ResponseValidator_ = NaClRendererHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReportExitStatusMinVersion = 0,
    kReportLoadStatusMinVersion = 0,
    kProvideExitControlMinVersion = 0,
  };
  virtual ~NaClRendererHost() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  virtual bool ReportExitStatus(int32_t exit_status);

  using ReportExitStatusCallback = base::Callback<void()>;
  virtual void ReportExitStatus(int32_t exit_status, const ReportExitStatusCallback& callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  virtual bool ReportLoadStatus(::NaClErrorCode load_status);

  using ReportLoadStatusCallback = base::Callback<void()>;
  virtual void ReportLoadStatus(::NaClErrorCode load_status, const ReportLoadStatusCallback& callback) = 0;

  virtual void ProvideExitControl(NaClExitControlPtr exit_control) = 0;
};

class NaClExitControlProxy;

template <typename ImplRefTraits>
class NaClExitControlStub;

class NaClExitControlRequestValidator;

class  NaClExitControl
    : public NaClExitControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = NaClExitControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = NaClExitControlStub<ImplRefTraits>;

  using RequestValidator_ = NaClExitControlRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };
  virtual ~NaClExitControl() {}
};

class  NaClRendererHostProxy
    : public NaClRendererHost {
 public:
  explicit NaClRendererHostProxy(mojo::MessageReceiverWithResponder* receiver);
  bool ReportExitStatus(int32_t exit_status) override;
  void ReportExitStatus(int32_t exit_status, const ReportExitStatusCallback& callback) override;
  bool ReportLoadStatus(::NaClErrorCode load_status) override;
  void ReportLoadStatus(::NaClErrorCode load_status, const ReportLoadStatusCallback& callback) override;
  void ProvideExitControl(NaClExitControlPtr exit_control) override;

  void set_group_controller(
        scoped_refptr<mojo::AssociatedGroupController> group_controller) {
    group_controller_ = std::move(group_controller);
  }
 private:
  mojo::MessageReceiverWithResponder* receiver_;
  scoped_refptr<mojo::AssociatedGroupController> group_controller_;
};

class  NaClExitControlProxy
    : public NaClExitControl {
 public:
  explicit NaClExitControlProxy(mojo::MessageReceiverWithResponder* receiver);

  void set_group_controller(
        scoped_refptr<mojo::AssociatedGroupController> group_controller) {
    group_controller_ = std::move(group_controller);
  }
 private:
  mojo::MessageReceiverWithResponder* receiver_;
  scoped_refptr<mojo::AssociatedGroupController> group_controller_;
};
class  NaClRendererHostStubDispatch {
 public:
  static bool Accept(NaClRendererHost* impl,
                     mojo::internal::SerializationContext* context,
                     mojo::Message* message);
  static bool AcceptWithResponder(NaClRendererHost* impl,
                                  mojo::internal::SerializationContext* context,
                                  mojo::Message* message,
                                  mojo::MessageReceiverWithStatus* responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NaClRendererHost>>
class NaClRendererHostStub
    : public NON_EXPORTED_BASE(mojo::MessageReceiverWithResponderStatus) {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NaClRendererHostStub() {}
  ~NaClRendererHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  mojo::internal::SerializationContext* serialization_context() {
    return &serialization_context_;
  }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NaClRendererHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), &serialization_context_, message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      mojo::MessageReceiverWithStatus* responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NaClRendererHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), &serialization_context_, message,
        responder);
  }

 private:
  ImplPointerType sink_;
  mojo::internal::SerializationContext serialization_context_;
};
class  NaClExitControlStubDispatch {
 public:
  static bool Accept(NaClExitControl* impl,
                     mojo::internal::SerializationContext* context,
                     mojo::Message* message);
  static bool AcceptWithResponder(NaClExitControl* impl,
                                  mojo::internal::SerializationContext* context,
                                  mojo::Message* message,
                                  mojo::MessageReceiverWithStatus* responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NaClExitControl>>
class NaClExitControlStub
    : public NON_EXPORTED_BASE(mojo::MessageReceiverWithResponderStatus) {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NaClExitControlStub() {}
  ~NaClExitControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  mojo::internal::SerializationContext* serialization_context() {
    return &serialization_context_;
  }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NaClExitControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), &serialization_context_, message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      mojo::MessageReceiverWithStatus* responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NaClExitControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), &serialization_context_, message,
        responder);
  }

 private:
  ImplPointerType sink_;
  mojo::internal::SerializationContext serialization_context_;
};
class  NaClRendererHostRequestValidator : public NON_EXPORTED_BASE(mojo::MessageReceiver) {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NaClExitControlRequestValidator : public NON_EXPORTED_BASE(mojo::MessageReceiver) {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NaClRendererHostResponseValidator : public NON_EXPORTED_BASE(mojo::MessageReceiver) {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace nacl

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_NACL_COMMON_NACL_MOJOM_H_