// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

define("components/nacl/common/nacl.mojom", [
    "mojo/public/js/bindings",
    "mojo/public/js/codec",
    "mojo/public/js/core",
    "mojo/public/js/validator",
], function(bindings, codec, core, validator) {
  var NaClErrorCode = {};

  NaClErrorCode.isKnownEnumValue = function(value) {
    return false;
  };

  NaClErrorCode.validate = function(enumValue) {
    var isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function NaClRendererHost_ReportExitStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NaClRendererHost_ReportExitStatus_Params.prototype.initDefaults_ = function() {
    this.exit_status = 0;
  };
  NaClRendererHost_ReportExitStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NaClRendererHost_ReportExitStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  NaClRendererHost_ReportExitStatus_Params.encodedSize = codec.kStructHeaderSize + 8;

  NaClRendererHost_ReportExitStatus_Params.decode = function(decoder) {
    var packed;
    var val = new NaClRendererHost_ReportExitStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.exit_status = decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NaClRendererHost_ReportExitStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NaClRendererHost_ReportExitStatus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.exit_status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NaClRendererHost_ReportExitStatus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NaClRendererHost_ReportExitStatus_ResponseParams.prototype.initDefaults_ = function() {
  };
  NaClRendererHost_ReportExitStatus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NaClRendererHost_ReportExitStatus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NaClRendererHost_ReportExitStatus_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NaClRendererHost_ReportExitStatus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NaClRendererHost_ReportExitStatus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NaClRendererHost_ReportExitStatus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NaClRendererHost_ReportExitStatus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NaClRendererHost_ReportLoadStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NaClRendererHost_ReportLoadStatus_Params.prototype.initDefaults_ = function() {
    this.load_status = 0;
  };
  NaClRendererHost_ReportLoadStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NaClRendererHost_ReportLoadStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    
    // validate NaClRendererHost_ReportLoadStatus_Params.load_status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, NaClErrorCode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NaClRendererHost_ReportLoadStatus_Params.encodedSize = codec.kStructHeaderSize + 8;

  NaClRendererHost_ReportLoadStatus_Params.decode = function(decoder) {
    var packed;
    var val = new NaClRendererHost_ReportLoadStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.load_status = decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NaClRendererHost_ReportLoadStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NaClRendererHost_ReportLoadStatus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.load_status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NaClRendererHost_ReportLoadStatus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NaClRendererHost_ReportLoadStatus_ResponseParams.prototype.initDefaults_ = function() {
  };
  NaClRendererHost_ReportLoadStatus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NaClRendererHost_ReportLoadStatus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NaClRendererHost_ReportLoadStatus_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  NaClRendererHost_ReportLoadStatus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new NaClRendererHost_ReportLoadStatus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  NaClRendererHost_ReportLoadStatus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NaClRendererHost_ReportLoadStatus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function NaClRendererHost_ProvideExitControl_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NaClRendererHost_ProvideExitControl_Params.prototype.initDefaults_ = function() {
    this.exit_control = new NaClExitControlPtr();
  };
  NaClRendererHost_ProvideExitControl_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NaClRendererHost_ProvideExitControl_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    
    // validate NaClRendererHost_ProvideExitControl_Params.exit_control
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NaClRendererHost_ProvideExitControl_Params.encodedSize = codec.kStructHeaderSize + 8;

  NaClRendererHost_ProvideExitControl_Params.decode = function(decoder) {
    var packed;
    var val = new NaClRendererHost_ProvideExitControl_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.exit_control = decoder.decodeStruct(new codec.Interface(NaClExitControlPtr));
    return val;
  };

  NaClRendererHost_ProvideExitControl_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NaClRendererHost_ProvideExitControl_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(NaClExitControlPtr), val.exit_control);
  };
  var kNaClRendererHost_ReportExitStatus_Name = 0;
  var kNaClRendererHost_ReportLoadStatus_Name = 1;
  var kNaClRendererHost_ProvideExitControl_Name = 2;

  function NaClRendererHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NaClRendererHost,
                                                   handleOrPtrInfo);
  }

  function NaClRendererHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  NaClRendererHostPtr.prototype.reportExitStatus = function() {
    return NaClRendererHostProxy.prototype.reportExitStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  NaClRendererHostProxy.prototype.reportExitStatus = function(exit_status) {
    var params = new NaClRendererHost_ReportExitStatus_Params();
    params.exit_status = exit_status;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageWithRequestIDBuilder(
          kNaClRendererHost_ReportExitStatus_Name,
          codec.align(NaClRendererHost_ReportExitStatus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NaClRendererHost_ReportExitStatus_Params, params);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NaClRendererHost_ReportExitStatus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NaClRendererHostPtr.prototype.reportLoadStatus = function() {
    return NaClRendererHostProxy.prototype.reportLoadStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  NaClRendererHostProxy.prototype.reportLoadStatus = function(load_status) {
    var params = new NaClRendererHost_ReportLoadStatus_Params();
    params.load_status = load_status;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageWithRequestIDBuilder(
          kNaClRendererHost_ReportLoadStatus_Name,
          codec.align(NaClRendererHost_ReportLoadStatus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(NaClRendererHost_ReportLoadStatus_Params, params);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(NaClRendererHost_ReportLoadStatus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  NaClRendererHostPtr.prototype.provideExitControl = function() {
    return NaClRendererHostProxy.prototype.provideExitControl
        .apply(this.ptr.getProxy(), arguments);
  };

  NaClRendererHostProxy.prototype.provideExitControl = function(exit_control) {
    var params = new NaClRendererHost_ProvideExitControl_Params();
    params.exit_control = exit_control;
    var builder = new codec.MessageBuilder(
        kNaClRendererHost_ProvideExitControl_Name,
        codec.align(NaClRendererHost_ProvideExitControl_Params.encodedSize));
    builder.encodeStruct(NaClRendererHost_ProvideExitControl_Params, params);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NaClRendererHostStub(delegate) {
    this.delegate_ = delegate;
  }
  NaClRendererHostStub.prototype.reportExitStatus = function(exit_status) {
    return this.delegate_ && this.delegate_.reportExitStatus && this.delegate_.reportExitStatus(exit_status);
  }
  NaClRendererHostStub.prototype.reportLoadStatus = function(load_status) {
    return this.delegate_ && this.delegate_.reportLoadStatus && this.delegate_.reportLoadStatus(load_status);
  }
  NaClRendererHostStub.prototype.provideExitControl = function(exit_control) {
    return this.delegate_ && this.delegate_.provideExitControl && this.delegate_.provideExitControl(exit_control);
  }

  NaClRendererHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNaClRendererHost_ProvideExitControl_Name:
      var params = reader.decodeStruct(NaClRendererHost_ProvideExitControl_Params);
      this.provideExitControl(params.exit_control);
      return true;
    default:
      return false;
    }
  };

  NaClRendererHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNaClRendererHost_ReportExitStatus_Name:
      var params = reader.decodeStruct(NaClRendererHost_ReportExitStatus_Params);
      return this.reportExitStatus(params.exit_status).then(function(response) {
        var responseParams =
            new NaClRendererHost_ReportExitStatus_ResponseParams();
        var builder = new codec.MessageWithRequestIDBuilder(
            kNaClRendererHost_ReportExitStatus_Name,
            codec.align(NaClRendererHost_ReportExitStatus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NaClRendererHost_ReportExitStatus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
    case kNaClRendererHost_ReportLoadStatus_Name:
      var params = reader.decodeStruct(NaClRendererHost_ReportLoadStatus_Params);
      return this.reportLoadStatus(params.load_status).then(function(response) {
        var responseParams =
            new NaClRendererHost_ReportLoadStatus_ResponseParams();
        var builder = new codec.MessageWithRequestIDBuilder(
            kNaClRendererHost_ReportLoadStatus_Name,
            codec.align(NaClRendererHost_ReportLoadStatus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(NaClRendererHost_ReportLoadStatus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
    default:
      return Promise.reject(Error("Unhandled message: " + reader.messageName));
    }
  };

  function validateNaClRendererHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNaClRendererHost_ReportExitStatus_Name:
        if (message.expectsResponse())
          paramsClass = NaClRendererHost_ReportExitStatus_Params;
      break;
      case kNaClRendererHost_ReportLoadStatus_Name:
        if (message.expectsResponse())
          paramsClass = NaClRendererHost_ReportLoadStatus_Params;
      break;
      case kNaClRendererHost_ProvideExitControl_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NaClRendererHost_ProvideExitControl_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNaClRendererHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kNaClRendererHost_ReportExitStatus_Name:
        if (message.isResponse())
          paramsClass = NaClRendererHost_ReportExitStatus_ResponseParams;
        break;
      case kNaClRendererHost_ReportLoadStatus_Name:
        if (message.isResponse())
          paramsClass = NaClRendererHost_ReportLoadStatus_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var NaClRendererHost = {
    name: 'nacl::mojom::NaClRendererHost',
    ptrClass: NaClRendererHostPtr,
    proxyClass: NaClRendererHostProxy,
    stubClass: NaClRendererHostStub,
    validateRequest: validateNaClRendererHostRequest,
    validateResponse: validateNaClRendererHostResponse,
  };
  NaClRendererHostStub.prototype.validator = validateNaClRendererHostRequest;
  NaClRendererHostProxy.prototype.validator = validateNaClRendererHostResponse;

  function NaClExitControlPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NaClExitControl,
                                                   handleOrPtrInfo);
  }

  function NaClExitControlProxy(receiver) {
    this.receiver_ = receiver;
  }

  function NaClExitControlStub(delegate) {
    this.delegate_ = delegate;
  }

  NaClExitControlStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  NaClExitControlStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return Promise.reject(Error("Unhandled message: " + reader.messageName));
    }
  };

  function validateNaClExitControlRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validateNaClExitControlResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var NaClExitControl = {
    name: 'nacl::mojom::NaClExitControl',
    ptrClass: NaClExitControlPtr,
    proxyClass: NaClExitControlProxy,
    stubClass: NaClExitControlStub,
    validateRequest: validateNaClExitControlRequest,
    validateResponse: null,
  };
  NaClExitControlStub.prototype.validator = validateNaClExitControlRequest;
  NaClExitControlProxy.prototype.validator = null;

  var exports = {};
  exports.NaClErrorCode = NaClErrorCode;
  exports.NaClRendererHost = NaClRendererHost;
  exports.NaClRendererHostPtr = NaClRendererHostPtr;
  exports.NaClExitControl = NaClExitControl;
  exports.NaClExitControlPtr = NaClExitControlPtr;

  return exports;
});