// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

define("mojo/common/text_direction.mojom", [
    "mojo/public/js/bindings",
    "mojo/public/js/codec",
    "mojo/public/js/core",
    "mojo/public/js/validator",
], function(bindings, codec, core, validator) {
  var TextDirection = {};
  TextDirection.UNKNOWN_DIRECTION = 0;
  TextDirection.RIGHT_TO_LEFT = TextDirection.UNKNOWN_DIRECTION + 1;
  TextDirection.LEFT_TO_RIGHT = TextDirection.RIGHT_TO_LEFT + 1;

  TextDirection.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  TextDirection.validate = function(enumValue) {
    var isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };


  var exports = {};
  exports.TextDirection = TextDirection;

  return exports;
});