// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#elif defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4056)
#pragma warning(disable:4065)
#pragma warning(disable:4756)
#endif

#include "services/service_manager/public/interfaces/service_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/logging.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/message_builder.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "mojo/common/common_custom_types_struct_traits.h"
#include "services/service_manager/public/cpp/service_info_struct_traits.h"
#include "services/service_manager/public/cpp/interface_provider_spec_struct_traits.h"
#include "ipc/ipc_message_utils.h"
#include "services/service_manager/public/cpp/identity_struct_traits.h"
#include "mojo/common/values_struct_traits.h"
namespace service_manager {
namespace mojom {
const char ServiceControl::Name_[] = "service_manager::mojom::ServiceControl";

ServiceControlProxy::ServiceControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceControlProxy::RequestQuit(
    ) {
   mojo::internal::SerializationContext serialization_context(
      group_controller_);
  size_t size = sizeof(::service_manager::mojom::internal::ServiceControl_RequestQuit_Params_Data);
  mojo::internal::MessageBuilder builder(internal::kServiceControl_RequestQuit_Name, size);

  auto params =
      ::service_manager::mojom::internal::ServiceControl_RequestQuit_Params_Data::New(builder.buffer());
  ALLOW_UNUSED_LOCAL(params);
  (&serialization_context)->handles.Swap(
      builder.message()->mutable_handles());
  bool ok = receiver_->Accept(builder.message());
  // This return value may be ignored as !ok implies the Connector has
  // encountered an error, which will be visible through other means.
  ALLOW_UNUSED_LOCAL(ok);
}

// static
bool ServiceControlStubDispatch::Accept(
    ServiceControl* impl,
    mojo::internal::SerializationContext* context,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kServiceControl_RequestQuit_Name: {
      internal::ServiceControl_RequestQuit_Params_Data* params =
          reinterpret_cast<internal::ServiceControl_RequestQuit_Params_Data*>(
              message->mutable_payload());
      
      (context)->handles.Swap((message)->mutable_handles());
      bool success = true;
      ServiceControl_RequestQuit_ParamsDataView input_data_view(params,
                                              context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            "ServiceControl::RequestQuit deserializer");
        return false;
      }
      // A null |impl| means no implementation was bound.
      assert(impl);
      TRACE_EVENT0("mojom", "ServiceControl::RequestQuit");
      mojo::internal::MessageDispatchContext context(message);
      impl->RequestQuit();
      return true;
    }
  }
  return false;
}

// static
bool ServiceControlStubDispatch::AcceptWithResponder(
    ServiceControl* impl,
    mojo::internal::SerializationContext* context,
    mojo::Message* message,
    mojo::MessageReceiverWithStatus* responder) {
  switch (message->header()->name) {
    case internal::kServiceControl_RequestQuit_Name: {
      break;
    }
  }
  return false;
}

bool ServiceControlRequestValidator::Accept(mojo::Message* message) {
  if (mojo::internal::ControlMessageHandler::IsControlMessage(message))
    return true;

  mojo::internal::ValidationContext validation_context(
    message->data(), message->data_num_bytes(), message->handles()->size(),
    message, "ServiceControl RequestValidator");

  switch (message->header()->name) {
    case internal::kServiceControl_RequestQuit_Name: {
      if (!mojo::internal::ValidateMessageIsRequestWithoutResponse(
              message, &validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateMessagePayload<
               internal::ServiceControl_RequestQuit_Params_Data>(
                  message, &validation_context)) {
        return false;
      }
      return true;
    }
    default:
      break;
  }

  // Unrecognized message.
  ReportValidationError(
      &validation_context,
      mojo::internal::VALIDATION_ERROR_MESSAGE_HEADER_UNKNOWN_METHOD);
  return false;
}

}  // namespace mojom
}  // namespace service_manager

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#elif defined(_MSC_VER)
#pragma warning(pop)
#endif