// cc/mojom/browser_controls_offset_tag_modifications.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'cc/mojom/browser_controls_offset_tag_modifications.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('cc.mojom');
  var browser_controls_offset_tags$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/browser_controls_offset_tags.mojom', 'browser_controls_offset_tags.mojom.js');
  }



  function BrowserControlsOffsetTagModifications(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BrowserControlsOffsetTagModifications.prototype.initDefaults_ = function() {
    this.tags = null;
    this.topControlsAdditionalHeight = 0;
    this.bottomControlsAdditionalHeight = 0;
  };
  BrowserControlsOffsetTagModifications.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BrowserControlsOffsetTagModifications.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BrowserControlsOffsetTagModifications.tags
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, browser_controls_offset_tags$.BrowserControlsOffsetTags, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  BrowserControlsOffsetTagModifications.encodedSize = codec.kStructHeaderSize + 16;

  BrowserControlsOffsetTagModifications.decode = function(decoder) {
    var packed;
    var val = new BrowserControlsOffsetTagModifications();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tags =
        decoder.decodeStructPointer(browser_controls_offset_tags$.BrowserControlsOffsetTags);
    val.topControlsAdditionalHeight =
        decoder.decodeStruct(codec.Int32);
    val.bottomControlsAdditionalHeight =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  BrowserControlsOffsetTagModifications.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BrowserControlsOffsetTagModifications.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(browser_controls_offset_tags$.BrowserControlsOffsetTags, val.tags);
    encoder.encodeStruct(codec.Int32, val.topControlsAdditionalHeight);
    encoder.encodeStruct(codec.Int32, val.bottomControlsAdditionalHeight);
  };
  exports.BrowserControlsOffsetTagModifications = BrowserControlsOffsetTagModifications;
})();