// cc/mojom/browser_controls_offset_tags.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'cc/mojom/browser_controls_offset_tags.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('cc.mojom');
  var offset_tag$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/offset_tag.mojom', '../../services/viz/public/mojom/compositing/offset_tag.mojom.js');
  }



  function BrowserControlsOffsetTags(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BrowserControlsOffsetTags.prototype.initDefaults_ = function() {
    this.topControlsOffsetTag = null;
    this.contentOffsetTag = null;
    this.bottomControlsOffsetTag = null;
  };
  BrowserControlsOffsetTags.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BrowserControlsOffsetTags.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BrowserControlsOffsetTags.topControlsOffsetTag
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, offset_tag$.OffsetTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BrowserControlsOffsetTags.contentOffsetTag
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, offset_tag$.OffsetTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BrowserControlsOffsetTags.bottomControlsOffsetTag
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, offset_tag$.OffsetTag, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BrowserControlsOffsetTags.encodedSize = codec.kStructHeaderSize + 24;

  BrowserControlsOffsetTags.decode = function(decoder) {
    var packed;
    var val = new BrowserControlsOffsetTags();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.topControlsOffsetTag =
        decoder.decodeStructPointer(offset_tag$.OffsetTag);
    val.contentOffsetTag =
        decoder.decodeStructPointer(offset_tag$.OffsetTag);
    val.bottomControlsOffsetTag =
        decoder.decodeStructPointer(offset_tag$.OffsetTag);
    return val;
  };

  BrowserControlsOffsetTags.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BrowserControlsOffsetTags.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(offset_tag$.OffsetTag, val.topControlsOffsetTag);
    encoder.encodeStructPointer(offset_tag$.OffsetTag, val.contentOffsetTag);
    encoder.encodeStructPointer(offset_tag$.OffsetTag, val.bottomControlsOffsetTag);
  };
  exports.BrowserControlsOffsetTags = BrowserControlsOffsetTags;
})();