// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./service_list.js";import"./object_fieldset.js";import{$}from"chrome://resources/js/util.js";import{DeviceRemote}from"./device.mojom-webui.js";import{connectToDevice}from"./device_broker.js";import{ConnectionStatus}from"./device_collection.js";import{formatManufacturerDataMap,formatServiceUuids}from"./device_utils.js";import{ObjectFieldSetElement}from"./object_fieldset.js";import{Page}from"./page.js";import{showSnackbar,SnackbarType}from"./snackbar.js";const PROPERTY_NAMES={name:"Name",address:"Address",isGattConnected:"GATT Connected","rssi.value":"Latest RSSI",serviceUuids:"Services",manufacturerDataMap:"Manufacturer Data"};export class DeviceDetailsPage extends Page{constructor(id,deviceInfo){super(id,deviceInfo.nameForDisplay,id);this.deviceInfo=deviceInfo;this.services=null;this.device_=null;this.deviceFieldSet_=document.createElement("object-field-set");this.deviceFieldSet_.toggleAttribute("show-all",true);this.deviceFieldSet_.dataset.nameMap=JSON.stringify(PROPERTY_NAMES);this.serviceList_=document.createElement("service-list");this.status_=ConnectionStatus.DISCONNECTED;this.connectBtn_=null;this.pageDiv.appendChild(document.importNode($("device-details-template").content,true));this.pageDiv.querySelector(".device-details").appendChild(this.deviceFieldSet_);this.pageDiv.querySelector(".services").appendChild(this.serviceList_);this.pageDiv.querySelector(".forget").addEventListener("click",function(){this.disconnect();this.pageDiv.dispatchEvent(new CustomEvent("forgetpressed",{detail:{address:this.deviceInfo.address}}))}.bind(this));this.connectBtn_=this.pageDiv.querySelector(".disconnect");this.connectBtn_.addEventListener("click",function(){this.device_!==null?this.disconnect():this.connect()}.bind(this));this.redraw()}connect(){if(this.status_!==ConnectionStatus.DISCONNECTED){return}this.updateConnectionStatus_(ConnectionStatus.CONNECTING);connectToDevice(this.deviceInfo.address).then(function(device){this.device_=device;this.updateConnectionStatus_(ConnectionStatus.CONNECTED);return this.device_.getServices()}.bind(this)).then(function(response){this.services=response.services;this.serviceList_.load(this.deviceInfo.address);this.redraw();this.fireDeviceInfoChanged_()}.bind(this)).catch(function(error){if(this.device_){this.device_.disconnect();this.device_=null}showSnackbar(this.deviceInfo.nameForDisplay+": "+error.message,SnackbarType.ERROR,"Retry",this.connect.bind(this));this.updateConnectionStatus_(ConnectionStatus.DISCONNECTED)}.bind(this))}disconnect(){if(!this.device_){return}this.device_.disconnect();this.device_=null;this.updateConnectionStatus_(ConnectionStatus.DISCONNECTED)}redraw(){const isConnected=this.deviceInfo.isGattConnected;if(isConnected){this.connect()}else{this.disconnect()}const connectedText=isConnected?"Connected":"Not Connected";const rssi=this.deviceInfo.rssi||{};let rssiValue="Unknown";if(rssi.value!=null&&rssi.value<=0){rssiValue=rssi.value}const serviceUuidsText=formatServiceUuids(this.deviceInfo.serviceUuids);const manufacturerDataMapText=formatManufacturerDataMap(this.deviceInfo.manufacturerDataMap);const deviceViewObj={name:this.deviceInfo.nameForDisplay,address:this.deviceInfo.address,isGattConnected:connectedText,"rssi.value":rssiValue,serviceUuids:serviceUuidsText,manufacturerDataMap:manufacturerDataMapText};this.deviceFieldSet_.dataset.value=JSON.stringify(deviceViewObj)}setDeviceInfo(info){this.deviceInfo=info;this.redraw()}fireDeviceInfoChanged_(){this.pageDiv.dispatchEvent(new CustomEvent("infochanged",{bubbles:true,detail:{info:this.deviceInfo}}))}updateConnectionStatus_(status){if(this.status_===status){return}this.status_=status;if(status===ConnectionStatus.DISCONNECTED){this.connectBtn_.textContent="Connect";this.connectBtn_.disabled=false}else if(status===ConnectionStatus.CONNECTING){this.connectBtn_.textContent="Connecting";this.connectBtn_.disabled=true}else{this.connectBtn_.textContent="Disconnect";this.connectBtn_.disabled=false}this.pageDiv.dispatchEvent(new CustomEvent("connectionchanged",{bubbles:true,detail:{address:this.deviceInfo.address,status:status}}))}}