// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{listenOnce}from"chrome://resources/js/util.js";import{getTemplate}from"./snackbar.html.js";let SnackbarOptions;const SHOW_DURATION=5e3;const TRANSITION_DURATION=225;export const SnackbarType={INFO:"info",SUCCESS:"success",WARNING:"warning",ERROR:"error"};class BluetoothSnackbarElement extends CustomElement{static get template(){return getTemplate()}static get is(){return"bluetooth-snackbar"}constructor(){super();this.boundStartTimeout_=null;this.boundStopTimeout_=null;this.timeoutId_=null;this.options_=null}connectedCallback(){assert(this.options_);this.shadowRoot.querySelector("#message").textContent=this.options_.message;this.classList.add(this.options_.type);const actionLink=this.shadowRoot.querySelector("a");actionLink.textContent=this.options_.actionText||"Dismiss";actionLink.addEventListener("click",(()=>{if(this.options_.action){this.options_.action()}this.dismiss()}));this.boundStartTimeout_=this.startTimeout_.bind(this);this.boundStopTimeout_=this.stopTimeout_.bind(this);this.addEventListener("mouseleave",this.boundStartTimeout_);this.addEventListener("mouseenter",this.boundStopTimeout_);this.timeoutId_=null}initialize(options){this.options_=options}show(){this.classList.add("open");if(hasContentFocus){this.startTimeout_()}else{this.stopTimeout_()}document.addEventListener("contentfocus",this.boundStartTimeout_);document.addEventListener("contentblur",this.boundStopTimeout_);this.dispatchEvent(new CustomEvent("showed",{bubbles:true,composed:true}))}ensureTransitionEndEvent_(){let fired=false;this.addEventListener("transitionend",function f(e){this.removeEventListener("transitionend",f);fired=true}.bind(this));window.setTimeout((()=>{if(!fired){this.dispatchEvent(new CustomEvent("transitionend",{bubbles:true,composed:true}))}}),TRANSITION_DURATION)}dismiss(){this.stopTimeout_();if(!this.classList.contains("open")){return Promise.resolve()}return new Promise(function(resolve){listenOnce(this,"transitionend",function(){this.dispatchEvent(new CustomEvent("dismissed"));resolve()}.bind(this));this.ensureTransitionEndEvent_();this.classList.remove("open");document.removeEventListener("contentfocus",this.boundStartTimeout_);document.removeEventListener("contentblur",this.boundStopTimeout_)}.bind(this))}startTimeout_(){this.timeoutId_=setTimeout(function(){this.dismiss()}.bind(this),SHOW_DURATION)}stopTimeout_(){if(this.classList.contains("open")){clearTimeout(this.timeoutId_);this.timeoutId_=null}}}customElements.define("bluetooth-snackbar",BluetoothSnackbarElement);let current=null;let queue=[];let hasContentFocus=true;document.addEventListener("contentfocus",(function(){hasContentFocus=true}));document.addEventListener("contentblur",(function(){hasContentFocus=false}));export function getSnackbarStateForTest(){return{current:current,numPending:queue.length}}export function showSnackbar(message,opt_type,opt_actionText,opt_action){const options={message:message,type:opt_type||SnackbarType.INFO,actionText:opt_actionText,action:opt_action};const newSnackbar=document.createElement("bluetooth-snackbar");newSnackbar.initialize(options);if(current){queue.push(newSnackbar)}else{show(newSnackbar)}return newSnackbar}window.showSnackbar=showSnackbar;function show(snackbar){document.body.querySelector("#snackbar-container").appendChild(snackbar);snackbar.addEventListener("dismissed",(function(){const container=document.body.querySelector("#snackbar-container");if(container){container.removeChild(current)}const newSnackbar=queue.shift();if(container&&newSnackbar){show(newSnackbar);return}current=null}));current=snackbar;setTimeout((function(){snackbar.show()}),10)}export function dismissSnackbar(clearQueue){if(clearQueue){queue=[]}if(current){return current.dismiss()}return Promise.resolve()}