// chrome/browser/resources/certificate_manager/certificate_manager.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const CertificateSourceSpec = { $: mojo.internal.Enum() };
export var CertificateSource;
(function (CertificateSource) {
    CertificateSource[CertificateSource["MIN_VALUE"] = 1] = "MIN_VALUE";
    CertificateSource[CertificateSource["MAX_VALUE"] = 12] = "MAX_VALUE";
    CertificateSource[CertificateSource["kChromeRootStore"] = 1] = "kChromeRootStore";
    CertificateSource[CertificateSource["kPlatformClientCert"] = 2] = "kPlatformClientCert";
    CertificateSource[CertificateSource["kEnterpriseTrustedCerts"] = 3] = "kEnterpriseTrustedCerts";
    CertificateSource[CertificateSource["kEnterpriseIntermediateCerts"] = 4] = "kEnterpriseIntermediateCerts";
    CertificateSource[CertificateSource["kEnterpriseDistrustedCerts"] = 5] = "kEnterpriseDistrustedCerts";
    CertificateSource[CertificateSource["kPlatformUserTrustedCerts"] = 6] = "kPlatformUserTrustedCerts";
    CertificateSource[CertificateSource["kPlatformUserIntermediateCerts"] = 7] = "kPlatformUserIntermediateCerts";
    CertificateSource[CertificateSource["kPlatformUserDistrustedCerts"] = 8] = "kPlatformUserDistrustedCerts";
    CertificateSource[CertificateSource["kProvisionedClientCert"] = 9] = "kProvisionedClientCert";
    CertificateSource[CertificateSource["kUserTrustedCerts"] = 10] = "kUserTrustedCerts";
    CertificateSource[CertificateSource["kUserIntermediateCerts"] = 11] = "kUserIntermediateCerts";
    CertificateSource[CertificateSource["kUserDistrustedCerts"] = 12] = "kUserDistrustedCerts";
})(CertificateSource || (CertificateSource = {}));
export const SuccessResultSpec = { $: mojo.internal.Enum() };
export var SuccessResult;
(function (SuccessResult) {
    SuccessResult[SuccessResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    SuccessResult[SuccessResult["MAX_VALUE"] = 0] = "MAX_VALUE";
    SuccessResult[SuccessResult["kSuccess"] = 0] = "kSuccess";
})(SuccessResult || (SuccessResult = {}));
export class CertificateManagerPageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'certificate_manager.mojom.CertificateManagerPageHandlerFactory', scope);
    }
}
export class CertificateManagerPageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CertificateManagerPageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createCertificateManagerPageHandler(page, handler) {
        this.proxy.sendMessage(0, CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CertificateManagerPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertificateManagerPageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CertificateManagerPageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$, null, impl.createCertificateManagerPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CertificateManagerPageHandlerFactory {
    static get $interfaceName() {
        return "certificate_manager.mojom.CertificateManagerPageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CertificateManagerPageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CertificateManagerPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertificateManagerPageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createCertificateManagerPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CertificateManagerPageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createCertificateManagerPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$, null, this.createCertificateManagerPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CertificateManagerPageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'certificate_manager.mojom.CertificateManagerPageHandler', scope);
    }
}
export class CertificateManagerPageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CertificateManagerPageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getCertificates(source) {
        return this.proxy.sendMessage(0, CertificateManagerPageHandler_GetCertificates_ParamsSpec.$, CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$, [
            source
        ], false);
    }
    getCertManagementMetadata() {
        return this.proxy.sendMessage(1, CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$, CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$, [], false);
    }
    viewCertificate(source, sha256HashHex) {
        this.proxy.sendMessage(2, CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$, null, [
            source,
            sha256HashHex
        ], false);
    }
    exportCertificates(source) {
        this.proxy.sendMessage(3, CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$, null, [
            source
        ], false);
    }
    importCertificate(source) {
        return this.proxy.sendMessage(4, CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$, CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$, [
            source
        ], false);
    }
    importAndBindCertificate(source) {
        return this.proxy.sendMessage(5, CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$, CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$, [
            source
        ], false);
    }
    deleteCertificate(source, displayName, sha256HashHex) {
        return this.proxy.sendMessage(6, CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$, CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$, [
            source,
            displayName,
            sha256HashHex
        ], false);
    }
    setIncludeSystemTrustStore(include) {
        this.proxy.sendMessage(7, CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$, null, [
            include
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CertificateManagerPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertificateManagerPageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CertificateManagerPageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CertificateManagerPageHandler_GetCertificates_ParamsSpec.$, CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$, impl.getCertificates.bind(impl), false);
        this.helper_internal_.registerHandler(1, CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$, CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$, impl.getCertManagementMetadata.bind(impl), false);
        this.helper_internal_.registerHandler(2, CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$, null, impl.viewCertificate.bind(impl), false);
        this.helper_internal_.registerHandler(3, CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$, null, impl.exportCertificates.bind(impl), false);
        this.helper_internal_.registerHandler(4, CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$, CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$, impl.importCertificate.bind(impl), false);
        this.helper_internal_.registerHandler(5, CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$, CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$, impl.importAndBindCertificate.bind(impl), false);
        this.helper_internal_.registerHandler(6, CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$, CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$, impl.deleteCertificate.bind(impl), false);
        this.helper_internal_.registerHandler(7, CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$, null, impl.setIncludeSystemTrustStore.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CertificateManagerPageHandler {
    static get $interfaceName() {
        return "certificate_manager.mojom.CertificateManagerPageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CertificateManagerPageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CertificateManagerPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertificateManagerPageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getCertificates;
    getCertManagementMetadata;
    viewCertificate;
    exportCertificates;
    importCertificate;
    importAndBindCertificate;
    deleteCertificate;
    setIncludeSystemTrustStore;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CertificateManagerPageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getCertificates =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CertificateManagerPageHandler_GetCertificates_ParamsSpec.$, CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$, this.getCertificates.createReceiverHandler(true /* expectsResponse */), false);
        this.getCertManagementMetadata =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$, CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$, this.getCertManagementMetadata.createReceiverHandler(true /* expectsResponse */), false);
        this.viewCertificate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$, null, this.viewCertificate.createReceiverHandler(false /* expectsResponse */), false);
        this.exportCertificates =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$, null, this.exportCertificates.createReceiverHandler(false /* expectsResponse */), false);
        this.importCertificate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$, CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$, this.importCertificate.createReceiverHandler(true /* expectsResponse */), false);
        this.importAndBindCertificate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$, CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$, this.importAndBindCertificate.createReceiverHandler(true /* expectsResponse */), false);
        this.deleteCertificate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$, CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$, this.deleteCertificate.createReceiverHandler(true /* expectsResponse */), false);
        this.setIncludeSystemTrustStore =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$, null, this.setIncludeSystemTrustStore.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CertificateManagerPagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'certificate_manager.mojom.CertificateManagerPage', scope);
    }
}
export class CertificateManagerPageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CertificateManagerPagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    askForImportPassword() {
        return this.proxy.sendMessage(0, CertificateManagerPage_AskForImportPassword_ParamsSpec.$, CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$, [], false);
    }
    askForConfirmation(title, message) {
        return this.proxy.sendMessage(1, CertificateManagerPage_AskForConfirmation_ParamsSpec.$, CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$, [
            title,
            message
        ], false);
    }
    triggerReload(sources) {
        this.proxy.sendMessage(2, CertificateManagerPage_TriggerReload_ParamsSpec.$, null, [
            sources
        ], false);
    }
    triggerMetadataUpdate() {
        this.proxy.sendMessage(3, CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the CertificateManagerPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertificateManagerPageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CertificateManagerPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CertificateManagerPage_AskForImportPassword_ParamsSpec.$, CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$, impl.askForImportPassword.bind(impl), false);
        this.helper_internal_.registerHandler(1, CertificateManagerPage_AskForConfirmation_ParamsSpec.$, CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$, impl.askForConfirmation.bind(impl), false);
        this.helper_internal_.registerHandler(2, CertificateManagerPage_TriggerReload_ParamsSpec.$, null, impl.triggerReload.bind(impl), false);
        this.helper_internal_.registerHandler(3, CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$, null, impl.triggerMetadataUpdate.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CertificateManagerPage {
    static get $interfaceName() {
        return "certificate_manager.mojom.CertificateManagerPage";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CertificateManagerPageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CertificateManagerPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertificateManagerPageCallbackRouter {
    helper_internal_;
    $;
    router_;
    askForImportPassword;
    askForConfirmation;
    triggerReload;
    triggerMetadataUpdate;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CertificateManagerPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.askForImportPassword =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CertificateManagerPage_AskForImportPassword_ParamsSpec.$, CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$, this.askForImportPassword.createReceiverHandler(true /* expectsResponse */), false);
        this.askForConfirmation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, CertificateManagerPage_AskForConfirmation_ParamsSpec.$, CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$, this.askForConfirmation.createReceiverHandler(true /* expectsResponse */), false);
        this.triggerReload =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, CertificateManagerPage_TriggerReload_ParamsSpec.$, null, this.triggerReload.createReceiverHandler(false /* expectsResponse */), false);
        this.triggerMetadataUpdate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$, null, this.triggerMetadataUpdate.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const SummaryCertInfoSpec = { $: {} };
export const CertManagementMetadataSpec = { $: {} };
export const CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_GetCertificates_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec = { $: {} };
export const CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec = { $: {} };
export const CertificateManagerPageHandler_ViewCertificate_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_ExportCertificates_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_ImportCertificate_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec = { $: {} };
export const CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec = { $: {} };
export const CertificateManagerPageHandler_DeleteCertificate_ParamsSpec = { $: {} };
export const CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec = { $: {} };
export const CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec = { $: {} };
export const CertificateManagerPage_AskForImportPassword_ParamsSpec = { $: {} };
export const CertificateManagerPage_AskForImportPassword_ResponseParamsSpec = { $: {} };
export const CertificateManagerPage_AskForConfirmation_ParamsSpec = { $: {} };
export const CertificateManagerPage_AskForConfirmation_ResponseParamsSpec = { $: {} };
export const CertificateManagerPage_TriggerReload_ParamsSpec = { $: {} };
export const CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec = { $: {} };
export const ActionResultSpec = { $: {} };
mojo.internal.Struct(SummaryCertInfoSpec.$, 'SummaryCertInfo', [
    mojo.internal.StructField('sha256hashHex', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDeletable', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(CertManagementMetadataSpec.$, 'CertManagementMetadata', [
    mojo.internal.StructField('includeSystemTrustStore', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numUserAddedSystemCerts', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isIncludeSystemTrustStoreManaged', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numPolicyCerts', 2, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numUserCerts', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showUserCertsUi', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$, 'CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(CertificateManagerPageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(CertificateManagerPageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CertificateManagerPageHandler_GetCertificates_ParamsSpec.$, 'CertificateManagerPageHandler_GetCertificates_Params', [
    mojo.internal.StructField('source', 0, 0, CertificateSourceSpec.$, 1, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$, 'CertificateManagerPageHandler_GetCertificates_ResponseParams', [
    mojo.internal.StructField('certs', 0, 0, mojo.internal.Array(SummaryCertInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$, 'CertificateManagerPageHandler_GetCertManagementMetadata_Params', [], [[0, 8],]);
mojo.internal.Struct(CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$, 'CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams', [
    mojo.internal.StructField('metadata', 0, 0, CertManagementMetadataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$, 'CertificateManagerPageHandler_ViewCertificate_Params', [
    mojo.internal.StructField('source', 0, 0, CertificateSourceSpec.$, 1, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sha256HashHex', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$, 'CertificateManagerPageHandler_ExportCertificates_Params', [
    mojo.internal.StructField('source', 0, 0, CertificateSourceSpec.$, 1, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$, 'CertificateManagerPageHandler_ImportCertificate_Params', [
    mojo.internal.StructField('source', 0, 0, CertificateSourceSpec.$, 1, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$, 'CertificateManagerPageHandler_ImportCertificate_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ActionResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$, 'CertificateManagerPageHandler_ImportAndBindCertificate_Params', [
    mojo.internal.StructField('source', 0, 0, CertificateSourceSpec.$, 1, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$, 'CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ActionResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$, 'CertificateManagerPageHandler_DeleteCertificate_Params', [
    mojo.internal.StructField('source', 0, 0, CertificateSourceSpec.$, 1, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('displayName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sha256HashHex', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$, 'CertificateManagerPageHandler_DeleteCertificate_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ActionResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$, 'CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params', [
    mojo.internal.StructField('include', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPage_AskForImportPassword_ParamsSpec.$, 'CertificateManagerPage_AskForImportPassword_Params', [], [[0, 8],]);
mojo.internal.Struct(CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$, 'CertificateManagerPage_AskForImportPassword_ResponseParams', [
    mojo.internal.StructField('password', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPage_AskForConfirmation_ParamsSpec.$, 'CertificateManagerPage_AskForConfirmation_Params', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('message', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$, 'CertificateManagerPage_AskForConfirmation_ResponseParams', [
    mojo.internal.StructField('confirmed', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPage_TriggerReload_ParamsSpec.$, 'CertificateManagerPage_TriggerReload_Params', [
    mojo.internal.StructField('sources', 0, 0, mojo.internal.Array(CertificateSourceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$, 'CertificateManagerPage_TriggerMetadataUpdate_Params', [], [[0, 8],]);
mojo.internal.Union(ActionResultSpec.$, 'ActionResult', {
    'error': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'success': {
        'ordinal': 1,
        'type': SuccessResultSpec.$,
    },
});
export var ActionResultFieldTags;
(function (ActionResultFieldTags) {
    ActionResultFieldTags[ActionResultFieldTags["ERROR"] = 0] = "ERROR";
    ActionResultFieldTags[ActionResultFieldTags["SUCCESS"] = 1] = "SUCCESS";
})(ActionResultFieldTags || (ActionResultFieldTags = {}));
export function whichActionResult(u) {
    if (u.error !== null && u.error !== undefined) {
        return ActionResultFieldTags.ERROR;
    }
    if (u.success !== null && u.success !== undefined) {
        return ActionResultFieldTags.SUCCESS;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
