// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"chrome://resources/cr_elements/cr_tab_box/cr_tab_box.js";import"chrome://resources/cr_elements/cr_tree/cr_tree.js";import"chrome://resources/cr_elements/cr_tree/cr_tree_item.js";import"./browser_proxy.js";import"./modifications_panel.js";import{assert}from"chrome://resources/js/assert.js";import{sendWithPromise}from"chrome://resources/js/cr.js";export var CertificateTrust;(function(CertificateTrust){CertificateTrust[CertificateTrust["CERTIFICATE_TRUST_DISTRUSTED"]=0]="CERTIFICATE_TRUST_DISTRUSTED";CertificateTrust[CertificateTrust["CERTIFICATE_TRUST_UNSPECIFIED"]=1]="CERTIFICATE_TRUST_UNSPECIFIED";CertificateTrust[CertificateTrust["CERTIFICATE_TRUST_TRUSTED"]=2]="CERTIFICATE_TRUST_TRUSTED"})(CertificateTrust||(CertificateTrust={}));function initialize(){const tabBox=document.querySelector("cr-tab-box");assert(tabBox);tabBox.hidden=false;const args=JSON.parse(chrome.getVariableValue("dialogArguments"));getCertificateInfo(args);getCertificateMetadata(args);const initializeDetailTab=oneShot((function(){const hierarchy=document.querySelector("#hierarchy");assert(hierarchy);initializeTree(hierarchy,showCertificateFields);const certFields=document.querySelector("#cert-fields");assert(certFields);initializeTree(certFields,showCertificateFieldValue);createCertificateHierarchy(args.hierarchy)}));setTimeout(initializeDetailTab,200);tabBox.addEventListener("selected-index-change",(function f(){tabBox.removeEventListener("selected-index-change",f);initializeDetailTab()}),true);stripGtkAccessorKeys();const exportButton=document.querySelector("#export");assert(exportButton);exportButton.onclick=exportCertificate}function getCertificateMetadata(certInfo){const modificationsTab=document.querySelector("#modifications-tab");assert(modificationsTab);if(certInfo.certMetadata===undefined){modificationsTab.remove();const modifications=document.querySelector("#modifications");assert(modifications);modifications.remove();return}modificationsTab.hidden=false;const modificationsPanel=document.querySelector("modifications-panel");assert(modificationsPanel);modificationsPanel.trustStateValue=certInfo.certMetadata.trust.toString();if(certInfo.certMetadata.isEditable){modificationsPanel.isEditable=true}if(certInfo.certMetadata.constraints!==undefined){modificationsPanel.constraints=certInfo.certMetadata.constraints}}function oneShot(fn){let fired=false;return function(){if(fired){return}fired=true;fn()}}function initializeTree(tree,handler){tree.detail={payload:{},children:{}};tree.addEventListener("cr-tree-change",handler)}function stripGtkAccessorKeys(){const tabs=document.querySelectorAll("div[slot='tab']");const nodes=Array.prototype.slice.call(tabs,0);const exportButton=document.querySelector("#export");nodes.push(exportButton);for(let i=0;i<nodes.length;i++){nodes[i].textContent=nodes[i].textContent.replace("&","")}}function revealTree(tree){tree.expanded=true;const detail=tree.detail;for(const key in detail.children){revealTree(detail.children[key])}}function getCertificateInfo(certInfo){const generalError=document.querySelector("#general-error");assert(generalError);generalError.hidden=!certInfo.isError;const generalFields=document.querySelector("#general-fields");assert(generalFields);generalFields.hidden=certInfo.isError;for(const key in certInfo.general){const el=document.querySelector(`#${key}`);assert(el);el.textContent=certInfo.general[key]}}function createCertificateHierarchy(hierarchy){const tree=document.querySelector("#hierarchy");assert(tree);const root=constructTree(hierarchy[0]);tree.detail.children["root"]=root;tree.add(root);let last=root;while(last.detail.children&&last.detail.children[0]){last=last.detail.children[0]}tree.selectedItem=last}function constructTree(tree){const treeItem=document.createElement("cr-tree-item");treeItem.label=tree.label;treeItem.detail={payload:tree.payload?tree.payload:{},children:{}};treeItem.setExtraAriaLabel(treeItem.detail.payload.val||"");if(tree.children){for(let i=0;i<tree.children.length;i++){const child=constructTree(tree.children[i]);treeItem.add(child);treeItem.detail.children[i]=child}}return treeItem}function clearCertificateFields(){const treeItem=document.querySelector("#cert-fields");assert(treeItem);const detail=treeItem.detail;for(const key in detail.children){treeItem.removeTreeItem(detail.children[key]);delete detail.children[key]}}function showCertificateFields(){clearCertificateFields();const hierarchy=document.querySelector("#hierarchy");assert(hierarchy);const item=hierarchy.selectedItem;if(item&&item.detail.payload.index!==undefined){sendWithPromise("requestCertificateFields",item.detail.payload.index).then(onCertificateFields)}}function onCertificateFields(certFields){clearCertificateFields();const tree=document.querySelector("#cert-fields");assert(tree);const root=constructTree(certFields[0]);tree.detail.children["root"]=root;tree.add(root);revealTree(tree);tree.selectedItem=tree.items[0];document.body.dispatchEvent(new CustomEvent("certificate-fields-updated-for-testing"))}function showCertificateFieldValue(){const certFields=document.querySelector("#cert-fields");assert(certFields);const item=certFields.selectedItem;const fieldValue=document.querySelector("#cert-field-value");assert(fieldValue);if(item&&item.detail.payload.val){fieldValue.textContent=item.detail.payload.val||""}else{fieldValue.textContent=""}}function exportCertificate(){const hierarchy=document.querySelector("#hierarchy");assert(hierarchy);const item=hierarchy.selectedItem;if(item&&item.detail.payload.index!==undefined){chrome.send("exportCertificate",[item.detail.payload.index])}}document.addEventListener("DOMContentLoaded",initialize);