// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { OpenWindowProxyImpl } from 'chrome://resources/js/open_window_proxy.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './description_citation.css.js';
import { getHtml } from './description_citation.html.js';
import { getAbbreviatedUrl } from './utils.js';
export class DescriptionCitationElement extends CrLitElement {
    static get is() {
        return 'description-citation';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            urlInfo: { type: Object },
            index: { type: Number },
            citationCount: { type: Number },
            productName: { type: String },
        };
    }
    #urlInfo_accessor_storage = {
        title: '',
        url: { url: '' },
        faviconUrl: { url: '' },
        thumbnailUrl: { url: '' },
        previewText: '',
    };
    get urlInfo() { return this.#urlInfo_accessor_storage; }
    set urlInfo(value) { this.#urlInfo_accessor_storage = value; }
    #index_accessor_storage = 0;
    get index() { return this.#index_accessor_storage; }
    set index(value) { this.#index_accessor_storage = value; }
    #citationCount_accessor_storage = 0;
    get citationCount() { return this.#citationCount_accessor_storage; }
    set citationCount(value) { this.#citationCount_accessor_storage = value; }
    #productName_accessor_storage = '';
    get productName() { return this.#productName_accessor_storage; }
    set productName(value) { this.#productName_accessor_storage = value; }
    openCitation_() {
        this.$.tooltip.hide();
        OpenWindowProxyImpl.getInstance().openUrl(this.urlInfo.url.url);
        chrome.metricsPrivate.recordUserAction('Commerce.Compare.CitationClicked');
    }
    getAriaLabel_() {
        return loadTimeData.getStringF('citationA11yLabel', this.index, this.citationCount, this.productName, getAbbreviatedUrl(this.urlInfo?.url.url), this.urlInfo.title || '', this.urlInfo.previewText || '');
    }
}
customElements.define(DescriptionCitationElement.is, DescriptionCitationElement);
