// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./icons.html.js";import"/strings.m.js";import"//resources/cr_elements/cr_shared_vars.css.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./result_text.html.js";import{WordStreamer}from"./word_streamer.js";export class ComposeResultTextElement extends PolymerElement{static get is(){return"compose-result-text"}static get template(){return getTemplate()}static get properties(){return{textInput:{type:Object,value:()=>({text:"",isPartial:false,streamingEnabled:false})},isOutputComplete:{type:Boolean,notify:true,value:false},hasOutput:{type:Boolean,computed:"hasOutput_(displayedChunks_, displayedFullText_)",notify:true},hasPartialOutput_:{type:Boolean,computed:"getHasPartialOutput_(displayedChunks_, displayedFullText_)",notify:true},displayedChunks_:{type:Object,readOnly:true,value:()=>[]},displayedFullText_:{type:String,readOnly:true,value:""}}}static get observers(){return["updateInputs(textInput)"]}wordStreamer_;initialText_="";constructor(){super();this.wordStreamer_=new WordStreamer(this.setStreamedWords_.bind(this))}updateInputs(){this.$.resultText.innerText=this.textInput.text;if(this.textInput.streamingEnabled){this.isOutputComplete=false;this.wordStreamer_.setText(this.textInput.text.trim(),!this.textInput.isPartial)}else{this.wordStreamer_.reset();if(!this.textInput.isPartial){this.displayedFullText_=this.textInput.text;this.isOutputComplete=this.displayedFullText_!=="";this.displayedChunks_=[]}else{this.displayedFullText_="";this.isOutputComplete=false}}}enableInstantStreamingForTesting(){this.wordStreamer_.setMsPerTickForTesting(0);this.wordStreamer_.setMsWaitBeforeCompleteForTesting(0);this.wordStreamer_.setCharsPerTickForTesting(5)}onFocusIn_(){this.dispatchEvent(new CustomEvent("set-result-focus",{bubbles:true,composed:true,detail:true}));this.initialText_=this.textInput.text}onFocusOut_(){this.dispatchEvent(new CustomEvent("set-result-focus",{bubbles:true,composed:true,detail:false}));const currentText=this.$.resultText.innerText;if(currentText===""){this.$.resultText.innerText=this.initialText_;return}if(currentText!==this.initialText_){this.dispatchEvent(new CustomEvent("result-edit",{bubbles:true,composed:true,detail:this.$.root.innerText}))}}partialTextCanEdit_(){if(this.hasOutput&&this.isOutputComplete){return"plaintext-only"}else{return"false"}}hasOutput_(){return this.displayedChunks_.length>0||this.displayedFullText_!==""}getHasPartialOutput_(){return this.hasOutput&&!this.isOutputComplete}setStreamedWords_(words,isComplete){this.displayedChunks_=words.map((text=>({text:text})));this.isOutputComplete=isComplete&&words.length>0;if(isComplete){this.wordStreamer_.reset()}}}customElements.define(ComposeResultTextElement.is,ComposeResultTextElement);