// chrome/browser/ui/webui/data_sharing/data_sharing.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { GroupDataSpec as dataSharing_mojom_GroupDataSpec } from './group_data.mojom-webui.js';
import { AbslStatusCodeSpec as mojoBase_mojom_AbslStatusCodeSpec } from '//resources/mojo/mojo/public/mojom/base/absl_status.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const GroupActionSpec = { $: mojo.internal.Enum() };
export var GroupAction;
(function (GroupAction) {
    GroupAction[GroupAction["MIN_VALUE"] = 0] = "MIN_VALUE";
    GroupAction[GroupAction["MAX_VALUE"] = 5] = "MAX_VALUE";
    GroupAction[GroupAction["kUnknown"] = 0] = "kUnknown";
    GroupAction[GroupAction["kJoinGroup"] = 1] = "kJoinGroup";
    GroupAction[GroupAction["kDeleteGroup"] = 2] = "kDeleteGroup";
    GroupAction[GroupAction["kLeaveGroup"] = 3] = "kLeaveGroup";
    GroupAction[GroupAction["kKeepGroup"] = 4] = "kKeepGroup";
    GroupAction[GroupAction["kStopSharing"] = 5] = "kStopSharing";
})(GroupAction || (GroupAction = {}));
export const GroupActionProgressSpec = { $: mojo.internal.Enum() };
export var GroupActionProgress;
(function (GroupActionProgress) {
    GroupActionProgress[GroupActionProgress["MIN_VALUE"] = 0] = "MIN_VALUE";
    GroupActionProgress[GroupActionProgress["MAX_VALUE"] = 3] = "MAX_VALUE";
    GroupActionProgress[GroupActionProgress["kUnknown"] = 0] = "kUnknown";
    GroupActionProgress[GroupActionProgress["kStarted"] = 1] = "kStarted";
    GroupActionProgress[GroupActionProgress["kFailed"] = 2] = "kFailed";
    GroupActionProgress[GroupActionProgress["kSuccess"] = 3] = "kSuccess";
})(GroupActionProgress || (GroupActionProgress = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'data_sharing.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "data_sharing.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'data_sharing.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    showUI() {
        this.proxy.sendMessage(0, PageHandler_ShowUI_ParamsSpec.$, null, [], false);
    }
    closeUI(statusCode) {
        this.proxy.sendMessage(1, PageHandler_CloseUI_ParamsSpec.$, null, [
            statusCode
        ], false);
    }
    apiInitComplete() {
        this.proxy.sendMessage(2, PageHandler_ApiInitComplete_ParamsSpec.$, null, [], false);
    }
    makeTabGroupShared(tabGroupId, groupId, accessToken) {
        return this.proxy.sendMessage(3, PageHandler_MakeTabGroupShared_ParamsSpec.$, PageHandler_MakeTabGroupShared_ResponseParamsSpec.$, [
            tabGroupId,
            groupId,
            accessToken
        ], false);
    }
    getShareLink(groupId, accessToken) {
        return this.proxy.sendMessage(4, PageHandler_GetShareLink_ParamsSpec.$, PageHandler_GetShareLink_ResponseParamsSpec.$, [
            groupId,
            accessToken
        ], false);
    }
    getTabGroupPreview(groupId, accessToken) {
        return this.proxy.sendMessage(5, PageHandler_GetTabGroupPreview_ParamsSpec.$, PageHandler_GetTabGroupPreview_ResponseParamsSpec.$, [
            groupId,
            accessToken
        ], false);
    }
    openTabGroup(groupId) {
        this.proxy.sendMessage(6, PageHandler_OpenTabGroup_ParamsSpec.$, null, [
            groupId
        ], false);
    }
    aboutToUnShareTabGroup(tabGroupId) {
        this.proxy.sendMessage(7, PageHandler_AboutToUnShareTabGroup_ParamsSpec.$, null, [
            tabGroupId
        ], false);
    }
    onTabGroupUnShareComplete(tabGroupId) {
        this.proxy.sendMessage(8, PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$, null, [
            tabGroupId
        ], false);
    }
    onGroupAction(action, progress) {
        this.proxy.sendMessage(9, PageHandler_OnGroupAction_ParamsSpec.$, null, [
            action,
            progress
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_ShowUI_ParamsSpec.$, null, impl.showUI.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_CloseUI_ParamsSpec.$, null, impl.closeUI.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_ApiInitComplete_ParamsSpec.$, null, impl.apiInitComplete.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_MakeTabGroupShared_ParamsSpec.$, PageHandler_MakeTabGroupShared_ResponseParamsSpec.$, impl.makeTabGroupShared.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_GetShareLink_ParamsSpec.$, PageHandler_GetShareLink_ResponseParamsSpec.$, impl.getShareLink.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_GetTabGroupPreview_ParamsSpec.$, PageHandler_GetTabGroupPreview_ResponseParamsSpec.$, impl.getTabGroupPreview.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_OpenTabGroup_ParamsSpec.$, null, impl.openTabGroup.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_AboutToUnShareTabGroup_ParamsSpec.$, null, impl.aboutToUnShareTabGroup.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$, null, impl.onTabGroupUnShareComplete.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_OnGroupAction_ParamsSpec.$, null, impl.onGroupAction.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "data_sharing.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    showUI;
    closeUI;
    apiInitComplete;
    makeTabGroupShared;
    getShareLink;
    getTabGroupPreview;
    openTabGroup;
    aboutToUnShareTabGroup;
    onTabGroupUnShareComplete;
    onGroupAction;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.showUI =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_ShowUI_ParamsSpec.$, null, this.showUI.createReceiverHandler(false /* expectsResponse */), false);
        this.closeUI =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_CloseUI_ParamsSpec.$, null, this.closeUI.createReceiverHandler(false /* expectsResponse */), false);
        this.apiInitComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_ApiInitComplete_ParamsSpec.$, null, this.apiInitComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.makeTabGroupShared =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_MakeTabGroupShared_ParamsSpec.$, PageHandler_MakeTabGroupShared_ResponseParamsSpec.$, this.makeTabGroupShared.createReceiverHandler(true /* expectsResponse */), false);
        this.getShareLink =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_GetShareLink_ParamsSpec.$, PageHandler_GetShareLink_ResponseParamsSpec.$, this.getShareLink.createReceiverHandler(true /* expectsResponse */), false);
        this.getTabGroupPreview =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_GetTabGroupPreview_ParamsSpec.$, PageHandler_GetTabGroupPreview_ResponseParamsSpec.$, this.getTabGroupPreview.createReceiverHandler(true /* expectsResponse */), false);
        this.openTabGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_OpenTabGroup_ParamsSpec.$, null, this.openTabGroup.createReceiverHandler(false /* expectsResponse */), false);
        this.aboutToUnShareTabGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_AboutToUnShareTabGroup_ParamsSpec.$, null, this.aboutToUnShareTabGroup.createReceiverHandler(false /* expectsResponse */), false);
        this.onTabGroupUnShareComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$, null, this.onTabGroupUnShareComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onGroupAction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_OnGroupAction_ParamsSpec.$, null, this.onGroupAction.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'data_sharing.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAccessTokenFetched(accessToken) {
        this.proxy.sendMessage(0, Page_OnAccessTokenFetched_ParamsSpec.$, null, [
            accessToken
        ], false);
    }
    readGroups(readGroupsParams) {
        return this.proxy.sendMessage(1, Page_ReadGroups_ParamsSpec.$, Page_ReadGroups_ResponseParamsSpec.$, [
            readGroupsParams
        ], false);
    }
    readGroupWithToken(param) {
        return this.proxy.sendMessage(2, Page_ReadGroupWithToken_ParamsSpec.$, Page_ReadGroupWithToken_ResponseParamsSpec.$, [
            param
        ], false);
    }
    deleteGroup(groupId) {
        return this.proxy.sendMessage(3, Page_DeleteGroup_ParamsSpec.$, Page_DeleteGroup_ResponseParamsSpec.$, [
            groupId
        ], false);
    }
    leaveGroup(groupId) {
        return this.proxy.sendMessage(4, Page_LeaveGroup_ParamsSpec.$, Page_LeaveGroup_ResponseParamsSpec.$, [
            groupId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnAccessTokenFetched_ParamsSpec.$, null, impl.onAccessTokenFetched.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_ReadGroups_ParamsSpec.$, Page_ReadGroups_ResponseParamsSpec.$, impl.readGroups.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_ReadGroupWithToken_ParamsSpec.$, Page_ReadGroupWithToken_ResponseParamsSpec.$, impl.readGroupWithToken.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_DeleteGroup_ParamsSpec.$, Page_DeleteGroup_ResponseParamsSpec.$, impl.deleteGroup.bind(impl), false);
        this.helper_internal_.registerHandler(4, Page_LeaveGroup_ParamsSpec.$, Page_LeaveGroup_ResponseParamsSpec.$, impl.leaveGroup.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "data_sharing.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onAccessTokenFetched;
    readGroups;
    readGroupWithToken;
    deleteGroup;
    leaveGroup;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAccessTokenFetched =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnAccessTokenFetched_ParamsSpec.$, null, this.onAccessTokenFetched.createReceiverHandler(false /* expectsResponse */), false);
        this.readGroups =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_ReadGroups_ParamsSpec.$, Page_ReadGroups_ResponseParamsSpec.$, this.readGroups.createReceiverHandler(true /* expectsResponse */), false);
        this.readGroupWithToken =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_ReadGroupWithToken_ParamsSpec.$, Page_ReadGroupWithToken_ResponseParamsSpec.$, this.readGroupWithToken.createReceiverHandler(true /* expectsResponse */), false);
        this.deleteGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_DeleteGroup_ParamsSpec.$, Page_DeleteGroup_ResponseParamsSpec.$, this.deleteGroup.createReceiverHandler(true /* expectsResponse */), false);
        this.leaveGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Page_LeaveGroup_ParamsSpec.$, Page_LeaveGroup_ResponseParamsSpec.$, this.leaveGroup.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ReadGroupsParamsSpec = { $: {} };
export const ReadGroupParamsSpec = { $: {} };
export const ReadGroupsResultSpec = { $: {} };
export const ReadGroupWithTokenParamSpec = { $: {} };
export const ReadGroupWithTokenResultSpec = { $: {} };
export const SharedTabSpec = { $: {} };
export const GroupPreviewSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_ShowUI_ParamsSpec = { $: {} };
export const PageHandler_CloseUI_ParamsSpec = { $: {} };
export const PageHandler_ApiInitComplete_ParamsSpec = { $: {} };
export const PageHandler_MakeTabGroupShared_ParamsSpec = { $: {} };
export const PageHandler_MakeTabGroupShared_ResponseParamsSpec = { $: {} };
export const PageHandler_GetShareLink_ParamsSpec = { $: {} };
export const PageHandler_GetShareLink_ResponseParamsSpec = { $: {} };
export const PageHandler_GetTabGroupPreview_ParamsSpec = { $: {} };
export const PageHandler_GetTabGroupPreview_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenTabGroup_ParamsSpec = { $: {} };
export const PageHandler_AboutToUnShareTabGroup_ParamsSpec = { $: {} };
export const PageHandler_OnTabGroupUnShareComplete_ParamsSpec = { $: {} };
export const PageHandler_OnGroupAction_ParamsSpec = { $: {} };
export const Page_OnAccessTokenFetched_ParamsSpec = { $: {} };
export const Page_ReadGroups_ParamsSpec = { $: {} };
export const Page_ReadGroups_ResponseParamsSpec = { $: {} };
export const Page_ReadGroupWithToken_ParamsSpec = { $: {} };
export const Page_ReadGroupWithToken_ResponseParamsSpec = { $: {} };
export const Page_DeleteGroup_ParamsSpec = { $: {} };
export const Page_DeleteGroup_ResponseParamsSpec = { $: {} };
export const Page_LeaveGroup_ParamsSpec = { $: {} };
export const Page_LeaveGroup_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(ReadGroupsParamsSpec.$, 'ReadGroupsParams', [
    mojo.internal.StructField('params', 0, 0, mojo.internal.Array(ReadGroupParamsSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReadGroupParamsSpec.$, 'ReadGroupParams', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('consistencyToken', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ReadGroupsResultSpec.$, 'ReadGroupsResult', [
    mojo.internal.StructField('groups', 0, 0, mojo.internal.Array(dataSharing_mojom_GroupDataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('statusCode', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ReadGroupWithTokenParamSpec.$, 'ReadGroupWithTokenParam', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accessToken', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ReadGroupWithTokenResultSpec.$, 'ReadGroupWithTokenResult', [
    mojo.internal.StructField('group', 0, 0, dataSharing_mojom_GroupDataSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('statusCode', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SharedTabSpec.$, 'SharedTab', [
    mojo.internal.StructField('displayUrl', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('faviconUrl', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(GroupPreviewSpec.$, 'GroupPreview', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sharedTabs', 8, 0, mojo.internal.Array(SharedTabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('statusCode', 16, 0, mojoBase_mojom_AbslStatusCodeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ShowUI_ParamsSpec.$, 'PageHandler_ShowUI_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_CloseUI_ParamsSpec.$, 'PageHandler_CloseUI_Params', [
    mojo.internal.StructField('statusCode', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ApiInitComplete_ParamsSpec.$, 'PageHandler_ApiInitComplete_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_MakeTabGroupShared_ParamsSpec.$, 'PageHandler_MakeTabGroupShared_Params', [
    mojo.internal.StructField('tabGroupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('groupId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accessToken', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_MakeTabGroupShared_ResponseParamsSpec.$, 'PageHandler_MakeTabGroupShared_ResponseParams', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetShareLink_ParamsSpec.$, 'PageHandler_GetShareLink_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accessToken', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetShareLink_ResponseParamsSpec.$, 'PageHandler_GetShareLink_ResponseParams', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetTabGroupPreview_ParamsSpec.$, 'PageHandler_GetTabGroupPreview_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('accessToken', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetTabGroupPreview_ResponseParamsSpec.$, 'PageHandler_GetTabGroupPreview_ResponseParams', [
    mojo.internal.StructField('groupPreview', 0, 0, GroupPreviewSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenTabGroup_ParamsSpec.$, 'PageHandler_OpenTabGroup_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_AboutToUnShareTabGroup_ParamsSpec.$, 'PageHandler_AboutToUnShareTabGroup_Params', [
    mojo.internal.StructField('tabGroupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnTabGroupUnShareComplete_ParamsSpec.$, 'PageHandler_OnTabGroupUnShareComplete_Params', [
    mojo.internal.StructField('tabGroupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OnGroupAction_ParamsSpec.$, 'PageHandler_OnGroupAction_Params', [
    mojo.internal.StructField('action', 0, 0, GroupActionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('progress', 4, 0, GroupActionProgressSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_OnAccessTokenFetched_ParamsSpec.$, 'Page_OnAccessTokenFetched_Params', [
    mojo.internal.StructField('accessToken', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ReadGroups_ParamsSpec.$, 'Page_ReadGroups_Params', [
    mojo.internal.StructField('readGroupsParams', 0, 0, ReadGroupsParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ReadGroups_ResponseParamsSpec.$, 'Page_ReadGroups_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ReadGroupsResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ReadGroupWithToken_ParamsSpec.$, 'Page_ReadGroupWithToken_Params', [
    mojo.internal.StructField('param', 0, 0, ReadGroupWithTokenParamSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ReadGroupWithToken_ResponseParamsSpec.$, 'Page_ReadGroupWithToken_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ReadGroupWithTokenResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_DeleteGroup_ParamsSpec.$, 'Page_DeleteGroup_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_DeleteGroup_ResponseParamsSpec.$, 'Page_DeleteGroup_ResponseParams', [
    mojo.internal.StructField('statusCode', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_LeaveGroup_ParamsSpec.$, 'Page_LeaveGroup_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_LeaveGroup_ResponseParamsSpec.$, 'Page_LeaveGroup_ResponseParams', [
    mojo.internal.StructField('statusCode', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
