// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/d3/d3.min.js";import{assert}from"chrome://resources/js/assert.js";const kNodeRadius=6;const kPageNodesTargetY=20;const kPageNodesYRange=100;const kProcessNodesYRange=100;const kWorkerNodesYRange=200;const kFrameNodesTargetY=kPageNodesYRange+50;const kFrameNodesTopMargin=kPageNodesYRange;const kFrameNodesBottomMargin=kWorkerNodesYRange+50;const kMaxBoundaryStrength=1;const kHighYStrength=.9;const kWeakYStrength=.1;function tooltipClassForIndex(objectIndex){return`object${objectIndex}`}function toggleTooltipRows(clickedRow,objectIndex){const valueClasses=`tr.value.${tooltipClassForIndex(objectIndex)}`;const tooltip=d3.select(clickedRow.parentElement);const isCollapsed=tooltip.select(valueClasses).classed("collapsed");tooltip.selectAll(valueClasses).classed("collapsed",!isCollapsed)}class ToolTip{floating=true;x;y;node;graph_;div_;descriptionJson_="";constructor(div,node,graph){this.x=node.x;this.y=node.y-28;this.node=node;this.graph_=graph;this.div_=d3.select(div).append("div").attr("class","tooltip").style("opacity",0).style("left",`${this.x}px`).style("top",`${this.y}px`);this.div_.append("table").append("tbody");this.div_.transition().duration(200).style("opacity",.9);const drag=d3.drag().subject((()=>this));drag.on("start",this.onDragStart_.bind(this));drag.on("drag",this.onDrag_.bind(this));this.div_.call(drag);this.onDescription(JSON.stringify({}))}nodeMoved(){if(!this.floating){return}const node=this.node;this.x=node.x;this.y=node.y-28;this.div_.style("left",`${this.x}px`).style("top",`${this.y}px`)}getCenter(){const rect=this.div_.node().getBoundingClientRect();return[rect.x+rect.width/2,rect.y+rect.height/2]}goAway(){this.div_.transition().duration(200).style("opacity",0).remove()}onDescription(descriptionJson){if(this.descriptionJson_===descriptionJson){return}function flattenObjectRec(visited,flattened,path,objectIndex,object){if(typeof object!=="object"||visited.has(object)){return objectIndex}visited.add(object);objectIndex++;if(path){flattened.push({contents:[path,""],rowClass:"heading",objectIndex:objectIndex})}const subObjects=[];for(const[key,value]of Object.entries(object)){if(!!value&&typeof value==="object"){subObjects.push([key,value])}else{let strValue=String(value);if(strValue.length>50){strValue=`${strValue.substring(0,47)}...`}flattened.push({contents:[key,strValue],rowClass:"value",objectIndex:objectIndex})}}for(const[key,value]of subObjects){const fullPath=path?`${path} > ${key}`:key;objectIndex=flattenObjectRec(visited,flattened,fullPath,objectIndex,value)}return objectIndex}function flattenObject(object){const flattened=[];flattenObjectRec(new Set,flattened,"",0,object);return flattened}this.descriptionJson_=descriptionJson;const flattenedDescription=flattenObject(JSON.parse(descriptionJson));if(flattenedDescription.length===0){flattenedDescription.push({contents:["No Data",""],rowClass:"heading",objectIndex:0})}let tr=this.div_.selectAll("tbody").selectAll("tr").data(flattenedDescription);tr.enter().append("tr").selectAll("td").data((d=>d.contents)).enter().append("td");tr.exit().remove();tr=this.div_.selectAll("tr");tr.select("td").attr("colspan",((_d,i,nodes)=>{const parent=d3.select(nodes[i].parentElement);const parentData=parent.datum();return parentData.rowClass==="heading"?2:null}));tr.selectAll("td").data((d=>d.contents)).text((d=>d));tr.on("click",((event,d)=>{toggleTooltipRows(event.currentTarget,d.objectIndex)})).each(((d,i,nodes)=>{const el=nodes[i];const rowData=d;el.classList.add(rowData.rowClass,tooltipClassForIndex(rowData.objectIndex))}))}onDragStart_(){this.floating=false}onDrag_(event){this.x=event.x;this.y=event.y;this.div_.style("left",`${this.x}px`).style("top",`${this.y}px`);this.graph_.updateToolTipLinks()}}class GraphNode{id;color="black";iconUrl="";tooltip=null;index;x=0;y=0;vx;vy;fx=null;fy=null;constructor(id){this.id=id}get title(){return""}setInitialPosition(graphWidth,graphHeight){this.x=graphWidth/2;this.y=this.targetPositionY(graphHeight);this.vx=0;this.vy=0}targetPositionY(graphHeight){const bounds=this.allowedRangeY(graphHeight);return(bounds[0]+bounds[1])/2}get targetYPositionStrength(){return kWeakYStrength}get linkStrengthScalingFactor(){return 1}allowedRangeY(graphHeight){return[0,graphHeight]}get manyBodyStrength(){return-200}get linkTargets(){return[]}get dashedLinkTargets(){return[]}selectColor(id){if(id<0){id=-id}const color=d3.schemeSet3[Number(id%BigInt(12))];assert(color);return color}}class PageNode extends GraphNode{page;constructor(page){super(page.id);this.page=page;this.y=kPageNodesTargetY}get title(){return this.page.mainFrameUrl.url.length>0?this.page.mainFrameUrl.url:"Page"}get targetYPositionStrength(){return kHighYStrength}get linkStrengthScalingFactor(){return.5}allowedRangeY(_graphHeight){return[0,kPageNodesYRange]}get manyBodyStrength(){return-600}get dashedLinkTargets(){const targets=[];if(this.page.openerFrameId){targets.push(this.page.openerFrameId)}if(this.page.embedderFrameId){targets.push(this.page.embedderFrameId)}return targets}}class FrameNode extends GraphNode{frame;constructor(frame){super(frame.id);this.frame=frame;this.color=this.selectColor(frame.processId)}get title(){return this.frame.url.url.length>0?this.frame.url.url:"Frame"}targetPositionY(_graphHeight){return kFrameNodesTargetY}allowedRangeY(graphHeight){return[kFrameNodesTopMargin,graphHeight-kFrameNodesBottomMargin]}get linkTargets(){return[this.frame.parentFrameId||this.frame.pageId,this.frame.processId]}}class ProcessNode extends GraphNode{process;constructor(process){super(process.id);this.process=process;this.color=this.selectColor(process.id)}get title(){return`PID: ${this.process.pid.pid}`}get targetYPositionStrength(){return kHighYStrength}get linkStrengthScalingFactor(){return.5}allowedRangeY(graphHeight){return[graphHeight-kProcessNodesYRange,graphHeight]}get manyBodyStrength(){return-600}}class WorkerNode extends GraphNode{worker;constructor(worker){super(worker.id);this.worker=worker;this.color=this.selectColor(worker.processId)}get title(){return this.worker.url.url.length>0?this.worker.url.url:"Worker"}get targetYPositionStrength(){return kHighYStrength}allowedRangeY(graphHeight){return[graphHeight-kWorkerNodesYRange,graphHeight-kProcessNodesYRange]}get manyBodyStrength(){return-600}get linkTargets(){return[this.worker.processId,...this.worker.clientFrameIds,...this.worker.clientWorkerIds,...this.worker.childWorkerIds]}}function boundingForce(graphHeight,graphWidth){let nodes=[];let bounds=[];const xBounds=[2*kNodeRadius,graphWidth-2*kNodeRadius];const boundPosition=(pos,bound)=>Math.max(bound[0],Math.min(pos,bound[1]));function force(_alpha){const n=nodes.length;for(let i=0;i<n;++i){const bound=bounds[i];const node=nodes[i];assert(bound);assert(node);const yNextPosition=node.y+node.vy;const yBoundedPosition=boundPosition(yNextPosition,bound);if(yNextPosition!==yBoundedPosition){node.vy+=(yBoundedPosition-yNextPosition)*kMaxBoundaryStrength}const xNextPosition=node.x+node.vx;const xBoundedPosition=boundPosition(xNextPosition,xBounds);if(xNextPosition!==xBoundedPosition){node.vx+=(xBoundedPosition-xNextPosition)*kMaxBoundaryStrength}}}force.initialize=function(n){nodes=n;bounds=nodes.map((node=>{const nodeBounds=node.allowedRangeY(graphHeight);nodeBounds[0]+=kNodeRadius*2;nodeBounds[1]-=kNodeRadius*2;return nodeBounds}))};return force}export class Graph{svg_;div_;wasResized_=false;width_=0;height_=0;simulation_=null;toolTipLinkGroup_=null;separatorGroup_=null;nodeGroup_=null;linkGroup_=null;dashedLinkGroup_=null;nodes_=new Map;links_=[];dashedLinks_=[];pollDescriptionsInterval_=0;drag_=null;constructor(svg,div){this.svg_=svg;this.div_=div}initialize(){const simulation=d3.forceSimulation();simulation.on("tick",this.onTick_.bind(this));const linkForce=d3.forceLink().id((d=>d.id.toString()));const defaultStrength=linkForce.strength();simulation.force("link",linkForce.strength(((l,i,n)=>defaultStrength(l,i,n)*l.source.linkStrengthScalingFactor*l.target.linkStrengthScalingFactor)));simulation.force("charge",d3.forceManyBody().strength(this.getManyBodyStrength_.bind(this)));this.simulation_=simulation;const svg=d3.select(this.svg_);this.toolTipLinkGroup_=svg.append("g").attr("class","tool-tip-links");this.linkGroup_=svg.append("g").attr("class","links");this.dashedLinkGroup_=svg.append("g").attr("class","dashed-links");this.nodeGroup_=svg.append("g").attr("class","nodes");this.separatorGroup_=svg.append("g").attr("class","separators");const drag=d3.drag();drag.clickDistance(4);drag.on("start",this.onDragStart_.bind(this));drag.on("drag",this.onDrag_.bind(this));drag.on("end",this.onDragEnd_.bind(this));this.drag_=drag}frameCreated(frame){this.addNode_(new FrameNode(frame));this.render_()}pageCreated(page){this.addNode_(new PageNode(page));this.render_()}processCreated(process){this.addNode_(new ProcessNode(process));this.render_()}workerCreated(worker){this.addNode_(new WorkerNode(worker));this.render_()}frameChanged(frame){const frameNode=this.nodes_.get(frame.id);frameNode.frame=frame;this.render_()}pageChanged(page){const pageNode=this.nodes_.get(page.id);this.removeDashedNodeLinks_(pageNode);pageNode.page=page;this.addDashedNodeLinks_(pageNode);this.render_()}processChanged(process){const processNode=this.nodes_.get(process.id);processNode.process=process;this.render_()}workerChanged(worker){const workerNode=this.nodes_.get(worker.id);this.removeNodeLinks_(workerNode);workerNode.worker=worker;this.addNodeLinks_(workerNode);this.render_()}favIconDataAvailable(iconInfo){const graphNode=this.nodes_.get(iconInfo.nodeId);if(graphNode){graphNode.iconUrl="data:image/png;base64,"+iconInfo.iconData}this.render_()}nodeDeleted(nodeId){const node=this.nodes_.get(nodeId);this.removeNodeLinks_(node);this.removeDashedNodeLinks_(node);this.nodes_.delete(nodeId);this.render_()}nodeDescriptions(nodeDescriptions){for(const[nodeId,nodeDescription]of nodeDescriptions){const node=this.nodes_.get(nodeId);if(node&&node.tooltip){node.tooltip.onDescription(nodeDescription)}}this.render_()}updateToolTipLinks(){const pinnedTooltips=[];for(const node of this.nodes_.values()){const tooltip=node.tooltip;if(tooltip){if(tooltip.floating){tooltip.nodeMoved()}else{pinnedTooltips.push(tooltip)}}}function setLineEndpoints(d,line){const center=d.getCenter();line.attr("x1",(_d=>center[0])).attr("y1",(_d=>center[1])).attr("x2",(d=>d.node.x)).attr("y2",(d=>d.node.y))}const toolTipLinks=this.toolTipLinkGroup_.selectAll("line").data(pinnedTooltips);toolTipLinks.enter().append("line").attr("stroke","LightGray").attr("stroke-dasharray","1").attr("stroke-opacity","0.8").each((function(d){const line=d3.select(this);setLineEndpoints(d,line)}));toolTipLinks.each((function(d){const line=d3.select(this);setLineEndpoints(d,line)}));toolTipLinks.exit().remove()}removeNodeLinks_(node){this.links_=this.links_.filter((link=>link.source!==node&&link.target!==node))}removeDashedNodeLinks_(node){this.dashedLinks_=this.dashedLinks_.filter((link=>link.source!==node&&link.target!==node))}pollForNodeDescriptions_(){const nodeIds=[];for(const node of this.nodes_.values()){if(node.tooltip){nodeIds.push(node.id)}}if(nodeIds.length){this.div_.dispatchEvent(new CustomEvent("request-node-descriptions",{bubbles:true,composed:true,detail:nodeIds}));if(this.pollDescriptionsInterval_===0){this.pollDescriptionsInterval_=setInterval(this.pollForNodeDescriptions_.bind(this),1e3)}}else{clearInterval(this.pollDescriptionsInterval_);this.pollDescriptionsInterval_=0}}onGraphNodeClick_(_event,node){if(node.tooltip){node.tooltip.goAway();node.tooltip=null}else{node.tooltip=new ToolTip(this.div_,node,this);this.pollForNodeDescriptions_()}}render_(){const link=this.linkGroup_.selectAll("line").data(this.links_);link.enter().append("line");link.exit().remove();const dashedLink=this.dashedLinkGroup_.selectAll("line").data(this.dashedLinks_);dashedLink.enter().append("line");dashedLink.exit().remove();const nodes=Array.from(this.nodes_.values());const node=this.nodeGroup_.selectAll("g:not(.dead)").data(nodes,(d=>d.id));if(!node.enter().empty()){const newNodes=node.enter().append("g").call(this.drag_).on("click",this.onGraphNodeClick_.bind(this));const circles=newNodes.append("circle").attr("id",(d=>`circle-${d.id}`)).attr("r",kNodeRadius*1.5).attr("fill","green");newNodes.append("image").attr("x",-8).attr("y",-8).attr("width",16).attr("height",16);newNodes.append("title");circles.transition().duration(2e3).attr("fill",(d=>d.color)).attr("r",kNodeRadius)}if(!node.exit().empty()){const deletedNodes=node.exit().classed("dead",true);deletedNodes.interrupt();deletedNodes.each((d=>{if(d.tooltip){d.tooltip.goAway()}}));deletedNodes.transition().remove().select("circle").attr("r",9).attr("fill","red").transition().duration(2e3).attr("r",0)}node.selectAll("title").text((d=>d.title));node.selectAll("image").attr("href",(d=>d.iconUrl));if(!node.enter().empty()||!node.exit().empty()||!link.enter().empty()||!link.exit().empty()||!dashedLink.enter().empty()||!dashedLink.exit().empty()){this.simulation_.nodes(nodes);const links=this.links_.concat(this.dashedLinks_);this.simulation_.force("link").links(links);this.restartSimulation_()}}onTick_(){const nodes=this.nodeGroup_.selectAll("g");nodes.attr("transform",(d=>`translate(${d.x},${d.y})`));const lines=this.linkGroup_.selectAll("line");lines.attr("x1",(d=>d.source.x)).attr("y1",(d=>d.source.y)).attr("x2",(d=>d.target.x)).attr("y2",(d=>d.target.y));const dashedLines=this.dashedLinkGroup_.selectAll("line");dashedLines.attr("x1",(d=>d.source.x)).attr("y1",(d=>d.source.y)).attr("x2",(d=>d.target.x)).attr("y2",(d=>d.target.y));this.updateToolTipLinks()}addNode_(node){this.nodes_.set(node.id,node);this.addNodeLinks_(node);this.addDashedNodeLinks_(node);node.setInitialPosition(this.width_,this.height_)}addNodeLinks_(node){for(const linkTarget of node.linkTargets){const target=this.nodes_.get(linkTarget);if(target){this.links_.push({source:node,target:target})}}}addDashedNodeLinks_(node){for(const dashedLinkTarget of node.dashedLinkTargets){const target=this.nodes_.get(dashedLinkTarget);if(target){this.dashedLinks_.push({source:node,target:target})}}}onDragStart_(event,d){if(!event.active){this.restartSimulation_()}d.fx=d.x;d.fy=d.y}onDrag_(event,d){d.fx=event.x;d.fy=event.y}onDragEnd_(event,d){if(!event.active){this.simulation_.alphaTarget(0)}const bounds=d.allowedRangeY(this.height_);if(event.y<bounds[0]||event.y>bounds[1]){d.fx=null;d.fy=null}d3.select(`#circle-${d.id}`).classed("pinned",d.fx!=null)}getTargetPositionY_(d){return d.targetPositionY(this.height_)}getTargetPositionStrengthY_(d){return d.targetYPositionStrength}getManyBodyStrength_(d){return d.manyBodyStrength}updateSeparators_(graphWidth,graphHeight){const separators=[["Pages","Frame Tree",kPageNodesYRange],["","Workers",graphHeight-kWorkerNodesYRange],["","Processes",graphHeight-kProcessNodesYRange]];const kAboveLabelOffset=-6;const kBelowLabelOffset=14;const groups=this.separatorGroup_.selectAll("g").data(separators);if(groups.enter()){const group=groups.enter().append("g").attr("transform",(d=>`translate(0,${d[2]})`));group.append("line").attr("x1",10).attr("y1",0).attr("x2",graphWidth-10).attr("y2",0).attr("stroke","black").attr("stroke-dasharray","4");group.each((function(d){const parentGroup=d3.select(this);const aboveLabel=d[0];const belowLabel=d[1];if(aboveLabel){parentGroup.append("text").attr("x",20).attr("y",kAboveLabelOffset).attr("class","separator").text(aboveLabel)}if(belowLabel){parentGroup.append("text").attr("x",20).attr("y",kBelowLabelOffset).attr("class","separator").text(belowLabel)}}))}groups.attr("transform",(d=>{const value=d[2];return`translate(0,${value})`}));groups.selectAll("line").attr("x2",graphWidth-10)}restartSimulation_(){this.simulation_.alphaTarget(.3).restart()}onResize(){this.width_=this.svg_.clientWidth;this.height_=this.svg_.clientHeight;this.updateSeparators_(this.width_,this.height_);const xForce=d3.forceX().x(this.width_/2).strength(.1);const yForce=d3.forceY().y(this.getTargetPositionY_.bind(this)).strength(this.getTargetPositionStrengthY_.bind(this));this.simulation_.force("x_pos",xForce);this.simulation_.force("y_pos",yForce);this.simulation_.force("y_bound",boundingForce(this.height_,this.width_));if(!this.wasResized_){this.wasResized_=true;this.nodes_.forEach((node=>node.setInitialPosition(this.width_,this.height_)));for(let i=0;i<200;++i){this.simulation_.tick()}}this.restartSimulation_()}}