// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{GlicRequestHeaderInjector}from"/shared/glic_request_headers.js";import{assert}from"chrome://resources/js/assert.js";import{getRequiredElement}from"chrome://resources/js/util.js";import{FrePageHandlerFactory,FrePageHandlerRemote,FreWebUiState}from"./glic_fre.mojom-webui.js";import{GlicFreWebviewLoadAbortReason}from"./metrics_enums.js";const PRE_HOLD_LOADING_TIME_MS=loadTimeData.getInteger("preLoadingTimeMs");const MIN_HOLD_LOADING_TIME_MS=loadTimeData.getInteger("minLoadingTimeMs");const MAX_WAIT_TIME_MS=loadTimeData.getInteger("maxLoadingTimeMs");const RELOAD_MAX_WAIT_TIME_RELOAD_MS=loadTimeData.getInteger("reloadMaxLoadingTimeMs");const MIN_HEIGHT=200;export var FreResultType;(function(FreResultType){FreResultType[FreResultType["ACCEPT"]=0]="ACCEPT";FreResultType[FreResultType["DISMISS"]=1]="DISMISS";FreResultType[FreResultType["REJECT"]=2]="REJECT"})(FreResultType||(FreResultType={}));export class FreAppController{state=FreWebUiState.kUninitialized;loadingTimer;webview;webviewEventTracker=new EventTracker;glicRequestHeaderInjector;freHandler;earliestLoadingDismissTime;useReloadTimeout=false;freContainer;webviewContainer;partitionString;shouldSizeForDialog;onCloseCallback;constructor(options={}){this.onLoadCommit=this.onLoadCommit.bind(this);this.onContentLoad=this.onContentLoad.bind(this);this.onNewWindow=this.onNewWindow.bind(this);const container=getRequiredElement("fre-app-container");assert(container,"#fre-app-container not found in constructor");this.freContainer=container;this.freHandler=new FrePageHandlerRemote;FrePageHandlerFactory.getRemote().createPageHandler(this.freHandler.$.bindNewPipeAndPassReceiver());this.webviewContainer=getRequiredElement("freWebviewContainer");assert(this.webviewContainer,"#freWebviewContainer not found in constructor");this.partitionString=options.partitionString??"glicfrepart";this.shouldSizeForDialog=options.shouldSizeForDialog??true;this.onCloseCallback=options.onClose;this.webview=this.createWebview();window.addEventListener("online",(()=>{this.online()}));window.addEventListener("offline",(()=>{this.offline()}));window.addEventListener("load",(()=>{const buttons=this.freContainer.querySelectorAll(".close-button");for(const button of buttons){const parentPanel=button.closest(".panel");if(parentPanel){button.addEventListener("click",(()=>{chrome.metricsPrivate.recordUserAction("Glic.Fre.CloseWithX");this.dismissFre(this.panelIdToEnum(parentPanel.id))}))}}const disabledByAdminButton=getRequiredElement("freDisabledByAdminCloseButton");assert(disabledByAdminButton);const parentPanel=disabledByAdminButton.closest(".panel");assert(parentPanel);disabledByAdminButton.addEventListener("click",(()=>{chrome.metricsPrivate.recordUserAction("Glic.Fre.DisabledByAdminPanelCloseButton");this.dismissFre(this.panelIdToEnum(parentPanel.id))}));const disabledByAdminLink=this.freContainer.querySelector("#freDisabledByAdminPanel a");assert(disabledByAdminLink);disabledByAdminLink.addEventListener("click",(e=>{e.preventDefault();chrome.metricsPrivate.recordUserAction("Glic.Fre.DisabledByAdminPanelLinkClicked");this.freHandler.validateAndOpenLinkInNewTab({url:e.target.href});e.stopPropagation()}));getRequiredElement("fre-reload")?.addEventListener("click",(()=>{this.reload()}))}));this.freContainer.addEventListener("keydown",(ev=>{if(ev.code==="Escape"){ev.stopPropagation();ev.preventDefault();const visiblePanel=this.freContainer.querySelector(".panel:not([hidden])");if(visiblePanel){chrome.metricsPrivate.recordUserAction("Glic.Fre.CloseWithEsc");this.dismissFre(this.panelIdToEnum(visiblePanel.id))}}}));if(navigator.onLine){this.setState(FreWebUiState.kBeginLoading)}else{this.setState(FreWebUiState.kOffline)}}onLoadCommit(e){if(!e.isTopLevel){return}const url=new URL(e.url);const urlHash=url.hash;if(loadTimeData.getBoolean("caaGuestError")&&(url.hostname==="access.workspace.google.com"||url.hostname==="admin.google.com")){this.setState(FreWebUiState.kDisabledByAdmin);return}if(urlHash==="#continue"){this.acceptFre()}else if(urlHash.startsWith("#noThanks")){const source=url.searchParams.get("source");if(source==="x_button"){chrome.metricsPrivate.recordUserAction(`Glic.Fre.CloseWithX`);this.dismissFre(FreWebUiState.kReady)}else{this.rejectFre()}}}onContentLoad(){if(this.state===FreWebUiState.kBeginLoading||this.state===FreWebUiState.kFinishLoading){this.setState(FreWebUiState.kReady)}else if(this.state===FreWebUiState.kShowLoading){this.setState(FreWebUiState.kHoldLoading)}}onNewWindow(e){e.preventDefault();this.freHandler.validateAndOpenLinkInNewTab({url:e.targetUrl});e.stopPropagation()}online(){if(this.state!==FreWebUiState.kOffline){return}this.setState(FreWebUiState.kBeginLoading)}offline(){const allowedStates=[FreWebUiState.kBeginLoading,FreWebUiState.kShowLoading,FreWebUiState.kFinishLoading];if(allowedStates.includes(this.state)){this.setState(FreWebUiState.kOffline)}}reload(){this.destroyWebview();this.useReloadTimeout=true;this.freHandler.freReloaded();this.setState(FreWebUiState.kBeginLoading)}showPanel(id){for(const panel of this.freContainer.querySelectorAll(".panel")){panel.hidden=panel.id!==id}if(id==="freGuestPanel"){this.webview.focus()}}setState(newState){if(this.state===newState){return}if(this.state){this.states.get(this.state).onExit?.call(this);this.cancelTimeout()}this.state=newState;this.states.get(this.state).onEnter?.call(this);this.freHandler.webUiStateChanged(newState)}states=new Map([[FreWebUiState.kBeginLoading,{onEnter:this.beginLoading}],[FreWebUiState.kShowLoading,{onEnter:this.showLoading}],[FreWebUiState.kHoldLoading,{onEnter:this.holdLoading}],[FreWebUiState.kFinishLoading,{onEnter:this.finishLoading}],[FreWebUiState.kError,{onEnter:()=>{this.useReloadTimeout=false;this.destroyWebview();this.showPanel("freErrorPanel")}}],[FreWebUiState.kDisabledByAdmin,{onEnter:()=>{this.destroyWebview();this.showPanel("freDisabledByAdminPanel")}}],[FreWebUiState.kOffline,{onEnter:()=>{this.useReloadTimeout=false;this.destroyWebview();this.showPanel("freOfflinePanel")}}],[FreWebUiState.kReady,{onEnter:()=>{this.useReloadTimeout=false;this.showPanel("freGuestPanel")}}]]);cancelTimeout(){if(this.loadingTimer){clearTimeout(this.loadingTimer);this.loadingTimer=undefined}}async beginLoading(){const showLoadingTime=performance.now()+PRE_HOLD_LOADING_TIME_MS;const{success:success}=await this.freHandler.prepareForClient();if(!success){this.setState(FreWebUiState.kError);return}this.destroyWebview();this.freHandler.logWebUiLoadComplete();this.webview.src=loadTimeData.getString("glicFreURL");this.loadingTimer=setTimeout((()=>{this.setState(FreWebUiState.kShowLoading)}),Math.max(0,showLoadingTime-performance.now()))}showLoading(){this.showPanel("freLoadingPanel");this.earliestLoadingDismissTime=performance.now()+MIN_HOLD_LOADING_TIME_MS;this.loadingTimer=setTimeout((()=>{this.setState(FreWebUiState.kFinishLoading)}),MIN_HOLD_LOADING_TIME_MS)}holdLoading(){this.loadingTimer=setTimeout((()=>{this.setState(FreWebUiState.kReady)}),Math.max(0,this.earliestLoadingDismissTime-performance.now()))}finishLoading(){const timeoutValue=this.useReloadTimeout?RELOAD_MAX_WAIT_TIME_RELOAD_MS:MAX_WAIT_TIME_MS;this.loadingTimer=setTimeout((()=>{console.warn("Exceeded timeout in finishLoading");chrome.metricsPrivate.recordUserAction("Glic.Fre.WebviewLoadTimedOut");chrome.metricsPrivate.recordEnumerationValue("Glic.Fre.WebviewLoadAbortReason",GlicFreWebviewLoadAbortReason.ERR_TIMED_OUT,GlicFreWebviewLoadAbortReason.MAX_VALUE+1);this.freHandler.exceededTimeoutError();this.setState(FreWebUiState.kError)}),timeoutValue-MIN_HOLD_LOADING_TIME_MS)}onSizeChanged(e){window.resizeTo(e.newWidth,e.newHeight)}createWebview(){const webview=document.createElement("webview");webview.id="freGuestFrame";webview.setAttribute("partition",this.partitionString);webview.setAttribute("autosize","true");if(this.shouldSizeForDialog){webview.setAttribute("minwidth",loadTimeData.getInteger("freInitialWidth").toString());webview.setAttribute("maxwidth",loadTimeData.getInteger("freInitialWidth").toString());webview.setAttribute("minheight",MIN_HEIGHT.toString());webview.setAttribute("maxheight",window.screen.availHeight.toString())}this.glicRequestHeaderInjector=new GlicRequestHeaderInjector(webview,loadTimeData.getString("chromeVersion"),loadTimeData.getString("chromeChannel"),loadTimeData.getString("glicHeaderRequestTypes"));this.webviewContainer.appendChild(webview);this.webviewEventTracker.add(webview,"loadcommit",this.onLoadCommit.bind(this));this.webviewEventTracker.add(webview,"contentload",this.onContentLoad.bind(this));this.webviewEventTracker.add(webview,"loadabort",this.onLoadAbort.bind(this));this.webviewEventTracker.add(webview,"newwindow",this.onNewWindow.bind(this));this.webviewEventTracker.add(webview,"sizechanged",this.onSizeChanged.bind(this));return webview}reasonStringToEnum(reason){switch(reason){case"ERR_ABORTED":return GlicFreWebviewLoadAbortReason.ERR_ABORTED;case"ERR_INVALID_URL":return GlicFreWebviewLoadAbortReason.ERR_INVALID_URL;case"ERR_DISALLOWED_URL_SCHEME":return GlicFreWebviewLoadAbortReason.ERR_DISALLOWED_URL_SCHEME;case"ERR_BLOCKED_BY_CLIENT":return GlicFreWebviewLoadAbortReason.ERR_BLOCKED_BY_CLIENT;case"ERR_ADDRESS_UNREACHABLE":return GlicFreWebviewLoadAbortReason.ERR_ADDRESS_UNREACHABLE;case"ERR_EMPTY_RESPONSE":return GlicFreWebviewLoadAbortReason.ERR_EMPTY_RESPONSE;case"ERR_FILE_NOT_FOUND":return GlicFreWebviewLoadAbortReason.ERR_FILE_NOT_FOUND;case"ERR_UNKNOWN_URL_SCHEME":return GlicFreWebviewLoadAbortReason.ERR_UNKNOWN_URL_SCHEME;case"ERR_TIMED_OUT":return GlicFreWebviewLoadAbortReason.ERR_TIMED_OUT;case"ERR_HTTP_RESPONSE_CODE_FAILURE":return GlicFreWebviewLoadAbortReason.ERR_HTTP_RESPONSE_CODE_FAILURE;default:return GlicFreWebviewLoadAbortReason.UNKNOWN}}onLoadAbort(e){const reasonEnum=this.reasonStringToEnum(e.reason);chrome.metricsPrivate.recordUserAction("Glic.Fre.WebviewLoadAborted");chrome.metricsPrivate.recordEnumerationValue("Glic.Fre.WebviewLoadAbortReason",reasonEnum,GlicFreWebviewLoadAbortReason.MAX_VALUE+1);this.setState(FreWebUiState.kError)}panelIdToEnum(panelId){switch(panelId){case"freGuestPanel":return FreWebUiState.kReady;case"freOfflinePanel":return FreWebUiState.kOffline;case"freErrorPanel":return FreWebUiState.kError;case"freLoadingPanel":return FreWebUiState.kShowLoading;case"freDisabledByAdminPanel":return FreWebUiState.kDisabledByAdmin;default:return FreWebUiState.kUninitialized}}destroyWebview(){this.webviewEventTracker.removeAll();if(this.glicRequestHeaderInjector){this.glicRequestHeaderInjector.destroy();this.glicRequestHeaderInjector=undefined}this.webviewContainer.removeChild(this.webview);this.webview=this.createWebview()}dismissFre(state){this.freHandler.dismissFre(state);this.onCloseCallback?.()}acceptFre(){this.freHandler.acceptFre()}rejectFre(){this.freHandler.rejectFre();this.onCloseCallback?.()}}