// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{css,html,nothing,CrLitElement,render}from"chrome://resources/lit/v3_0/lit.rollup.js";import"chrome://history/strings.m.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";import{sendWithPromise}from"chrome://resources/js/cr.js";const sheet$1=new CSSStyleSheet;sheet$1.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-100-rgb:244,199,195;--google-red-100:rgb(var(--google-red-100-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-red-700-rgb:197,57,41;--google-red-700:rgb(var(--google-red-700-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--google-yellow-700-rgb:240,147,0;--google-yellow-700:rgb(var(--google-yellow-700-rgb));--cr-card-background-color:white;--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:var(--cr-elevation-2);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html{--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-scrollable-border-color:var(--google-grey-700)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-surface1:rgb(248,250,253);--cr-fallback-color-surface2:rgb(243,246,252);--cr-fallback-color-surface3:rgb(239,243,250);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgb(236,239,247);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--cr-fallback-color-primary));--cr-focus-outline-inverse-color:var(--color-sys-state-focus-ring-inverse,var(--cr-fallback-color-inverse-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0));--cr-checked-color:var(--color-checkbox-foreground-checked,var(--cr-fallback-color-primary))}@media (prefers-color-scheme:dark){html{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(40,40,40);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(31,31,31);--cr-fallback-color-surface1:rgb(39,40,42);--cr-fallback-color-surface2:rgb(45,47,49);--cr-fallback-color-surface3:rgb(51,52,56);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(196,199,197);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(4,125,183);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(94,94,94);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet$1];function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}function assertInstanceof(value,type,message){if(value instanceof type){return}throw new Error(`Value ${value} is not of type ${type.name||typeof type}`)}function assertNotReached(message="Unreachable code hit"){assert(false,message)}const CLASS_NAME="focus-outline-visible";const docsToManager=new Map;class FocusOutlineManager{focusByKeyboard_=true;classList_;constructor(doc){this.classList_=doc.documentElement.classList;doc.addEventListener("keydown",(e=>this.onEvent_(true,e)),true);doc.addEventListener("mousedown",(e=>this.onEvent_(false,e)),true);this.updateVisibility()}onEvent_(focusByKeyboard,e){if(this.focusByKeyboard_===focusByKeyboard){return}if(e instanceof KeyboardEvent&&e.repeat){return}this.focusByKeyboard_=focusByKeyboard;this.updateVisibility()}updateVisibility(){this.visible=this.focusByKeyboard_}set visible(visible){this.classList_.toggle(CLASS_NAME,visible)}get visible(){return this.classList_.contains(CLASS_NAME)}static forDocument(doc){let manager=docsToManager.get(doc);if(!manager){manager=new FocusOutlineManager(doc);docsToManager.set(doc,manager)}return manager}}class EventTracker{listeners_=[];add(target,eventType,listener,capture=false){const h={target:target,eventType:eventType,listener:listener,capture:capture};this.listeners_.push(h);target.addEventListener(eventType,listener,capture)}remove(target,eventType){this.listeners_=this.listeners_.filter((listener=>{if(listener.target===target&&(!eventType||listener.eventType===eventType)){EventTracker.removeEventListener(listener);return false}return true}))}removeAll(){this.listeners_.forEach((listener=>EventTracker.removeEventListener(listener)));this.listeners_=[]}static removeEventListener(entry){entry.target.removeEventListener(entry.eventType,entry.listener,entry.capture)}}function getDeepActiveElement(){let a=document.activeElement;while(a&&a.shadowRoot&&a.shadowRoot.activeElement){a=a.shadowRoot.activeElement}return a}function isRTL(){return document.documentElement.dir==="rtl"}function quoteString(str){return str.replace(/([\\\.\+\*\?\[\^\]\$\(\)\{\}\=\!\<\>\|\:])/g,"\\$1")}function listenOnce(target,eventNames,callback){const eventNamesArray=Array.isArray(eventNames)?eventNames:eventNames.split(/ +/);const removeAllAndCallCallback=function(event){eventNamesArray.forEach((function(eventName){target.removeEventListener(eventName,removeAllAndCallCallback,false)}));return callback(event)};eventNamesArray.forEach((function(eventName){target.addEventListener(eventName,removeAllAndCallCallback,false)}))}function hasKeyModifiers(e){return!!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey)}function debounceEnd(fn,time=50){let timerId;return()=>{clearTimeout(timerId);timerId=setTimeout(fn,time)}}const ACTIVE_CLASS="focus-row-active";class FocusRow{root;delegate;eventTracker=new EventTracker;boundary_;constructor(root,boundary,delegate){this.root=root;this.boundary_=boundary||document.documentElement;this.delegate=delegate}static isFocusable(element){if(!element||element.disabled){return false}let current=element;while(true){assertInstanceof(current,Element);const style=window.getComputedStyle(current);if(style.visibility==="hidden"||style.display==="none"){return false}const parent=current.parentNode;if(!parent){return false}if(parent===current.ownerDocument||parent instanceof DocumentFragment){return true}current=parent}}static getFocusableElement(element){const withFocusable=element;if(withFocusable.getFocusableElement){return withFocusable.getFocusableElement()}return element}addItem(type,selectorOrElement){assert(type);let element;if(typeof selectorOrElement==="string"){element=this.root.querySelector(selectorOrElement)}else{element=selectorOrElement}if(!element){return false}element.setAttribute("focus-type",type);element.tabIndex=this.isActive()?0:-1;this.eventTracker.add(element,"blur",this.onBlur_.bind(this));this.eventTracker.add(element,"focus",this.onFocus_.bind(this));this.eventTracker.add(element,"keydown",this.onKeydown_.bind(this));this.eventTracker.add(element,"mousedown",this.onMousedown_.bind(this));return true}destroy(){this.eventTracker.removeAll()}getCustomEquivalent(_sampleElement){const focusable=this.getFirstFocusable();assert(focusable);return focusable}getElements(){return Array.from(this.root.querySelectorAll("[focus-type]")).map(FocusRow.getFocusableElement)}getEquivalentElement(sampleElement){if(this.getFocusableElements().indexOf(sampleElement)>=0){return sampleElement}const sampleFocusType=this.getTypeForElement(sampleElement);if(sampleFocusType){const sameType=this.getFirstFocusable(sampleFocusType);if(sameType){return sameType}}return this.getCustomEquivalent(sampleElement)}getFirstFocusable(type){const element=this.getFocusableElements().find((el=>!type||el.getAttribute("focus-type")===type));return element||null}getFocusableElements(){return this.getElements().filter(FocusRow.isFocusable)}getTypeForElement(element){return element.getAttribute("focus-type")||""}isActive(){return this.root.classList.contains(ACTIVE_CLASS)}makeActive(active){if(active===this.isActive()){return}this.getElements().forEach((function(element){element.tabIndex=active?0:-1}));this.root.classList.toggle(ACTIVE_CLASS,active)}onBlur_(e){if(!this.boundary_.contains(e.relatedTarget)){return}const currentTarget=e.currentTarget;if(this.getFocusableElements().indexOf(currentTarget)>=0){this.makeActive(false)}}onFocus_(e){if(this.delegate){this.delegate.onFocus(this,e)}}onMousedown_(e){if(e.button){return}const target=e.currentTarget;if(!target.disabled){target.tabIndex=0}}onKeydown_(e){const elements=this.getFocusableElements();const currentElement=FocusRow.getFocusableElement(e.currentTarget);const elementIndex=elements.indexOf(currentElement);assert(elementIndex>=0);if(this.delegate&&this.delegate.onKeydown(this,e)){return}const isShiftTab=!e.altKey&&!e.ctrlKey&&!e.metaKey&&e.shiftKey&&e.key==="Tab";if(hasKeyModifiers(e)&&!isShiftTab){return}let index=-1;let shouldStopPropagation=true;if(isShiftTab){index=elementIndex-1;if(index<0){return}}else if(e.key==="ArrowLeft"){index=elementIndex+(isRTL()?1:-1)}else if(e.key==="ArrowRight"){index=elementIndex+(isRTL()?-1:1)}else if(e.key==="Home"){index=0}else if(e.key==="End"){index=elements.length-1}else{shouldStopPropagation=false}const elementToFocus=elements[index];if(elementToFocus){this.getEquivalentElement(elementToFocus).focus();e.preventDefault()}if(shouldStopPropagation){e.stopPropagation()}}}class VirtualFocusRow extends FocusRow{constructor(root,delegate){super(root,null,delegate)}getCustomEquivalent(sampleElement){const equivalent=this.delegate?this.delegate.getCustomEquivalent(sampleElement):null;return equivalent||super.getCustomEquivalent(sampleElement)}}let hideInk=false;document.addEventListener("pointerdown",(function(){hideInk=true}),true);document.addEventListener("keydown",(function(){hideInk=false}),true);function focusWithoutInk(toFocus){if(!("noink"in toFocus)||!hideInk){toFocus.focus();return}const toFocusWithNoInk=toFocus;assert(document===toFocusWithNoInk.ownerDocument);const{noink:noink}=toFocusWithNoInk;toFocusWithNoInk.noink=true;toFocusWithNoInk.focus();toFocusWithNoInk.noink=noink}const isMac=/Mac/.test(navigator.platform);const isWindows=/Win/.test(navigator.platform);const isAndroid=/Android/.test(navigator.userAgent);const isIOS=/CriOS/.test(navigator.userAgent);let instance$g=null;function getCss$f(){return instance$g||(instance$g=[...[],css`:host{--cr-hairline:1px solid var(--color-menu-separator,var(--cr-fallback-color-divider));--cr-action-menu-disabled-item-color:var(--color-menu-item-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-action-menu-disabled-item-opacity:1;--cr-menu-background-color:var(--color-menu-background,var(--cr-fallback-color-surface));--cr-menu-background-focus-color:var(--cr-hover-background-color);--cr-menu-shadow:var(--cr-elevation-2);--cr-primary-text-color:var(--color-menu-item-foreground,var(--cr-fallback-color-on-surface))}:host dialog{background-color:var(--cr-menu-background-color);border:none;border-radius:var(--cr-menu-border-radius,4px);box-shadow:var(--cr-menu-shadow);margin:0;min-width:128px;outline:none;overflow:var(--cr-action-menu-overflow,auto);padding:0;position:absolute}@media (forced-colors:active){:host dialog{border:var(--cr-border-hcm)}}:host dialog::backdrop{background-color:transparent}:host ::slotted(.dropdown-item){-webkit-tap-highlight-color:transparent;background:none;border:none;border-radius:0;box-sizing:border-box;color:var(--cr-primary-text-color);font:inherit;min-height:32px;padding:8px 24px;text-align:start;user-select:none;width:100%}:host ::slotted(.dropdown-item:not([hidden])){align-items:center;display:flex}:host ::slotted(.dropdown-item[disabled]){color:var(--cr-action-menu-disabled-item-color,var(--cr-primary-text-color));opacity:var(--cr-action-menu-disabled-item-opacity,0.65)}:host ::slotted(.dropdown-item:not([disabled])){cursor:pointer}:host ::slotted(.dropdown-item:focus){background-color:var(--cr-menu-background-focus-color);outline:none}:host ::slotted(.dropdown-item:focus-visible){outline:solid 2px var(--cr-focus-outline-color);outline-offset:-2px}@media (forced-colors:active){:host ::slotted(.dropdown-item:focus){outline:var(--cr-focus-outline-hcm)}}.item-wrapper{outline:none;padding:var(--cr-action-menu-padding,8px 0)}`])}function getHtml$9(){return html`
<dialog id="dialog" part="dialog" @close="${this.onNativeDialogClose_}"
    role="application"
    aria-roledescription="${this.roleDescription||nothing}">
  <div id="wrapper" class="item-wrapper" role="menu" tabindex="-1"
      aria-label="${this.accessibilityLabel||nothing}">
    <slot id="contentNode" @slotchange="${this.onSlotchange_}"></slot>
  </div>
</dialog>`}var AnchorAlignment;(function(AnchorAlignment){AnchorAlignment[AnchorAlignment["BEFORE_START"]=-2]="BEFORE_START";AnchorAlignment[AnchorAlignment["AFTER_START"]=-1]="AFTER_START";AnchorAlignment[AnchorAlignment["CENTER"]=0]="CENTER";AnchorAlignment[AnchorAlignment["BEFORE_END"]=1]="BEFORE_END";AnchorAlignment[AnchorAlignment["AFTER_END"]=2]="AFTER_END"})(AnchorAlignment||(AnchorAlignment={}));const DROPDOWN_ITEM_CLASS="dropdown-item";const SELECTABLE_DROPDOWN_ITEM_QUERY=`.${DROPDOWN_ITEM_CLASS}:not([hidden]):not([disabled])`;const AFTER_END_OFFSET=10;function getStartPointWithAnchor(start,end,menuLength,anchorAlignment,min,max){let startPoint=0;switch(anchorAlignment){case AnchorAlignment.BEFORE_START:startPoint=start-menuLength;break;case AnchorAlignment.AFTER_START:startPoint=start;break;case AnchorAlignment.CENTER:startPoint=(start+end-menuLength)/2;break;case AnchorAlignment.BEFORE_END:startPoint=end-menuLength;break;case AnchorAlignment.AFTER_END:startPoint=end;break}if(startPoint+menuLength>max){startPoint=end-menuLength}if(startPoint<min){startPoint=start}startPoint=Math.max(min,Math.min(startPoint,max-menuLength));return startPoint}function getDefaultShowConfig(){return{top:0,left:0,height:0,width:0,anchorAlignmentX:AnchorAlignment.AFTER_START,anchorAlignmentY:AnchorAlignment.AFTER_START,minX:0,minY:0,maxX:0,maxY:0}}class CrActionMenuElement extends CrLitElement{static get is(){return"cr-action-menu"}static get styles(){return getCss$f()}render(){return getHtml$9.bind(this)()}static get properties(){return{accessibilityLabel:{type:String},autoReposition:{type:Boolean},open:{type:Boolean,notify:true},roleDescription:{type:String}}}#accessibilityLabel_accessor_storage;get accessibilityLabel(){return this.#accessibilityLabel_accessor_storage}set accessibilityLabel(value){this.#accessibilityLabel_accessor_storage=value}#autoReposition_accessor_storage=false;get autoReposition(){return this.#autoReposition_accessor_storage}set autoReposition(value){this.#autoReposition_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#roleDescription_accessor_storage;get roleDescription(){return this.#roleDescription_accessor_storage}set roleDescription(value){this.#roleDescription_accessor_storage=value}boundClose_=null;resizeObserver_=null;hasMousemoveListener_=false;anchorElement_=null;lastConfig_=null;firstUpdated(){this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("mouseover",this.onMouseover_);this.addEventListener("click",this.onClick_)}disconnectedCallback(){super.disconnectedCallback();this.removeListeners_()}getDialog(){return this.$.dialog}removeListeners_(){window.removeEventListener("resize",this.boundClose_);window.removeEventListener("popstate",this.boundClose_);if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}}onNativeDialogClose_(e){if(e.target!==this.$.dialog){return}this.fire("close")}onClick_(e){if(e.target===this){this.close();e.stopPropagation()}}onKeyDown_(e){e.stopPropagation();if(e.key==="Tab"||e.key==="Escape"){this.close();if(e.key==="Tab"){this.fire("tabkeyclose",{shiftKey:e.shiftKey})}e.preventDefault();return}if(e.key!=="Enter"&&e.key!=="ArrowUp"&&e.key!=="ArrowDown"){return}const options=Array.from(this.querySelectorAll(SELECTABLE_DROPDOWN_ITEM_QUERY));if(options.length===0){return}const focused=getDeepActiveElement();const index=options.findIndex((option=>FocusRow.getFocusableElement(option)===focused));if(e.key==="Enter"){if(index!==-1){return}if(isWindows||isMac){this.close();e.preventDefault();return}}e.preventDefault();this.updateFocus_(options,index,e.key!=="ArrowUp");if(!this.hasMousemoveListener_){this.hasMousemoveListener_=true;this.addEventListener("mousemove",(e=>{this.onMouseover_(e);this.hasMousemoveListener_=false}),{once:true})}}onMouseover_(e){const item=e.composedPath().find((el=>el.matches&&el.matches(SELECTABLE_DROPDOWN_ITEM_QUERY)));(item||this.$.wrapper).focus()}updateFocus_(options,focusedIndex,next){const numOptions=options.length;assert(numOptions>0);let index;if(focusedIndex===-1){index=next?0:numOptions-1}else{const delta=next?1:-1;index=(numOptions+focusedIndex+delta)%numOptions}options[index].focus()}close(){if(!this.open){return}this.removeListeners_();this.$.dialog.close();this.open=false;if(this.anchorElement_){assert(this.anchorElement_);focusWithoutInk(this.anchorElement_);this.anchorElement_=null}if(this.lastConfig_){this.lastConfig_=null}}showAt(anchorElement,config){this.anchorElement_=anchorElement;this.anchorElement_.scrollIntoViewIfNeeded();const rect=this.anchorElement_.getBoundingClientRect();let height=rect.height;if(config&&!config.noOffset&&config.anchorAlignmentY===AnchorAlignment.AFTER_END){height-=AFTER_END_OFFSET}this.showAtPosition(Object.assign({top:rect.top,left:rect.left,height:height,width:rect.width,anchorAlignmentX:AnchorAlignment.BEFORE_END},config));this.$.wrapper.focus()}showAtPosition(config){const doc=document.scrollingElement;const scrollLeft=doc.scrollLeft;const scrollTop=doc.scrollTop;this.resetStyle_();this.$.dialog.showModal();this.open=true;config.top+=scrollTop;config.left+=scrollLeft;this.positionDialog_(Object.assign({minX:scrollLeft,minY:scrollTop,maxX:scrollLeft+doc.clientWidth,maxY:scrollTop+doc.clientHeight},config));doc.scrollTop=scrollTop;doc.scrollLeft=scrollLeft;this.addListeners_();const openedByKey=FocusOutlineManager.forDocument(document).visible;if(openedByKey){const firstSelectableItem=this.querySelector(SELECTABLE_DROPDOWN_ITEM_QUERY);if(firstSelectableItem){requestAnimationFrame((()=>{firstSelectableItem.focus()}))}}}resetStyle_(){this.$.dialog.style.left="";this.$.dialog.style.right="";this.$.dialog.style.top="0"}positionDialog_(config){this.lastConfig_=config;const c=Object.assign(getDefaultShowConfig(),config);const top=c.top;const left=c.left;const bottom=top+c.height;const right=left+c.width;const rtl=getComputedStyle(this).direction==="rtl";if(rtl){c.anchorAlignmentX*=-1}const offsetWidth=this.$.dialog.offsetWidth;const menuLeft=getStartPointWithAnchor(left,right,offsetWidth,c.anchorAlignmentX,c.minX,c.maxX);if(rtl){const menuRight=document.scrollingElement.clientWidth-menuLeft-offsetWidth;this.$.dialog.style.right=menuRight+"px"}else{this.$.dialog.style.left=menuLeft+"px"}const menuTop=getStartPointWithAnchor(top,bottom,this.$.dialog.offsetHeight,c.anchorAlignmentY,c.minY,c.maxY);this.$.dialog.style.top=menuTop+"px"}onSlotchange_(){for(const node of this.$.contentNode.assignedElements({flatten:true})){if(node.classList.contains(DROPDOWN_ITEM_CLASS)&&!node.getAttribute("role")){node.setAttribute("role","menuitem")}}}addListeners_(){this.boundClose_=this.boundClose_||(()=>{if(this.$.dialog.open){this.close()}});window.addEventListener("resize",this.boundClose_);window.addEventListener("popstate",this.boundClose_);if(this.autoReposition){this.resizeObserver_=new ResizeObserver((()=>{if(this.lastConfig_){this.positionDialog_(this.lastConfig_);this.fire("cr-action-menu-repositioned")}}));this.resizeObserver_.observe(this.$.dialog)}}}customElements.define(CrActionMenuElement.is,CrActionMenuElement);let instance$f=null;function getCss$e(){return instance$f||(instance$f=[...[],css`[hidden],:host([hidden]){display:none !important}`])}let instance$e=null;function getCss$d(){return instance$e||(instance$e=[...[getCss$e()],css`:host{align-items:center;display:inline-flex;justify-content:center;position:relative;vertical-align:middle;fill:var(--iron-icon-fill-color,currentcolor);stroke:var(--iron-icon-stroke-color,none);width:var(--iron-icon-width,24px);height:var(--iron-icon-height,24px)}`])}let iconsetMap=null;class IconsetMap extends EventTarget{iconsets_=new Map;static getInstance(){return iconsetMap||(iconsetMap=new IconsetMap)}static resetInstanceForTesting(instance){iconsetMap=instance}get(id){return this.iconsets_.get(id)||null}set(id,iconset){assert(!this.iconsets_.has(id),`Tried to add a second iconset with id '${id}'`);this.iconsets_.set(id,iconset);this.dispatchEvent(new CustomEvent("cr-iconset-added",{detail:id}))}}class CrIconElement extends CrLitElement{static get is(){return"cr-icon"}static get styles(){return getCss$d()}static get properties(){return{icon:{type:String}}}#icon_accessor_storage="";get icon(){return this.#icon_accessor_storage}set icon(value){this.#icon_accessor_storage=value}iconsetName_="";iconName_="";iconset_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("icon")){const[iconsetName,iconName]=this.icon.split(":");this.iconName_=iconName||"";this.iconsetName_=iconsetName||"";this.updateIcon_()}}updateIcon_(){if(this.iconName_===""&&this.iconset_){this.iconset_.removeIcon(this)}else if(this.iconsetName_){const iconsetMap=IconsetMap.getInstance();this.iconset_=iconsetMap.get(this.iconsetName_);assert(this.iconset_,`Could not find iconset for: '${this.iconsetName_}:${this.iconName_}'`);this.iconset_.applyIcon(this,this.iconName_)}}}customElements.define(CrIconElement.is,CrIconElement);let instance$d=null;function getCss$c(){return instance$d||(instance$d=[...[],css`:host{bottom:0;display:block;left:0;overflow:hidden;pointer-events:none;position:absolute;right:0;top:0;transform:translate3d(0,0,0)}.ripple{background-color:currentcolor;left:0;opacity:var(--paper-ripple-opacity,0.25);pointer-events:none;position:absolute;will-change:height,transform,width}.ripple,:host(.circle){border-radius:50%}`])}const MAX_RADIUS_PX=300;const MIN_DURATION_MS=800;function distance(x1,y1,x2,y2){const xDelta=x1-x2;const yDelta=y1-y2;return Math.sqrt(xDelta*xDelta+yDelta*yDelta)}class CrRippleElement extends CrLitElement{static get is(){return"cr-ripple"}static get styles(){return getCss$c()}static get properties(){return{holdDown:{type:Boolean},recenters:{type:Boolean},noink:{type:Boolean}}}#holdDown_accessor_storage=false;get holdDown(){return this.#holdDown_accessor_storage}set holdDown(value){this.#holdDown_accessor_storage=value}#recenters_accessor_storage=false;get recenters(){return this.#recenters_accessor_storage}set recenters(value){this.#recenters_accessor_storage=value}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}ripples_=[];eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();assert(this.parentNode);const keyEventTarget=this.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?this.parentNode.host:this.parentElement;this.eventTracker_.add(keyEventTarget,"pointerdown",(e=>this.uiDownAction(e)));this.eventTracker_.add(keyEventTarget,"pointerup",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"pointerout",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"keydown",(e=>{if(e.defaultPrevented){return}if(e.key==="Enter"){this.onEnterKeydown_();return}if(e.key===" "){this.onSpaceKeydown_()}}));this.eventTracker_.add(keyEventTarget,"keyup",(e=>{if(e.defaultPrevented){return}if(e.key===" "){this.onSpaceKeyup_()}}))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("holdDown")){this.holdDownChanged_(this.holdDown,changedProperties.get("holdDown"))}}uiDownAction(e){if(e!==undefined&&e.button!==0){return}if(!this.noink){this.downAction_(e)}}downAction_(e){if(this.ripples_.length&&this.holdDown){return}this.showRipple_(e)}clear(){this.hideRipple_();this.holdDown=false}showAndHoldDown(){this.ripples_.forEach((ripple=>{ripple.remove()}));this.ripples_=[];this.holdDown=true}showRipple_(e){const rect=this.getBoundingClientRect();const roundedCenterX=function(){return Math.round(rect.width/2)};const roundedCenterY=function(){return Math.round(rect.height/2)};let x=0;let y=0;const centered=!e;if(centered){x=roundedCenterX();y=roundedCenterY()}else{x=Math.round(e.clientX-rect.left);y=Math.round(e.clientY-rect.top)}const corners=[{x:0,y:0},{x:rect.width,y:0},{x:0,y:rect.height},{x:rect.width,y:rect.height}];const cornerDistances=corners.map((function(corner){return Math.round(distance(x,y,corner.x,corner.y))}));const radius=Math.min(MAX_RADIUS_PX,Math.max.apply(Math,cornerDistances));const startTranslate=`${x-radius}px, ${y-radius}px`;let endTranslate=startTranslate;if(this.recenters&&!centered){endTranslate=`${roundedCenterX()-radius}px, ${roundedCenterY()-radius}px`}const ripple=document.createElement("div");ripple.classList.add("ripple");ripple.style.height=ripple.style.width=2*radius+"px";this.ripples_.push(ripple);this.shadowRoot.appendChild(ripple);ripple.animate({transform:[`translate(${startTranslate}) scale(0)`,`translate(${endTranslate}) scale(1)`]},{duration:Math.max(MIN_DURATION_MS,Math.log(radius)*radius)||0,easing:"cubic-bezier(.2, .9, .1, .9)",fill:"forwards"})}uiUpAction(){if(!this.noink){this.upAction_()}}upAction_(){if(!this.holdDown){this.hideRipple_()}}hideRipple_(){if(this.ripples_.length===0){return}this.ripples_.forEach((function(ripple){const opacity=ripple.computedStyleMap().get("opacity");if(opacity===null){ripple.remove();return}const animation=ripple.animate({opacity:[opacity.value,0]},{duration:150,fill:"forwards"});animation.finished.then((()=>{ripple.remove()}))}));this.ripples_=[]}onEnterKeydown_(){this.uiDownAction();window.setTimeout((()=>{this.uiUpAction()}),1)}onSpaceKeydown_(){this.uiDownAction()}onSpaceKeyup_(){this.uiUpAction()}holdDownChanged_(newHoldDown,oldHoldDown){if(oldHoldDown===undefined){return}if(newHoldDown){this.downAction_()}else{this.upAction_()}}}customElements.define(CrRippleElement.is,CrRippleElement);const CrRippleMixin=superClass=>{class CrRippleMixin extends superClass{static get properties(){return{noink:{type:Boolean}}}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}rippleContainer=null;ripple_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("noink")&&this.hasRipple()){assert(this.ripple_);this.ripple_.noink=this.noink}}ensureRippleOnPointerdown(){this.addEventListener("pointerdown",(()=>this.ensureRipple()),{capture:true})}ensureRipple(){if(this.hasRipple()){return}this.ripple_=this.createRipple();this.ripple_.noink=this.noink;const rippleContainer=this.rippleContainer||this.shadowRoot;assert(rippleContainer);rippleContainer.appendChild(this.ripple_)}getRipple(){this.ensureRipple();assert(this.ripple_);return this.ripple_}hasRipple(){return Boolean(this.ripple_)}createRipple(){const ripple=document.createElement("cr-ripple");ripple.id="ink";return ripple}}return CrRippleMixin};let instance$c=null;function getCss$b(){return instance$c||(instance$c=[...[],css`:host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:32px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;position:relative;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}#ink{--paper-ripple-opacity:1;color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([suppress-rtl-flip]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([suppress-rtl-flip])[multiple-icons_]) cr-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}cr-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}`])}function getHtml$8(){return html`
<div id="icon">
  <div id="maskedImage"></div>
</div>`}const CrIconbuttonElementBase=CrRippleMixin(CrLitElement);class CrIconButtonElement extends CrIconbuttonElementBase{static get is(){return"cr-icon-button"}static get styles(){return getCss$b()}render(){return getHtml$8.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},ironIcon:{type:String,reflect:true},suppressRtlFlip:{type:Boolean,value:false,reflect:true},multipleIcons_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ironIcon_accessor_storage;get ironIcon(){return this.#ironIcon_accessor_storage}set ironIcon(value){this.#ironIcon_accessor_storage=value}#multipleIcons__accessor_storage=false;get multipleIcons_(){return this.#multipleIcons__accessor_storage}set multipleIcons_(value){this.#multipleIcons__accessor_storage=value}spaceKeyDown_=false;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("ironIcon")){const icons=(this.ironIcon||"").split(",");this.multipleIcons_=icons.length>1}}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}if(changedProperties.has("ironIcon")){this.onIronIconChanged_()}}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onIronIconChanged_(){this.shadowRoot.querySelectorAll("cr-icon").forEach((el=>el.remove()));if(!this.ironIcon){return}const icons=(this.ironIcon||"").split(",");icons.forEach((async icon=>{const crIcon=document.createElement("cr-icon");crIcon.icon=icon;this.$.icon.appendChild(crIcon);await crIcon.updateComplete;crIcon.shadowRoot.querySelectorAll("svg, img").forEach((child=>child.setAttribute("role","none")))}))}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click()}}}customElements.define(CrIconButtonElement.is,CrIconButtonElement);let instance$b=null;function getCss$a(){return instance$b||(instance$b=[...[],css`.icon-arrow-back{--cr-icon-image:url(//resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(//resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(//resources/images/icon_arrow_drop_up_cr23.svg)}.icon-arrow-upward{--cr-icon-image:url(//resources/images/icon_arrow_upward.svg)}.icon-cancel{--cr-icon-image:url(//resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(//resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(//resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(//resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(//resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(//resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(//resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(//resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(//resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(//resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(//resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(//resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(//resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(//resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(//resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(//resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(//resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(//resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--google-grey-700));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--google-grey-500))}}`])}let instance$a=null;function getCss$9(){return instance$a||(instance$a=[...[],css`:host{display:none}`])}function getHtml$7(){return html`
<svg id="baseSvg" xmlns="http://www.w3.org/2000/svg"
     viewBox="0 0 ${this.size} ${this.size}"
     preserveAspectRatio="xMidYMid meet" focusable="false"
     style="pointer-events: none; display: block; width: 100%; height: 100%;">
 </svg>
<slot></slot>
`}const APPLIED_ICON_CLASS="cr-iconset-svg-icon_";class CrIconsetElement extends CrLitElement{static get is(){return"cr-iconset"}static get styles(){return getCss$9()}render(){return getHtml$7.bind(this)()}static get properties(){return{name:{type:String},size:{type:Number}}}#name_accessor_storage="";get name(){return this.#name_accessor_storage}set name(value){this.#name_accessor_storage=value}#size_accessor_storage=24;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("name")){assert(changedProperties.get("name")===undefined);IconsetMap.getInstance().set(this.name,this)}}applyIcon(element,iconName){this.removeIcon(element);const svg=this.cloneIcon_(iconName);if(svg){svg.classList.add(APPLIED_ICON_CLASS);element.shadowRoot.insertBefore(svg,element.shadowRoot.childNodes[0]);return svg}return null}createIcon(iconName){return this.cloneIcon_(iconName)}removeIcon(element){const oldSvg=element.shadowRoot.querySelector(`.${APPLIED_ICON_CLASS}`);if(oldSvg){oldSvg.remove()}}cloneIcon_(id){const sourceSvg=this.querySelector(`g[id="${id}"]`);if(!sourceSvg){return null}const svgClone=this.$.baseSvg.cloneNode(true);const content=sourceSvg.cloneNode(true);content.removeAttribute("id");const contentViewBox=content.getAttribute("viewBox");if(contentViewBox){svgClone.setAttribute("viewBox",contentViewBox)}svgClone.appendChild(content);return svgClone}}customElements.define(CrIconsetElement.is,CrIconsetElement);function isValidArray(arr){if(arr instanceof Array&&Object.isFrozen(arr)){return true}return false}function getStaticString(literal){const isStaticString=isValidArray(literal)&&!!literal.raw&&isValidArray(literal.raw)&&literal.length===literal.raw.length&&literal.length===1;assert(isStaticString,"static_types.js only allows static strings");return literal.join("")}function createTypes(_ignore,literal){return getStaticString(literal)}const rules={createHTML:createTypes,createScript:createTypes,createScriptURL:createTypes};let staticPolicy;if(window.trustedTypes){staticPolicy=window.trustedTypes.createPolicy("static-types",rules)}else{staticPolicy=rules}function getTrustedHTML(literal){return staticPolicy.createHTML("",literal)}function getTrustedScriptURL(literal){return staticPolicy.createScriptURL("",literal)}const div=document.createElement("div");div.innerHTML=getTrustedHTML`
<cr-iconset name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M 5.832031 17.5 C 5.375 17.5 4.984375 17.335938 4.65625 17.011719 C 4.328125 16.683594 4.167969 16.292969 4.167969 15.832031 L 4.167969 5 L 3.332031 5 L 3.332031 3.332031 L 7.5 3.332031 L 7.5 2.5 L 12.5 2.5 L 12.5 3.332031 L 16.667969 3.332031 L 16.667969 5 L 15.832031 5 L 15.832031 15.832031 C 15.832031 16.292969 15.671875 16.683594 15.34375 17.011719 C 15.015625 17.335938 14.625 17.5 14.167969 17.5 Z M 14.167969 5 L 5.832031 5 L 5.832031 15.832031 L 14.167969 15.832031 Z M 7.5 14.167969 L 9.167969 14.167969 L 9.167969 6.667969 L 7.5 6.667969 Z M 10.832031 14.167969 L 12.5 14.167969 L 12.5 6.667969 L 10.832031 6.667969 Z M 5.832031 5 L 5.832031 15.832031 Z M 5.832031 5 ">
        </path>
      </g>
      <g id="domain" viewBox="0 -960 960 960">
        <path d="M96-144v-672h384v144h384v528H96Zm72-72h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm168 456h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm0-152h72v-72h-72v72Zm144 456h312v-384H480v80h72v72h-72v80h72v72h-72v80Zm168-232v-72h72v72h-72Zm0 152v-72h72v72h-72Z"></path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
      <g id="password">
        <path d="M5.833 11.667c.458 0 .847-.16 1.167-.479.333-.333.5-.729.5-1.188s-.167-.847-.5-1.167a1.555 1.555 0 0 0-1.167-.5c-.458 0-.854.167-1.188.5A1.588 1.588 0 0 0 4.166 10c0 .458.16.854.479 1.188.333.319.729.479 1.188.479Zm0 3.333c-1.389 0-2.569-.486-3.542-1.458C1.319 12.569.833 11.389.833 10c0-1.389.486-2.569 1.458-3.542C3.264 5.486 4.444 5 5.833 5c.944 0 1.813.243 2.604.729a4.752 4.752 0 0 1 1.833 1.979h7.23c.458 0 .847.167 1.167.5.333.319.5.708.5 1.167v3.958c0 .458-.167.854-.5 1.188A1.588 1.588 0 0 1 17.5 15h-3.75a1.658 1.658 0 0 1-1.188-.479 1.658 1.658 0 0 1-.479-1.188v-1.042H10.27a4.59 4.59 0 0 1-1.813 2A5.1 5.1 0 0 1 5.833 15Zm3.292-4.375h4.625v2.708H15v-1.042a.592.592 0 0 1 .167-.438.623.623 0 0 1 .458-.188c.181 0 .327.063.438.188a.558.558 0 0 1 .188.438v1.042H17.5V9.375H9.125a3.312 3.312 0 0 0-1.167-1.938 3.203 3.203 0 0 0-2.125-.77 3.21 3.21 0 0 0-2.354.979C2.827 8.298 2.5 9.083 2.5 10s.327 1.702.979 2.354a3.21 3.21 0 0 0 2.354.979c.806 0 1.514-.25 2.125-.75.611-.514 1-1.167 1.167-1.958Z"></path>
      </g>
      
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="m7.824 13 5.602 5.602L12 20l-8-8 8-8 1.426 1.398L7.824 11H20v2Zm0 0">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle" viewBox="0 -960 960 960">
        <path d="m424-296 282-282-56-56-226 226-114-114-56 56 170 170Zm56 216q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="chrome-product" viewBox="0 -960 960 960">
        <path d="M336-479q0 60 42 102t102 42q60 0 102-42t42-102q0-60-42-102t-102-42q-60 0-102 42t-42 102Zm144 216q11 0 22.5-.5T525-267L427-99q-144-16-237.5-125T96-479q0-43 9.5-84.5T134-645l160 274q28 51 78 79.5T480-263Zm0-432q-71 0-126.5 42T276-545l-98-170q53-71 132.5-109.5T480-863q95 0 179 45t138 123H480Zm356 72q15 35 21.5 71t6.5 73q0 155-100 260.5T509-96l157-275q14-25 22-52t8-56q0-40-15-77t-41-67h196Z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete" viewBox="0 -960 960 960">
        <path
          d="M309.37-135.87q-34.48 0-58.74-24.26-24.26-24.26-24.26-58.74v-474.5h-53.5v-83H378.5v-53.5h202.52v53.5h206.11v83h-53.5v474.07q0 35.21-24.26 59.32t-58.74 24.11H309.37Zm341.26-557.5H309.37v474.5h341.26v-474.5ZM379.7-288.24h77.5v-336h-77.5v336Zm123.1 0h77.5v-336h-77.5v336ZM309.37-693.37v474.5-474.5Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <!-- source: https://fonts.google.com/icons?selected=Material+Symbols+Outlined:family_link:FILL@0;wght@0;GRAD@0;opsz@24&icon.size=24&icon.color=%23e8eaed -->
      <g id="kite" viewBox="0 -960 960 960">
        <path
          d="M390-40q-51 0-90.5-30.5T246-149q-6-23-25-37t-43-14q-16 0-30 6.5T124-175l-61-51q21-26 51.5-40t63.5-14q51 0 91 30t54 79q6 23 25 37t42 14q19 0 34-10t26-25l1-2-276-381q-8-11-11.5-23t-3.5-24q0-16 6-30.5t18-26.5l260-255q11-11 26-17t30-6q15 0 30 6t26 17l260 255q12 12 18 26.5t6 30.5q0 12-3.5 24T825-538L500-88q-18 25-48 36.5T390-40Zm110-185 260-360-260-255-259 256 259 359Zm1-308Z"/>
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new" viewBox="0 -960 960 960">
        <path
          d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h264v72H216v528h528v-264h72v264q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm171-192-51-51 357-357H576v-72h240v240h-72v-117L387-336Z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync" viewBox="0 -960 960 960">
        <path
          d="M216-192v-72h74q-45-40-71.5-95.5T192-480q0-101 61-177.5T408-758v75q-63 23-103.5 77.5T264-480q0 48 19.5 89t52.5 70v-63h72v192H216Zm336-10v-75q63-23 103.5-77.5T696-480q0-48-19.5-89T624-639v63h-72v-192h192v72h-74q45 40 71.5 95.5T768-480q0 101-61 177.5T552-202Z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam" viewBox="0 -960 960 960">
        <path
          d="M216-192q-29 0-50.5-21.5T144-264v-432q0-29.7 21.5-50.85Q187-768 216-768h432q29.7 0 50.85 21.15Q720-725.7 720-696v168l144-144v384L720-432v168q0 29-21.15 50.5T648-192H216Zm0-72h432v-432H216v432Zm0 0v-432 432Z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}const UrlSpec={$:{}};mojo.internal.Struct(UrlSpec.$,"Url",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);function getSupportedScaleFactors(){const supportedScaleFactors=[];if(!isIOS){supportedScaleFactors.push(1)}if(!isIOS&&!isAndroid){supportedScaleFactors.push(2)}else{supportedScaleFactors.push(window.devicePixelRatio)}return supportedScaleFactors}function getUrlForCss(s){const s2=s.replace(/(\(|\)|\,|\s|\'|\"|\\)/g,"\\$1");return`url("${s2}")`}function getImageSet(path){const supportedScaleFactors=getSupportedScaleFactors();const replaceStartIndex=path.indexOf("SCALEFACTOR");if(replaceStartIndex<0){return getUrlForCss(path)}let s="";for(let i=0;i<supportedScaleFactors.length;++i){const scaleFactor=supportedScaleFactors[i];const pathWithScaleFactor=path.substr(0,replaceStartIndex)+scaleFactor+path.substr(replaceStartIndex+"scalefactor".length);s+=getUrlForCss(pathWithScaleFactor)+" "+scaleFactor+"x";if(i!==supportedScaleFactors.length-1){s+=", "}}return"image-set("+s+")"}function getBaseFaviconUrl(){const faviconUrl=new URL("chrome://favicon2/");faviconUrl.searchParams.set("size","16");faviconUrl.searchParams.set("scaleFactor","SCALEFACTORx");return faviconUrl}function getDefaultFaviconUrlParams(){return{isSyncedUrlForHistoryUi:false,remoteIconUrlForUma:"",size:16,forceLightMode:false,fallbackToHost:true,ignoreCache:false,forceEmptyDefaultFavicon:false,scaleFactor:""}}function getFaviconUrl(url,optionalParams){const params=Object.assign(getDefaultFaviconUrlParams(),optionalParams);const faviconUrl=getBaseFaviconUrl();faviconUrl.searchParams.set("pageUrl",url);faviconUrl.searchParams.set("size",params.size.toString());const fallback=params.isSyncedUrlForHistoryUi?"1":"0";faviconUrl.searchParams.set("allowGoogleServerFallback",fallback);if(params.isSyncedUrlForHistoryUi){faviconUrl.searchParams.set("iconUrl",params.remoteIconUrlForUma)}if(params.forceLightMode){faviconUrl.searchParams.set("forceLightMode","true")}if(!params.fallbackToHost){faviconUrl.searchParams.set("fallbackToHost","0")}if(params.ignoreCache){faviconUrl.searchParams.set("cacheBypass",String(Date.now()))}if(params.forceEmptyDefaultFavicon){faviconUrl.searchParams.set("forceEmptyDefaultFavicon","1")}if(params.scaleFactor){faviconUrl.searchParams.set("scaleFactor",params.scaleFactor)}return faviconUrl.toString()}function getFaviconForPageURL(url,isSyncedUrlForHistoryUi,remoteIconUrlForUma="",size=16,forceLightMode=false,fallbackToHost=true,ignoreCache=false,forceEmptyDefaultFavicon=false,scaleFactor=""){return getImageSet(getFaviconUrl(url,{isSyncedUrlForHistoryUi:isSyncedUrlForHistoryUi,remoteIconUrlForUma:remoteIconUrlForUma,size:size,forceLightMode:forceLightMode,fallbackToHost:fallbackToHost,ignoreCache:ignoreCache,forceEmptyDefaultFavicon:forceEmptyDefaultFavicon,scaleFactor:scaleFactor}))}let instance$9=null;function getCss$8(){return instance$9||(instance$9=[...[getCss$e()],css`:host{--cr-button-background-color:transparent;--cr-button-border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--cr-button-text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--cr-button-ripple-opacity:1;--cr-button-ripple-color:var(--cr-active-background-color);--cr-button-disabled-background-color:transparent;--cr-button-disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground))}:host(.action-button){--cr-button-background-color:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--cr-button-text-color:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--cr-button-ripple-color:var(--cr-active-on-primary-background-color);--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host(.tonal-button),:host(.floating-button){--cr-button-background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container));--cr-button-text-color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container));--cr-button-border:none;--cr-button-disabled-background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background));--cr-button-disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--cr-button-disabled-border:none}:host{flex-shrink:0;display:inline-flex;align-items:center;justify-content:center;box-sizing:border-box;min-width:5.14em;height:var(--cr-button-height);padding:8px 16px;outline-width:0;overflow:hidden;position:relative;cursor:pointer;user-select:none;-webkit-tap-highlight-color:transparent;border:var(--cr-button-border,1px solid var(--cr-button-border-color));border-radius:100px;background:var(--cr-button-background-color);color:var(--cr-button-text-color);font-weight:500;line-height:20px;isolation:isolate}@media (forced-colors:active){:host{forced-color-adjust:none}}:host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;gap:8px;padding-block-end:8px;padding-block-start:8px}:host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}:host-context(.focus-outline-visible):host(:focus){box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:2px}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute}#content{display:inline}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host([disabled]){background:var(--cr-button-disabled-background-color);border:var(--cr-button-disabled-border,1px solid var(--cr-button-disabled-border-color));color:var(--cr-button-disabled-text-color);cursor:auto;pointer-events:none}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}#ink{color:var(--cr-button-ripple-color);--paper-ripple-opacity:var(--cr-button-ripple-opacity)}#background{z-index:0}#hoverBackground,cr-ripple{z-index:1}#content,::slotted(*){z-index:2}`])}function getHtml$6(){return html`
<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    @slotchange="${this.onPrefixIconSlotChanged_}">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    @slotchange="${this.onSuffixIconSlotChanged_}">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>`}const CrButtonElementBase=CrRippleMixin(CrLitElement);class CrButtonElement extends CrButtonElementBase{static get is(){return"cr-button"}static get styles(){return getCss$8()}render(){return getHtml$6.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},hasPrefixIcon_:{type:Boolean,reflect:true},hasSuffixIcon_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#hasPrefixIcon__accessor_storage=false;get hasPrefixIcon_(){return this.#hasPrefixIcon__accessor_storage}set hasPrefixIcon_(value){this.#hasPrefixIcon__accessor_storage=value}#hasSuffixIcon__accessor_storage=false;get hasSuffixIcon_(){return this.#hasSuffixIcon__accessor_storage}set hasSuffixIcon_(value){this.#hasSuffixIcon__accessor_storage=value}spaceKeyDown_=false;timeoutIds_=new Set;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}FocusOutlineManager.forDocument(document)}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}}disconnectedCallback(){super.disconnectedCallback();this.timeoutIds_.forEach(clearTimeout);this.timeoutIds_.clear()}setTimeout_(fn,delay){if(!this.isConnected){return}const id=setTimeout((()=>{this.timeoutIds_.delete(id);fn()}),delay);this.timeoutIds_.add(id)}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false;this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onPrefixIconSlotChanged_(){this.hasPrefixIcon_=this.$.prefixIcon.assignedElements().length>0}onSuffixIconSlotChanged_(){this.hasSuffixIcon_=this.$.suffixIcon.assignedElements().length>0}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}this.getRipple().uiDownAction();if(e.key==="Enter"){this.click();this.setTimeout_((()=>this.getRipple().uiUpAction()),100)}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click();this.getRipple().uiUpAction()}}}customElements.define(CrButtonElement.is,CrButtonElement);let instance$8=null;function getCss$7(){return instance$8||(instance$8=[...[],css`.cr-scrollable{anchor-name:--cr-scrollable;anchor-scope:--cr-scrollable;container-type:scroll-state;overflow:auto}.cr-scrollable-top,.cr-scrollable-top-shadow,.cr-scrollable-bottom{display:none;position:fixed;position-anchor:--cr-scrollable;left:anchor(left);width:anchor-size(width);pointer-events:none;&:where(.force-on){display:block}}.cr-scrollable-top{top:anchor(top);border-top:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:top){display:block}}.cr-scrollable-bottom{bottom:anchor(bottom);border-bottom:1px solid var(--cr-scrollable-border-color);@container scroll-state(scrollable:bottom){display:block}}.cr-scrollable-top-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);display:block;height:8px;opacity:0;top:anchor(top);transition:opacity 500ms;z-index:1;&:where(.force-on){opacity:1}@container scroll-state(scrollable:top){opacity:1}}`])}let instance$7=null;function getCss$6(){return instance$7||(instance$7=[...[getCss$e(),getCss$a(),getCss$7()],css`dialog{background-color:var(--cr-dialog-background-color,white);border:0;border-radius:var(--cr-dialog-border-radius,8px);bottom:50%;box-shadow:0 0 16px rgba(0,0,0,0.12),0 16px 16px rgba(0,0,0,0.24);color:inherit;line-height:20px;max-height:initial;max-width:initial;overflow-y:hidden;padding:0;position:absolute;top:50%;width:var(--cr-dialog-width,512px)}@media (prefers-color-scheme:dark){dialog{background-color:var(--cr-dialog-background-color,var(--google-grey-900));background-image:linear-gradient(rgba(255,255,255,.04),rgba(255,255,255,.04))}}@media (forced-colors:active){dialog{border:var(--cr-border-hcm)}}dialog[open] #content-wrapper{display:flex;flex-direction:column;max-height:100vh;overflow:auto}.top-container,:host ::slotted([slot=button-container]),:host ::slotted([slot=footer]){flex-shrink:0}dialog::backdrop{background-color:rgba(0,0,0,0.6);bottom:0;left:0;position:fixed;right:0;top:0}:host ::slotted([slot=body]){color:var(--cr-secondary-text-color);padding:0 var(--cr-dialog-body-padding-horizontal,20px)}:host ::slotted([slot=title]){color:var(--cr-primary-text-color);flex:1;font-family:var(--cr-dialog-font-family,inherit);font-size:var(--cr-dialog-title-font-size,calc(15 / 13 * 100%));line-height:1;padding-bottom:var(--cr-dialog-title-slot-padding-bottom,16px);padding-inline-end:var(--cr-dialog-title-slot-padding-end,20px);padding-inline-start:var(--cr-dialog-title-slot-padding-start,20px);padding-top:var(--cr-dialog-title-slot-padding-top,20px)}:host ::slotted([slot=button-container]){display:flex;justify-content:flex-end;padding-bottom:var(--cr-dialog-button-container-padding-bottom,16px);padding-inline-end:var(--cr-dialog-button-container-padding-horizontal,16px);padding-inline-start:var(--cr-dialog-button-container-padding-horizontal,16px);padding-top:var(--cr-dialog-button-container-padding-top,16px)}:host ::slotted([slot=footer]){border-bottom-left-radius:inherit;border-bottom-right-radius:inherit;border-top:1px solid #dbdbdb;margin:0;padding:16px 20px}:host([hide-backdrop]) dialog::backdrop{opacity:0}@media (prefers-color-scheme:dark){:host ::slotted([slot=footer]){border-top-color:var(--cr-separator-color)}}.body-container{box-sizing:border-box;display:flex;flex-direction:column;min-height:1.375rem;overflow:auto}.top-container{align-items:flex-start;display:flex;min-height:var(--cr-dialog-top-container-min-height,31px)}.title-container{display:flex;flex:1;font-size:inherit;font-weight:inherit;margin:0;outline:none}#close{align-self:flex-start;margin-inline-end:4px;margin-top:4px}@container style(--cr-dialog-body-border-top){.cr-scrollable-top{display:block;border-top:var(--cr-dialog-body-border-top)}}`])}function getHtml$5(){return html`
<dialog id="dialog" @close="${this.onNativeDialogClose_}"
    @cancel="${this.onNativeDialogCancel_}" part="dialog"
    aria-labelledby="title"
    aria-description="${this.ariaDescriptionText||nothing}">
<!-- This wrapper is necessary, such that the "pulse" animation is not
    erroneously played when the user clicks on the outer-most scrollbar. -->
  <div id="content-wrapper" part="wrapper">
    <div class="top-container">
      <h2 id="title" class="title-container" tabindex="-1">
        <slot name="title"></slot>
      </h2>
      ${this.showCloseButton?html`
        <cr-icon-button id="close" class="icon-clear"
            aria-label="${this.closeText||nothing}"
            title="${this.closeText||nothing}"
            @click="${this.cancel}" @keypress="${this.onCloseKeypress_}">
        </cr-icon-button>
       `:""}
    </div>
    <slot name="header"></slot>
    <div class="body-container cr-scrollable" id="container"
        part="body-container">
      <div class="cr-scrollable-top"></div>
      <slot name="body"></slot>
      <div class="cr-scrollable-bottom"></div>
    </div>
    <slot name="button-container"></slot>
    <slot name="footer"></slot>
  </div>
</dialog>`}class CrDialogElement extends CrLitElement{static get is(){return"cr-dialog"}static get styles(){return getCss$6()}render(){return getHtml$5.bind(this)()}static get properties(){return{open:{type:Boolean,reflect:true},closeText:{type:String},ignorePopstate:{type:Boolean},ignoreEnterKey:{type:Boolean},consumeKeydownEvent:{type:Boolean},noCancel:{type:Boolean},showCloseButton:{type:Boolean},showOnAttach:{type:Boolean},ariaDescriptionText:{type:String}}}#closeText_accessor_storage;get closeText(){return this.#closeText_accessor_storage}set closeText(value){this.#closeText_accessor_storage=value}#consumeKeydownEvent_accessor_storage=false;get consumeKeydownEvent(){return this.#consumeKeydownEvent_accessor_storage}set consumeKeydownEvent(value){this.#consumeKeydownEvent_accessor_storage=value}#ignoreEnterKey_accessor_storage=false;get ignoreEnterKey(){return this.#ignoreEnterKey_accessor_storage}set ignoreEnterKey(value){this.#ignoreEnterKey_accessor_storage=value}#ignorePopstate_accessor_storage=false;get ignorePopstate(){return this.#ignorePopstate_accessor_storage}set ignorePopstate(value){this.#ignorePopstate_accessor_storage=value}#noCancel_accessor_storage=false;get noCancel(){return this.#noCancel_accessor_storage}set noCancel(value){this.#noCancel_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}#showCloseButton_accessor_storage=false;get showCloseButton(){return this.#showCloseButton_accessor_storage}set showCloseButton(value){this.#showCloseButton_accessor_storage=value}#showOnAttach_accessor_storage=false;get showOnAttach(){return this.#showOnAttach_accessor_storage}set showOnAttach(value){this.#showOnAttach_accessor_storage=value}#ariaDescriptionText_accessor_storage;get ariaDescriptionText(){return this.#ariaDescriptionText_accessor_storage}set ariaDescriptionText(value){this.#ariaDescriptionText_accessor_storage=value}mutationObserver_=null;boundKeydown_=null;firstUpdated(){window.addEventListener("popstate",(()=>{if(!this.ignorePopstate&&this.$.dialog.open){this.cancel()}}));if(!this.ignoreEnterKey){this.addEventListener("keypress",this.onKeypress_.bind(this))}this.addEventListener("pointerdown",(e=>this.onPointerdown_(e)))}connectedCallback(){super.connectedCallback();const mutationObserverCallback=()=>{if(this.$.dialog.open){this.addKeydownListener_()}else{this.removeKeydownListener_()}};this.mutationObserver_=new MutationObserver(mutationObserverCallback);this.mutationObserver_.observe(this.$.dialog,{attributes:true,attributeFilter:["open"]});mutationObserverCallback();if(this.showOnAttach){this.showModal()}}disconnectedCallback(){super.disconnectedCallback();this.removeKeydownListener_();if(this.mutationObserver_){this.mutationObserver_.disconnect();this.mutationObserver_=null}}addKeydownListener_(){if(!this.consumeKeydownEvent){return}this.boundKeydown_=this.boundKeydown_||this.onKeydown_.bind(this);this.addEventListener("keydown",this.boundKeydown_);document.body.addEventListener("keydown",this.boundKeydown_)}removeKeydownListener_(){if(!this.boundKeydown_){return}this.removeEventListener("keydown",this.boundKeydown_);document.body.removeEventListener("keydown",this.boundKeydown_);this.boundKeydown_=null}async showModal(){if(this.showOnAttach){const element=this.querySelector("[autofocus]");if(element&&element instanceof CrLitElement&&!element.shadowRoot){element.ensureInitialRender()}}this.$.dialog.showModal();assert(this.$.dialog.open);this.open=true;await this.updateComplete;this.fire("cr-dialog-open")}cancel(){this.fire("cancel");this.$.dialog.close();assert(!this.$.dialog.open);this.open=false}close(){this.$.dialog.close("success");assert(!this.$.dialog.open);this.open=false}setTitleAriaLabel(title){this.$.dialog.removeAttribute("aria-labelledby");this.$.dialog.setAttribute("aria-label",title)}onCloseKeypress_(e){e.stopPropagation()}onNativeDialogClose_(e){if(e.target!==this.getNative()){return}this.fire("close")}async onNativeDialogCancel_(e){if(e.target!==this.getNative()){return}if(this.noCancel){e.preventDefault();return}this.open=false;await this.updateComplete;this.fire("cancel")}getNative(){return this.$.dialog}onKeypress_(e){if(e.key!=="Enter"){return}const accept=e.target===this||e.composedPath().some((el=>el.tagName==="CR-INPUT"&&el.type!=="search"));if(!accept){return}const actionButton=this.querySelector(".action-button:not([disabled]):not([hidden])");if(actionButton){actionButton.click();e.preventDefault()}}onKeydown_(e){assert(this.consumeKeydownEvent);if(!this.getNative().open){return}if(this.ignoreEnterKey&&e.key==="Enter"){return}e.stopPropagation()}onPointerdown_(e){if(e.button!==0||e.composedPath()[0].tagName!=="DIALOG"){return}this.$.dialog.animate([{transform:"scale(1)",offset:0},{transform:"scale(1.02)",offset:.4},{transform:"scale(1.02)",offset:.6},{transform:"scale(1)",offset:1}],{duration:180,easing:"ease-in-out",iterations:1});e.preventDefault()}focus(){const titleContainer=this.shadowRoot.querySelector(".title-container");assert(titleContainer);titleContainer.focus()}}customElements.define(CrDialogElement.is,CrDialogElement);class CrLazyRenderLitElement extends CrLitElement{static get is(){return"cr-lazy-render-lit"}static get properties(){return{template:{type:Object},rendered_:{type:Boolean,state:true}}}#rendered__accessor_storage=false;get rendered_(){return this.#rendered__accessor_storage}set rendered_(value){this.#rendered__accessor_storage=value}#template_accessor_storage=()=>html``;get template(){return this.#template_accessor_storage}set template(value){this.#template_accessor_storage=value}child_=null;render(){if(this.rendered_){render(this.template(),this.parentNode,{host:this.getRootNode().host,renderBefore:this})}return html``}get(){if(!this.rendered_){this.rendered_=true;this.performUpdate();this.child_=this.previousElementSibling}assert(this.child_);return this.child_}getIfExists(){return this.child_}}customElements.define(CrLazyRenderLitElement.is,CrLazyRenderLitElement);function emptyHTML(){return window.trustedTypes?window.trustedTypes.emptyHTML:""}class CustomElement extends HTMLElement{static get template(){return emptyHTML()}constructor(){super();this.attachShadow({mode:"open"});const template=document.createElement("template");template.innerHTML=this.constructor.template||emptyHTML();this.shadowRoot.appendChild(template.content.cloneNode(true))}$(query){return this.shadowRoot.querySelector(query)}$all(query){return this.shadowRoot.querySelectorAll(query)}getRequiredElement(query){const el=this.shadowRoot.querySelector(query);assert(el);assert(el instanceof HTMLElement);return el}}function getTemplate(){return getTrustedHTML`<!--_html_template_start_--><style>:host{clip:rect(0 0 0 0);height:1px;overflow:hidden;position:fixed;width:1px}</style>

<div id="messages" role="alert" aria-live="polite" aria-relevant="additions">
</div>
<!--_html_template_end_-->`}const TIMEOUT_MS=150;const instances=new Map;function getInstance(container=document.body){if(instances.has(container)){return instances.get(container)}assert(container.isConnected);const instance=new CrA11yAnnouncerElement;container.appendChild(instance);instances.set(container,instance);return instance}class CrA11yAnnouncerElement extends CustomElement{static get is(){return"cr-a11y-announcer"}static get template(){return getTemplate()}currentTimeout_=null;messages_=[];disconnectedCallback(){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}for(const[parent,instance]of instances){if(instance===this){instances.delete(parent);break}}}announce(message,timeout=TIMEOUT_MS){if(this.currentTimeout_!==null){clearTimeout(this.currentTimeout_);this.currentTimeout_=null}this.messages_.push(message);this.currentTimeout_=setTimeout((()=>{const messagesDiv=this.shadowRoot.querySelector("#messages");messagesDiv.innerHTML=window.trustedTypes.emptyHTML;for(const message of this.messages_){const div=document.createElement("div");div.textContent=message;messagesDiv.appendChild(div)}this.dispatchEvent(new CustomEvent("cr-a11y-announcer-messages-sent",{bubbles:true,detail:{messages:this.messages_.slice()}}));this.messages_.length=0;this.currentTimeout_=null}),timeout)}}customElements.define(CrA11yAnnouncerElement.is,CrA11yAnnouncerElement);class HistorySearchedLabelElement extends CrLitElement{static get is(){return"history-searched-label"}render(){return html`<slot></slot>`}static get properties(){return{title:{type:String},searchTerm:{type:String}}}#searchTerm_accessor_storage;get searchTerm(){return this.#searchTerm_accessor_storage}set searchTerm(value){this.#searchTerm_accessor_storage=value}#title_accessor_storage;get title(){return this.#title_accessor_storage}set title(value){this.#title_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("title")||changedProperties.has("searchTerm")){this.setSearchedTextToBold_()}}setSearchedTextToBold_(){if(this.title===undefined){return}const titleText=this.title;if(this.searchTerm===""||this.searchTerm===null||this.searchTerm===undefined){this.textContent=titleText;return}const re=new RegExp(quoteString(this.searchTerm),"gim");let i=0;let match;this.textContent="";while(match=re.exec(titleText)){if(match.index>i){this.appendChild(document.createTextNode(titleText.slice(i,match.index)))}i=re.lastIndex;const b=document.createElement("b");b.textContent=titleText.substring(match.index,i);this.appendChild(b)}if(i<titleText.length){this.appendChild(document.createTextNode(titleText.slice(i)))}}}customElements.define(HistorySearchedLabelElement.is,HistorySearchedLabelElement);let instance$6=null;function getCss$5(){return instance$6||(instance$6=[...[],css`:host{-webkit-tap-highlight-color:transparent;align-items:center;cursor:pointer;display:flex;outline:none;user-select:none;--cr-checkbox-border-size:2px;--cr-checkbox-size:16px;--cr-checkbox-ripple-size:32px;--cr-checkbox-ripple-offset:50%;--cr-checkbox-checked-box-color:var(--cr-checked-color);--cr-checkbox-ripple-checked-color:var(--cr-active-background-color);--cr-checkbox-ripple-opacity:1;--cr-checkbox-mark-color:var(--color-checkbox-check,var(--cr-fallback-color-on-primary));--cr-checkbox-ripple-unchecked-color:var(--cr-active-background-color);--cr-checkbox-unchecked-box-color:var(--color-checkbox-foreground-unchecked,var(--cr-fallback-color-outline));--cr-checkbox-checked-ripple-opacity:.2;--cr-checkbox-unchecked-ripple-opacity:.15}@media (prefers-color-scheme:dark){:host{--cr-checkbox-checked-ripple-opacity:.4;--cr-checkbox-unchecked-ripple-opacity:.4}}:host([disabled]){cursor:initial;opacity:1;pointer-events:none;--cr-checkbox-checked-box-color:var(--color-checkbox-container-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-unchecked-box-color:var(--color-checkbox-outline-disabled,var(--cr-fallback-color-disabled-background));--cr-checkbox-mark-color:var(--color-checkbox-check-disabled,var(--cr-fallback-color-disabled-foreground))}#checkbox{background:none;border:var(--cr-checkbox-border-size) solid var(--cr-checkbox-unchecked-box-color);border-radius:2px;box-sizing:border-box;cursor:pointer;display:block;flex-shrink:0;height:var(--cr-checkbox-size);isolation:isolate;margin:0;outline:none;padding:0;position:relative;transform:none;width:var(--cr-checkbox-size)}:host([disabled][checked]) #checkbox{border-color:transparent}#hover-layer{display:none}#checkbox:hover #hover-layer{background-color:var(--cr-hover-background-color);border-radius:50%;display:block;height:32px;left:50%;overflow:hidden;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:32px}@media (forced-colors:active){:host(:focus) #checkbox{outline:var(--cr-focus-outline-hcm)}}#checkbox:focus-visible{outline:var(--cr-checkbox-focus-outline,2px solid var(--cr-focus-outline-color));outline-offset:2px}#checkmark{display:block;forced-color-adjust:auto;position:relative;transform:scale(0);z-index:1}#checkmark path{fill:var(--cr-checkbox-mark-color)}:host([checked]) #checkmark{transform:scale(1);transition:transform 140ms ease-out}:host([checked]) #checkbox{background:var(--cr-checkbox-checked-box-background-color,var(--cr-checkbox-checked-box-color));border-color:var(--cr-checkbox-checked-box-color)}#ink{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-unchecked-ripple-opacity));color:var(--cr-checkbox-ripple-unchecked-color);height:var(--cr-checkbox-ripple-size);left:var(--cr-checkbox-ripple-offset);outline:var(--cr-checkbox-ripple-ring,none);pointer-events:none;top:var(--cr-checkbox-ripple-offset);transform:translate(-50%,-50%);transition:color linear 80ms;width:var(--cr-checkbox-ripple-size)}:host([checked]) #ink{--paper-ripple-opacity:var(--cr-checkbox-ripple-opacity,var(--cr-checkbox-checked-ripple-opacity));color:var(--cr-checkbox-ripple-checked-color)}:host-context([dir=rtl]) #ink{left:auto;right:var(--cr-checkbox-ripple-offset);transform:translate(50%,-50%)}#labelContainer{color:var(--cr-checkbox-label-color,var(--cr-primary-text-color));padding-inline-start:var(--cr-checkbox-label-padding-start,20px);white-space:normal}:host(.label-first) #labelContainer{order:-1;padding-inline-end:var(--cr-checkbox-label-padding-end,20px);padding-inline-start:0}:host(.no-label) #labelContainer{display:none}#ariaDescription{height:0;overflow:hidden;width:0}`])}function getHtml$4(){return html`
<div id="checkbox" tabindex="${this.tabIndex}" role="checkbox"
    @keydown="${this.onKeyDown_}" @keyup="${this.onKeyUp_}"

    aria-disabled="${this.getAriaDisabled_()}"
    aria-checked="${this.getAriaChecked_()}"
    aria-label="${this.ariaLabelOverride||nothing}"
    aria-labelledby="${this.ariaLabelOverride?nothing:"labelContainer"}"
    aria-describedby="ariaDescription">
  <!-- Inline SVG paints faster than loading it from a separate file. -->
  <svg id="checkmark" width="12" height="12" viewBox="0 0 12 12"
      fill="none" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" clip-rule="evenodd"
        d="m10.192 2.121-6.01 6.01-2.121-2.12L1 7.07l2.121 2.121.707.707.354.354 7.071-7.071-1.06-1.06Z">
  </svg>
  <div id="hover-layer"></div>
</div>
<div id="labelContainer" part="label-container">
  <slot></slot>
</div>
<div id="ariaDescription" aria-hidden="true">${this.ariaDescription}</div>`}const CrCheckboxElementBase=CrRippleMixin(CrLitElement);class CrCheckboxElement extends CrCheckboxElementBase{static get is(){return"cr-checkbox"}static get styles(){return getCss$5()}render(){return getHtml$4.bind(this)()}static get properties(){return{checked:{type:Boolean,reflect:true,notify:true},disabled:{type:Boolean,reflect:true},ariaDescription:{type:String},ariaLabelOverride:{type:String},tabIndex:{type:Number}}}#checked_accessor_storage=false;get checked(){return this.#checked_accessor_storage}set checked(value){this.#checked_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ariaDescription_accessor_storage=null;get ariaDescription(){return this.#ariaDescription_accessor_storage}set ariaDescription(value){this.#ariaDescription_accessor_storage=value}#ariaLabelOverride_accessor_storage;get ariaLabelOverride(){return this.#ariaLabelOverride_accessor_storage}set ariaLabelOverride(value){this.#ariaLabelOverride_accessor_storage=value}#tabIndex_accessor_storage=0;get tabIndex(){return this.#tabIndex_accessor_storage}set tabIndex(value){this.#tabIndex_accessor_storage=value}firstUpdated(){this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("pointerup",this.hideRipple_.bind(this));this.$.labelContainer.addEventListener("pointerdown",this.showRipple_.bind(this));this.$.labelContainer.addEventListener("pointerleave",this.hideRipple_.bind(this))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("disabled")){const previousTabIndex=changedProperties.get("disabled");if(previousTabIndex!==undefined||this.disabled){this.tabIndex=this.disabled?-1:0}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("tabIndex")){this.removeAttribute("tabindex")}}focus(){this.$.checkbox.focus()}getFocusableElement(){return this.$.checkbox}getAriaDisabled_(){return this.disabled?"true":"false"}getAriaChecked_(){return this.checked?"true":"false"}showRipple_(){if(this.noink){return}this.getRipple().showAndHoldDown()}hideRipple_(){this.getRipple().clear()}async onClick_(e){if(this.disabled||e.target.tagName==="A"){return}e.stopPropagation();e.preventDefault();this.checked=!this.checked;await this.updateComplete;this.fire("change",this.checked)}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(e.key===" "){this.click()}}createRipple(){this.rippleContainer=this.$.checkbox;const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}}customElements.define(CrCheckboxElement.is,CrCheckboxElement);const FilteringBehaviorSpec={$:mojo.internal.Enum()};var FilteringBehavior;(function(FilteringBehavior){FilteringBehavior[FilteringBehavior["MIN_VALUE"]=-1]="MIN_VALUE";FilteringBehavior[FilteringBehavior["MAX_VALUE"]=3]="MAX_VALUE";FilteringBehavior[FilteringBehavior["kUnknown"]=-1]="kUnknown";FilteringBehavior[FilteringBehavior["kAllow"]=0]="kAllow";FilteringBehavior[FilteringBehavior["kBlock"]=2]="kBlock";FilteringBehavior[FilteringBehavior["kInvalid"]=3]="kInvalid"})(FilteringBehavior||(FilteringBehavior={}));class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"history.mojom.PageHandler",scope)}}class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPage(page){this.proxy.sendMessage(0,PageHandler_SetPage_ParamsSpec.$,null,[page],false)}queryHistory(query,maxResults,beginTime){return this.proxy.sendMessage(1,PageHandler_QueryHistory_ParamsSpec.$,PageHandler_QueryHistory_ResponseParamsSpec.$,[query,maxResults,beginTime],false)}queryHistoryContinuation(){return this.proxy.sendMessage(2,PageHandler_QueryHistoryContinuation_ParamsSpec.$,PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,[],false)}removeVisits(items){return this.proxy.sendMessage(3,PageHandler_RemoveVisits_ParamsSpec.$,PageHandler_RemoveVisits_ResponseParamsSpec.$,[items],false)}openClearBrowsingDataDialog(){this.proxy.sendMessage(4,PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,null,[],false)}removeBookmark(url){this.proxy.sendMessage(5,PageHandler_RemoveBookmark_ParamsSpec.$,null,[url],false)}setLastSelectedTab(lastTab){this.proxy.sendMessage(6,PageHandler_SetLastSelectedTab_ParamsSpec.$,null,[lastTab],false)}showSidePanelUI(){this.proxy.sendMessage(7,PageHandler_ShowSidePanelUI_ParamsSpec.$,null,[],false)}requestAccountInfo(){return this.proxy.sendMessage(8,PageHandler_RequestAccountInfo_ParamsSpec.$,PageHandler_RequestAccountInfo_ResponseParamsSpec.$,[],false)}turnOnHistorySync(){this.proxy.sendMessage(9,PageHandler_TurnOnHistorySync_ParamsSpec.$,null,[],false)}}class PageHandler{static get $interfaceName(){return"history.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"history.mojom.Page",scope)}}class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onHistoryDeleted(){this.proxy.sendMessage(0,Page_OnHistoryDeleted_ParamsSpec.$,null,[],false)}onHasOtherFormsChanged(hasOtherForms){this.proxy.sendMessage(1,Page_OnHasOtherFormsChanged_ParamsSpec.$,null,[hasOtherForms],false)}sendAccountInfo(accountInfo){this.proxy.sendMessage(2,Page_SendAccountInfo_ParamsSpec.$,null,[accountInfo],false)}}class PageCallbackRouter{helper_internal_;$;router_;onHistoryDeleted;onHasOtherFormsChanged;sendAccountInfo;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onHistoryDeleted=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnHistoryDeleted_ParamsSpec.$,null,this.onHistoryDeleted.createReceiverHandler(false),false);this.onHasOtherFormsChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_OnHasOtherFormsChanged_ParamsSpec.$,null,this.onHasOtherFormsChanged.createReceiverHandler(false),false);this.sendAccountInfo=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_SendAccountInfo_ParamsSpec.$,null,this.sendAccountInfo.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const QueryStateSpec={$:{}};const HistoryQuerySpec={$:{}};const DebugInfoSpec={$:{}};const HistoryEntrySpec={$:{}};const QueryResultSpec={$:{}};const RemovalItemSpec={$:{}};const AccountInfoSpec={$:{}};const PageHandler_SetPage_ParamsSpec={$:{}};const PageHandler_QueryHistory_ParamsSpec={$:{}};const PageHandler_QueryHistory_ResponseParamsSpec={$:{}};const PageHandler_QueryHistoryContinuation_ParamsSpec={$:{}};const PageHandler_QueryHistoryContinuation_ResponseParamsSpec={$:{}};const PageHandler_RemoveVisits_ParamsSpec={$:{}};const PageHandler_RemoveVisits_ResponseParamsSpec={$:{}};const PageHandler_OpenClearBrowsingDataDialog_ParamsSpec={$:{}};const PageHandler_RemoveBookmark_ParamsSpec={$:{}};const PageHandler_SetLastSelectedTab_ParamsSpec={$:{}};const PageHandler_ShowSidePanelUI_ParamsSpec={$:{}};const PageHandler_RequestAccountInfo_ParamsSpec={$:{}};const PageHandler_RequestAccountInfo_ResponseParamsSpec={$:{}};const PageHandler_TurnOnHistorySync_ParamsSpec={$:{}};const Page_OnHistoryDeleted_ParamsSpec={$:{}};const Page_OnHasOtherFormsChanged_ParamsSpec={$:{}};const Page_SendAccountInfo_ParamsSpec={$:{}};mojo.internal.Struct(QueryStateSpec.$,"QueryState",[mojo.internal.StructField("incremental",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("querying",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("searchTerm",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("after",16,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(HistoryQuerySpec.$,"HistoryQuery",[mojo.internal.StructField("term",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("finished",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(DebugInfoSpec.$,"DebugInfo",[mojo.internal.StructField("isUrlInLocalDatabase",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("visitCount",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("typedCount",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(HistoryEntrySpec.$,"HistoryEntry",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("domain",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("fallbackFaviconText",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("time",32,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("allTimestamps",40,0,mojo.internal.Array(mojo.internal.Double,false),null,false,0,undefined,undefined),mojo.internal.StructField("dateShort",48,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("deviceName",56,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("deviceType",64,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("dateTimeOfDay",72,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("dateRelativeDay",80,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("selected",88,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("readableTimestamp",96,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("snippet",104,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("starred",88,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("hostFilteringBehavior",92,0,FilteringBehaviorSpec.$,-1,false,0,undefined,undefined),mojo.internal.StructField("blockedVisit",88,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isUrlInRemoteUserData",88,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isActorVisit",88,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("remoteIconUrlForUma",112,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("debug",120,0,DebugInfoSpec.$,null,true,0,undefined,undefined)],[[0,136]]);mojo.internal.Struct(QueryResultSpec.$,"QueryResult",[mojo.internal.StructField("info",0,0,HistoryQuerySpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("value",8,0,mojo.internal.Array(HistoryEntrySpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(RemovalItemSpec.$,"RemovalItem",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("timestamps",8,0,mojo.internal.Array(mojo.internal.Double,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AccountInfoSpec.$,"AccountInfo",[mojo.internal.StructField("accountImageSrc",0,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("name",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("email",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$,"PageHandler_SetPage_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_QueryHistory_ParamsSpec.$,"PageHandler_QueryHistory_Params",[mojo.internal.StructField("query",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("maxResults",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("begin_time_$flag",12,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"begin_time_$value",originalFieldName:"beginTime"},undefined),mojo.internal.StructField("begin_time_$value",16,0,mojo.internal.Double,0,false,0,{isPrimary:false,originalFieldName:"beginTime"},undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_QueryHistory_ResponseParamsSpec.$,"PageHandler_QueryHistory_ResponseParams",[mojo.internal.StructField("results",0,0,QueryResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_QueryHistoryContinuation_ParamsSpec.$,"PageHandler_QueryHistoryContinuation_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,"PageHandler_QueryHistoryContinuation_ResponseParams",[mojo.internal.StructField("results",0,0,QueryResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RemoveVisits_ParamsSpec.$,"PageHandler_RemoveVisits_Params",[mojo.internal.StructField("items",0,0,mojo.internal.Array(RemovalItemSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RemoveVisits_ResponseParamsSpec.$,"PageHandler_RemoveVisits_ResponseParams",[],[[0,8]]);mojo.internal.Struct(PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,"PageHandler_OpenClearBrowsingDataDialog_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RemoveBookmark_ParamsSpec.$,"PageHandler_RemoveBookmark_Params",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetLastSelectedTab_ParamsSpec.$,"PageHandler_SetLastSelectedTab_Params",[mojo.internal.StructField("lastTab",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ShowSidePanelUI_ParamsSpec.$,"PageHandler_ShowSidePanelUI_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RequestAccountInfo_ParamsSpec.$,"PageHandler_RequestAccountInfo_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RequestAccountInfo_ResponseParamsSpec.$,"PageHandler_RequestAccountInfo_ResponseParams",[mojo.internal.StructField("accountInfo",0,0,AccountInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_TurnOnHistorySync_ParamsSpec.$,"PageHandler_TurnOnHistorySync_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnHistoryDeleted_ParamsSpec.$,"Page_OnHistoryDeleted_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnHasOtherFormsChanged_ParamsSpec.$,"Page_OnHasOtherFormsChanged_Params",[mojo.internal.StructField("hasOtherForms",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_SendAccountInfo_ParamsSpec.$,"Page_SendAccountInfo_Params",[mojo.internal.StructField("accountInfo",0,0,AccountInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);class BrowserServiceImpl{handler;callbackRouter;constructor(handler,callbackRouter){this.handler=handler;this.callbackRouter=callbackRouter}static getInstance(){if(instance$5){return instance$5}const handler=PageHandler.getRemote();const callbackRouter=new PageCallbackRouter;handler.setPage(callbackRouter.$.bindNewPipeAndPassRemote());return instance$5=new BrowserServiceImpl(handler,callbackRouter)}static setInstance(obj){instance$5=obj}getForeignSessions(){return sendWithPromise("getForeignSessions")}openForeignSessionAllTabs(sessionTag){chrome.send("openForeignSessionAllTabs",[sessionTag])}openForeignSessionTab(sessionTag,tabId,e){chrome.send("openForeignSessionTab",[sessionTag,String(tabId),e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey])}deleteForeignSession(sessionTag){chrome.send("deleteForeignSession",[sessionTag])}recordHistogram(histogram,value,max){chrome.send("metricsHandler:recordInHistogram",[histogram,value,max])}recordBooleanHistogram(histogram,value){chrome.metricsPrivate.recordBoolean(histogram,value)}recordAction(action){if(action.indexOf("_")===-1){action=`HistoryPage_${action}`}chrome.send("metricsHandler:recordAction",[action])}recordTime(histogram,time){chrome.send("metricsHandler:recordTime",[histogram,time])}recordLongTime(histogram,time){chrome.metricsPrivate.recordLongTime(histogram,time)}navigateToUrl(url,target,e){chrome.send("navigateToUrl",[url,target,e.button,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey])}otherDevicesInitialized(){chrome.send("otherDevicesInitialized")}startTurnOnSyncFlow(){chrome.send("startTurnOnSyncFlow")}}let instance$5=null;const sheet=new CSSStyleSheet;sheet.replaceSync(`html{--card-border-color:rgba(0,0,0,0.14);--card-first-last-item-padding:8px;--card-max-width:960px;--card-min-width:550px;--card-padding-between:16px;--card-padding-side:24px;--first-card-padding-top:24px;--history-item-time-color:#646464;--interactive-color:var(--google-blue-500);--item-height:36px;--separator-color:rgba(0,0,0,0.08);--side-bar-width:256px;--sidebar-footer-text-color:var(--google-grey-700);--sidebar-unselected-color:#5a5a5a;--toolbar-height:56px}@media (prefers-color-scheme:dark){html{--card-border-color:var(--cr-separator-color);--history-item-time-color:var(--cr-secondary-text-color);--interactive-color:var(--google-blue-300);--separator-color:var(--cr-separator-color);--sidebar-footer-text-color:rgba(255,255,255,0.6);--sidebar-unselected-color:var(--cr-secondary-text-color)}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet];let instance$4=null;function getCss$4(){return instance$4||(instance$4=[...[getCss$e()],css`a{color:var(--cr-link-color)}.history-cards{margin:0 auto;max-width:var(--card-max-width);min-width:var(--card-min-width);padding:0 var(--card-padding-side);width:calc(100% - 2 * var(--card-padding-side))}.card-title{align-items:center;display:flex;font-size:16px;font-weight:500;line-height:24px;overflow:hidden;padding:23px 24px 13px;text-overflow:ellipsis;white-space:nowrap}.centered-message{align-items:center;color:var(--md-loading-message-color);display:flex;flex:1;font-size:108%;font-weight:500;height:100%;justify-content:center}.website-icon{background-repeat:no-repeat;background-size:16px;background-position:center center;border-radius:4px;flex:none;height:24px;width:24px}.website-link{align-items:center;color:var(--cr-primary-text-color);display:flex;overflow:hidden;text-decoration:none}.website-title{font-size:12px;font-weight:500;margin-inline-start:8px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}`])}const RESULTS_PER_PAGE=150;const BROWSING_GAP_TIME=15*60*1e3;var HistorySignInState;(function(HistorySignInState){HistorySignInState[HistorySignInState["SIGNED_OUT"]=0]="SIGNED_OUT";HistorySignInState[HistorySignInState["WEB_ONLY_SIGNED_IN"]=1]="WEB_ONLY_SIGNED_IN";HistorySignInState[HistorySignInState["SIGNED_IN_NOT_SYNCING_TABS"]=2]="SIGNED_IN_NOT_SYNCING_TABS";HistorySignInState[HistorySignInState["SIGNED_IN_SYNCING_TABS"]=3]="SIGNED_IN_SYNCING_TABS";HistorySignInState[HistorySignInState["SIGN_IN_PENDING_NOT_SYNCING_TABS"]=4]="SIGN_IN_PENDING_NOT_SYNCING_TABS";HistorySignInState[HistorySignInState["SIGN_IN_PENDING_SYNCING_TABS"]=5]="SIGN_IN_PENDING_SYNCING_TABS";HistorySignInState[HistorySignInState["SYNC_DISABLED"]=6]="SYNC_DISABLED"})(HistorySignInState||(HistorySignInState={}));var HistoryPageViewHistogram;(function(HistoryPageViewHistogram){HistoryPageViewHistogram[HistoryPageViewHistogram["HISTORY"]=0]="HISTORY";HistoryPageViewHistogram[HistoryPageViewHistogram["DEPRECATED_GROUPED_WEEK"]=1]="DEPRECATED_GROUPED_WEEK";HistoryPageViewHistogram[HistoryPageViewHistogram["DEPRECATED_GROUPED_MONTH"]=2]="DEPRECATED_GROUPED_MONTH";HistoryPageViewHistogram[HistoryPageViewHistogram["SYNCED_TABS"]=3]="SYNCED_TABS";HistoryPageViewHistogram[HistoryPageViewHistogram["SIGNIN_PROMO"]=4]="SIGNIN_PROMO";HistoryPageViewHistogram[HistoryPageViewHistogram["JOURNEYS"]=5]="JOURNEYS";HistoryPageViewHistogram[HistoryPageViewHistogram["PRODUCT_SPECIFICATIONS_LISTS"]=6]="PRODUCT_SPECIFICATIONS_LISTS";HistoryPageViewHistogram[HistoryPageViewHistogram["END"]=7]="END"})(HistoryPageViewHistogram||(HistoryPageViewHistogram={}));const SYNCED_TABS_HISTOGRAM_NAME="HistoryPage.OtherDevicesMenu";var SyncedTabsHistogram;(function(SyncedTabsHistogram){SyncedTabsHistogram[SyncedTabsHistogram["INITIALIZED"]=0]="INITIALIZED";SyncedTabsHistogram[SyncedTabsHistogram["SHOW_MENU_DEPRECATED"]=1]="SHOW_MENU_DEPRECATED";SyncedTabsHistogram[SyncedTabsHistogram["LINK_CLICKED"]=2]="LINK_CLICKED";SyncedTabsHistogram[SyncedTabsHistogram["LINK_RIGHT_CLICKED"]=3]="LINK_RIGHT_CLICKED";SyncedTabsHistogram[SyncedTabsHistogram["SESSION_NAME_RIGHT_CLICKED_DEPRECATED"]=4]="SESSION_NAME_RIGHT_CLICKED_DEPRECATED";SyncedTabsHistogram[SyncedTabsHistogram["SHOW_SESSION_MENU"]=5]="SHOW_SESSION_MENU";SyncedTabsHistogram[SyncedTabsHistogram["COLLAPSE_SESSION"]=6]="COLLAPSE_SESSION";SyncedTabsHistogram[SyncedTabsHistogram["EXPAND_SESSION"]=7]="EXPAND_SESSION";SyncedTabsHistogram[SyncedTabsHistogram["OPEN_ALL"]=8]="OPEN_ALL";SyncedTabsHistogram[SyncedTabsHistogram["HAS_FOREIGN_DATA"]=9]="HAS_FOREIGN_DATA";SyncedTabsHistogram[SyncedTabsHistogram["HIDE_FOR_NOW"]=10]="HIDE_FOR_NOW";SyncedTabsHistogram[SyncedTabsHistogram["OPENED_LINK_VIA_CONTEXT_MENU"]=11]="OPENED_LINK_VIA_CONTEXT_MENU";SyncedTabsHistogram[SyncedTabsHistogram["LIMIT"]=12]="LIMIT"})(SyncedTabsHistogram||(SyncedTabsHistogram={}));var VisitContextMenuAction;(function(VisitContextMenuAction){VisitContextMenuAction[VisitContextMenuAction["MORE_FROM_THIS_SITE_CLICKED"]=0]="MORE_FROM_THIS_SITE_CLICKED";VisitContextMenuAction[VisitContextMenuAction["REMOVE_FROM_HISTORY_CLICKED"]=1]="REMOVE_FROM_HISTORY_CLICKED";VisitContextMenuAction[VisitContextMenuAction["REMOVE_BOOKMARK_CLICKED"]=2]="REMOVE_BOOKMARK_CLICKED";VisitContextMenuAction[VisitContextMenuAction["MAX_VALUE"]=3]="MAX_VALUE"})(VisitContextMenuAction||(VisitContextMenuAction={}));let instance$3=null;function getCss$3(){return instance$3||(instance$3=[...[],css`:host{background-color:white;border-bottom:1px solid var(--google-grey-300);bottom:0;color:var(--cr-primary-text-color);display:flex;left:0;opacity:0;padding-inline-start:var(--cr-toolbar-field-margin,0);pointer-events:none;position:absolute;right:0;top:0;transition:opacity var(--cr-toolbar-overlay-animation-duration),visibility var(--cr-toolbar-overlay-animation-duration);visibility:hidden}@media (prefers-color-scheme:dark){:host{background-color:var(--google-grey-900);background-image:linear-gradient(rgba(255,255,255,.04),rgba(255,255,255,.04));border-bottom-color:var(--cr-separator-color)}}:host([show]){opacity:1;pointer-events:initial;visibility:initial}#overlay-content{align-items:center;display:flex;flex:1;margin:0 auto;max-width:var(--cr-toolbar-selection-overlay-max-width,initial);padding:0 var(--cr-toolbar-selection-overlay-padding,24px)}#number-selected{flex:1}cr-icon-button{height:36px;margin-inline-end:24px;margin-inline-start:2px;width:36px}#slot{align-items:center;display:flex;gap:var(--cr-toolbar-selection-overlay-slot-gap,16px);margin-inline-start:8px}`])}function getHtml$3(){return html`
<div id="overlay-content">
  <cr-icon-button part="clearIcon"
      title="${this.cancelLabel}" iron-icon="cr:clear"
      @click="${this.onClearSelectionClick_}"></cr-icon-button>
  <div id="number-selected">${this.selectionLabel}</div>
  <div id="slot"><slot></slot></div>
</div>`}class CrToolbarSelectionOverlayElement extends CrLitElement{static get is(){return"cr-toolbar-selection-overlay"}static get styles(){return getCss$3()}render(){return getHtml$3.bind(this)()}static get properties(){return{show:{type:Boolean,reflect:true},cancelLabel:{type:String},selectionLabel:{type:String}}}#show_accessor_storage=false;get show(){return this.#show_accessor_storage}set show(value){this.#show_accessor_storage=value}#cancelLabel_accessor_storage="";get cancelLabel(){return this.#cancelLabel_accessor_storage}set cancelLabel(value){this.#cancelLabel_accessor_storage=value}#selectionLabel_accessor_storage="";get selectionLabel(){return this.#selectionLabel_accessor_storage}set selectionLabel(value){this.#selectionLabel_accessor_storage=value}firstUpdated(){this.setAttribute("role","toolbar")}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("selectionLabel")){if(changedProperties.get("selectionLabel")===undefined&&this.selectionLabel===""){return}this.setAttribute("aria-label",this.selectionLabel);const announcer=getInstance();announcer.announce(this.selectionLabel)}}onClearSelectionClick_(){this.fire("clear-selected-items")}}customElements.define(CrToolbarSelectionOverlayElement.is,CrToolbarSelectionOverlayElement);let instance$2=null;function getCss$2(){return instance$2||(instance$2=[...[],css`:host{--collapse-duration:var(--iron-collapse-transition-duration,300ms);display:block;transition:max-height var(--collapse-duration) ease-out;overflow:visible}:host([no-animation]){transition:none}:host(.collapse-closed){display:none}:host(:not(.collapse-opened)){overflow:hidden}`])}function getHtml$2(){return html`<slot></slot>`}class CrCollapseElement extends CrLitElement{static get is(){return"cr-collapse"}static get styles(){return getCss$2()}render(){return getHtml$2.bind(this)()}static get properties(){return{opened:{type:Boolean,notify:true},noAnimation:{type:Boolean,reflect:true}}}#opened_accessor_storage=false;get opened(){return this.#opened_accessor_storage}set opened(value){this.#opened_accessor_storage=value}#noAnimation_accessor_storage=false;get noAnimation(){return this.#noAnimation_accessor_storage}set noAnimation(value){this.#noAnimation_accessor_storage=value}toggle(){this.opened=!this.opened}show(){this.opened=true}hide(){this.opened=false}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","group")}this.setAttribute("aria-hidden","true");this.addEventListener("transitionend",(e=>this.onTransitionEnd_(e)))}updated(changedProperties){super.updated(changedProperties);if(!changedProperties.has("opened")){return}this.setAttribute("aria-hidden",this.opened?"false":"true");this.classList.toggle("collapse-closed",false);this.classList.toggle("collapse-opened",false);this.updateHeight_(this.opened,changedProperties.get("opened"));if(this.opened){this.focus()}}updateHeight_(opening,lastOpened){const finalMaxHeight=opening?"":"0px";const animationStartSize=`${this.getBoundingClientRect().height}px`;const animationEndSize=opening?`${this.scrollHeight}px`:"0px";const willAnimate=lastOpened!==undefined&&!this.noAnimation&&this.style.maxHeight!==finalMaxHeight&&animationStartSize!==animationEndSize;if(willAnimate&&!opening){this.style.maxHeight=animationStartSize;this.scrollTop=this.scrollTop}this.style.maxHeight=animationEndSize;if(!willAnimate){this.updateStyles_()}}onTransitionEnd_(e){if(e.composedPath()[0]===this){this.updateStyles_()}}updateStyles_(){this.style.maxHeight=this.opened?"":"0px";this.classList.toggle("collapse-closed",!this.opened);this.classList.toggle("collapse-opened",this.opened)}}customElements.define(CrCollapseElement.is,CrCollapseElement);let instance$1=null;function getCss$1(){return instance$1||(instance$1=[...[getCss$4()],css`:host{-webkit-tap-highlight-color:transparent;display:block}#card-heading{cursor:pointer;justify-content:space-between;padding-inline-end:0}#tab-item-list{padding:8px 0}#last-update-time{color:var(--cr-secondary-text-color)}#title-left-content{display:flex;overflow:hidden}#device-name{overflow:hidden;padding-inline-end:3px;text-overflow:ellipsis}#right-buttons{color:var(--cr-secondary-text-color);margin-inline-end:24px}#collapse{overflow:hidden}#history-item-container{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow)}.item-container{align-items:center;display:flex;margin:0 20px;min-height:var(--item-height)}.window-separator{background-color:var(--card-border-color);height:1px;margin:5px auto;width:80%}`])}function getHtml$1(){return html`<!--_html_template_start_-->
<div id="history-item-container">
  <div class="card-title" id="card-heading" aria-expanded="${this.opened}"
      aria-controls="collapse" @click="${this.toggleTabCard}">
    <div id="title-left-content">
      <div id="device-name">${this.device}</div>
      <span id="last-update-time">${this.lastUpdateTime}</span>
    </div>
    <div id="right-buttons">
      <cr-icon-button id="menu-button" iron-icon="cr:more-vert"
          @click="${this.onMenuButtonClick_}"
          title="$i18n{actionMenuDescription}">
      </cr-icon-button>
      <cr-icon-button id="collapse-button"
          iron-icon="${this.getCollapseIcon_()}"
          title="${this.getCollapseTitle_()}">
      </cr-icon-button>
    </div>
  </div>

  <cr-collapse id="collapse" ?opened="${this.opened}"
      @opened-changed="${this.onOpenedChanged_}">
    <div id="tab-item-list">
      ${this.tabs.map(((tab,index)=>html`
        <div class="item-container">
          <a href="${tab.url}" class="website-link" title="${tab.title}"
              data-session-id="${tab.sessionId}"
              @click="${this.openTab_}"
              @contextmenu="${this.onLinkRightClick_}">
            <div class="website-icon"></div>
            <history-searched-label class="website-title"
                title="${tab.title}"
                search-term="${this.searchTerm}">
            </history-searched-label>
          </a>
        </div>
        <div class="window-separator"
            ?hidden="${!this.isWindowSeparatorIndex_(index)}">
        </div>
      `))}
    </div>
  </cr-collapse>
</div>
<!--_html_template_end_-->`}class HistorySyncedDeviceCardElement extends CrLitElement{static get is(){return"history-synced-device-card"}static get styles(){return getCss$1()}render(){return getHtml$1.bind(this)()}static get properties(){return{tabs:{type:Array},device:{type:String},lastUpdateTime:{type:String},opened:{type:Boolean,notify:true},searchTerm:{type:String},separatorIndexes:{type:Array},sessionTag:{type:String}}}#device_accessor_storage="";get device(){return this.#device_accessor_storage}set device(value){this.#device_accessor_storage=value}#lastUpdateTime_accessor_storage="";get lastUpdateTime(){return this.#lastUpdateTime_accessor_storage}set lastUpdateTime(value){this.#lastUpdateTime_accessor_storage=value}#tabs_accessor_storage=[];get tabs(){return this.#tabs_accessor_storage}set tabs(value){this.#tabs_accessor_storage=value}#opened_accessor_storage=true;get opened(){return this.#opened_accessor_storage}set opened(value){this.#opened_accessor_storage=value}#searchTerm_accessor_storage;get searchTerm(){return this.#searchTerm_accessor_storage}set searchTerm(value){this.#searchTerm_accessor_storage=value}#separatorIndexes_accessor_storage=[];get separatorIndexes(){return this.#separatorIndexes_accessor_storage}set separatorIndexes(value){this.#separatorIndexes_accessor_storage=value}#sessionTag_accessor_storage="";get sessionTag(){return this.#sessionTag_accessor_storage}set sessionTag(value){this.#sessionTag_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("tabs")){this.notifyFocusUpdate_();this.updateIcons_()}}createFocusRows(){const titleRow=new FocusRow(this.$["card-heading"],null);titleRow.addItem("menu","#menu-button");titleRow.addItem("collapse","#collapse-button");const rows=[titleRow];if(this.opened){this.shadowRoot.querySelectorAll(".item-container").forEach((function(el){const row=new FocusRow(el,null);row.addItem("link",".website-link");rows.push(row)}))}return rows}openTab_(e){const browserService=BrowserServiceImpl.getInstance();browserService.recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.LINK_CLICKED,SyncedTabsHistogram.LIMIT);browserService.openForeignSessionTab(this.sessionTag,Number(e.currentTarget.dataset["sessionId"]),e);e.preventDefault()}async toggleTabCard(){const histogramValue=this.opened?SyncedTabsHistogram.COLLAPSE_SESSION:SyncedTabsHistogram.EXPAND_SESSION;BrowserServiceImpl.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,histogramValue,SyncedTabsHistogram.LIMIT);this.opened=!this.opened;await this.updateComplete;this.fire("update-focus-grid")}notifyFocusUpdate_(){this.fire("update-focus-grid")}updateIcons_(){setTimeout((()=>{const icons=this.shadowRoot.querySelectorAll(".website-icon");for(let i=0;i<this.tabs.length;i++){icons[i].style.backgroundImage=getFaviconForPageURL(this.tabs[i].url,true,this.tabs[i].remoteIconUrlForUma)}}),0)}isWindowSeparatorIndex_(index){return this.separatorIndexes.indexOf(index)!==-1}getCollapseIcon_(){return this.opened?"cr:expand-less":"cr:expand-more"}getCollapseTitle_(){return this.opened?loadTimeData.getString("collapseSessionButton"):loadTimeData.getString("expandSessionButton")}onMenuButtonClick_(e){this.fire("synced-device-card-open-menu",{target:e.target,tag:this.sessionTag});e.stopPropagation()}onLinkRightClick_(){BrowserServiceImpl.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.LINK_RIGHT_CLICKED,SyncedTabsHistogram.LIMIT)}onOpenedChanged_(e){this.opened=e.detail.value}}customElements.define(HistorySyncedDeviceCardElement.is,HistorySyncedDeviceCardElement);class FocusGrid{rows=[];ignoreFocusChange_=false;lastFocused_=null;onFocus(row,e){if(this.ignoreFocusChange_){this.ignoreFocusChange_=false}else{this.lastFocused_=e.currentTarget}this.rows.forEach((function(r){r.makeActive(r===row)}))}onKeydown(row,e){const rowIndex=this.rows.indexOf(row);assert(rowIndex>=0);let newRow=-1;if(e.key==="ArrowUp"){newRow=rowIndex-1}else if(e.key==="ArrowDown"){newRow=rowIndex+1}else if(e.key==="PageUp"){newRow=0}else if(e.key==="PageDown"){newRow=this.rows.length-1}const rowToFocus=this.rows[newRow];if(rowToFocus){this.ignoreFocusChange_=true;rowToFocus.getEquivalentElement(this.lastFocused_).focus();e.preventDefault();return true}return false}getCustomEquivalent(_sampleElement){return null}destroy(){this.rows.forEach((function(row){row.destroy()}));this.rows.length=0}getRowIndexForTarget(target){for(let i=0;i<this.rows.length;++i){if(this.rows[i].getElements().indexOf(target)>=0){return i}}return-1}getRowForRoot(root){for(let i=0;i<this.rows.length;++i){if(this.rows[i].root===root){return this.rows[i]}}return null}addRow(row){this.addRowBefore(row,null)}addRowBefore(row,nextRow){row.delegate=row.delegate||this;const nextRowIndex=nextRow?this.rows.indexOf(nextRow):-1;if(nextRowIndex===-1){this.rows.push(row)}else{this.rows.splice(nextRowIndex,0,row)}}removeRow(row){const nextRowIndex=row?this.rows.indexOf(row):-1;if(nextRowIndex>-1){this.rows.splice(nextRowIndex,1)}}ensureRowActive(preferredRow){if(this.rows.length===0){return}for(let i=0;i<this.rows.length;++i){if(this.rows[i].isActive()){return}}(this.rows[preferredRow||0]||this.rows[0]).makeActive(true)}}let instance=null;function getCss(){return instance||(instance=[...[getCss$4()],css`:host{display:block;overflow:auto}#sync-promo-illustration{background:url(images/sign_in_promo.svg) no-repeat center center;background-size:contain;height:222px;margin-top:100px;width:594.5px}.sync-history-illustration{content:url(images/sync_history_promo.svg);width:100%}.sync-history-promo-avatar-illustration{content:url(./images/avatar_surrounding_illustration_light.svg);height:132px;width:100%}@media (prefers-color-scheme:dark){#sync-promo-illustration{background-image:url(images/sign_in_promo_dark.svg)}.sync-history-illustration{content:url(images/sync_history_promo_dark.svg)}.sync-history-promo-avatar-illustration{content:url(images/avatar_surrounding_illustration_dark.svg)}}#no-synced-tabs{height:100%}#sign-in-guide{align-items:center;display:flex;flex-direction:column;justify-content:center;overflow-x:hidden;text-align:center}#turn-on-sync-promo{font-size:215%;margin-top:40px}#turn-on-sync-promo-desc{color:var(--cr-secondary-text-color);font-size:123%;margin-top:10px}#turn-on-sync-button{margin:24px 0}#synced-device-list{padding-top:var(--first-card-padding-top)}history-synced-device-card{margin-block-end:var(--card-padding-between)}.history-sync-optin{align-items:center;display:flex;flex-direction:column}.sync-history-promo{margin-top:12px;margin-bottom:0;font-size:24px;font-weight:500}.sync-history-promo-desc{margin-top:8px;max-width:684px;color:var(--cr-secondary-text-color);text-align:center;font-size:16px}.avatar{background-color:var(--md-background-color);border:solid var(--md-background-color);border-radius:50%;height:64px;left:50%;position:absolute;top:50%;transform:translate(-50%,-50%);width:64px}.image-container{align-items:center;display:flex;height:162px;position:relative;margin-top:36px}.profile-row{text-align:left;align-items:center;display:flex;margin-top:16px}.account-info-container{padding-inline-start:16px}.profile-icon{border-radius:20px;height:40px;width:40px}.account-name{font-size:13px}.account-email{color:var(--cr-primary-text-color);font-size:12px;font-weight:400}.action-button{margin:16px 0}
`])}function getHtml(){return html`<!--_html_template_start_-->
<div id="synced-device-list" class="history-cards"
    ?hidden="${!this.syncedDevices_.length}">
  ${this.syncedDevices_.map(((syncedDevice,index)=>html`
    <history-synced-device-card
        .device="${syncedDevice.device}"
        .lastUpdateTime="${syncedDevice.lastUpdateTime}"
        .tabs="${syncedDevice.tabs}"
        .separatorIndexes="${syncedDevice.separatorIndexes}"
        .searchTerm="${this.searchTerm}"
        .sessionTag="${syncedDevice.tag}"
        ?opened="${syncedDevice.opened}"
        @opened-changed="${this.onCardOpenedChanged_}"
        data-index="${index}">
    </history-synced-device-card>
  `))}
</div>
<div id="no-synced-tabs" class="centered-message"
    ?hidden="${!this.showNoSyncedMessage_()}">
  ${this.noSyncedTabsMessage_()}
</div>

<div id="sign-in-guide"
    ?hidden="${!this.showSignInGuide_()||this.replaceSyncPromosWithSignInPromos_}">
  <div id="sync-promo-illustration"></div>
  <div id="turn-on-sync-promo">$i18n{turnOnSyncPromo}</div>
  <div id="turn-on-sync-promo-desc">$i18n{turnOnSyncPromoDesc}</div>
  <cr-button id="turn-on-sync-button" class="action-button"
      @click="${this.onTurnOnSyncClick_}">
    $i18n{turnOnSyncButton}
  </cr-button>
</div>


  ${this.shouldShowHistorySyncOptIn_()?html`
    <div id="history-sync-optin" class="history-sync-optin">
      ${this.isSignInState_(HistorySignInState.SIGNED_OUT)||this.isSignInState_(HistorySignInState.WEB_ONLY_SIGNED_IN)?html`
        <div class="image-container">
          <img class="sync-history-illustration" alt="">
        </div>
        <h1 class="sync-history-promo">$i18n{turnOnSyncHistoryPromo}</h1>
        <div id="signed-out-sync-history-promo-desc"
            class="sync-history-promo-desc">
          $i18n{syncHistoryPromoBodySignedOut}
        </div>
      `:""}

      ${this.isSignInState_(HistorySignInState.WEB_ONLY_SIGNED_IN)&&this.accountInfo_?html`
        <div class="profile-row">
          <img id="profile-icon" class="profile-icon"
              src="${this.accountInfo_.accountImageSrc.url}">
          <div class="account-info-container">
            <div id="account-name" class="account-name">
              ${this.accountInfo_.name}</div>
            <div id="account-email" class="account-email">
              ${this.accountInfo_.email}</div>
          </div>
        </div>
      `:""}

      ${this.isSignInStatePending_()&&this.accountInfo_?html`
        <div class="image-container">
          <img class="sync-history-promo-avatar-illustration" alt="">
          <img id="sign-in-pending-avatar" class="avatar"
              src="${this.accountInfo_.accountImageSrc.url}" alt="">
        </div>
        <h1 class="sync-history-promo">$i18n{turnOnSyncHistoryPromo}</h1>

        ${this.isSignInState_(HistorySignInState.SIGN_IN_PENDING_NOT_SYNCING_TABS)?html`
          <div id="sign-in-pending-sync-history-promo-desc"
              class="sync-history-promo-desc">
            $i18n{syncHistoryPromoBodyPendingSignIn}
          </div>
        `:""}

        ${this.isSignInState_(HistorySignInState.SIGN_IN_PENDING_SYNCING_TABS)?html`
          <div id="sign-in-pending-sync-history-promo-desc-sync-history-on"
            class="sync-history-promo-desc">
          $i18n{syncHistoryPromoBodyPendingSignInSyncHistoryOn}
          </div>
        `:""}
      `:""}

      ${this.isSignInState_(HistorySignInState.SIGNED_IN_NOT_SYNCING_TABS)&&this.accountInfo_?html`
          <div class="image-container">
            <img class="sync-history-promo-avatar-illustration" alt="">
            <img id="signed-in-avatar" class="avatar"
                src="${this.accountInfo_.accountImageSrc.url}" alt="">
          </div>
          <h1 class="sync-history-promo">$i18n{turnOnSyncHistoryPromo}</h1>
          <div id="signed-in-sync-history-promo-desc"
              class="sync-history-promo-desc">
            $i18n{turnOnSignedInSyncHistoryPromoBodySignInSyncOff}
          </div>
        `:""}

      <!-- Button -->
      ${this.isSignInState_(HistorySignInState.SIGN_IN_PENDING_SYNCING_TABS)?html`
          <cr-button id="verify-its-you-button" class="action-button"
              @click="${this.onTurnOnHistorySyncClick_}">$i18n{verifyItsYou}
          </cr-button>`:html`
          <cr-button id="sync-history-button" class="action-button"
              @click="${this.onTurnOnHistorySyncClick_}">
            $i18n{turnOnSyncHistoryButton}
          </cr-button>`}
    </div>
  `:""}


<cr-lazy-render-lit id="menu" .template='${()=>html`
  <cr-action-menu role-description="$i18n{menu}">
    <button id="menuOpenButton" class="dropdown-item"
        @click="${this.onOpenAllClick_}">
      $i18n{openAll}
    </button>
    <button id="menuDeleteButton" class="dropdown-item"
        @click="${this.onDeleteSessionClick_}">
      $i18n{deleteSession}
    </button>
  </cr-action-menu>
`}'>
</cr-lazy-render-lit>
<!--_html_template_end_-->`}class HistorySyncedDeviceManagerElement extends CrLitElement{static get is(){return"history-synced-device-manager"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{sessionList:{type:Array},searchTerm:{type:String},syncedDevices_:{type:Array},signInState:{type:Number},guestSession_:{type:Boolean},signInAllowed_:{type:Boolean},fetchingSyncedTabs_:{type:Boolean},hasSeenForeignData_:{type:Boolean},actionMenuModel_:{type:String},replaceSyncPromosWithSignInPromos_:{type:Boolean},accountInfo_:{type:Object}}}focusGrid_=null;focusGridUpdateTimeout_=null;#syncedDevices__accessor_storage=[];get syncedDevices_(){return this.#syncedDevices__accessor_storage}set syncedDevices_(value){this.#syncedDevices__accessor_storage=value}#hasSeenForeignData__accessor_storage=false;get hasSeenForeignData_(){return this.#hasSeenForeignData__accessor_storage}set hasSeenForeignData_(value){this.#hasSeenForeignData__accessor_storage=value}#fetchingSyncedTabs__accessor_storage=false;get fetchingSyncedTabs_(){return this.#fetchingSyncedTabs__accessor_storage}set fetchingSyncedTabs_(value){this.#fetchingSyncedTabs__accessor_storage=value}#actionMenuModel__accessor_storage=null;get actionMenuModel_(){return this.#actionMenuModel__accessor_storage}set actionMenuModel_(value){this.#actionMenuModel__accessor_storage=value}#guestSession__accessor_storage=loadTimeData.getBoolean("isGuestSession");get guestSession_(){return this.#guestSession__accessor_storage}set guestSession_(value){this.#guestSession__accessor_storage=value}#signInAllowed__accessor_storage=loadTimeData.getBoolean("isSignInAllowed");get signInAllowed_(){return this.#signInAllowed__accessor_storage}set signInAllowed_(value){this.#signInAllowed__accessor_storage=value}#replaceSyncPromosWithSignInPromos__accessor_storage=loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos");get replaceSyncPromosWithSignInPromos_(){return this.#replaceSyncPromosWithSignInPromos__accessor_storage}set replaceSyncPromosWithSignInPromos_(value){this.#replaceSyncPromosWithSignInPromos__accessor_storage=value}#accountInfo__accessor_storage=null;get accountInfo_(){return this.#accountInfo__accessor_storage}set accountInfo_(value){this.#accountInfo__accessor_storage=value}onAccountInfoDataReceivedListenerId_=null;#signInState_accessor_storage=HistorySignInState.SIGNED_OUT;get signInState(){return this.#signInState_accessor_storage}set signInState(value){this.#signInState_accessor_storage=value}#searchTerm_accessor_storage="";get searchTerm(){return this.#searchTerm_accessor_storage}set searchTerm(value){this.#searchTerm_accessor_storage=value}#sessionList_accessor_storage=[];get sessionList(){return this.#sessionList_accessor_storage}set sessionList(value){this.#sessionList_accessor_storage=value}firstUpdated(){this.addEventListener("synced-device-card-open-menu",this.onOpenMenu_);this.addEventListener("update-focus-grid",this.updateFocusGrid_)}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("sessionList")){this.updateSyncedDevices_()}if(changedProperties.has("searchTerm")){this.searchTermChanged_()}if(changedProperties.has("signInState")){this.signInStateChanged_(changedProperties.get("signInState"))}}connectedCallback(){super.connectedCallback();this.focusGrid_=new FocusGrid;BrowserServiceImpl.getInstance().otherDevicesInitialized();BrowserServiceImpl.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.INITIALIZED,SyncedTabsHistogram.LIMIT);this.onAccountInfoDataReceivedListenerId_=BrowserServiceImpl.getInstance().callbackRouter.sendAccountInfo.addListener(this.handleAccountInfoChanged_.bind(this));BrowserServiceImpl.getInstance().handler.requestAccountInfo().then((({accountInfo:accountInfo})=>this.handleAccountInfoChanged_(accountInfo)))}disconnectedCallback(){super.disconnectedCallback();this.focusGrid_.destroy();assert(this.onAccountInfoDataReceivedListenerId_);BrowserServiceImpl.getInstance().callbackRouter.removeListener(this.onAccountInfoDataReceivedListenerId_);this.onAccountInfoDataReceivedListenerId_=null}configureSignInForTest(data){this.signInState=data.signInState;this.signInAllowed_=data.signInAllowed;this.guestSession_=data.guestSession}createInternalDevice_(session){let tabs=[];const separatorIndexes=[];for(let i=0;i<session.windows.length;i++){const windowId=session.windows[i].sessionId;const newTabs=session.windows[i].tabs;if(newTabs.length===0){continue}newTabs.forEach((function(tab){tab.windowId=windowId}));let windowAdded=false;if(!this.searchTerm){tabs=tabs.concat(newTabs);windowAdded=true}else{const searchText=this.searchTerm.toLowerCase();for(let j=0;j<newTabs.length;j++){const tab=newTabs[j];if(tab.title.toLowerCase().indexOf(searchText)!==-1){tabs.push(tab);windowAdded=true}}}if(windowAdded&&i!==session.windows.length-1){separatorIndexes.push(tabs.length-1)}}return{device:session.name,lastUpdateTime:"– "+session.modifiedTime,opened:true,separatorIndexes:separatorIndexes,timestamp:session.timestamp,tabs:tabs,tag:session.tag}}onTurnOnSyncClick_(){BrowserServiceImpl.getInstance().startTurnOnSyncFlow()}onTurnOnHistorySyncClick_(){BrowserServiceImpl.getInstance().handler.turnOnHistorySync()}handleAccountInfoChanged_(accountInfo){this.accountInfo_=accountInfo}onOpenMenu_(e){this.actionMenuModel_=e.detail.tag;this.$.menu.get().showAt(e.detail.target);BrowserServiceImpl.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.SHOW_SESSION_MENU,SyncedTabsHistogram.LIMIT)}onOpenAllClick_(){const menu=this.$.menu.getIfExists();assert(menu);const browserService=BrowserServiceImpl.getInstance();browserService.recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.OPEN_ALL,SyncedTabsHistogram.LIMIT);assert(this.actionMenuModel_);browserService.openForeignSessionAllTabs(this.actionMenuModel_);this.actionMenuModel_=null;menu.close()}updateFocusGrid_(){if(!this.focusGrid_){return}this.focusGrid_.destroy();if(this.focusGridUpdateTimeout_){clearTimeout(this.focusGridUpdateTimeout_)}this.focusGridUpdateTimeout_=setTimeout((()=>{const cards=this.shadowRoot.querySelectorAll("history-synced-device-card");Array.from(cards).reduce(((prev,cur)=>prev.concat(cur.createFocusRows())),[]).forEach((row=>{this.focusGrid_.addRow(row)}));this.focusGrid_.ensureRowActive(1);this.focusGridUpdateTimeout_=null}))}onDeleteSessionClick_(){const menu=this.$.menu.getIfExists();assert(menu);const browserService=BrowserServiceImpl.getInstance();browserService.recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.HIDE_FOR_NOW,SyncedTabsHistogram.LIMIT);assert(this.actionMenuModel_);browserService.deleteForeignSession(this.actionMenuModel_);this.actionMenuModel_=null;menu.close()}clearSyncedDevicesForTest(){this.clearDisplayedSyncedDevices_()}clearDisplayedSyncedDevices_(){this.syncedDevices_=[]}isSignInState_(state){return this.signInState===state}shouldShowHistorySyncOptIn_(){return this.replaceSyncPromosWithSignInPromos_&&!this.isSignInState_(HistorySignInState.SYNC_DISABLED)&&!this.isSignInState_(HistorySignInState.SIGNED_IN_SYNCING_TABS)}isSignInStatePending_(){return this.isSignInState_(HistorySignInState.SIGN_IN_PENDING_NOT_SYNCING_TABS)||this.isSignInState_(HistorySignInState.SIGN_IN_PENDING_SYNCING_TABS)}showNoSyncedMessage_(){if(this.guestSession_||this.signInState===HistorySignInState.SYNC_DISABLED){return true}return this.signInState===HistorySignInState.SIGNED_IN_SYNCING_TABS&&this.syncedDevices_.length===0}showSignInGuide_(){const show=this.signInState===HistorySignInState.SIGNED_OUT&&!this.guestSession_&&this.signInAllowed_;if(show){BrowserServiceImpl.getInstance().recordAction("Signin_Impression_FromRecentTabs")}return show}noSyncedTabsMessage_(){let stringName=this.fetchingSyncedTabs_?"loading":"noSyncedResults";if(this.searchTerm!==""){stringName="noSearchResults"}return loadTimeData.getString(stringName)}updateSyncedDevices_(){this.fetchingSyncedTabs_=false;if(!this.sessionList){return}if(this.sessionList.length>0&&!this.hasSeenForeignData_){this.hasSeenForeignData_=true;BrowserServiceImpl.getInstance().recordHistogram(SYNCED_TABS_HISTOGRAM_NAME,SyncedTabsHistogram.HAS_FOREIGN_DATA,SyncedTabsHistogram.LIMIT)}const devices=[];this.sessionList.forEach((session=>{const device=this.createInternalDevice_(session);if(device.tabs.length!==0){devices.push(device)}}));this.syncedDevices_=devices}signInStateChanged_(previous){if(previous===undefined){return}this.dispatchEvent(new CustomEvent("history-view-changed",{bubbles:true,composed:true}));if(this.replaceSyncPromosWithSignInPromos_){if(this.signInState===HistorySignInState.SIGNED_OUT||this.signInState===HistorySignInState.SYNC_DISABLED){this.clearDisplayedSyncedDevices_();return}}else if(this.signInState===HistorySignInState.SIGNED_OUT){this.clearDisplayedSyncedDevices_();return}this.fetchingSyncedTabs_=true}searchTermChanged_(){this.clearDisplayedSyncedDevices_();this.updateSyncedDevices_()}onCardOpenedChanged_(e){const currentTarget=e.currentTarget;const index=Number(currentTarget.dataset["index"]);const device=this.syncedDevices_[index];device.opened=e.detail.value;this.requestUpdate()}}customElements.define(HistorySyncedDeviceManagerElement.is,HistorySyncedDeviceManagerElement);export{HistorySyncedDeviceCardElement as A,BrowserServiceImpl as B,CrRippleMixin as C,HistorySyncedDeviceManagerElement as D,EventTracker as E,FocusOutlineManager as F,listenOnce as G,HistoryPageViewHistogram as H,RESULTS_PER_PAGE as R,SYNCED_TABS_HISTOGRAM_NAME as S,UrlSpec as U,VirtualFocusRow as V,assert as a,assertNotReached as b,getCss$a as c,getFaviconForPageURL as d,getDeepActiveElement as e,getTrustedHTML as f,getCss$e as g,getInstance as h,FocusRow as i,focusWithoutInk as j,getCss$4 as k,VisitContextMenuAction as l,BROWSING_GAP_TIME as m,debounceEnd as n,isWindows as o,isMac as p,getCss$7 as q,getTrustedScriptURL as r,hasKeyModifiers as s,HistorySignInState as t,CrActionMenuElement as u,CrButtonElement as v,CrCheckboxElement as w,CrDialogElement as x,SyncedTabsHistogram as y,HistorySearchedLabelElement as z};