// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{BrowserProxyImpl}from"./browser_proxy.js";let instance=null;export class ScreenshotBitmapBrowserProxyImpl{screenshot;isSidePanelOpenOnScreenshot=false;screenshotListenerId;onOverlayReshownListenerId;callbacks=[];onOverlayReshownCallbacks=[];constructor(){this.screenshotListenerId=BrowserProxyImpl.getInstance().callbackRouter.screenshotDataReceived.addListener(this.screenshotDataReceived.bind(this));this.onOverlayReshownListenerId=BrowserProxyImpl.getInstance().callbackRouter.onOverlayReshown.addListener(this.onOverlayReshown.bind(this))}static getInstance(){return instance||(instance=new ScreenshotBitmapBrowserProxyImpl)}static setInstance(obj){instance=obj}fetchScreenshot(callback){this.callbacks.push(callback);if(this.screenshot){createImageBitmap(this.screenshot).then((bitmap=>{callback(bitmap,this.isSidePanelOpenOnScreenshot)}));return}}addOnOverlayReshownListener(callback){this.onOverlayReshownCallbacks.push(callback)}async parseScreenshotData(screenshotData){const data=screenshotData.pixelData;let pixelData;if(Array.isArray(data.bytes)){pixelData=new Uint8ClampedArray(data.bytes)}else{assert(data.sharedMemory);const sharedMemory=data.sharedMemory;const{buffer:buffer,result:result}=sharedMemory.bufferHandle.mapBuffer(0,sharedMemory.size);assert(result===Mojo.RESULT_OK);pixelData=new Uint8ClampedArray(buffer)}const imageWidth=screenshotData.imageInfo.width;const imageHeight=screenshotData.imageInfo.height;const imageData=new ImageData(pixelData,imageWidth,imageHeight);return createImageBitmap(imageData)}async onOverlayReshown(screenshotData){const data=screenshotData.pixelData;if(data.invalidBuffer){return}this.screenshot=await this.parseScreenshotData(screenshotData);for(const callback of this.onOverlayReshownCallbacks){createImageBitmap(this.screenshot).then((bitmap=>{callback(bitmap)}))}}async screenshotDataReceived(screenshotData,isSidePanelOpen){const data=screenshotData.pixelData;if(data.invalidBuffer){return}this.screenshot=await this.parseScreenshotData(screenshotData);this.isSidePanelOpenOnScreenshot=isSidePanelOpen;for(const callback of this.callbacks){createImageBitmap(this.screenshot).then((bitmap=>{callback(bitmap,this.isSidePanelOpenOnScreenshot)}))}}}