// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";export var MessageType;(function(MessageType){MessageType[MessageType["SCROLL_TO"]=0]="SCROLL_TO"})(MessageType||(MessageType={}));export var ParamType;(function(ParamType){ParamType["MESSAGE_TYPE"]="type";ParamType["TEXT_FRAGMENTS"]="textFragments";ParamType["PDF_PAGE_NUMBER"]="pdfPageNumber"})(ParamType||(ParamType={}));const HANDSHAKE_INTERVAL_MS=500;export class PostMessageReceiver{eventTracker=new EventTracker;sidePanelProxy;resultsFrame;listenerIds=[];resultsSearchUrl=new URL(loadTimeData.getString("resultsSearchURL"));handshakeMessage=(new TextEncoder).encode(loadTimeData.getString("handshakeMessage"));handshakeIntervalId=null;isAimSearchboxEnabled=loadTimeData.getBoolean("enableAimSearchbox");constructor(sidePanelProxy,resultsFrame){this.sidePanelProxy=sidePanelProxy;this.resultsFrame=resultsFrame;this.eventTracker.add(window,"message",this.onMessageReceived.bind(this));this.listenerIds=[this.sidePanelProxy.callbackRouter.sendClientMessageToAim.addListener(this.onSendClientMessageToAim.bind(this)),this.sidePanelProxy.callbackRouter.aimHandshakeReceived.addListener(this.onAimHandshakeReceived.bind(this))];this.queueHandshake()}detach(){this.eventTracker.removeAll();this.listenerIds.forEach((id=>assert(this.sidePanelProxy.callbackRouter.removeListener(id))));this.listenerIds=[];this.stopAimHandshake()}queueHandshake(){if(!this.isAimSearchboxEnabled){return}this.eventTracker.add(this.resultsFrame,"load",(()=>{this.handshakeIntervalId=setInterval((()=>{this.onSendClientMessageToAim(this.handshakeMessage)}),HANDSHAKE_INTERVAL_MS)}))}onSendClientMessageToAim(serializedMessage){const contentWindow=this.resultsFrame.contentWindow;assert(contentWindow);contentWindow.postMessage(serializedMessage,this.resultsSearchUrl.origin)}onMessageReceived(event){if(event.origin!==this.resultsSearchUrl.origin){return}try{const data=JSON.parse(event.data);const messageType=data[ParamType.MESSAGE_TYPE];if(messageType===MessageType.SCROLL_TO){this.sidePanelProxy.handler.onScrollToMessage(data[ParamType.TEXT_FRAGMENTS],data[ParamType.PDF_PAGE_NUMBER]);return}}catch(e){this.onAimMessage(event.data)}}onAimMessage(message){if(!this.isAimSearchboxEnabled){return}this.sidePanelProxy.handler.onAimMessage(Array.from(message))}onAimHandshakeReceived(){this.stopAimHandshake()}stopAimHandshake(){if(this.handshakeIntervalId){clearInterval(this.handshakeIntervalId);this.handshakeIntervalId=null}}}