// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { LensSidePanelPageCallbackRouter, LensSidePanelPageHandlerFactory, LensSidePanelPageHandlerRemote } from '../lens_side_panel.mojom-webui.js';
let instance = null;
export class SidePanelBrowserProxyImpl {
    callbackRouter = new LensSidePanelPageCallbackRouter();
    handler = new LensSidePanelPageHandlerRemote();
    constructor() {
        const factory = LensSidePanelPageHandlerFactory.getRemote();
        factory.createSidePanelPageHandler(this.handler.$.bindNewPipeAndPassReceiver(), this.callbackRouter.$.bindNewPipeAndPassRemote());
    }
    static getInstance() {
        return instance || (instance = new SidePanelBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
