import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style md-select cr-spinner-style">cr-link-row[hide-icon]::part(icon){display:none}div[slot='body']{max-height:60vh}.md-select{--md-select-width:100%;margin-bottom:var(--cr-form-field-bottom-spacing);margin-top:2px}.bold-text{font-weight:bold}.flex{display:flex}cr-icon,site-favicon{max-width:16px;padding-inline-end:15px}.failed-row{margin-inline-start:31px;padding-block:8px}.failed-row~.failed-row{border-top:1px solid var(--cr-separator-color)}.url-username-group{display:grid;grid-template-columns:fit-content(50%) 1fr;width:100%}.website:not(:empty){margin-inline-end:16px}.error-status{color:var(--error-color);padding-inline-start:30px}#successIcon{fill:var(--cr-checked-color)}#conflictsWarningIcon{height:18px;--iron-icon-fill-color:rgb(234,134,0)}.flex-float-left{margin-inline-end:auto}#skipButton{margin-inline-end:8px}#conflictsList{margin-top:16px}.error-icon{margin-block:auto;--iron-icon-fill-color:var(--error-color)}#failuresSummary{color:var(--cr-primary-text-color);padding:8px 0}#failuresTitleRow{margin-block:16px 8px}#tipBox{align-items:center;background:var(--google-grey-50);border:1px solid var(--cr-separator-color);border-radius:4px;margin-top:16px;padding:8px}#deleteFileOption{margin-top:16px;min-height:36px;padding-inline-start:1px;--cr-checkbox-label-padding-start:16px;--cr-checkbox-size:14px;--cr-checkbox-border-size:1px;--cr-checkbox-ripple-size:36px}@media (prefers-color-scheme:dark){#tipBox{background:var(--google-grey-900)}#conflictsWarningIcon{--iron-icon-fill-color:var(--google-yellow-300)}}</style>

<cr-link-row id="linkRow" class="cr-row" on-click="onBannerClick_"
    label="$i18n{importPasswords}" sub-label="[[bannerDescription_]]"
    hide-icon$="[[shouldHideLinkRowIcon_(dialogState_, isAccountStoreUser)]]"
    ariaShowSublabel ariaShowLabel roleDescription="button"
    non-clickable$="[[!isAccountStoreUser]]">
  <cr-button id="selectFileButtonLinkRow" on-click="onSelectFileClick_"
      class="cr-row-action-button"
      hidden="[[shouldHideSelectFileButton_(isAccountStoreUser, dialogState_)]]">
    $i18n{selectFile}
  </cr-button>
  <div class="spinner" hidden$="[[!isState_(
      dialogStateEnum_.IN_PROGRESS, dialogState_)]]"></div>
</cr-link-row>

<!-- STORE_PICKER dialog -->
<template is="dom-if"
    if="[[isState_(dialogStateEnum_.STORE_PICKER, dialogState_)]]" restamp>
  <cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach no-cancel>
    <div slot="title" id="title">$i18n{importPasswords}</div>
    <div slot="body">
      <select class="md-select" id="storePicker" autofocus
          value="[[selectedStoreOption_]]"
          aria-description="$i18n{importPasswordsStorePickerA11yDescription}">
        <option value="[[storeOptionEnum_.ACCOUNT]]">
          [[getStoreOptionAccountText_(accountEmail)]]
        </option>
        <option value="[[storeOptionEnum_.DEVICE]]">
          $i18n{passwordsStoreOptionDevice}
        </option>
      </select>
      <div id="description">$i18n{importPasswordsSelectFile}</div>
    </div>
    <div slot="button-container">
      <cr-button id="cancelButton" class="cancel-button"
          on-click="onCloseClick_">
        $i18n{cancel}
      </cr-button>
      <cr-button id="selectFileButtonStorePicker" class="action-button"
          on-click="onSelectFileClick_">
        $i18n{selectFile}
      </cr-button>
    </div>
  </cr-dialog>
</template>

<!-- ERROR dialog -->
<template is="dom-if"
    if="[[isState_(dialogStateEnum_.ERROR, dialogState_)]]" restamp>
  <cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach no-cancel>
    <div slot="title" id="title">$i18n{importPasswordsErrorTitle}</div>
    <div slot="body">
      <template is="dom-if" if="[[isAccountStoreUser]]" restamp>
        <select class="md-select" id="storePicker" autofocus
            value="[[selectedStoreOption_]]"
            aria-description="$i18n{importPasswordsStorePickerA11yDescription}">
          <option value="[[storeOptionEnum_.ACCOUNT]]">
            [[getStoreOptionAccountText_(accountEmail)]]
          </option>
          <option value="[[storeOptionEnum_.DEVICE]]">
            $i18n{passwordsStoreOptionDevice}
          </option>
        </select>
      </template>
      <div class="flex">
        <cr-icon class="error-icon" icon="cr:warning"></cr-icon>
        <div id="description"
            inner-h-t-m-l="[[getErrorDialogDescription_(results_)]]">
        </div>
      </div>
    </div>
    <div slot="button-container">
      <cr-button id="closeButton" class="cancel-button"
          on-click="onCloseClick_" autofocus>
        $i18n{close}
      </cr-button>
      <cr-button id="selectFileButtonError" class="action-button"
          on-click="onSelectFileClick_">
        $i18n{selectFile}
      </cr-button>
    </div>
  </cr-dialog>
</template>

<!-- SUCCESS dialog -->
<template is="dom-if" if="[[isState_(dialogStateEnum_.SUCCESS, dialogState_)]]"
    restamp>
  <cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach no-cancel>
    <div slot="title" id="title">[[getSuccessDialogTitle_(results_)]]</div>
    <div slot="body">
      <div class="flex">
        <cr-icon id="successIcon" icon="cr:check-circle"></cr-icon>
        <div id="description">[[successDescription_]]</div>
      </div>
      <cr-checkbox id="deleteFileOption"
        hidden="[[shouldHideDeleteFileOption_(results_)]]"
        inner-h-t-m-l="[[getCheckboxLabelHtml_(results_)]]">
      </cr-checkbox>
      <div hidden="[[shouldHideFailuresSummary_(results_)]]">
        <div id="failuresTitleRow" class="flex-centered">
          <cr-icon class="error-icon" icon="cr:warning"></cr-icon>
          <div id="failuresSummary">[[failedImportsSummary_]]</div>
        </div>
        <template is="dom-repeat"
            items="[[getFailedImportsWithKnownErrors_(results_)]]">
          <div class="failed-row">
            <div class="flex-centered">
              <site-favicon domain="[[item.url]]" aria-hidden="true">
              </site-favicon>
              <div class="url-username-group">
                <div class="website bold-text text-elide">[[item.url]]</div>
                <div class="username text-elide">[[item.username]]</div>
              </div>
            </div>
            <div class="error-status">
              [[getFailedEntryErrorMessage_(item.status)]]
            </div>
          </div>
        </template>
        <div class="failed-row" hidden="[[!showRowsWithUnknownErrorsSummary_]]">
          <div class="error-status">[[rowsWithUnknownErrorsSummary_]]</div>
        </div>
      </div>
    </div>
    <div slot="button-container">
      <cr-button id="closeButton" class="cancel-button"
          on-click="onCloseClick_" autofocus>
        $i18n{close}
      </cr-button>
      <cr-button id="viewPasswordsButton" class="action-button"
          on-click="onViewPasswordsClick_">
        $i18n{viewPasswordsButton}
      </cr-button>
    </div>
  </cr-dialog>
</template>

<!-- ALREADY_ACTIVE dialog -->
<template is="dom-if"
    if="[[isState_(dialogStateEnum_.ALREADY_ACTIVE, dialogState_)]]" restamp>
  <cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach no-cancel>
    <div slot="title" id="title">$i18n{importPasswords}</div>
    <div slot="body" class="flex-centered">
      <cr-icon id="infoIcon" icon="cr:info-outline"></cr-icon>
      <div id="description">$i18n{importPasswordsAlreadyActive}</div>
    </div>
    <div slot="button-container">
      <cr-button id="closeButton" class="action-button"
          on-click="onCloseClick_" autofocus>
        $i18n{close}
      </cr-button>
    </div>
  </cr-dialog>
</template>

<!-- CONFLICTS dialog -->
<template is="dom-if"
    if="[[isState_(dialogStateEnum_.CONFLICTS, dialogState_)]]" restamp>
  <cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach no-cancel>
    <div slot="title" id="title" class="flex-centered">
      <cr-icon id="conflictsWarningIcon" icon="cr:warning"></cr-icon>
      <span>[[conflictsDialogTitle_]]</span>
    </div>
    <div slot="body">
      <div id="description">$i18n{importPasswordsConflictsDescription}</div>
      <div id="conflictsList">
        <template is="dom-repeat" items="[[conflicts_]]">
          <password-preview-item password-id="[[item.id]]"
              url="[[item.url]]" username="[[item.username]]"
              password="[[item.password]]" first="[[!index]]"
              on-change="onPasswordSelectedChange_"
              checked="[[isPreviewItemChecked_(item.id)]]">
          </password-preview-item>
        </template>
      </div>
    </div>
    <div slot="button-container">
      <cr-button id="cancelButton" class="cancel-button flex-float-left"
          on-click="onCloseClick_" autofocus>
        $i18n{importPasswordsCancel}
      </cr-button>
      <cr-button id="skipButton" class="skip-button" on-click="onSkipClick_">
        $i18n{importPasswordsSkip}
      </cr-button>
      <cr-button id="replaceButton" class="action-button"
          on-click="onReplaceClick_"
          disabled="[[shouldDisableReplace_(conflictsSelectedForReplace_)]]">
        $i18n{importPasswordsReplace}
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}
