// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var AnnotationMode;(function(AnnotationMode){AnnotationMode["OFF"]="off";AnnotationMode["DRAW"]="draw";AnnotationMode["TEXT"]="text"})(AnnotationMode||(AnnotationMode={}));var AnnotationBrushType;(function(AnnotationBrushType){AnnotationBrushType["ERASER"]="eraser";AnnotationBrushType["HIGHLIGHTER"]="highlighter";AnnotationBrushType["PEN"]="pen"})(AnnotationBrushType||(AnnotationBrushType={}));var TextAlignment;(function(TextAlignment){TextAlignment["LEFT"]="left";TextAlignment["CENTER"]="center";TextAlignment["RIGHT"]="right"})(TextAlignment||(TextAlignment={}));var TextStyle;(function(TextStyle){TextStyle["BOLD"]="bold";TextStyle["ITALIC"]="italic"})(TextStyle||(TextStyle={}));var TextTypeface;(function(TextTypeface){TextTypeface["SANS_SERIF"]="sans-serif";TextTypeface["SERIF"]="serif";TextTypeface["MONOSPACE"]="monospace"})(TextTypeface||(TextTypeface={}));var DisplayAnnotationsAction;(function(DisplayAnnotationsAction){DisplayAnnotationsAction["DISPLAY_ANNOTATIONS"]="display-annotations";DisplayAnnotationsAction["HIDE_ANNOTATIONS"]="hide-annotations"})(DisplayAnnotationsAction||(DisplayAnnotationsAction={}));var FittingType;(function(FittingType){FittingType["NONE"]="none";FittingType["FIT_TO_PAGE"]="fit-to-page";FittingType["FIT_TO_WIDTH"]="fit-to-width";FittingType["FIT_TO_HEIGHT"]="fit-to-height";FittingType["FIT_TO_BOUNDING_BOX"]="fit-to-bounding-box";FittingType["FIT_TO_BOUNDING_BOX_WIDTH"]="fit-to-bounding-box-width";FittingType["FIT_TO_BOUNDING_BOX_HEIGHT"]="fit-to-bounding-box-height"})(FittingType||(FittingType={}));var FormFieldFocusType;(function(FormFieldFocusType){FormFieldFocusType["NONE"]="none";FormFieldFocusType["NON_TEXT"]="non-text";FormFieldFocusType["TEXT"]="text"})(FormFieldFocusType||(FormFieldFocusType={}));var SaveToDriveState;(function(SaveToDriveState){SaveToDriveState["UNINITIALIZED"]="uninitialized";SaveToDriveState["UPLOADING"]="uploading";SaveToDriveState["SUCCESS"]="success";SaveToDriveState["CONNECTION_ERROR"]="connection-error";SaveToDriveState["STORAGE_FULL_ERROR"]="storage-full-error";SaveToDriveState["SESSION_TIMEOUT_ERROR"]="session-timeout-error";SaveToDriveState["UNKNOWN_ERROR"]="unknown-error"})(SaveToDriveState||(SaveToDriveState={}));var SaveToDriveBubbleRequestType;(function(SaveToDriveBubbleRequestType){SaveToDriveBubbleRequestType["CANCEL_UPLOAD"]="cancel-upload";SaveToDriveBubbleRequestType["MANAGE_STORAGE"]="manage-storage";SaveToDriveBubbleRequestType["OPEN_IN_DRIVE"]="open-in-drive";SaveToDriveBubbleRequestType["RETRY"]="retry";SaveToDriveBubbleRequestType["DIALOG_CLOSED"]="dialog-closed"})(SaveToDriveBubbleRequestType||(SaveToDriveBubbleRequestType={}));function assert(value,message){if(value){return}throw new Error("Assertion failed"+"")}class GestureDetector{element_;pinchStartEvent_=null;lastTouchTouchesCount_=0;lastEvent_=null;isPresentationMode_=false;accumulatedWheelScale_=null;wheelEndTimeout_=null;eventTarget_=new EventTarget;constructor(element){this.element_=element;this.element_.addEventListener("touchstart",this.onTouchStart_.bind(this),{passive:true});const boundOnTouch=this.onTouch_.bind(this);this.element_.addEventListener("touchmove",boundOnTouch,{passive:true});this.element_.addEventListener("touchend",boundOnTouch,{passive:true});this.element_.addEventListener("touchcancel",boundOnTouch,{passive:true});this.element_.addEventListener("wheel",this.onWheel_.bind(this),{passive:false});document.addEventListener("contextmenu",this.handleContextMenuEvent_.bind(this))}setPresentationMode(enabled){this.isPresentationMode_=enabled}getEventTarget(){return this.eventTarget_}wasTwoFingerTouch(){return this.lastTouchTouchesCount_===2}notify_(type,detail){const clientRect=this.element_.getBoundingClientRect();detail.center={x:detail.center.x-clientRect.x,y:detail.center.y-clientRect.y};this.eventTarget_.dispatchEvent(new CustomEvent(type,{detail:detail}))}onTouchStart_(event){this.lastTouchTouchesCount_=event.touches.length;if(!this.wasTwoFingerTouch()){return}this.pinchStartEvent_=event;this.lastEvent_=event;this.notify_("pinchstart",{center:center(event)})}onTouch_(event){if(!this.pinchStartEvent_){return}const lastEvent=this.lastEvent_;if(event.touches.length<2||lastEvent.touches.length!==event.touches.length){const startScaleRatio=pinchScaleRatio(lastEvent,this.pinchStartEvent_);this.pinchStartEvent_=null;this.lastEvent_=null;this.notify_("pinchend",{startScaleRatio:startScaleRatio,center:center(lastEvent)});return}const scaleRatio=pinchScaleRatio(event,lastEvent);const startScaleRatio=pinchScaleRatio(event,this.pinchStartEvent_);this.notify_("pinchupdate",{scaleRatio:scaleRatio,direction:scaleRatio>1?"in":"out",startScaleRatio:startScaleRatio,center:center(event)});this.lastEvent_=event}onWheel_(event){if(!event.ctrlKey){if(this.isPresentationMode_){this.notify_("wheel",{center:{x:event.clientX,y:event.clientY},direction:event.deltaY>0?"down":"up"})}return}event.preventDefault();if(this.isPresentationMode_){return}const wheelScale=Math.exp(-event.deltaY/100);const scale=Math.min(1.25,Math.max(.75,wheelScale));const position={x:event.clientX,y:event.clientY};if(this.accumulatedWheelScale_==null){this.accumulatedWheelScale_=1;this.notify_("pinchstart",{center:position})}this.accumulatedWheelScale_*=scale;this.notify_("pinchupdate",{scaleRatio:scale,direction:scale>1?"in":"out",startScaleRatio:this.accumulatedWheelScale_,center:position});if(this.wheelEndTimeout_!=null){window.clearTimeout(this.wheelEndTimeout_);this.wheelEndTimeout_=null}const gestureEndDelayMs=100;const endEvent={startScaleRatio:this.accumulatedWheelScale_,center:position};this.wheelEndTimeout_=window.setTimeout((()=>{this.notify_("pinchend",endEvent);this.wheelEndTimeout_=null;this.accumulatedWheelScale_=null}),gestureEndDelayMs)}handleContextMenuEvent_(e){const capabilities=e.sourceCapabilities;if(capabilities&&capabilities.firesTouchEvents&&!this.wasTwoFingerTouch()){e.preventDefault()}}}function pinchScaleRatio(event,prevEvent){const distance1=distance(prevEvent);const distance2=distance(event);return distance1===0?null:distance2/distance1}function distance(event){assert(event.touches.length>1);const touch1=event.touches[0];const touch2=event.touches[1];const dx=touch1.clientX-touch2.clientX;const dy=touch1.clientY-touch2.clientY;return Math.sqrt(dx*dx+dy*dy)}function center(event){assert(event.touches.length>1);const touch1=event.touches[0];const touch2=event.touches[1];return{x:(touch1.clientX+touch2.clientX)/2,y:(touch1.clientY+touch2.clientY)/2}}function convertFormFocusChangeMessage(message){return message}const SWIPE_TIMER_INTERVAL_MS=200;const SWIPE_X_DIST_MIN=150;const SWIPE_Y_DIST_MAX=100;var SwipeDirection;(function(SwipeDirection){SwipeDirection[SwipeDirection["RIGHT_TO_LEFT"]=0]="RIGHT_TO_LEFT";SwipeDirection[SwipeDirection["LEFT_TO_RIGHT"]=1]="LEFT_TO_RIGHT"})(SwipeDirection||(SwipeDirection={}));class SwipeDetector{element_;isPresentationMode_=false;swipeStartEvent_=null;elapsedTimeForTesting_=null;eventTarget_=new EventTarget;constructor(element){this.element_=element;this.element_.addEventListener("touchstart",this.onTouchStart_.bind(this),{passive:true});this.element_.addEventListener("touchend",this.onTouchEnd_.bind(this),{passive:true});this.element_.addEventListener("touchcancel",(()=>this.onTouchCancel_()),{passive:true})}setElapsedTimerForTesting(time){this.elapsedTimeForTesting_=time}setPresentationMode(enabled){this.isPresentationMode_=enabled}getPresentationModeForTesting(){return this.isPresentationMode_}getEventTarget(){return this.eventTarget_}notify_(direction){this.eventTarget_.dispatchEvent(new CustomEvent("swipe",{detail:direction}))}onTouchStart_(event){if(!this.isPresentationMode_){return}if(event.touches.length!==1||this.swipeStartEvent_){this.swipeStartEvent_=null;return}this.swipeStartEvent_=event;return}onTouchCancel_(){if(!this.isPresentationMode_||!this.swipeStartEvent_){return}this.swipeStartEvent_=null}onTouchEnd_(event){if(!this.isPresentationMode_||!this.swipeStartEvent_){return}if(event.touches.length!==0||this.swipeStartEvent_.touches.length!==1){return}const elapsedTime=this.elapsedTimeForTesting_?this.elapsedTimeForTesting_:event.timeStamp-this.swipeStartEvent_.timeStamp;const swipeStartObj=this.swipeStartEvent_.changedTouches[0];assert(swipeStartObj);const swipeEndObj=event.changedTouches[0];assert(swipeEndObj);const distX=swipeEndObj.pageX-swipeStartObj.pageX;const distY=swipeEndObj.pageY-swipeStartObj.pageY;if(elapsedTime<=SWIPE_TIMER_INTERVAL_MS&&Math.abs(distX)>=SWIPE_X_DIST_MIN&&Math.abs(distY)<=SWIPE_Y_DIST_MAX){const direction=distX>0?SwipeDirection.LEFT_TO_RIGHT:SwipeDirection.RIGHT_TO_LEFT;this.notify_(direction)}this.swipeStartEvent_=null}}const channel=new MessageChannel;const sizer=document.querySelector("#sizer");const plugin=document.querySelector("embed");const srcUrl=new URL(plugin.src);let parentOrigin=srcUrl.origin;if(parentOrigin==="chrome-untrusted://print"){parentOrigin="chrome://print"}let caretBrowsingEnabled=false;let isFormFieldFocused=false;plugin.addEventListener("message",(e=>{const message=e.data;switch(message.type){case"formFocusChange":const focusedData=convertFormFocusChangeMessage(message);isFormFieldFocused=focusedData.focused!==FormFieldFocusType.NONE;break;case"rendererPreferencesUpdated":const caretBrowsingEnabledData=message;caretBrowsingEnabled=caretBrowsingEnabledData.caretBrowsingEnabled;break}channel.port1.postMessage(message)}));let isPresentationMode=false;channel.port1.onmessage=e=>{switch(e.data.type){case"setPresentationMode":isPresentationMode=e.data.enablePresentationMode;gestureDetector.setPresentationMode(isPresentationMode);swipeDetector.setPresentationMode(isPresentationMode);if(isPresentationMode){document.documentElement.className="fullscreen"}else{document.documentElement.className="";plugin.focus()}break;case"syncScrollToRemote":window.scrollTo({left:e.data.x,top:e.data.y,behavior:e.data.isSmooth?"smooth":"auto"});channel.port1.postMessage({type:"ackScrollToRemote",x:window.scrollX,y:window.scrollY});return;case"updateSize":sizer.style.width=`${e.data.width}px`;sizer.style.height=`${e.data.height}px`;return;case"viewport":if(parentOrigin==="chrome://print"&&e.data.layoutOptions){switch(e.data.layoutOptions.direction){case 1:document.dir="rtl";break;case 2:document.dir="ltr";break;default:document.dir="";break}}break}plugin.postMessage(e.data)};window.parent.postMessage({type:"connect",token:srcUrl.href},parentOrigin,[channel.port2]);window.addEventListener("scroll",(()=>{channel.port1.postMessage({type:"syncScrollFromRemote",x:window.scrollX,y:window.scrollY})}));function relayGesture(e){const gestureEvent=e;channel.port1.postMessage({type:"gesture",gesture:{type:gestureEvent.type,detail:gestureEvent.detail}})}const gestureDetector=new GestureDetector(plugin);for(const type of["pinchstart","pinchupdate","pinchend","wheel"]){gestureDetector.getEventTarget().addEventListener(type,relayGesture)}function relaySwipe(e){const swipeEvent=e;channel.port1.postMessage({type:"swipe",direction:swipeEvent.detail})}const swipeDetector=new SwipeDetector(plugin);swipeDetector.getEventTarget().addEventListener("swipe",relaySwipe);document.addEventListener("pointerdown",(e=>{if(e.button!==0){return}channel.port1.postMessage({type:"sendClickEvent",x:e.clientX,y:e.clientY})}));document.addEventListener("keydown",(e=>{switch(e.key){case" ":break;case"PageDown":case"PageUp":if(!hasKeyModifiers(e)){e.preventDefault();break}return;case"ArrowDown":case"ArrowLeft":case"ArrowRight":case"ArrowUp":if(caretBrowsingEnabled){break}if(!isFormFieldFocused&&!hasKeyModifiers(e)){e.preventDefault();break}return;case"Enter":case"Escape":case"Tab":break;case"=":case"-":case"+":if(isPresentationMode&&hasCtrlModifier(e)){e.preventDefault()}return;case"a":if(hasCtrlModifierOnly(e)){e.preventDefault();break}return;default:if(hasCtrlModifier(e)){break}return}channel.port1.postMessage({type:"sendKeyEvent",keyEvent:{keyCode:e.keyCode,code:e.code,key:e.key,shiftKey:e.shiftKey,ctrlKey:e.ctrlKey,altKey:e.altKey,metaKey:e.metaKey}})}));document.addEventListener("keypress",(e=>{switch(e.key){case" ":if(!isFormFieldFocused){e.preventDefault()}break}}));function hasCtrlModifier(e){let hasModifier=e.ctrlKey;return hasModifier}function hasCtrlModifierOnly(e){let metaModifier=e.metaKey;return hasCtrlModifier(e)&&!e.shiftKey&&!e.altKey&&!metaModifier}function hasKeyModifiers(e){return!!(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey)}