// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_ripple/cr_ripple.js';
import '//resources/cr_elements/cr_menu_selector/cr_menu_selector.js';
import '//resources/cr_elements/cr_nav_menu_item_style.css.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './sidebar.css.js';
import { getHtml } from './sidebar.html.js';
export class RelatedWebsiteSetsSidebarElement extends CrLitElement {
    static get is() {
        return 'related-website-sets-sidebar';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            menuItems_: { type: Array },
        };
    }
    #menuItems__accessor_storage = [
        {
            icon: 'cr:settings_icon',
            name: 'Settings',
            path: 'chrome://settings',
        },
    ];
    get menuItems_() { return this.#menuItems__accessor_storage; }
    set menuItems_(value) { this.#menuItems__accessor_storage = value; }
    getMenuItemsForTesting() {
        return this.menuItems_;
    }
}
customElements.define(RelatedWebsiteSetsSidebarElement.is, RelatedWebsiteSetsSidebarElement);
