// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{dedupingMixin}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{PromiseResolver}from"chrome://resources/js/promise_resolver.js";import{PrivacySandboxDialogBrowserProxy,PrivacySandboxPromptAction}from"./privacy_sandbox_dialog_browser_proxy.js";export const PrivacySandboxDialogMixin=dedupingMixin((superClass=>{class PrivacySandboxDialogMixin extends superClass{static get properties(){return{wasScrolledToBottom:{type:Boolean,observer:"onWasScrolledToBottomChange_",value:true},loadPrivacyPolicy_:{type:Boolean,value:false}}}didStartWithScrollbar_=false;wasScrolledToBottomResolver_;moreButtonInitialized_;equalizedButtons_;loadPrivacyPolicyOnExpand(newValue,oldValue){if(newValue&&!oldValue){this.loadPrivacyPolicy_=true}}onConsentLearnMoreExpandedChanged(newValue,oldValue){if(newValue&&!oldValue){this.onContentSizeChanging_(true);this.promptActionOccurred(PrivacySandboxPromptAction.CONSENT_MORE_INFO_OPENED)}if(!newValue&&oldValue){this.onContentSizeChanging_(false);this.promptActionOccurred(PrivacySandboxPromptAction.CONSENT_MORE_INFO_CLOSED)}}onNoticeLearnMoreExpandedChanged(newValue,oldValue){if(newValue&&!oldValue){this.onContentSizeChanging_(true);this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_MORE_INFO_OPENED)}if(!newValue&&oldValue){this.onContentSizeChanging_(false);this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_MORE_INFO_CLOSED)}}onNoticeSiteSuggestedAdsLearnMoreExpandedChanged(newValue,oldValue){if(newValue&&!oldValue){this.onContentSizeChanging_(true);this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_SITE_SUGGESTED_ADS_MORE_INFO_OPENED)}if(!newValue&&oldValue){this.onContentSizeChanging_(false);this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_SITE_SUGGESTED_ADS_MORE_INFO_CLOSED)}}onNoticeAdsMeasurementLearnMoreExpandedChanged(newValue,oldValue){if(newValue&&!oldValue){this.onContentSizeChanging_(true);this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_ADS_MEASUREMENT_MORE_INFO_OPENED)}if(!newValue&&oldValue){this.onContentSizeChanging_(false);this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_ADS_MEASUREMENT_MORE_INFO_CLOSED)}}onNoticeOpenSettings(){this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_OPEN_SETTINGS)}onNoticeAcknowledge(){this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_ACKNOWLEDGE)}onConsentMoreClicked(){this.onMoreClicked_();this.promptActionOccurred(PrivacySandboxPromptAction.CONSENT_MORE_BUTTON_CLICKED)}onNoticeMoreClicked(){this.onMoreClicked_();this.promptActionOccurred(PrivacySandboxPromptAction.NOTICE_MORE_BUTTON_CLICKED)}onRestrictedNoticeMoreClicked(){this.onMoreClicked_();this.promptActionOccurred(PrivacySandboxPromptAction.RESTRICTED_NOTICE_MORE_BUTTON_CLICKED)}promptActionOccurred(action){PrivacySandboxDialogBrowserProxy.getInstance().promptActionOccurred(action)}onContentSizeChanging_(expanding){const scrollable=this.shadowRoot.querySelector("[scrollable]");if(expanding){scrollable.classList.toggle("hide-scrollbar",false);this.didStartWithScrollbar_=scrollable.offsetHeight<scrollable.scrollHeight}else{scrollable.classList.toggle("hide-scrollbar",!this.didStartWithScrollbar_)}}updateScrollableContents(){requestAnimationFrame((()=>{const scrollable=this.shadowRoot.querySelector("[scrollable]");scrollable.classList.toggle("can-scroll",scrollable.clientHeight<scrollable.scrollHeight)}))}maybeShowMoreButton(){this.wasScrolledToBottomResolver_=new PromiseResolver;this.moreButtonInitialized_=new PromiseResolver;return new Promise((resolve=>{const scrollable=this.shadowRoot.querySelector("[scrollable]");this.wasScrolledToBottom=false;const buttonRowHeight=64;let lastTextElementId="#lastTextElement";if(scrollable.querySelector("#lastTextElementV2")){lastTextElementId="#lastTextElementV2"}const lastTextElement=scrollable.querySelector(lastTextElementId);const options={root:scrollable,threshold:[1],rootMargin:`0px 0px -${buttonRowHeight}px 0px`};const observer=new IntersectionObserver((entries=>{for(const entry of entries){this.wasScrolledToBottom=entry.intersectionRatio>=.99;if(this.wasScrolledToBottom){this.wasScrolledToBottomResolver_.resolve();observer.disconnect()}resolve()}this.moreButtonInitialized_.resolve()}),options);observer.observe(lastTextElement)}))}whenWasScrolledToBottomForTest(){return this.wasScrolledToBottomResolver_.promise}moreButtonInitializedForTest(){return this.moreButtonInitialized_.promise}onWasScrolledToBottomChange_(){const scrollable=this.shadowRoot.querySelector("[scrollable]");scrollable.classList.toggle("more-content-available",!this.wasScrolledToBottom)}onMoreClicked_(){const scrollable=this.shadowRoot.querySelector("[scrollable]");scrollable.scrollBy({top:scrollable.clientHeight})}}return PrivacySandboxDialogMixin}));