// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getRequiredElement}from"chrome://resources/js/util.js";var StatusClass;(function(StatusClass){StatusClass["GOOD"]="good";StatusClass["BAD"]="bad";StatusClass["MEDIUM"]="medium";StatusClass["INFO"]="info"})(StatusClass||(StatusClass={}));function addStatusRow(name,value,cssClass){const row=document.createElement("tr");const nameCol=row.appendChild(document.createElement("td"));const valueCol=row.appendChild(document.createElement("td"));nameCol.textContent=name;valueCol.textContent=value;if(cssClass!=null){nameCol.classList.add(cssClass);valueCol.classList.add(cssClass)}getRequiredElement("sandbox-status").appendChild(row);return row}function setEvaluation(result){const message=result?"You are adequately sandboxed.":"You are NOT adequately sandboxed.";getRequiredElement("evaluation").innerText=message}function addGoodBadRow(name,result){return addStatusRow(name,result?"Yes":"No",result?StatusClass.GOOD:StatusClass.BAD)}function linuxHandler(){const suidSandbox=loadTimeData.getBoolean("suid");const nsSandbox=loadTimeData.getBoolean("userNs");let layer1SandboxType="None";let layer1SandboxCssClass=StatusClass.BAD;if(suidSandbox){layer1SandboxType="SUID";layer1SandboxCssClass=StatusClass.MEDIUM}else if(nsSandbox){layer1SandboxType="Namespace";layer1SandboxCssClass=StatusClass.GOOD}addStatusRow("Layer 1 Sandbox",layer1SandboxType,layer1SandboxCssClass);addGoodBadRow("PID namespaces",loadTimeData.getBoolean("pidNs"));addGoodBadRow("Network namespaces",loadTimeData.getBoolean("netNs"));addGoodBadRow("Seccomp-BPF sandbox",loadTimeData.getBoolean("seccompBpf"));addGoodBadRow("Seccomp-BPF sandbox supports TSYNC",loadTimeData.getBoolean("seccompTsync"));const enforcingYamaBroker=loadTimeData.getBoolean("yamaBroker");addGoodBadRow("Ptrace Protection with Yama LSM (Broker)",enforcingYamaBroker);const enforcingYamaNonbroker=loadTimeData.getBoolean("yamaNonbroker");const yamaNonbrokerCssClass=enforcingYamaBroker?enforcingYamaNonbroker?StatusClass.GOOD:StatusClass.MEDIUM:StatusClass.BAD;addStatusRow("Ptrace Protection with Yama LSM (Non-broker)",enforcingYamaNonbroker?"Yes":"No",yamaNonbrokerCssClass);setEvaluation(loadTimeData.getBoolean("sandboxGood"))}document.addEventListener("DOMContentLoaded",(()=>{linuxHandler()}));