// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{a as assertNotReached,l as listenOnce,g as getCss$5,b as getCss$6,C as CrSearchFieldMixinLit,c as getCss$7,d as assert,I as I18nMixinLit,R as RelaunchMixin,W as WebUiListenerMixin,e as I18nMixin,f as RestartType,s as sanitizeInnerHtml,S as SettingsViewMixin,P as PrefsMixin,M as MetricsBrowserProxyImpl,h as Router,r as routes,A as AiPageInteractions,O as OpenWindowProxyImpl,i as SettingsAiPageFeaturePrefName,F as FeatureOptInState,j as AiPageActions,H as HelpBubbleMixin,k as CrSettingsPrefs,m as SearchableViewContainerMixin,n as RouteObserverMixin,o as CrPolicyPrefMixin,p as PrefControlMixin,q as pageVisibility,t as AutofillSettingsReferrer,u as PasswordManagerImpl,v as PasswordManagerPage,w as FocusRowMixin,x as ScrollableMixin,y as focusWithoutInk,z as getSearchManager,B as SyncBrowserProxyImpl,D as ProfileInfoBrowserProxyImpl,E as SignedInState,G as getImage,J as StatusAction,L as ListPropertyUpdateMixin,K as BaseMixin,N as NONE_SELECTED,T as TooltipMixin,Q as NetworkPredictionOptions,U as PrivacyGuideInteractions,V as PrivacyGuideAvailabilityMixin,X as HatsBrowserProxyImpl,Y as TrustSafetyInteraction,Z as CookieControlsMode,_ as PromiseResolver,$ as PrivacyGuideBrowserProxyImpl,a0 as MAX_PRIVACY_GUIDE_PROMO_IMPRESSION,a1 as ResetBrowserProxyImpl,a2 as SearchEnginesBrowserProxyImpl,a3 as EntityDataManagerProxyImpl,a4 as AiEnterpriseFeaturePrefName,a5 as ModelExecutionEnterprisePolicyValue,a6 as PaymentsManagerImpl,a7 as AutofillManagerImpl,a8 as getTrustedScriptURL,a9 as getTopLevelRoute,aa as combineSearchResults,ab as getInstance,ac as FocusOutlineManager,ad as CrSelectableMixin,ae as FindShortcutMixin,af as setGlobalScrollTarget,ag as resetGlobalScrollTargetForTesting,ah as ChoiceMadeLocation}from"./shared.rollup.js";export{aU as AiPageCompareInteractions,aV as AiPageComposeInteractions,aW as AiPageHistorySearchInteractions,aX as AiPageTabOrganizationInteractions,aY as CardBenefitsUserAction,ao as ChromeSigninUserChoice,aI as ControlledRadioButtonElement,az as CrActionMenuElement,aA as CrButtonElement,aB as CrDialogElement,aC as CrLinkRowElement,ai as CrPolicyPrefIndicatorElement,aD as CrRadioButtonElement,aE as CrRadioGroupElement,aF as CrToggleElement,aZ as CvcDeletionUserAction,ak as DEFAULT_CHECKED_VALUE,al as DEFAULT_UNCHECKED_VALUE,a_ as DeleteBrowsingDataAction,am as ExtensionControlBrowserProxyImpl,aj as ExtensionControlledIndicatorElement,an as LifetimeBrowserProxyImpl,ap as PageStatus,aM as PasswordCheckReferrer,a$ as PrivacyElementInteractions,b0 as PrivacyGuideSettingsStates,b1 as PrivacyGuideStepsEligibleAndReached,aw as PrivacyPageBrowserProxyImpl,bb as PrivacySandboxBrowserProxyImpl,be as Route,b2 as SafeBrowsingInteractions,aO as SafeBrowsingSetting,b3 as SafetyCheckNotificationsModuleInteractions,b4 as SafetyCheckUnusedSitePermissionsModuleInteractions,b5 as SafetyHubCardState,b6 as SafetyHubEntryPoint,b7 as SafetyHubModuleType,b8 as SafetyHubSurfaces,bf as SearchEnginesInteractions,bg as SearchRequest,ax as SecureDnsMode,ay as SecureDnsUiManagementMode,aP as SecurityPageInteraction,aL as SettingsAutofillAiEntriesListElement,aN as SettingsCheckboxListEntryElement,aJ as SettingsDropdownMenuElement,aG as SettingsPluralStringProxyImpl,av as SettingsPrefsElement,bj as SettingsSectionElement,ba as SettingsSyncAccountControlElement,aK as SettingsToggleButtonElement,bk as SiteFaviconElement,ar as TrustedVaultBannerState,as as UserSelectableType,bc as buildRouter,aQ as convertLanguageCodeForChrome,aR as convertLanguageCodeForTranslate,aS as getBaseLanguage,aH as getTrustedHTML,aT as isTranslateBaseLanguage,at as prefToString,b9 as resetPageVisibilityForTesting,bd as resetRouterForTesting,bh as setSearchManagerForTesting,bi as showBubble,au as stringToPrefValue,aq as syncPrefsIndividualDataTypes}from"./shared.rollup.js";import{css,html,CrLitElement,nothing}from"chrome://resources/lit/v3_0/lit.rollup.js";import{html as html$1,PolymerElement,dedupingMixin,afterNextRender,beforeNextRender,flush}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{addWebUiListener,removeWebUiListener,sendWithPromise}from"chrome://resources/js/cr.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";export{loadTimeData}from"chrome://resources/js/load_time_data.js";import"chrome://settings/strings.m.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";let instance$e=null;function getCss$4(){return instance$e||(instance$e=[...[],css`:host{--cr-drawer-width:256px}:host dialog{--transition-timing:200ms ease;background-color:var(--cr-drawer-background-color,#fff);border:none;border-start-end-radius:var(--cr-drawer-border-start-end-radius,0);border-end-end-radius:var(--cr-drawer-border-end-end-radius,0);bottom:0;left:calc(-1 * var(--cr-drawer-width));margin:0;max-height:initial;max-width:initial;overflow:hidden;padding:0;position:absolute;top:0;transition:left var(--transition-timing);width:var(--cr-drawer-width)}@media (prefers-color-scheme:dark){:host dialog{background:var(--cr-drawer-background-color,var(--google-grey-900)) linear-gradient(rgba(255,255,255,.04),rgba(255,255,255,.04))}}:host dialog,#container{height:100%;word-break:break-word}:host([show_]) dialog{left:0}:host([align=rtl]) dialog{left:auto;right:calc(-1 * var(--cr-drawer-width));transition:right var(--transition-timing)}:host([show_][align=rtl]) dialog{right:0}:host dialog::backdrop{background:rgba(0,0,0,0.5);bottom:0;left:0;opacity:0;position:absolute;right:0;top:0;transition:opacity var(--transition-timing)}:host([show_]) dialog::backdrop{opacity:1}.drawer-header{align-items:center;border-bottom:var(--cr-separator-line);color:var(--cr-drawer-header-color,inherit);display:flex;font-size:123.08%;font-weight:var(--cr-drawer-header-font-weight,inherit);min-height:56px;padding-inline-start:var(--cr-drawer-header-padding,24px)}@media (prefers-color-scheme:dark){.drawer-header{color:var(--cr-primary-text-color)}}#heading{outline:none}:host ::slotted([slot='body']){height:calc(100% - 56px);overflow:auto}picture{margin-inline-end:16px}picture,#product-logo{height:24px;width:24px}`])}function getHtml$4(){return html`
<dialog id="dialog" @cancel="${this.onDialogCancel_}"
    @click="${this.onDialogClick_}" @close="${this.onDialogClose_}">
  <div id="container" @click="${this.onContainerClick_}">
    <div class="drawer-header">
      <slot name="header-icon">
        <picture>
          <source media="(prefers-color-scheme: dark)"
              srcset="//resources/images/chrome_logo_dark.svg">
          <img id="product-logo"
              srcset="chrome://theme/current-channel-logo@1x 1x,
                      chrome://theme/current-channel-logo@2x 2x"
              role="presentation">
        </picture>
      </slot>
      <div id="heading" tabindex="-1">${this.heading}</div>
    </div>
    <slot name="body"></slot>
  </div>
</dialog>`}class CrDrawerElement extends CrLitElement{static get is(){return"cr-drawer"}static get styles(){return getCss$4()}render(){return getHtml$4.bind(this)()}static get properties(){return{heading:{type:String},show_:{type:Boolean,reflect:true},align:{type:String,reflect:true}}}#heading_accessor_storage="";get heading(){return this.#heading_accessor_storage}set heading(value){this.#heading_accessor_storage=value}#align_accessor_storage="ltr";get align(){return this.#align_accessor_storage}set align(value){this.#align_accessor_storage=value}#show__accessor_storage=false;get show_(){return this.#show__accessor_storage}set show_(value){this.#show__accessor_storage=value}get open(){return this.$.dialog.open}set open(_value){assertNotReached("Cannot set |open|.")}toggle(){if(this.open){this.cancel()}else{this.openDrawer()}}async openDrawer(){if(this.open){return}this.$.dialog.showModal();this.show_=true;await this.updateComplete;this.fire("cr-drawer-opening");listenOnce(this.$.dialog,"transitionend",(()=>{this.fire("cr-drawer-opened")}))}dismiss_(cancel){if(!this.open){return}this.show_=false;listenOnce(this.$.dialog,"transitionend",(()=>{this.$.dialog.close(cancel?"canceled":"closed")}))}cancel(){this.dismiss_(true)}close(){this.dismiss_(false)}wasCanceled(){return!this.open&&this.$.dialog.returnValue==="canceled"}onContainerClick_(event){event.stopPropagation()}onDialogClick_(){this.cancel()}onDialogCancel_(event){event.preventDefault();this.cancel()}onDialogClose_(){this.fire("close")}}customElements.define(CrDrawerElement.is,CrDrawerElement);let instance$d=null;function getCss$3(){return instance$d||(instance$d=[...[],css`.spinner{--cr-spinner-size:28px;mask-image:url(//resources/images/throbber_small.svg);mask-position:center;mask-repeat:no-repeat;mask-size:var(--cr-spinner-size) var(--cr-spinner-size);background-color:var(--cr-spinner-color,var(--google-blue-500));height:var(--cr-spinner-size);width:var(--cr-spinner-size)}@media (prefers-color-scheme:dark){.spinner{background-color:var(--cr-spinner-color,var(--google-blue-300))}}`])}let instance$c=null;function getCss$2(){return instance$c||(instance$c=[...[getCss$5(),getCss$6(),getCss$3()],css`:host{display:block;height:40px;isolation:isolate;transition:background-color 150ms cubic-bezier(0.4,0,0.2,1),width 150ms cubic-bezier(0.4,0,0.2,1);width:44px}:host([disabled]){opacity:var(--cr-disabled-opacity)}[hidden]{display:none !important}@media (prefers-color-scheme:light){cr-icon-button{--cr-icon-button-fill-color:var(--cr-toolbar-search-field-input-icon-color,var(--google-grey-700));--cr-icon-button-focus-outline-color:var(--cr-toolbar-icon-button-focus-outline-color,var(--cr-focus-outline-color))}}@media (prefers-color-scheme:dark){cr-icon-button{--cr-icon-button-fill-color:var(--cr-toolbar-search-field-input-icon-color,var(--google-grey-500))}}cr-icon-button{--cr-icon-button-fill-color:var(--cr-toolbar-search-field-icon-color,var(--color-toolbar-search-field-icon,var(--cr-secondary-text-color)));--cr-icon-button-size:var(--cr-toolbar-icon-container-size,28px);--cr-icon-button-icon-size:20px;margin:var(--cr-toolbar-icon-margin,0)}#icon{transition:margin 150ms,opacity 200ms}#prompt{color:var(--cr-toolbar-search-field-prompt-color,var(--color-toolbar-search-field-foreground-placeholder,var(--cr-secondary-text-color)));opacity:0}@media (prefers-color-scheme:dark){#prompt{color:var(--cr-toolbar-search-field-prompt-color,white)}}@media (prefers-color-scheme:dark){#prompt{--cr-toolbar-search-field-prompt-opacity:1;color:var(--cr-secondary-text-color,white)}}.spinner{--cr-spinner-color:var(--cr-toolbar-search-field-input-icon-color,var(--google-grey-700));--cr-spinner-size:var(--cr-icon-size);margin:0;opacity:1;padding:2px;position:absolute}@media (prefers-color-scheme:dark){.spinner{--cr-spinner-color:var(--cr-toolbar-search-field-input-icon-color,white)}}#prompt{transition:opacity 200ms}#searchTerm{-webkit-font-smoothing:antialiased;flex:1;font-size:12px;font-weight:500;line-height:185%;margin:var(--cr-toolbar-search-field-term-margin,0);position:relative}label{bottom:0;cursor:var(--cr-toolbar-search-field-cursor,text);left:0;overflow:hidden;position:absolute;right:0;top:0;white-space:nowrap}:host([has-search-text]) label{visibility:hidden}input{-webkit-appearance:none;background:transparent;border:none;caret-color:var(--cr-toolbar-search-field-input-caret-color,currentColor);color:var(--cr-toolbar-search-field-input-text-color,var(--color-toolbar-search-field-foreground,var(--cr-fallback-color-on-surface)));font:inherit;font-size:12px;font-weight:500;outline:none;padding:0;position:relative;width:100%}@media (prefers-color-scheme:dark){input{color:var(--cr-toolbar-search-field-input-text-color,white)}}input[type='search']::-webkit-search-cancel-button{display:none}:host([narrow]){border-radius:var(--cr-toolbar-search-field-border-radius,0)}:host(:not([narrow])){background:none;border-radius:var(--cr-toolbar-search-field-border-radius,46px);cursor:var(--cr-toolbar-search-field-cursor,default);height:36px;max-width:var(--cr-toolbar-field-max-width,none);overflow:hidden;padding:0 6px;position:relative;width:var(--cr-toolbar-field-width,680px);--cr-toolbar-search-field-border-radius:100px}@media (prefers-color-scheme:dark){:host(:not([narrow])){background:var(--cr-toolbar-search-field-background,rgba(0,0,0,0.22))}}#background,#stateBackground{display:none}:host(:not([narrow])) #background{background:var(--cr-toolbar-search-field-background,var(--color-toolbar-search-field-background,var(--cr-fallback-color-base-container)));border-radius:inherit;display:block;inset:0;pointer-events:none;position:absolute;z-index:0}:host([search-focused_]:not([narrow])){outline:2px solid var(--cr-focus-outline-color);outline-offset:2px}:host(:not([narrow])) #stateBackground{display:block;inset:0;pointer-events:none;position:absolute}:host(:hover:not([search-focused_],[narrow])) #stateBackground{background:var(--color-toolbar-search-field-background-hover,var(--cr-hover-background-color));z-index:1}:host(:not([narrow]):not([showing-search])) #icon{opacity:var(--cr-toolbar-search-field-icon-opacity,1)}:host(:not([narrow])) #prompt{opacity:var(--cr-toolbar-search-field-prompt-opacity,1)}:host([narrow]) #prompt{opacity:var(--cr-toolbar-search-field-narrow-mode-prompt-opacity,0)}:host([narrow]:not([showing-search])) #searchTerm{display:none}:host([showing-search][spinner-active]) #icon{opacity:0}:host([narrow][showing-search]){width:100%}:host([narrow][showing-search]) #icon,:host([narrow][showing-search]) .spinner{margin-inline-start:var(--cr-toolbar-search-icon-margin-inline-start,18px)}#content{align-items:center;display:flex;height:100%;position:relative;z-index:2}`])}function getHtml$3(){return html`
<div id="background"></div>
<div id="stateBackground"></div>
<div id="content">
  ${this.shouldShowSpinner_()?html`
    <div class="spinner"></div>`:""}
    <cr-icon-button id="icon" iron-icon="${this.iconOverride||"cr:search"}"
        title="${this.label}" tabindex="${this.getIconTabIndex_()}"
        aria-hidden="${this.getIconAriaHidden_()}" suppress-rtl-flip
        @click="${this.onSearchIconClicked_}" ?disabled="${this.disabled}">
  </cr-icon-button>
  <div id="searchTerm">
    <label id="prompt" for="searchInput" aria-hidden="true">
      ${this.label}
    </label>
    <input id="searchInput"
        aria-labelledby="prompt"
        aria-description="${this.inputAriaDescription}"
        autocapitalize="off"
        autocomplete="off"
        type="search"
        @beforeinput="${this.onSearchTermNativeBeforeInput}"
        @input="${this.onSearchTermNativeInput}"
        @search="${this.onSearchTermSearch}"
        @keydown="${this.onSearchTermKeydown_}"
        @focus="${this.onInputFocus_}"
        @blur="${this.onInputBlur_}"
        ?autofocus="${this.autofocus}"
        spellcheck="false"
        ?disabled="${this.disabled}">
  </div>
  ${this.hasSearchText?html`
    <cr-icon-button id="clearSearch" iron-icon="cr:cancel"
        title="${this.clearLabel}" @click="${this.clearSearch_}"
        ?disabled="${this.disabled}"></cr-icon-button>`:""}
</div>`}const CrToolbarSearchFieldElementBase=CrSearchFieldMixinLit(CrLitElement);class CrToolbarSearchFieldElement extends CrToolbarSearchFieldElementBase{static get is(){return"cr-toolbar-search-field"}static get styles(){return getCss$2()}render(){return getHtml$3.bind(this)()}static get properties(){return{narrow:{type:Boolean,reflect:true},showingSearch:{type:Boolean,notify:true,reflect:true},disabled:{type:Boolean,reflect:true},autofocus:{type:Boolean,reflect:true},spinnerActive:{type:Boolean,reflect:true},searchFocused_:{type:Boolean,reflect:true},iconOverride:{type:String},inputAriaDescription:{type:String}}}#narrow_accessor_storage=false;get narrow(){return this.#narrow_accessor_storage}set narrow(value){this.#narrow_accessor_storage=value}#showingSearch_accessor_storage=false;get showingSearch(){return this.#showingSearch_accessor_storage}set showingSearch(value){this.#showingSearch_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}#spinnerActive_accessor_storage=false;get spinnerActive(){return this.#spinnerActive_accessor_storage}set spinnerActive(value){this.#spinnerActive_accessor_storage=value}#searchFocused__accessor_storage=false;get searchFocused_(){return this.#searchFocused__accessor_storage}set searchFocused_(value){this.#searchFocused__accessor_storage=value}#iconOverride_accessor_storage;get iconOverride(){return this.#iconOverride_accessor_storage}set iconOverride(value){this.#iconOverride_accessor_storage=value}#inputAriaDescription_accessor_storage="";get inputAriaDescription(){return this.#inputAriaDescription_accessor_storage}set inputAriaDescription(value){this.#inputAriaDescription_accessor_storage=value}firstUpdated(){this.addEventListener("click",(e=>this.showSearch_(e)))}getSearchInput(){return this.$.searchInput}isSearchFocused(){return this.searchFocused_}async showAndFocus(){this.showingSearch=true;await this.updateComplete;this.focus_()}onSearchTermNativeBeforeInput(e){this.fire("search-term-native-before-input",{e:e})}onSearchTermInput(){super.onSearchTermInput();this.showingSearch=this.hasSearchText||this.isSearchFocused()}onSearchTermNativeInput(e){this.onSearchTermInput();this.fire("search-term-native-input",{e:e,inputValue:this.getValue()})}getIconTabIndex_(){return this.narrow&&!this.hasSearchText?0:-1}getIconAriaHidden_(){return Boolean(!this.narrow||this.hasSearchText).toString()}shouldShowSpinner_(){return this.spinnerActive&&this.showingSearch}onSearchIconClicked_(){this.fire("search-icon-clicked")}focus_(){this.getSearchInput().focus()}onInputFocus_(){this.searchFocused_=true}onInputBlur_(){this.searchFocused_=false;if(!this.hasSearchText){this.showingSearch=false}}onSearchTermKeydown_(e){if(e.key==="Escape"){this.showingSearch=false;this.setValue("");this.getSearchInput().blur()}}async showSearch_(e){if(e.target!==this.shadowRoot.querySelector("#clearSearch")){this.showingSearch=true}if(this.narrow){await this.updateComplete;this.focus_()}}clearSearch_(){this.setValue("");this.focus_();this.spinnerActive=false;this.fire("search-term-cleared")}}customElements.define(CrToolbarSearchFieldElement.is,CrToolbarSearchFieldElement);let instance$b=null;function getCss$1(){return instance$b||(instance$b=[...[getCss$7(),getCss$6()],css`:host{align-items:center;box-sizing:border-box;color:var(--google-grey-900);display:flex;height:var(--cr-toolbar-height)}@media (prefers-color-scheme:dark){:host{color:var(--cr-secondary-text-color)}}h1{flex:1;font-size:170%;font-weight:var(--cr-toolbar-header-font-weight,500);letter-spacing:.25px;line-height:normal;margin-inline-start:6px;padding-inline-end:12px;white-space:var(--cr-toolbar-header-white-space,normal)}@media (prefers-color-scheme:dark){h1{color:var(--cr-primary-text-color)}}#leftContent{position:relative;transition:opacity 100ms}#leftSpacer{align-items:center;box-sizing:border-box;display:flex;padding-inline-start:calc(12px + 6px);width:var(--cr-toolbar-left-spacer-width,auto)}cr-icon-button{--cr-icon-button-size:32px;min-width:32px}@media (prefers-color-scheme:light){cr-icon-button{--cr-icon-button-fill-color:currentColor;--cr-icon-button-focus-outline-color:var(--cr-focus-outline-color)}}#centeredContent{display:flex;flex:1 1 0;justify-content:center}#rightSpacer{padding-inline-end:12px}:host([narrow]) #centeredContent{justify-content:flex-end}:host([has-overlay]){transition:visibility var(--cr-toolbar-overlay-animation-duration);visibility:hidden}:host([narrow][showing-search_]) #leftContent{opacity:0;position:absolute}:host(:not([narrow])) #leftContent{flex:1 1 var(--cr-toolbar-field-margin,0)}:host(:not([narrow])) #centeredContent{flex-basis:var(--cr-toolbar-center-basis,0)}:host(:not([narrow])[disable-right-content-grow]) #centeredContent{justify-content:start;padding-inline-start:12px}:host(:not([narrow])) #rightContent{flex:1 1 0;text-align:end}:host(:not([narrow])[disable-right-content-grow]) #rightContent{flex:0 1 0}picture{display:none}#menuButton{margin-inline-end:9px}#menuButton~h1{margin-inline-start:0}:host([always-show-logo]) picture,:host(:not([narrow])) picture{display:initial;margin-inline-end:16px}:host([always-show-logo]) #leftSpacer,:host(:not([narrow])) #leftSpacer{padding-inline-start:calc(12px + 9px)}:host([always-show-logo]) :is(picture,#product-logo),:host(:not([narrow])) :is(picture,#product-logo){height:24px;width:24px}`])}function getHtml$2(){return html`
<div id="leftContent">
  <div id="leftSpacer">
    ${this.showMenu?html`
      <cr-icon-button id="menuButton" class="no-overlap"
          iron-icon="cr20:menu" @click="${this.onMenuClick_}"
          aria-label="${this.menuLabel||nothing}"
          title="${this.menuLabel}">
      </cr-icon-button>`:""}
    <slot name="product-logo">
      <picture>
        <source media="(prefers-color-scheme: dark)"
            srcset="//resources/images/chrome_logo_dark.svg">
        <img id="product-logo"
            srcset="chrome://theme/current-channel-logo@1x 1x,
                    chrome://theme/current-channel-logo@2x 2x"
            role="presentation">
      </picture>
    </slot>
    <h1>${this.pageName}</h1>
  </div>
</div>

<div id="centeredContent" ?hidden="${!this.showSearch}">
  <cr-toolbar-search-field id="search" ?narrow="${this.narrow}"
      label="${this.searchPrompt}" clear-label="${this.clearLabel}"
      ?spinner-active="${this.spinnerActive}"
      ?showing-search="${this.showingSearch_}"
      @showing-search-changed="${this.onShowingSearchChanged_}"
      ?autofocus="${this.autofocus}" icon-override="${this.searchIconOverride}"
      input-aria-description="${this.searchInputAriaDescription}">
  </cr-toolbar-search-field>
</div>

<div id="rightContent">
  <div id="rightSpacer">
    <slot></slot>
  </div>
</div>`}class CrToolbarElement extends CrLitElement{static get is(){return"cr-toolbar"}static get styles(){return getCss$1()}render(){return getHtml$2.bind(this)()}static get properties(){return{pageName:{type:String},searchPrompt:{type:String},clearLabel:{type:String},menuLabel:{type:String},spinnerActive:{type:Boolean},showMenu:{type:Boolean},showSearch:{type:Boolean},autofocus:{type:Boolean,reflect:true},narrow:{type:Boolean,reflect:true,notify:true},narrowThreshold:{type:Number},alwaysShowLogo:{type:Boolean,reflect:true},showingSearch_:{type:Boolean,reflect:true},searchIconOverride:{type:String},searchInputAriaDescription:{type:String}}}#pageName_accessor_storage="";get pageName(){return this.#pageName_accessor_storage}set pageName(value){this.#pageName_accessor_storage=value}#searchPrompt_accessor_storage="";get searchPrompt(){return this.#searchPrompt_accessor_storage}set searchPrompt(value){this.#searchPrompt_accessor_storage=value}#clearLabel_accessor_storage="";get clearLabel(){return this.#clearLabel_accessor_storage}set clearLabel(value){this.#clearLabel_accessor_storage=value}#menuLabel_accessor_storage;get menuLabel(){return this.#menuLabel_accessor_storage}set menuLabel(value){this.#menuLabel_accessor_storage=value}#spinnerActive_accessor_storage=false;get spinnerActive(){return this.#spinnerActive_accessor_storage}set spinnerActive(value){this.#spinnerActive_accessor_storage=value}#showMenu_accessor_storage=false;get showMenu(){return this.#showMenu_accessor_storage}set showMenu(value){this.#showMenu_accessor_storage=value}#showSearch_accessor_storage=true;get showSearch(){return this.#showSearch_accessor_storage}set showSearch(value){this.#showSearch_accessor_storage=value}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}#narrow_accessor_storage=false;get narrow(){return this.#narrow_accessor_storage}set narrow(value){this.#narrow_accessor_storage=value}#narrowThreshold_accessor_storage=900;get narrowThreshold(){return this.#narrowThreshold_accessor_storage}set narrowThreshold(value){this.#narrowThreshold_accessor_storage=value}#alwaysShowLogo_accessor_storage=false;get alwaysShowLogo(){return this.#alwaysShowLogo_accessor_storage}set alwaysShowLogo(value){this.#alwaysShowLogo_accessor_storage=value}#showingSearch__accessor_storage=false;get showingSearch_(){return this.#showingSearch__accessor_storage}set showingSearch_(value){this.#showingSearch__accessor_storage=value}#searchIconOverride_accessor_storage;get searchIconOverride(){return this.#searchIconOverride_accessor_storage}set searchIconOverride(value){this.#searchIconOverride_accessor_storage=value}#searchInputAriaDescription_accessor_storage="";get searchInputAriaDescription(){return this.#searchInputAriaDescription_accessor_storage}set searchInputAriaDescription(value){this.#searchInputAriaDescription_accessor_storage=value}narrowQuery_=null;willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("narrowThreshold")){this.narrowQuery_=window.matchMedia(`(max-width: ${this.narrowThreshold}px)`);this.narrow=this.narrowQuery_.matches;this.narrowQuery_.addListener((()=>this.onQueryChanged_()))}}getSearchField(){return this.$.search}onMenuClick_(){this.fire("cr-toolbar-menu-click")}async focusMenuButton(){assert(this.showMenu);await this.updateComplete;const menuButton=this.shadowRoot.querySelector("#menuButton");assert(!!menuButton);menuButton.focus()}isMenuFocused(){return!!this.shadowRoot.activeElement&&this.shadowRoot.activeElement.id==="menuButton"}onShowingSearchChanged_(e){this.showingSearch_=e.detail.value}onQueryChanged_(){assert(this.narrowQuery_);this.narrow=this.narrowQuery_.matches}}customElements.define(CrToolbarElement.is,CrToolbarElement);const styleMod$1=document.createElement("dom-module");styleMod$1.appendChild(html$1`
  <template>
    <style>
:host{color:var(--cr-primary-text-color);line-height:154%;overflow:hidden;user-select:text}
    </style>
  </template>
`.content);styleMod$1.register("cr-page-host-style");const WebUiListenerMixinLit=superClass=>{class WebUiListenerMixinLit extends superClass{webUiListeners_=[];addWebUiListener(eventName,callback){this.webUiListeners_.push(addWebUiListener(eventName,callback))}disconnectedCallback(){super.disconnectedCallback();while(this.webUiListeners_.length>0){removeWebUiListener(this.webUiListeners_.pop())}}}return WebUiListenerMixinLit};let instance$a=null;function getCss(){return instance$a||(instance$a=[...[],css`:host{align-items:center;border-top:1px solid var(--cr-separator-color);color:var(--cr-secondary-text-color);display:none;font-size:0.8125rem;justify-content:center;padding:0 24px}:host([is-managed_]){display:flex}a[href]{color:var(--cr-link-color)}cr-icon{align-self:flex-start;flex-shrink:0;height:20px;padding-inline-end:var(--managed-footnote-icon-padding,8px);width:20px}`])}function getHtml$1(){return html`${this.isManaged_?html`
  <cr-icon .icon="${this.managedByIcon_}"></cr-icon>
  <div id="content" .innerHTML="${this.getManagementString_()}"></div>
`:""}`}const ManagedFootnoteElementBase=I18nMixinLit(WebUiListenerMixinLit(CrLitElement));class ManagedFootnoteElement extends ManagedFootnoteElementBase{static get is(){return"managed-footnote"}static get styles(){return getCss()}render(){return getHtml$1.bind(this)()}static get properties(){return{isManaged_:{reflect:true,type:Boolean},managedByIcon_:{reflect:true,type:String}}}#isManaged__accessor_storage=loadTimeData.getBoolean("isManaged");get isManaged_(){return this.#isManaged__accessor_storage}set isManaged_(value){this.#isManaged__accessor_storage=value}#managedByIcon__accessor_storage=loadTimeData.getString("managedByIcon");get managedByIcon_(){return this.#managedByIcon__accessor_storage}set managedByIcon_(value){this.#managedByIcon__accessor_storage=value}firstUpdated(){this.addWebUiListener("is-managed-changed",(managed=>{loadTimeData.overrideValues({isManaged:managed});this.isManaged_=managed}))}getManagementString_(){return this.i18nAdvanced("browserManagedByOrg")}}customElements.define(ManagedFootnoteElement.is,ManagedFootnoteElement);chrome.send("observeManagedUI");function getTemplate$J(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{--about-page-image-space:10px}.info-sections{padding:var(--cr-section-vertical-padding) var(--cr-section-padding)}.info-section{margin-bottom:12px}.product-title{font-size:153.85%;font-weight:400;margin-bottom:auto;margin-top:auto}#product-logo{margin-inline-end:var(--about-page-image-space)}.icon-container{margin-inline-end:var(--about-page-image-space);min-width:32px;text-align:center}cr-icon[icon='cr:check-circle']{fill:var(--cr-checked-color)}cr-icon[icon='cr:error']{fill:var(--settings-error-color)}#throbber{height:var(--cr-icon-size);vertical-align:middle}cr-button{white-space:nowrap}
    </style>
    <settings-section page-title="$i18n{aboutPageTitle}">
      <div class="cr-row two-line first">
        <img id="product-logo" on-click="onProductLogoClick_"
            srcset="chrome://theme/current-channel-logo@1x 1x,
                    chrome://theme/current-channel-logo@2x 2x"
            alt="$i18n{aboutProductLogoAlt}"
            role="presentation">
        <div class="product-title">$i18n{aboutProductTitle}</div>
      </div>
      <div class="cr-row two-line">
        <!-- Set the icon from the iconset (when it's obsolete/EOL and
          when update is done) or set the src (when it's updating). -->

        <div class="icon-container"
            hidden="[[!shouldShowIcons_(showUpdateStatus_)]]">
          <cr-icon
              hidden="[[shouldShowThrobber_(
                  obsoleteSystemInfo_, currentUpdateStatusEvent_)]]"
              icon$="[[getUpdateStatusIcon_(
                  obsoleteSystemInfo_, currentUpdateStatusEvent_)]]">
          </cr-icon>
          <img id="throbber" src="chrome://resources/images/throbber_small.svg"
              hidden="[[!shouldShowThrobber_(
                  obsoleteSystemInfo_, currentUpdateStatusEvent_)]]">
        </div>

        <div class="flex cr-padded-text">

          <div id="updateStatusMessage" hidden="[[!showUpdateStatus_]]">
            <div role="alert" aria-live="polite"
                inner-h-t-m-l="[[getUpdateStatusMessage_(
                    currentUpdateStatusEvent_)]]">
            </div>
            <a hidden$="[[!shouldShowLearnMoreLink_(
                currentUpdateStatusEvent_)]]" target="_blank"
                href="https://support.google.com/chrome?p=update_error"
                aria-label="$i18nPolymer{aboutLearnMoreUpdatingErrors}">
              $i18n{learnMore}
            </a>
          </div>
          <span id="deprecationWarning"
              hidden="[[!obsoleteSystemInfo_.obsolete]]">
            $i18n{aboutObsoleteSystem}
            <a href="$i18n{aboutObsoleteSystemURL}" target="_blank"
                aria-label="$i18nPolymer{aboutLearnMoreSystemRequirements}">
              $i18n{learnMore}
            </a>
          </span>

          <div class="secondary">$i18n{aboutBrowserVersion}</div>
        </div>

        <div class="separator" hidden="[[!showButtonContainer_]]"></div>
        <span id="buttonContainer" hidden="[[!showButtonContainer_]]">
          <cr-button id="relaunch" hidden="[[!showRelaunch_]]"
              on-click="onRelaunchClick_">
            $i18n{aboutRelaunch}
          </cr-button>
        </span>

      </div>

      <cr-link-row class="hr" id="help" on-click="onHelpClick_"
          label="$i18n{aboutGetHelpUsingChrome}"
          external></cr-link-row>

      <cr-link-row class="hr" on-click="onManagementPageClick_"
          start-icon="[[managedByIcon_]]" label="$i18n{managementPage}"
          role-description="$i18n{subpageArrowRoleDescription}"
          hidden$="[[!isManaged_]]"></cr-link-row>
    </settings-section>

    <settings-section>
      <div class="info-sections">
        <div class="info-section">
          <div class="secondary">$i18n{aboutProductTitle}</div>
          <div class="secondary">$i18n{aboutProductCopyright}</div>
        </div>

        <div class="info-section">
          <div class="secondary">$i18nRaw{aboutProductLicense}</div>
        </div>


  <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
    <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RELAUNCH]]"
        on-close="onRelaunchDialogClose"></relaunch-confirmation-dialog>
  </template>

      </div>
    </settings-section>
<!--_html_template_end_-->`}var UpdateStatus;(function(UpdateStatus){UpdateStatus["CHECKING"]="checking";UpdateStatus["UPDATING"]="updating";UpdateStatus["NEARLY_UPDATED"]="nearly_updated";UpdateStatus["UPDATED"]="updated";UpdateStatus["FAILED"]="failed";UpdateStatus["FAILED_HTTP"]="failed_http";UpdateStatus["FAILED_DOWNLOAD"]="failed_download";UpdateStatus["DISABLED"]="disabled";UpdateStatus["DISABLED_BY_ADMIN"]="disabled_by_admin";UpdateStatus["NEED_PERMISSION_TO_UPDATE"]="need_permission_to_update"})(UpdateStatus||(UpdateStatus={}));class AboutPageBrowserProxyImpl{pageReady(){chrome.send("aboutPageReady")}refreshUpdateStatus(){chrome.send("refreshUpdateStatus")}openHelpPage(){chrome.send("openHelpPage")}static getInstance(){return instance$9||(instance$9=new AboutPageBrowserProxyImpl)}static setInstance(obj){instance$9=obj}}let instance$9=null;const SettingsAboutPageElementBase=RelaunchMixin(WebUiListenerMixin(I18nMixin(PolymerElement)));class SettingsAboutPageElement extends SettingsAboutPageElementBase{static get is(){return"settings-about-page"}static get template(){return getTemplate$J()}static get properties(){return{currentUpdateStatusEvent_:{type:Object,value:{message:"",progress:0,rollback:false,status:UpdateStatus.DISABLED}},isManaged_:{type:Boolean,value(){return loadTimeData.getBoolean("isManaged")}},managedByIcon_:{type:String,value(){return loadTimeData.getString("managedByIcon")}},obsoleteSystemInfo_:{type:Object,value(){return{obsolete:loadTimeData.getBoolean("aboutObsoleteNowOrSoon"),endOfLine:loadTimeData.getBoolean("aboutObsoleteEndOfTheLine")}}},showUpdateStatus_:{type:Boolean,value:false},showButtonContainer_:Boolean,showRelaunch_:{type:Boolean,value:false}}}static get observers(){return["updateShowUpdateStatus_("+"obsoleteSystemInfo_, currentUpdateStatusEvent_)","updateShowRelaunch_(currentUpdateStatusEvent_)","updateShowButtonContainer_(showRelaunch_)"]}aboutBrowserProxy_=AboutPageBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.aboutBrowserProxy_.pageReady();this.startListening_()}getPromoteUpdaterClass_(){return""}startListening_(){this.addWebUiListener("update-status-changed",this.onUpdateStatusChanged_.bind(this));this.aboutBrowserProxy_.refreshUpdateStatus()}onUpdateStatusChanged_(event){this.currentUpdateStatusEvent_=event}onLearnMoreClick_(event){event.stopPropagation()}onHelpClick_(){this.aboutBrowserProxy_.openHelpPage()}onRelaunchClick_(){this.performRestart(RestartType.RELAUNCH)}updateShowUpdateStatus_(){if(this.obsoleteSystemInfo_.endOfLine){this.showUpdateStatus_=false;return}this.showUpdateStatus_=this.currentUpdateStatusEvent_.status!==UpdateStatus.DISABLED}updateShowButtonContainer_(){this.showButtonContainer_=this.showRelaunch_}updateShowRelaunch_(){this.showRelaunch_=this.checkStatus_(UpdateStatus.NEARLY_UPDATED)}shouldShowLearnMoreLink_(){return this.currentUpdateStatusEvent_.status===UpdateStatus.FAILED}getUpdateStatusMessage_(){switch(this.currentUpdateStatusEvent_.status){case UpdateStatus.CHECKING:case UpdateStatus.NEED_PERMISSION_TO_UPDATE:return this.i18nAdvanced("aboutUpgradeCheckStarted");case UpdateStatus.NEARLY_UPDATED:return this.i18nAdvanced("aboutUpgradeRelaunch");case UpdateStatus.UPDATED:return this.i18nAdvanced("aboutUpgradeUpToDate");case UpdateStatus.UPDATING:assert(typeof this.currentUpdateStatusEvent_.progress==="number");const progressPercent=this.currentUpdateStatusEvent_.progress+"%";if(this.currentUpdateStatusEvent_.progress>0){return this.i18nAdvanced("aboutUpgradeUpdatingPercent",{substitutions:[progressPercent]})}return this.i18nAdvanced("aboutUpgradeUpdating");default:let result="";const message=this.currentUpdateStatusEvent_.message;if(message){result+=message}const connectMessage=this.currentUpdateStatusEvent_.connectionTypes;if(connectMessage){result+=`<div>${connectMessage}</div>`}return sanitizeInnerHtml(result,{tags:["br","pre"]})}}getUpdateStatusIcon_(){if(this.obsoleteSystemInfo_.endOfLine){return"cr:error"}switch(this.currentUpdateStatusEvent_.status){case UpdateStatus.DISABLED_BY_ADMIN:return"cr20:domain";case UpdateStatus.FAILED:return"cr:error";case UpdateStatus.UPDATED:case UpdateStatus.NEARLY_UPDATED:return"cr:check-circle";default:return""}}shouldShowThrobber_(){if(this.obsoleteSystemInfo_.endOfLine){return false}switch(this.currentUpdateStatusEvent_.status){case UpdateStatus.CHECKING:case UpdateStatus.UPDATING:return true;default:return false}}checkStatus_(status){return this.currentUpdateStatusEvent_.status===status}onManagementPageClick_(){window.location.href=loadTimeData.getString("managementPageUrl")}onProductLogoClick_(){this.$["product-logo"].animate({transform:["none","rotate(-10turn)"]},{duration:500,easing:"cubic-bezier(1, 0, 0, 1)"})}shouldShowIcons_(){if(this.obsoleteSystemInfo_.endOfLine){return true}return this.showUpdateStatus_}searchContents(query){return Promise.resolve({canceled:false,matchCount:0,wasClearSearch:query===""})}}customElements.define(SettingsAboutPageElement.is,SettingsAboutPageElement);function getTemplate$I(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared settings-columned-section">:host{--cr-icon-size:16px;--info-card-background-color:var(--google-blue-50)}@media (prefers-color-scheme:dark){:host{--info-card-background-color:var(--google-grey-800)}}.settings-columned-section{background-color:var(--info-card-background-color)}.title{color:var(--cr-primary-text-color);font-size:1rem;font-weight:500;letter-spacing:.25px}.settings-columned-section h3.description-header{color:var(--cr-primary-text-color);font-weight:500}.icon-bulleted-list li{margin:8px 0}settings-section{--cr-card-shadow:none}@media (forced-colors:active){settings-section{--cr-border-hcm:none}}</style>

<settings-section>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="title first">$i18n{aiPageMainTitle}</h2>
    <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiPageMainSublabel1}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiPageMainSublabel2}</div>
      </li>
      <li>
        <cr-icon icon="[[icon3_]]" aria-hidden="true"></cr-icon>
        <div class="secondary">
        <template is="dom-if" if="[[!isManaged_()]]" restamp>
          $i18n{aiPageMainSublabel3}
        </template>
        <template is="dom-if" if="[[isManaged_()]]" restamp>
          $i18n{aiPageMainManagedSublabel3}
          <a href="$i18n{aiPageMainManagedLearnMoreUrl}"
              aria-label="$i18n{aiPageMainManagedLearnMoreAccessibiltyLabel}"
              aria-description="$i18n{opensInNewTab}"
              target="_blank">
            $i18n{learnMore}
          </a>
        </template>
        </div>
      </li>
    </ul>
  </div>
</div>
</settings-section>
<!--_html_template_end_-->`}class SettingsAiInfoCardElement extends PolymerElement{static get is(){return"settings-ai-info-card"}static get template(){return getTemplate$I()}static get properties(){return{icon3_:{type:String,computed:"computeIcon3_()"}}}isManaged_(){return loadTimeData.getBoolean("isManaged")}computeIcon3_(){return this.isManaged_()?loadTimeData.getString("managedByIcon"):"settings20:account-box"}}customElements.define(SettingsAiInfoCardElement.is,SettingsAiInfoCardElement);function getTemplate$H(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared"></style>

<!-- TODO(crbug.com/362225975): Remove V2 suffixes. -->
<settings-section page-title="$i18n{aiInnovationsPageTitle}">
  <div>
    <cr-link-row id="passwordChangeRowV2" class="hr"
        hidden="[[!showPasswordChangeControl_]]"
        start-icon="cr20:password"
        label="$i18n{passwordChangeSettingLabel}"
        sub-label="$i18n{passwordChangeSettingSubLabel}"
        on-click="onPasswordChangeRowClick_" external>
    </cr-link-row>
    <cr-link-row id="historySearchRowV2" class="hr"
        hidden="[[!showHistorySearchControl_]]"
        start-icon="settings20:search-spark"
        label="$i18n{historySearchSettingLabel}"
        sub-label="[[getHistorySearchSublabel_(
          prefs.optimization_guide.history_search_setting_state.value)]]"
        role-description="$i18n{subpageArrowRoleDescription}"
        on-click="onHistorySearchRowClick_">
    </cr-link-row>
    <cr-link-row id="compareRowV2" class="hr"
        hidden="[[!showCompareControl_]]"
        start-icon="settings20:table-chart-organize"
        label="$i18n{aiCompareLabel}"
        sub-label="$i18n{aiCompareSublabel}"
        role-description="$i18n{subpageArrowRoleDescription}"
        on-click="onCompareRowClick_">
    </cr-link-row>
    <cr-link-row id="composeRowV2" class="hr"
        hidden="[[!showComposeControl_]]"
        start-icon="settings20:pen-spark"
        label="$i18n{aiComposeLabel}"
        sub-label="$i18n{aiComposeSublabelV2}"
        role-description="$i18n{subpageArrowRoleDescription}"
        on-click="onComposeRowClick_">
    </cr-link-row>
    <cr-link-row id="tabOrganizationRowV2" class="hr"
        hidden="[[!showTabOrganizationControl_]]"
        start-icon="settings20:auto-tab-group"
        label="$i18n{tabOrganizationSettingLabel}"
        sub-label="$i18n{tabOrganizationSettingSublabelV2}"
        role-description="$i18n{subpageArrowRoleDescription}"
        on-click="onTabOrganizationRowClick_">
    </cr-link-row>
  </div>
</settings-section>
<!--_html_template_end_-->`}const SettingsAiPageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsAiPageElement extends SettingsAiPageElementBase{static get is(){return"settings-ai-page"}static get template(){return getTemplate$H()}static get properties(){return{showComposeControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showComposeControl")},showCompareControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showCompareControl")},showHistorySearchControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showHistorySearchControl")},showTabOrganizationControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showTabOrganizationControl")},showPasswordChangeControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showPasswordChangeControl")}}}shouldRecordMetrics_=true;metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.maybeLogVisibilityMetrics_()}maybeLogVisibilityMetrics_(){if(!this.shouldRecordMetrics_||Router.getInstance().getCurrentRoute()!==routes.AI){return}this.shouldRecordMetrics_=false;this.metricsBrowserProxy_.recordBooleanHistogram("Settings.AiPage.ElementVisibility.HistorySearch",this.showHistorySearchControl_);this.metricsBrowserProxy_.recordBooleanHistogram("Settings.AiPage.ElementVisibility.Compare",this.showCompareControl_);this.metricsBrowserProxy_.recordBooleanHistogram("Settings.AiPage.ElementVisibility.Compose",this.showComposeControl_);this.metricsBrowserProxy_.recordBooleanHistogram("Settings.AiPage.ElementVisibility.TabOrganization",this.showTabOrganizationControl_);this.metricsBrowserProxy_.recordBooleanHistogram("Settings.AiPage.ElementVisibility.PasswordChange",this.showPasswordChangeControl_)}onHistorySearchRowClick_(){this.recordInteractionMetrics_(AiPageInteractions.HISTORY_SEARCH_CLICK,"Settings.AiPage.HistorySearchEntryPointClick");const router=Router.getInstance();router.navigateTo(router.getRoutes().HISTORY_SEARCH)}onCompareRowClick_(){this.recordInteractionMetrics_(AiPageInteractions.COMPARE_CLICK,"Settings.AiPage.CompareEntryPointClick");const router=Router.getInstance();router.navigateTo(router.getRoutes().COMPARE)}onComposeRowClick_(){this.recordInteractionMetrics_(AiPageInteractions.COMPOSE_CLICK,"Settings.AiPage.ComposeEntryPointClick");const router=Router.getInstance();router.navigateTo(router.getRoutes().OFFER_WRITING_HELP)}onTabOrganizationRowClick_(){this.recordInteractionMetrics_(AiPageInteractions.TAB_ORGANIZATION_CLICK,"Settings.AiPage.TabOrganizationEntryPointClick");const router=Router.getInstance();router.navigateTo(router.getRoutes().AI_TAB_ORGANIZATION)}onPasswordChangeRowClick_(){this.recordInteractionMetrics_(AiPageInteractions.PASSWORD_CHANGE_CLICK,"Settings.AiPage.PasswordChangeEntryPointClick");OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("passwordChangeSettingsUrl"))}recordInteractionMetrics_(interaction,action){this.metricsBrowserProxy_.recordAiPageInteractions(interaction);this.metricsBrowserProxy_.recordAction(action)}getHistorySearchSublabel_(){const isAnswersEnabled=loadTimeData.getBoolean("historyEmbeddingsAnswersFeatureEnabled");if(this.getPref(SettingsAiPageFeaturePrefName.HISTORY_SEARCH).value===FeatureOptInState.ENABLED){return isAnswersEnabled?loadTimeData.getString("historySearchWithAnswersSublabelOn"):loadTimeData.getString("historySearchSublabelOn")}return isAnswersEnabled?loadTimeData.getString("historySearchWithAnswersSublabelOff"):loadTimeData.getString("historySearchSublabelOff")}getFocusConfig(){const map=new Map;if(routes.HISTORY_SEARCH){map.set(routes.HISTORY_SEARCH.path,"#historySearchRowV2")}if(routes.COMPARE){map.set(routes.COMPARE.path,"#compareRowV2")}if(routes.OFFER_WRITING_HELP){map.set(routes.OFFER_WRITING_HELP.path,"#composeRowV2")}if(routes.AI_TAB_ORGANIZATION){map.set(routes.AI_TAB_ORGANIZATION.path,"#tabOrganizationRowV2")}return map}getAssociatedControlFor(childViewId){const ids=["compare","compose","historySearch","tabOrganization"];assert(ids.includes(childViewId));let triggerId=null;switch(childViewId){case"compare":assert(this.showCompareControl_);triggerId="compareRowV2";break;case"compose":assert(this.showComposeControl_);triggerId="composeRowV2";break;case"historySearch":assert(this.showHistorySearchControl_);triggerId="historySearchRowV2";break;case"tabOrganization":assert(this.showTabOrganizationControl_);triggerId="tabOrganizationRowV2";break}assert(triggerId);const control=this.shadowRoot.querySelector(`#${triggerId}`);assert(control);return control}}customElements.define(SettingsAiPageElement.is,SettingsAiPageElement);function getTemplate$G(){return html$1`<!--_html_template_start_--><style include="cr-icons cr-shared-style settings-shared">.learn-more-label[href='']{display:none}</style>

<settings-section page-title="$i18n{glicSectionTitle}">
  <div>
    <!-- TODO(crbug.com/393445109) Placeholder for final icons. -->
    <cr-link-row id="glicLinkRow"

        start-icon="settings20:lightbulb"


        label="$i18n{glicRowLabel}"
        on-click="onGlicPageClick_">

      <div slot="sub-label">
        $i18n{glicRowSublabel}
        <a id="learnMoreLabel" class="learn-more-label"
            href="$i18n{glicSettingsPageLearnMoreUrl}"
            aria-description="$i18n{opensInNewTab}"
            on-click="onSettingsPageLearnMoreClick_" target="_blank">
          $i18n{learnMore}
        </a>
      </div>
    </cr-link-row>
  </div>
</settings-section>
<!--_html_template_end_-->`}const SettingsGlicPageElementBase=SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));class SettingsGlicPageElement extends SettingsGlicPageElementBase{static get is(){return"settings-glic-page"}static get template(){return getTemplate$G()}static get properties(){return{spark_:{type:String,value:()=>loadTimeData.getBoolean("glicAssetsV2Enabled")?"settings-internal:sparkv2":"settings-internal:spark"}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();onGlicPageClick_(){Router.getInstance().navigateTo(routes.GEMINI)}onSettingsPageLearnMoreClick_(event){this.metricsBrowserProxy_.recordAction(AiPageActions.GLIC_COLLAPSED_LEARN_MORE_CLICKED);event.stopPropagation()}getFocusConfig(){return new Map([[routes.GEMINI.path,"#glicLinkRow"]])}getAssociatedControlFor(childViewId){assert(childViewId==="gemini");const control=this.shadowRoot.querySelector("#glicLinkRow");assert(control);return control}}customElements.define(SettingsGlicPageElement.is,SettingsGlicPageElement);class GlicBrowserProxyImpl{setGlicOsLauncherEnabled(enabled){chrome.send("setGlicOsLauncherEnabled",[enabled])}getGlicShortcut(){return sendWithPromise("getGlicShortcut")}setGlicShortcut(shortcut){return sendWithPromise("setGlicShortcut",shortcut)}getGlicFocusToggleShortcut(){return sendWithPromise("getGlicFocusToggleShortcut")}setGlicFocusToggleShortcut(shortcut){return sendWithPromise("setGlicFocusToggleShortcut",shortcut)}setShortcutSuspensionState(shouldSuspend){chrome.send("setShortcutSuspensionState",[shouldSuspend])}getDisallowedByAdmin(){return sendWithPromise("getGlicDisallowedByAdmin")}static getInstance(){return instance$8||(instance$8=new GlicBrowserProxyImpl)}static setInstance(obj){instance$8=obj}}let instance$8=null;function getTemplate$F(){return html$1`<!--_html_template_start_--><style include="cr-icons cr-shared-style settings-columned-section settings-shared">.keyboard-shortcut-setting{align-items:start}#mainShortcutSetting{border-top:none}.shortcut-input{margin-top:2px}.section{padding:0 var(--cr-section-padding)}.separator{margin-inline-end:4px;margin-inline-start:0}.toggle-actions-container{display:flex;align-items:center}.learn-more-label[href='']{display:none}</style>

<settings-subpage page-title="$i18n{glicPageTitle}" route-path$="[[routePath]]">
  <template is="dom-if" if="[[disallowedByAdmin_]]" restamp>
    <div class="section">
      <cr-icon icon="cr:domain"></cr-icon>
      $i18n{glicPolicyDisabledMessage}
    </div>
  </template>
  <div class="section">
    <h2 class="cr-title-text">$i18n{glicPreferencesSection}</h2>
    <!-- Glic Policy Disabled - show disabled controls -->
    <template is="dom-if" if="[[disallowedByAdmin_]]" restamp>
      <settings-toggle-button id="launcherToggle" pref="[[fakePref_]]"
          disabled label="$i18n{glicOsWidgetToggle}">
      </settings-toggle-button>
    </template>

    <!-- Glic Policy Enabled -->
    <template is="dom-if"
        on-dom-change="onEnabledTemplateDomChange_"
        if="[[!disallowedByAdmin_]]"
        restamp>
      <settings-toggle-button
          id="tabstripButtonToggle"
          pref="{{prefs.glic.pinned_to_tabstrip}}"
          label="$i18n{glicTabstripButtonToggle}"
          sub-label="$i18n{glicTabstripButtonToggleSublabel}"
          on-settings-boolean-control-change="onTabstripButtonToggleChange_">
      </settings-toggle-button>
      <settings-toggle-button
          id="launcherToggle" pref="{{prefs.glic.launcher_enabled}}"
          label="$i18n{glicOsWidgetToggle}"
          sub-label="$i18n{glicOsWidgetToggleSublabel}"
          learn-more-url="$i18n{glicLauncherToggleLearnMoreUrl}"
          on-learn-more-clicked="onLauncherToggleLearnMoreClick_"
          checked="{{launcherToggleOn_}}"
          on-settings-boolean-control-change="onLauncherToggleChange_">
      </settings-toggle-button>
      <cr-collapse opened="[[launcherToggleOn_]]">
        <div class="cr-row keyboard-shortcut-setting"
             id="mainShortcutSetting">
          <div class="flex cr-padded-text">
            <div class="shortcut-label" aria-hidden>
              $i18n{glicKeyboardShortcut}
            </div>
            <div class="secondary"
                learn-more-url="$i18n{glicKeyboardShortcutLearnMoreUrl}">
              $i18n{glicKeyboardShortcutSublabel}
              <a id="shortcutsLearnMoreLabel" class="learn-more-label"
                  href="$i18n{glicKeyboardShortcutLearnMoreUrl}"
                  aria-label="$i18n{glicKeyboardShortcutLearnMoreLabel}"
                  aria-description="$i18n{opensInNewTab}"
                  on-click="onShortcutsLearnMoreClick_" target="_blank">
                $i18n{glicKeyboardShortcutLearnMoreLabel}
              </a>
            </div>
          </div>
          <cr-shortcut-input class="cr-padded-text shortcut-input"
              input-aria-label="$i18n{glicKeyboardShortcut}"
              shortcut="[[registeredShortcut_]]"
              allow-ctrl-alt-shortcuts
              on-input-capture-change="onInputCaptureChange_"
              on-shortcut-updated="onShortcutUpdated_">
          </cr-shortcut-input>
        </div>
      </cr-collapse>
      <div class="cr-row keyboard-shortcut-setting"
           id="focusToggleShortcutSetting">
        <div class="flex cr-padded-text">
          <div class="shortcut-label" aria-hidden>
            $i18n{glicNavigationShortcut}
          </div>
          <div class="secondary">$i18n{glicNavigationShortcutSublabel}
              <a id="shortcutsNavigationLearnMoreLabel"
                  class="learn-more-label"
                  href="$i18n{glicKeyboardShortcutLearnMoreUrl}"
                  aria-label="$i18n{glicKeyboardShortcutLearnMoreLabel}"
                  aria-description="$i18n{opensInNewTab}"
                  on-click="onShortcutsLearnMoreClick_" target="_blank">
                $i18n{glicKeyboardShortcutLearnMoreLabel}
              </a>
          </div>
        </div>
        <cr-shortcut-input class="cr-padded-text shortcut-input"
            input-aria-label="$i18n{glicNavigationShortcut}"
            shortcut="[[registeredFocusToggleShortcut_]]"
            allow-ctrl-alt-shortcuts
            on-shortcut-updated="onFocusToggleShortcutUpdated_">
        </cr-shortcut-input>
      </div>
      <settings-toggle-button class="hr"
          id="closedCaptionsToggle"
          hidden="[[!closedCaptionsFeatureEnabled_]]"
          pref="{{prefs.glic.closed_captioning_enabled}}"
          label="$i18n{glicClosedCaptionsToggle}"
          sub-label="$i18n{glicClosedCaptionsToggleSublabel}"
          on-settings-boolean-control-change="onClosedCaptionsToggleChange_">
      </settings-toggle-button>
    </template>
  </div>
  <div class="section">
    <h2 class="cr-title-text">$i18n{glicDataSection}</h2>
    <!-- Glic Policy Disabled - show disabled controls -->
    <template is="dom-if" if="[[disallowedByAdmin_]]" restamp>
      <settings-toggle-button
          id="geolocationToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicLocationToggle}"
          sub-label="[[locationSubLabel_]]">
      </settings-toggle-button>
      <settings-toggle-button
          id="microphoneToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicMicrophoneToggle}"
          sub-label="[[microphoneSubLabel_]]">
      </settings-toggle-button>
      <settings-toggle-button
          id="tabAccessToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicTabAccessToggle}"
          sub-label="[[tabAccessSubLabel_]]"
          hidden="[[showGlicDefaultTabContextSetting_]]">
      </settings-toggle-button>
      <settings-toggle-button
          id="defaultTabAccessToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicDefaultTabAccessToggle}"
          sub-label-with-link="[[defaultTabAccessSubLabel_]]"
          on-sub-label-link-clicked="onDefaultTabAccessToggleLearnMoreClick_"
          hidden="[[!showGlicDefaultTabContextSetting_]]">
      </settings-toggle-button>
      <settings-toggle-button
          id="webActuationToggleDisabled" pref="[[fakePref_]]" disabled
          label="$i18n{glicWebActuationToggle}"
          sub-label-with-link="[[webActuationSubLabel_]]"
          on-sub-label-link-clicked="onWebActuationToggleLearnMoreClick_"
          hidden="[[!webActuationFeatureEnabled_]]">
      </settings-toggle-button>
    </template>

    <!-- Glic Policy Enabled -->
    <template is="dom-if" if="[[!disallowedByAdmin_]]" restamp>
      <settings-toggle-button
          id="geolocationToggle" pref="{{prefs.glic.geolocation_enabled}}"
          label="$i18n{glicLocationToggle}"
          sub-label="[[locationSubLabel_]]"
          learn-more-url="[[locationLearnMoreUrl_]]"
          on-learn-more-clicked="onLocationToggleLearnMoreClick_"
          on-settings-boolean-control-change="onGeolocationToggleChange_">
      </settings-toggle-button>
      <settings-toggle-button
          id="microphoneToggle" pref="{{prefs.glic.microphone_enabled}}"
          label="$i18n{glicMicrophoneToggle}"
          sub-label="[[microphoneSubLabel_]]"
          on-settings-boolean-control-change="onMicrophoneToggleChange_">
      </settings-toggle-button>
      <div hidden="[[showGlicDefaultTabContextSetting_]]">
      <settings-toggle-button
          id="tabAccessToggle" pref="{{prefs.glic.tab_context_enabled}}"
          label="$i18n{glicTabAccessToggle}"
          sub-label="[[tabAccessSubLabel_]]"
          learn-more-url="[[tabAccessLearnMoreUrl_]]"
          on-learn-more-clicked="onTabAccessToggleLearnMoreClick_"
          on-settings-boolean-control-change="onTabAccessToggleChange_"
          no-toggle-on-host-click on-click="onTabAccessExpand_"
          hidden="[[showGlicDefaultTabContextSetting_]]">
        <div id="tabAccessToggleActions" class="toggle-actions-container"
            slot="more-actions">
          <cr-expand-button id="tabAccessExpandButton" no-hover
              expanded="{{tabAccessToggleExpanded_}}">
          </cr-expand-button>
          <div class="separator"></div>
        </div>
      </settings-toggle-button>
      <cr-collapse id="tabAccessInfoCollapse"
          opened="[[tabAccessToggleExpanded_]]"
          hidden="[[showGlicDefaultTabContextSetting_]]">
        <div class="settings-columned-section">
          <div class="column">
            <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
            <ul class="icon-bulleted-list">
              <li>
                <cr-icon aria-hidden="true"

                      icon="settings20:edit-square">


                  </cr-icon>
                  <div class="secondary">$i18n{glicTabAccessWhenOn1}</div>
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon aria-hidden="true"

                      icon="settings20:web">


                  </cr-icon>
                  <div class="secondary">$i18n{glicTabAccessConsider1}
                    <a id="shortcutTabAccessConsider1LearnMoreLabel"
                        class="learn-more-label"
                        href="[[tabAccessLearnMoreUrl_]]"
                        on-click="onTabAccessToggleLearnMoreClick_"
                        aria-label=
                           "$i18n{glicTabAccessConsider1LearnMoreLabel}"
                        aria-description="$i18n{opensInNewTab}"
                        target="_blank">
                    $i18n{glicTabAccessConsider1LearnMoreLabel}
                  </a>
                  </div>
                </li>
              </ul>
            </div>
          </div>
        </cr-collapse>
      </div>
      <div hidden="[[!showGlicDefaultTabContextSetting_]]">
        <settings-toggle-button
            id="defaultTabAccessToggle"
            pref="{{prefs.glic.default_tab_context_enabled}}"
            label="$i18n{glicDefaultTabAccessToggle}"
            sub-label-with-link="[[defaultTabAccessSubLabel_]]"
            on-sub-label-link-clicked="onDefaultTabAccessToggleLearnMoreClick_"
            on-settings-boolean-control-change="onDefaultTabAccessToggleChange_"
            no-toggle-on-host-click on-click="onDefaultTabAccessExpand_">
          <div id="defaultTabAccessToggleActions"
              class="toggle-actions-container"
              slot="more-actions">
            <cr-expand-button id="defaultTabAccessExpandButton" no-hover
                expanded="{{defaultTabAccessToggleExpanded_}}">
            </cr-expand-button>
            <div class="separator"></div>
          </div>
        </settings-toggle-button>
        <cr-collapse id="defaultTabAccessInfoCollapse"
            opened="[[defaultTabAccessToggleExpanded_]]">
          <div class="settings-columned-section">
            <div class="column">
              <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon aria-hidden="true"

                      icon="settings20:edit-square">


                  </cr-icon>
                  <div class="secondary">
                    $i18n{glicDefaultTabAccessWhenOn1}
                  </div>
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon aria-hidden="true"

                      icon="settings20:web">


                  </cr-icon>
                  <div class="secondary">
                    $i18n{glicDefaultTabAccessConsider1}
                  </div>
                </li>
                <li hidden="[[isEnterpriseAccountDataProtected_]]">
                  <cr-icon aria-hidden="true" 
                    icon="settings20:web">
                    
                    
                  </cr-icon>
                  <div class="secondary">
                    $i18n{glicDefaultTabAccessConsider2}
                  </div>
                </li>
              </ul>
            </div>
          </div>
        </cr-collapse>
      </div>
    <div hidden="[[!webActuationFeatureEnabled_]]">
      <settings-toggle-button
          id="webActuationToggle"
          pref="{{prefs.glic.user_enabled_actuation_on_web}}"
          label="$i18n{glicWebActuationToggle}"
          sub-label-with-link="[[webActuationSubLabel_]]"
          on-sub-label-link-clicked="onWebActuationToggleLearnMoreClick_"
          on-settings-boolean-control-change="onWebActuationToggleChange_"
          no-toggle-on-host-click on-click="onWebActuationExpand_">
          <div id="webActuationToggleActions"
            class="toggle-actions-container"
            slot="more-actions">
          <cr-expand-button id="webActuationExpandButton" no-hover
              expanded="{{webActuationEnabledExpanded_}}">
          </cr-expand-button>
          <div class="separator"></div>
        </div>
      </settings-toggle-button>
      <cr-collapse id="webActuationInfoCollapse"
          opened="[[webActuationEnabledExpanded_]]"
          hidden="[[!webActuationFeatureEnabled_]]">
        <div class="settings-columned-section">
          <div class="column">
            <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
            <ul class="icon-bulleted-list">
              <li>
                <cr-icon aria-hidden="true"
                    icon="settings20:arrow-selector-tool">
                </cr-icon>
                <div class="secondary">
                  $i18n{glicWebActuationToggleWhenOn1}
                </div>
              </li>
              <li>
                <cr-icon aria-hidden="true"
                    icon="cr:check-circle">
                </cr-icon>
                <div class="secondary">
                  $i18n{glicWebActuationToggleWhenOn2}
                </div>
              </li>
            </ul>
          </div>
          <div class="column">
            <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
            <ul class="icon-bulleted-list">
              <li>
                <cr-icon aria-hidden="true"
                  
                    icon="settings20:web">
                  
                  
                </cr-icon>
                <div class="secondary">
                  $i18n{glicWebActuationToggleConsider1}
                </div>
              </li>
              <li>
                <cr-icon aria-hidden="true"
                    icon="settings20:shield">
                </cr-icon>
                <div class="secondary">
                  $i18nRaw{glicWebActuationToggleConsider2}
                </div>
              </li>
            </ul>
          </div>
        </div>
      </cr-collapse>
    </div>
      <cr-link-row id="activityButton" on-click="onActivityRowClick_"
          label="$i18n{glicActivityButton}"
          sub-label="$i18n{glicActivityButtonSublabel}" external>
      </cr-link-row>
      <cr-link-row id="extensionsButton"
          hidden="[[!glicExtensionsFeatureEnabled_]]"
          on-click="onExtensionsRowClick_"
          label="$i18n{glicExtensionsButton}"
          sub-label="$i18n{glicExtensionsButtonSublabel}" external>
      </cr-link-row>
      <cr-link-row id="geminiPersonalContextLink" class="hr"
          hidden="[[!showGlicPersonalContextLink_]]"
          on-click="onGeminiPersonalContextClick_"
          label="$i18n{glicPersonalContextSettingLabel}"
          sub-label="$i18n{glicPersonalContextSettingSublabel}" external>
      </cr-link-row>
    </template>
  </div>
</settings-subpage>
<!--_html_template_end_-->`}var SettingsGlicPageFeaturePrefName;(function(SettingsGlicPageFeaturePrefName){SettingsGlicPageFeaturePrefName["CLOSED_CAPTIONS_ENABLED"]="glic.closed_captioning_enabled";SettingsGlicPageFeaturePrefName["GEOLOCATION_ENABLED"]="glic.geolocation_enabled";SettingsGlicPageFeaturePrefName["LAUNCHER_ENABLED"]="glic.launcher_enabled";SettingsGlicPageFeaturePrefName["MICROPHONE_ENABLED"]="glic.microphone_enabled";SettingsGlicPageFeaturePrefName["SETTINGS_POLICY"]="browser.gemini_settings";SettingsGlicPageFeaturePrefName["TAB_CONTEXT_ENABLED"]="glic.tab_context_enabled";SettingsGlicPageFeaturePrefName["TABSTRIP_BUTTON_ENABLED"]="glic.pinned_to_tabstrip";SettingsGlicPageFeaturePrefName["USER_STATUS"]="glic.user_status";SettingsGlicPageFeaturePrefName["DEFAULT_TAB_CONTEXT_ENABLED"]="glic.default_tab_context_enabled";SettingsGlicPageFeaturePrefName["WEB_ACTUATION_ENABLED"]="glic.user_enabled_actuation_on_web"})(SettingsGlicPageFeaturePrefName||(SettingsGlicPageFeaturePrefName={}));const OS_WIDGET_TOGGLE_ELEMENT_ID="kGlicOsToggleElementId";const OS_WIDGET_KEYBOARD_SHORTCUT_ELEMENT_ID="kGlicOsWidgetKeyboardShortcutElementId";const SettingsGlicSubpageElementBase=SettingsViewMixin(HelpBubbleMixin(I18nMixin(WebUiListenerMixin(PrefsMixin(PolymerElement)))));class SettingsGlicSubpageElement extends SettingsGlicSubpageElementBase{static get is(){return"settings-glic-subpage"}static get template(){return getTemplate$F()}static get properties(){return{disallowedByAdmin_:{type:Boolean,value:false},registeredShortcut_:{type:String,value:""},registeredFocusToggleShortcut_:{type:String,value:""},tabAccessToggleExpanded_:{type:Boolean,value:false},fakePref_:{type:Object,value:{key:"glic.fake_pref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:0}},closedCaptionsFeatureEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("glicClosedCaptionsFeatureEnabled")},glicExtensionsFeatureEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("glicExtensionsFeatureEnabled")},glicUserStatusCheckFeatureEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("glicUserStatusCheckFeatureEnabled")},showGlicDefaultTabContextSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("showGlicDefaultTabContextSetting")},showGlicPersonalContextLink_:{type:Boolean,value:()=>loadTimeData.getBoolean("showGeminiPersonalContextLink")},locationSubLabel_:{type:String,computed:`computeLocationSubLabel_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},locationLearnMoreUrl_:{type:String,computed:`computeLocationLearnMoreUrl_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},microphoneSubLabel_:{type:String,computed:`computeMicrophoneSubLabel_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},tabAccessSubLabel_:{type:String,computed:`computeTabAccessSubLabel_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},tabAccessLearnMoreUrl_:{type:String,computed:`computeTabAccessLearnMoreUrl_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},defaultTabAccessToggleExpanded_:{type:Boolean,value:false},defaultTabAccessSubLabel_:{type:String,computed:`computeDefaultTabAccessSubLabel_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},defaultTabAccessLearnMoreUrl_:{type:String,computed:`computeDefaultTabAccessLearnMoreUrl_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},spark_:{type:String,computed:`computeSpark_()`},isEnterpriseAccountDataProtected_:{type:Boolean,computed:`computeIsEnterpriseAccountDataProtected_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},webActuationFeatureEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("glicWebActuationFeatureEnabled")&&loadTimeData.getBoolean("glicActorEnabled")},webActuationEnabledExpanded_:{type:Boolean,value:false},webActuationSubLabel_:{type:String,computed:`computeWebActuationSubLabel_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`},webActuationLearnMoreUrl_:{type:String,computed:`computeWebActuationLearnMoreUrl_(prefs.${SettingsGlicPageFeaturePrefName.USER_STATUS}.value)`}}}static get observers(){return["onTabContextEnabledChanged_("+`prefs.${SettingsGlicPageFeaturePrefName.TAB_CONTEXT_ENABLED}.value)`,"onDefaultTabContextEnabledChanged_("+`prefs.${SettingsGlicPageFeaturePrefName.DEFAULT_TAB_CONTEXT_ENABLED}.value)`,"onWebActuationEnabledChanged_("+`prefs.${SettingsGlicPageFeaturePrefName.WEB_ACTUATION_ENABLED}.value)`]}shortcutInput_;focusToggleShortcutInput_;removedShortcut_=null;browserProxy_=GlicBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();async connectedCallback(){super.connectedCallback();this.browserProxy_.getDisallowedByAdmin().then(this.disallowedByAdminChanged_.bind(this));this.addWebUiListener("glic-disallowed-by-admin-changed",this.disallowedByAdminChanged_.bind(this));this.registeredShortcut_=await this.browserProxy_.getGlicShortcut();this.registeredFocusToggleShortcut_=await this.browserProxy_.getGlicFocusToggleShortcut();await CrSettingsPrefs.initialized}async onEnabledTemplateDomChange_(){await CrSettingsPrefs.initialized;if(this.disallowedByAdmin_){return}const launcherToggle=this.shadowRoot.querySelector("#launcherToggle");const shortcutInput=this.shadowRoot.querySelector("#mainShortcutSetting .shortcut-input");assert(launcherToggle);assert(shortcutInput);this.registerHelpBubble(OS_WIDGET_TOGGLE_ELEMENT_ID,launcherToggle.getBubbleAnchor());this.registerHelpBubble(OS_WIDGET_KEYBOARD_SHORTCUT_ELEMENT_ID,shortcutInput)}onLauncherToggleChange_(event){const enabled=event.target.checked;this.browserProxy_.setGlicOsLauncherEnabled(enabled);this.metricsBrowserProxy_.recordAction("Glic.OsEntrypoint.Settings.Toggle"+(enabled?".Enabled":".Disabled"));this.hideHelpBubble(OS_WIDGET_TOGGLE_ELEMENT_ID)}onGeolocationToggleChange_(event){const enabled=event.target.checked;this.metricsBrowserProxy_.recordAction("Glic.Settings.Geolocation"+(enabled?".Enabled":".Disabled"))}onMicrophoneToggleChange_(event){const enabled=event.target.checked;this.metricsBrowserProxy_.recordAction("Glic.Settings.Microphone"+(enabled?".Enabled":".Disabled"))}async onShortcutUpdated_(event){this.shortcutInput_=event.detail;await this.browserProxy_.setGlicShortcut(this.shortcutInput_);if(this.removedShortcut_===null){this.removedShortcut_=this.registeredShortcut_}this.registeredShortcut_=await this.browserProxy_.getGlicShortcut();this.metricsBrowserProxy_.recordBooleanHistogram("Glic.OsEntrypoint.Settings.Shortcut",!!this.shortcutInput_);this.hideHelpBubble(OS_WIDGET_KEYBOARD_SHORTCUT_ELEMENT_ID)}async onFocusToggleShortcutUpdated_(event){this.focusToggleShortcutInput_=event.detail;await this.browserProxy_.setGlicFocusToggleShortcut(this.focusToggleShortcutInput_);this.registeredFocusToggleShortcut_=await this.browserProxy_.getGlicFocusToggleShortcut();this.metricsBrowserProxy_.recordBooleanHistogram("Glic.Focus.Settings.Shortcut.Customized",!!this.focusToggleShortcutInput_)}recordShortcutEnablement(){if(this.shortcutInput_&&!this.removedShortcut_){this.metricsBrowserProxy_.recordAction("GlicOsEntrypoint.Settings.ShortcutEnabled")}else if(!this.shortcutInput_&&this.removedShortcut_){this.metricsBrowserProxy_.recordAction("GlicOsEntrypoint.Settings.ShortcutDisabled")}else{this.metricsBrowserProxy_.recordAction("GlicOsEntrypoint.Settings.ShortcutEdited")}}onInputCaptureChange_(event){const capturing=event.detail;this.browserProxy_.setShortcutSuspensionState(capturing);if(!capturing){this.recordShortcutEnablement();this.removedShortcut_=null}}onTabContextEnabledChanged_(enabled){this.tabAccessToggleExpanded_=enabled}onDefaultTabContextEnabledChanged_(enabled){this.defaultTabAccessToggleExpanded_=enabled}onTabAccessToggleChange_(event){const target=event.target;const enabled=target.checked;this.metricsBrowserProxy_.recordAction("Glic.Settings.TabContext"+(enabled?".Enabled":".Disabled"))}onTabAccessExpand_(){this.tabAccessToggleExpanded_=!this.tabAccessToggleExpanded_}onDefaultTabAccessExpand_(){this.defaultTabAccessToggleExpanded_=!this.defaultTabAccessToggleExpanded_}onDefaultTabAccessToggleChange_(event){const target=event.target;const enabled=target.checked;this.metricsBrowserProxy_.recordAction("Glic.Settings.DefaultTabContext"+(enabled?".Enabled":".Disabled"))}onWebActuationEnabledChanged_(enabled){this.webActuationEnabledExpanded_=enabled}onActivityRowClick_(){OpenWindowProxyImpl.getInstance().openUrl(this.i18n("glicActivityButtonUrl"))}onExtensionsRowClick_(){const url=new URL(this.i18n("glicExtensionsManagementUrl"));OpenWindowProxyImpl.getInstance().openUrl(url.toString())}onShortcutsLearnMoreClick_(){this.metricsBrowserProxy_.recordAction(AiPageActions.GLIC_SHORTCUTS_LEARN_MORE_CLICKED)}onLauncherToggleLearnMoreClick_(){this.metricsBrowserProxy_.recordAction(AiPageActions.GLIC_SHORTCUTS_LAUNCHER_TOGGLE_LEARN_MORE_CLICKED)}onLocationToggleLearnMoreClick_(){this.metricsBrowserProxy_.recordAction(AiPageActions.GLIC_SHORTCUTS_LOCATION_TOGGLE_LEARN_MORE_CLICKED)}onTabAccessToggleLearnMoreClick_(){this.metricsBrowserProxy_.recordAction(AiPageActions.GLIC_SHORTCUTS_TAB_ACCESS_TOGGLE_LEARN_MORE_CLICKED)}onDefaultTabAccessToggleLearnMoreClick_(){this.metricsBrowserProxy_.recordAction(AiPageActions.GLIC_SHORTCUTS_DEFAULT_TAB_ACCESS_TOGGLE_LEARN_MORE_CLICKED);OpenWindowProxyImpl.getInstance().openUrl(this.defaultTabAccessLearnMoreUrl_)}onGeminiPersonalContextClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("geminiPersonalContextUrl"))}disallowedByAdminChanged_(disallowed){this.disallowedByAdmin_=disallowed}onClosedCaptionsToggleChange_(event){const enabled=event.target.checked;this.metricsBrowserProxy_.recordAction("Glic.Settings.ClosedCaptions."+(enabled?"Enabled":"Disabled"))}onTabstripButtonToggleChange_(event){const enabled=event.target.checked;this.metricsBrowserProxy_.recordAction("Glic.Settings.TabstripButton."+(enabled?"Enabled":"Disabled"))}computeIsEnterpriseAccountDataProtected_(userStatus){return this.glicUserStatusCheckFeatureEnabled_&&!!userStatus?.isEnterpriseAccountDataProtected}computeLocationSubLabel_(userStatus){return this.computeIsEnterpriseAccountDataProtected_(userStatus)?this.i18n("glicLocationToggleSublabelDataProtected"):this.i18n("glicLocationToggleSublabel")}computeLocationLearnMoreUrl_(userStatus){return this.computeIsEnterpriseAccountDataProtected_(userStatus)?"":this.i18n("glicLocationToggleLearnMoreUrl")}computeMicrophoneSubLabel_(userStatus){return this.computeIsEnterpriseAccountDataProtected_(userStatus)?this.i18n("glicMicrophoneToggleSublabelDataProtected"):this.i18n("glicMicrophoneToggleSublabel")}computeTabAccessSubLabel_(userStatus){return this.computeIsEnterpriseAccountDataProtected_(userStatus)?this.i18n("glicTabAccessToggleSublabelDataProtected"):this.i18n("glicTabAccessToggleSublabel")}computeTabAccessLearnMoreUrl_(userStatus){return this.computeIsEnterpriseAccountDataProtected_(userStatus)?this.i18n("glicTabAccessToggleLearnMoreUrlDataProtected"):this.i18n("glicTabAccessToggleLearnMoreUrl")}computeDefaultTabAccessSubLabel_(userStatus){return this.computeIsEnterpriseAccountDataProtected_(userStatus)?this.i18nAdvanced("glicDefaultTabAccessToggleSublabelDataProtected").toString():this.i18nAdvanced("glicDefaultTabAccessToggleSublabel").toString()}computeDefaultTabAccessLearnMoreUrl_(userStatus){return this.computeIsEnterpriseAccountDataProtected_(userStatus)?this.i18n("glicDefaultTabAccessToggleLearnMoreUrlDataProtected"):this.i18n("glicDefaultTabAccessToggleLearnMoreUrl")}computeSpark_(){return loadTimeData.getBoolean("glicAssetsV2Enabled")?"settings-internal:sparkv2":"settings-internal:spark"}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}onWebActuationToggleChange_(event){const target=event.target;const enabled=target.checked;this.metricsBrowserProxy_.recordAction("Glic.Settings.WebActuation"+(enabled?".Enabled":".Disabled"))}onWebActuationExpand_(){this.webActuationEnabledExpanded_=!this.webActuationEnabledExpanded_}onWebActuationToggleLearnMoreClick_(){this.metricsBrowserProxy_.recordAction(AiPageActions.GLIC_SHORTCUTS_WEB_ACTUATION_TOGGLE_LEARN_MORE_CLICKED);OpenWindowProxyImpl.getInstance().openUrl(this.webActuationLearnMoreUrl_)}computeWebActuationSubLabel_(){return this.i18nAdvanced("glicWebActuationToggleSublabel").toString()}computeWebActuationLearnMoreUrl_(){return loadTimeData.getString("glicWebActuationToggleLearnMoreUrl")}}customElements.define(SettingsGlicSubpageElement.is,SettingsGlicSubpageElement);function getTemplate$E(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}cr-view-manager [slot=view]:not(.closing){position:initial}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-ai-info-card slot="view" id="aiInfoCard"></settings-ai-info-card>


  <template is="dom-if" if="[[showGlicSettings_]]">
    <settings-glic-page slot="view" id="glic" prefs="{{prefs}}">
    </settings-glic-page>

    <settings-glic-subpage slot="view" id="gemini"
        data-parent-view-id="glic" prefs="{{prefs}}"
        route-path$="[[routes_.GEMINI.path]]">
    </settings-glic-subpage>
  </template>


  <template is="dom-if" if="[[showAiPageAiFeatureSection_]]">
    <settings-ai-page slot="view" id="parent" prefs="{{prefs}}">
    </settings-ai-page>
  </template>

  <template is="dom-if" if="[[showHistorySearchControl_]]">
    <settings-history-search-page slot="view" id="historySearch"
        data-parent-view-id="parent" prefs="{{prefs}}"
        route-path$="[[routes_.HISTORY_SEARCH.path]]">
    </settings-history-search-page>
  </template>

  <template is="dom-if" if="[[showCompareControl_]]">
    <settings-ai-compare-subpage slot="view" id="compare"
        data-parent-view-id="parent" prefs="{{prefs}}"
        route-path$="[[routes_.COMPARE.path]]">
    </settings-ai-compare-subpage>
  </template>

  <template is="dom-if" if="[[showComposeControl_]]">
    <settings-offer-writing-help-page slot="view" id="compose"
        data-parent-view-id="parent" prefs="{{prefs}}"
        route-path$="[[routes_.OFFER_WRITING_HELP.path]]">
    </settings-offer-writing-help-page>
  </template>

  <template is="dom-if" if="[[showTabOrganizationControl_]]">
    <settings-ai-tab-organization-subpage slot="view" id="tabOrganization"
        data-parent-view-id="parent" prefs="{{prefs}}"
        route-path$="[[routes_.AI_TAB_ORGANIZATION.path]]">
    </settings-ai-tab-organization-subpage>
  </template>
</cr-view-manager>
<!--_html_template_end_-->`}const SettingsAiPageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsAiPageIndexElement extends SettingsAiPageIndexElementBase{static get is(){return"settings-ai-page-index"}static get template(){return getTemplate$E()}static get properties(){return{prefs:Object,routes_:{type:Object,value:()=>routes},showGlicSettings_:{type:Boolean,value:()=>loadTimeData.getBoolean("showGlicSettings")},showAiPageAiFeatureSection_:{type:Boolean,value:()=>loadTimeData.getBoolean("showAiPageAiFeatureSection")},showComposeControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showComposeControl")},showCompareControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showCompareControl")},showHistorySearchControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showHistorySearchControl")},showTabOrganizationControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("showTabOrganizationControl")}}}showDefaultViews_(){const defaultViews=["aiInfoCard"];if(this.showAiPageAiFeatureSection_){defaultViews.push("parent")}if(this.showGlicSettings_){defaultViews.push("glic")}this.$.viewManager.switchViews(defaultViews,"no-animation","no-animation")}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.AI:this.showDefaultViews_();break;case routes.BASIC:this.showDefaultViews_();break;case routes.AI_TAB_ORGANIZATION:assert(this.showTabOrganizationControl_);this.$.viewManager.switchView("tabOrganization","no-animation","no-animation");break;case routes.HISTORY_SEARCH:assert(this.showHistorySearchControl_);this.$.viewManager.switchView("historySearch","no-animation","no-animation");break;case routes.OFFER_WRITING_HELP:assert(this.showComposeControl_);this.$.viewManager.switchView("compose","no-animation","no-animation");break;case routes.COMPARE:assert(this.showCompareControl_);this.$.viewManager.switchView("compare","no-animation","no-animation");break;case routes.GEMINI:assert(this.showGlicSettings_);this.$.viewManager.switchView("gemini","no-animation","no-animation");break}}))}}customElements.define(SettingsAiPageIndexElement.is,SettingsAiPageIndexElement);class AppearanceBrowserProxyImpl{getDefaultZoom(){return chrome.settingsPrivate.getDefaultZoom()}getThemeInfo(themeId){return chrome.management.get(themeId)}isChildAccount(){return loadTimeData.getBoolean("isChildAccount")}openCustomizeChrome(){chrome.send("openCustomizeChrome")}openCustomizeChromeToolbarSection(){chrome.send("openCustomizeChromeToolbarSection")}recordHoverCardImagesEnabledChanged(enabled){chrome.metricsPrivate.recordBoolean("Settings.HoverCards.ImagePreview.Enabled",enabled)}resetPinnedToolbarActions(){chrome.send("resetPinnedToolbarActions")}useDefaultTheme(){chrome.send("useDefaultTheme")}useGtkTheme(){chrome.send("useGtkTheme")}useQtTheme(){chrome.send("useQtTheme")}validateStartupPage(url){return sendWithPromise("validateStartupPage",url)}pinnedToolbarActionsAreDefault(){return sendWithPromise("pinnedToolbarActionsAreDefault")}static getInstance(){return instance$7||(instance$7=new AppearanceBrowserProxyImpl)}static setInstance(obj){instance$7=obj}}let instance$7=null;function getTemplate$D(){return html$1`<!--_html_template_start_-->    <style>:host{cursor:auto;display:block;width:100%}cr-input{width:100%;--cr-input-width:50%}cr-input::part(row-container){justify-content:normal}
    </style>
    <!-- Max length of 100 KB to prevent browser from freezing. -->
    <cr-input id="input" value="{{value}}" error-message="$i18n{notValid}"
        placeholder="$i18n{enterCustomWebAddress}" maxlength="102400"
        on-change="onChange_" on-keydown="onKeydown_" on-input="validate_"
        invalid="{{invalid}}" input-tabindex="[[getTabindex_(canTab)]]"
        disabled="[[isDisabled_(disabled, pref.*)]]" spellcheck="false"
        on-keyup="stopKeyEventPropagation_"
        on-keypress="stopKeyEventPropagation_">
      <template is="dom-if" if="[[hasPrefPolicyIndicator(pref.*)]]">
        <cr-policy-pref-indicator pref="[[pref]]" icon-aria-label="[[label]]"
            slot="suffix">
        </cr-policy-pref-indicator>
      </template>
    </cr-input>
<!--_html_template_end_-->`}const HomeUrlInputElementBase=CrPolicyPrefMixin(PrefControlMixin(PolymerElement));class HomeUrlInputElement extends HomeUrlInputElementBase{static get is(){return"home-url-input"}static get template(){return getTemplate$D()}static get properties(){return{pref:{observer:"prefChanged_"},disabled:{type:Boolean,value:false,reflectToAttribute:true},canTab:Boolean,invalid:{type:Boolean,value:false},value:{type:String,value:"",notify:true}}}browserProxy_=AppearanceBrowserProxyImpl.getInstance();constructor(){super();this.noExtensionIndicator=true}focus(){this.$.input.focus()}prefChanged_(){if(!this.pref){return}this.setInputValueFromPref_()}setInputValueFromPref_(){assert(this.pref.type===chrome.settingsPrivate.PrefType.URL);this.value=this.pref.value}getTabindex_(canTab){return canTab?0:-1}onChange_(){if(this.invalid){this.resetValue_();return}assert(this.pref.type===chrome.settingsPrivate.PrefType.URL);this.set("pref.value",this.value)}resetValue_(){this.invalid=false;this.setInputValueFromPref_();this.$.input.blur()}onKeydown_(event){if(event.key==="Enter"&&this.invalid){event.preventDefault()}else if(event.key==="Escape"){this.resetValue_()}this.stopKeyEventPropagation_(event)}stopKeyEventPropagation_(e){e.stopPropagation()}isDisabled_(disabled){return disabled||this.isPrefEnforced()}validate_(){if(this.value===""){this.invalid=false;return}this.browserProxy_.validateStartupPage(this.value).then((isValid=>{this.invalid=!isValid}))}}customElements.define(HomeUrlInputElement.is,HomeUrlInputElement);const ColorSchemeModeSpec={$:mojo.internal.Enum()};var ColorSchemeMode;(function(ColorSchemeMode){ColorSchemeMode[ColorSchemeMode["MIN_VALUE"]=0]="MIN_VALUE";ColorSchemeMode[ColorSchemeMode["MAX_VALUE"]=2]="MAX_VALUE";ColorSchemeMode[ColorSchemeMode["kSystem"]=0]="kSystem";ColorSchemeMode[ColorSchemeMode["kLight"]=1]="kLight";ColorSchemeMode[ColorSchemeMode["kDark"]=2]="kDark"})(ColorSchemeMode||(ColorSchemeMode={}));class CustomizeColorSchemeModeHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"customize_color_scheme_mode.mojom.CustomizeColorSchemeModeHandlerFactory",scope)}}class CustomizeColorSchemeModeHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CustomizeColorSchemeModeHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createCustomizeColorSchemeModeHandler(pendingClient,pendingHandler){this.proxy.sendMessage(0,CustomizeColorSchemeModeHandlerFactory_CreateCustomizeColorSchemeModeHandler_ParamsSpec.$,null,[pendingClient,pendingHandler],false)}}class CustomizeColorSchemeModeHandlerFactory{static get $interfaceName(){return"customize_color_scheme_mode.mojom.CustomizeColorSchemeModeHandlerFactory"}static getRemote(){let remote=new CustomizeColorSchemeModeHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class CustomizeColorSchemeModeHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"customize_color_scheme_mode.mojom.CustomizeColorSchemeModeHandler",scope)}}class CustomizeColorSchemeModeHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CustomizeColorSchemeModeHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setColorSchemeMode(colorSchemeMode){this.proxy.sendMessage(0,CustomizeColorSchemeModeHandler_SetColorSchemeMode_ParamsSpec.$,null,[colorSchemeMode],false)}initializeColorSchemeMode(){this.proxy.sendMessage(1,CustomizeColorSchemeModeHandler_InitializeColorSchemeMode_ParamsSpec.$,null,[],false)}}class CustomizeColorSchemeModeClientPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"customize_color_scheme_mode.mojom.CustomizeColorSchemeModeClient",scope)}}class CustomizeColorSchemeModeClientRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(CustomizeColorSchemeModeClientPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setColorSchemeMode(colorSchemeMode){this.proxy.sendMessage(0,CustomizeColorSchemeModeClient_SetColorSchemeMode_ParamsSpec.$,null,[colorSchemeMode],false)}}class CustomizeColorSchemeModeClientCallbackRouter{helper_internal_;$;router_;setColorSchemeMode;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CustomizeColorSchemeModeClientRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.setColorSchemeMode=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,CustomizeColorSchemeModeClient_SetColorSchemeMode_ParamsSpec.$,null,this.setColorSchemeMode.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const CustomizeColorSchemeModeHandlerFactory_CreateCustomizeColorSchemeModeHandler_ParamsSpec={$:{}};const CustomizeColorSchemeModeHandler_SetColorSchemeMode_ParamsSpec={$:{}};const CustomizeColorSchemeModeHandler_InitializeColorSchemeMode_ParamsSpec={$:{}};const CustomizeColorSchemeModeClient_SetColorSchemeMode_ParamsSpec={$:{}};mojo.internal.Struct(CustomizeColorSchemeModeHandlerFactory_CreateCustomizeColorSchemeModeHandler_ParamsSpec.$,"CustomizeColorSchemeModeHandlerFactory_CreateCustomizeColorSchemeModeHandler_Params",[mojo.internal.StructField("pendingClient",0,0,mojo.internal.InterfaceProxy(CustomizeColorSchemeModeClientRemote),null,false,0,undefined,undefined),mojo.internal.StructField("pendingHandler",8,0,mojo.internal.InterfaceRequest(CustomizeColorSchemeModeHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(CustomizeColorSchemeModeHandler_SetColorSchemeMode_ParamsSpec.$,"CustomizeColorSchemeModeHandler_SetColorSchemeMode_Params",[mojo.internal.StructField("colorSchemeMode",0,0,ColorSchemeModeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(CustomizeColorSchemeModeHandler_InitializeColorSchemeMode_ParamsSpec.$,"CustomizeColorSchemeModeHandler_InitializeColorSchemeMode_Params",[],[[0,8]]);mojo.internal.Struct(CustomizeColorSchemeModeClient_SetColorSchemeMode_ParamsSpec.$,"CustomizeColorSchemeModeClient_SetColorSchemeMode_Params",[mojo.internal.StructField("colorSchemeMode",0,0,ColorSchemeModeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);let instance$6=null;class CustomizeColorSchemeModeBrowserProxy{handler;callbackRouter;constructor(handler,callbackRouter){this.handler=handler;this.callbackRouter=callbackRouter}static getInstance(){if(!instance$6){const handler=new CustomizeColorSchemeModeHandlerRemote;const callbackRouter=new CustomizeColorSchemeModeClientCallbackRouter;CustomizeColorSchemeModeHandlerFactory.getRemote().createCustomizeColorSchemeModeHandler(callbackRouter.$.bindNewPipeAndPassRemote(),handler.$.bindNewPipeAndPassReceiver());instance$6=new CustomizeColorSchemeModeBrowserProxy(handler,callbackRouter)}return instance$6}static setInstance(handler,callbackRouter){instance$6=new CustomizeColorSchemeModeBrowserProxy(handler,callbackRouter)}}function getTemplate$C(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">#custom-input{--cr-radio-button-disc-margin-block-start:calc((1.54em + 12px) / 2 - 8px);align-items:start}#themeRow cr-button,#toolbarRow cr-button{margin-inline-end:20px}#themeRow .separator,#toolbarRow .separator{margin-inline-start:0}#toolbarRow{border-top:var(--cr-separator-line)}.hover-card-toggles{padding-inline-end:0}.hover-card-toggles settings-toggle-button{padding-inline-start:0}#tabSearchPositionRestart{margin-inline-end:20px}

    </style>
    <settings-section page-title="$i18n{appearancePageTitle}">
      <div route-path="default">
        <div class="settings-row first" id="themeRow"
            hidden="[[!pageVisibility.setTheme]]">
          <cr-link-row id="openTheme" class="first"
              hidden="[[!pageVisibility.setTheme]]"
              label="$i18n{themes}" sub-label="[[themeSublabel_]]"
              on-click="onThemeClick_" external></cr-link-row>


          <div class="settings-row continuation"
              hidden="[[!showThemesSecondary_(
                  prefs.extensions.theme.id.value, systemTheme_)]]"
              id="themesSecondaryActions">
            <div class="separator"></div>
            <template is="dom-if" if="[[showUseClassic_(
                prefs.extensions.theme.id.value, systemTheme_)]]" restamp>
              <cr-button id="useDefault" on-click="onUseDefaultClick_">
                $i18n{useClassicTheme}
              </cr-button>
            </template>
            <template is="dom-if" if="[[showUseGtk_(
                prefs.extensions.theme.id.value, systemTheme_)]]" restamp>
              <cr-button id="useGtk" on-click="onUseGtkClick_">
                $i18n{useGtkTheme}
              </cr-button>
            </template>
            <template is="dom-if" if="[[showUseQt_(
                prefs.extensions.theme.id.value, systemTheme_)]]" restamp>
              <cr-button id="useQt" on-click="onUseQtClick_">
                $i18n{useQtTheme}
              </cr-button>
            </template>
          </div>

        </div>
        <div id="toolbarRow" class="settings-row">
          <cr-link-row id="customizeToolbar"
              label="$i18n{customizeToolbar}"
              on-click="onCustomizeToolbarClick_" external>
          </cr-link-row>
          <template is="dom-if" if="[[showResetPinnedActionsButton_]]">
            <div class="separator"></div>
            <cr-button id="resetPinnedToolbarActions"
                on-click="onResetPinnedToolbarActionsClick_"
                aria-label="$i18n{resetToolbarToDefault}">
              $i18n{resetToDefault}
            </cr-button>
          </template>
        </div>
        <div id="colorSchemeModeRow" class="cr-row"

            hidden="[[!showColorSchemeMode_(prefs.extensions.theme.id.value,
              systemTheme_)]]"

        >
          <div id="colorSchemeModeLabel" class="flex cr-padded-text"
              aria-hidden="true">
            $i18n{colorSchemeMode}
          </div>
          <select id="colorSchemeModeSelect" class="md-select"
              on-change="onColorSchemeModeChange_"
              aria-labelledby="colorSchemeModeLabel">
            <template is="dom-repeat" items="[[colorSchemeModeOptions_]]">
              <option value="[[item.value]]"
                  selected="[[isSelectedColorSchemeMode_(
                      item.value, selectedColorSchemeMode_)]]">
                [[item.name]]
              </option>
            </template>
          </select>
        </div>
        <div
            class="hr"
            hidden="[[!showHr_(
                pageVisibility.setTheme, pageVisibility.homeButton)]]">
        </div>
        <settings-toggle-button elide-label
            hidden="[[!pageVisibility.homeButton]]"
            pref="{{prefs.browser.show_home_button}}"
            label="$i18n{showHomeButton}"
            sub-label="[[getShowHomeSubLabel_(
                prefs.browser.show_home_button.value,
                prefs.homepage_is_newtabpage.value,
                prefs.homepage.value)]]">
        </settings-toggle-button>
        <template is="dom-if" if="[[prefs.browser.show_home_button.value]]">
          <div id="home-button-options" class="list-frame"
              hidden="[[!pageVisibility.homeButton]]">
            <settings-radio-group pref="{{prefs.homepage_is_newtabpage}}">
              <controlled-radio-button class="list-item" name="true"
                  pref="[[prefs.homepage_is_newtabpage]]"
                  label="$i18n{homePageNtp}" no-extension-indicator>
              </controlled-radio-button>
              <controlled-radio-button id="custom-input" class="list-item"
                  name="false" pref="[[prefs.homepage_is_newtabpage]]"
                  no-extension-indicator>
                <!-- TODO(dbeam): this can show double indicators when both
                     homepage and whether to use the NTP as the homepage are
                     managed. -->
                <home-url-input id="customHomePage" pref="{{prefs.homepage}}"
                    can-tab="[[!prefs.homepage_is_newtabpage.value]]">
                </home-url-input>
              </controlled-radio-button>
              <template is="dom-if" if="[[prefs.homepage.extensionId]]">
                <extension-controlled-indicator
                    extension-id="[[prefs.homepage.extensionId]]"
                    extension-can-be-disabled="[[
                        prefs.homepage.extensionCanBeDisabled]]"
                    extension-name="[[prefs.homepage.controlledByName]]"
                    on-disable-extension="onDisableExtension_">
                </extension-controlled-indicator>
              </template>
            </settings-radio-group>
          </div>
        </template>
        <div
            class="hr"
            hidden="[[!showHr_(
                pageVisibility.homeButton, pageVisibility.bookmarksBar)]]">
        </div>
        <settings-toggle-button
            hidden="[[!pageVisibility.bookmarksBar]]"
            pref="{{prefs.bookmark_bar.show_on_all_tabs}}"
            label="$i18n{showBookmarksBar}">
        </settings-toggle-button>

        <settings-toggle-button class="hr" id="showSavedTabGroups"
            pref="{{prefs.bookmark_bar.show_tab_groups}}"
            label="$i18n{showTabGroupsInBookmarksBar}">
        </settings-toggle-button>

        <settings-toggle-button class="hr" id="autoPinNewTabGroups"
            pref="{{prefs.auto_pin_new_tab_groups}}"
            label="$i18n{autoPinNewTabGroups}">
        </settings-toggle-button>

        <template is="dom-if" if="[[showTabSearchPositionSettings_]]" restamp>
          <div class="cr-row" id="tabSearchPositionRow">
            <div class="flex cr-padded-text" aria-hidden="true">
              $i18n{tabSearchPosition}
            </div>
            <template is="dom-if" if="[[showTabSearchPositionRestartButton_]]"
                restamp>
              <cr-button id="tabSearchPositionRestart" role="alert"
                  on-click="onTabSearchPositionRestartClick_">
                $i18n{restart}
              </cr-button>
            </template>
            <settings-dropdown-menu id="tabSearchPositionDropdown"
                label="$i18n{tabSearchPosition}"
                pref="{{prefs.tab_search.is_right_aligned}}"
                menu-options="[[tabSearchOptions_]]">
            </settings-dropdown-menu>
          </div>
        </template>
        <div class="cr-row">
          <div class="flex cr-padded-text" aria-hidden="true">
            $i18n{sidePanelPosition}
          </div>
          <settings-dropdown-menu id="sidePanelPosition"
              label="$i18n{sidePanelPosition}"
              pref="{{prefs.side_panel.is_right_aligned}}"
              menu-options="[[sidePanelOptions_]]">
          </settings-dropdown-menu>
        </div>
        <template is="dom-if" if="[[!showHoverCardImagesOption_]]">
          <div class="hr" hidden="[[!pageVisibility.hoverCard]]"></div>
          <settings-toggle-button id="hoverCardMemoryUsageToggle"
              hidden="[[!pageVisibility.hoverCard]]"
              pref="{{prefs.browser.hovercard.memory_usage_enabled}}"
              label="$i18n{showHoverCardMemoryUsageStandalone}">
          </settings-toggle-button>
        </template>
        <template is="dom-if" if="[[showHoverCardImagesOption_]]">
          <div class="cr-row" hidden="[[!pageVisibility.hoverCard]]">
            $i18n{hoverCardTitle}
          </div>
          <div class="list-frame hover-card-toggles">
            <settings-toggle-button id="hoverCardImagesToggle"
                hidden="[[!pageVisibility.hoverCard]]"
                on-settings-boolean-control-change="onHoverCardImagesToggleChange_"
                pref="{{prefs.browser.hovercard.image_previews_enabled}}"
                label="$i18n{showHoverCardImages}">
            </settings-toggle-button>
            <settings-toggle-button id="hoverCardMemoryUsageToggle" class="hr"
                hidden="[[!pageVisibility.hoverCard]]"
                pref="{{prefs.browser.hovercard.memory_usage_enabled}}"
                label="$i18n{showHoverCardMemoryUsage}">
            </settings-toggle-button>
          </div>
        </template>


        <div class="hr" hidden="[[!pageVisibility.bookmarksBar]]"></div>
        <settings-toggle-button
            hidden="[[!showCustomChromeFrame_]]"
            pref="{{prefs.browser.custom_chrome_frame}}"
            label="$i18n{showWindowDecorations}"
            inverted>
        </settings-toggle-button>

        <div class="cr-row">
          <div class="flex cr-padded-text" aria-hidden="true">
            $i18n{fontSize}
          </div>
          <settings-dropdown-menu id="defaultFontSize" label="$i18n{fontSize}"
              pref="{{prefs.webkit.webprefs.default_font_size}}"
              menu-options="[[fontSizeOptions_]]">
          </settings-dropdown-menu>
        </div>
        <cr-link-row class="hr" id="customize-fonts-subpage-trigger"
            label="$i18n{customizeFonts}" on-click="onCustomizeFontsClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
        <div class="cr-row" hidden="[[!pageVisibility.pageZoom]]">
          <div id="pageZoom" class="flex cr-padded-text" aria-hidden="true">
            $i18n{pageZoom}
          </div>
          <select id="zoomLevel" class="md-select" aria-labelledby="pageZoom"
              on-change="onZoomLevelChange_">
            <template is="dom-repeat" items="[[pageZoomLevels_]]">
              <option value="[[item]]"
                  selected="[[zoomValuesEqual_(item, defaultZoom_)]]">
                [[formatZoom_(item)]]%
              </option>
            </template>
          </select>
        </div>

      </div>
      <settings-toggle-button class="hr" id="splitViewDragAndDrop"
          hidden="[[!showSplitViewDragAndDropSetting_]]"
          pref="{{prefs.browser.split_view_drag_and_drop_enabled}}"
          label="$i18n{allowSplitViewDragAndDrop}">
      </settings-toggle-button>
    </settings-section>
    <template is="dom-if" if="[[showManagedThemeDialog_]]" restamp>
      <managed-dialog on-close="onManagedDialogClosed_"
          title="$i18n{themeManagedDialogTitle}"
          body="$i18n{themeManagedDialogBody}">
      </managed-dialog>
    </template>
<!--_html_template_end_-->`}const SIZE_DIFFERENCE_FIXED_STANDARD=3;const AUTOGENERATED_THEME_ID="autogenerated_theme_id";const USER_COLOR_THEME_ID="user_color_theme_id";var SystemTheme;(function(SystemTheme){SystemTheme[SystemTheme["DEFAULT"]=0]="DEFAULT";SystemTheme[SystemTheme["GTK"]=1]="GTK";SystemTheme[SystemTheme["QT"]=2]="QT"})(SystemTheme||(SystemTheme={}));const SettingsAppearancePageElementBase=SettingsViewMixin(RelaunchMixin(I18nMixin(PrefsMixin(PolymerElement))));class SettingsAppearancePageElement extends SettingsAppearancePageElementBase{static get is(){return"settings-appearance-page"}static get template(){return getTemplate$C()}static get properties(){return{pageVisibility_:{type:Object,value:()=>pageVisibility?.appearance},defaultZoom_:Number,isWallpaperPolicyControlled_:{type:Boolean,value:true},colorSchemeModeOptions_:{readOnly:true,type:Array,value(){return[{value:ColorSchemeMode.kLight,name:loadTimeData.getString("lightMode")},{value:ColorSchemeMode.kDark,name:loadTimeData.getString("darkMode")},{value:ColorSchemeMode.kSystem,name:loadTimeData.getString("systemMode")}]}},selectedColorSchemeMode_:Number,fontSizeOptions_:{readOnly:true,type:Array,value(){return[{value:9,name:loadTimeData.getString("verySmall")},{value:12,name:loadTimeData.getString("small")},{value:16,name:loadTimeData.getString("medium")},{value:20,name:loadTimeData.getString("large")},{value:24,name:loadTimeData.getString("veryLarge")}]}},pageZoomLevels_:Array,themeSublabel_:String,themeUrl_:String,systemTheme_:{type:Object,value:SystemTheme.DEFAULT},isForcedTheme_:{type:Boolean,computed:"computeIsForcedTheme_("+"prefs.autogenerated.theme.policy.color.controlledBy)"},showCustomChromeFrame_:{type:Boolean,value(){return loadTimeData.getBoolean("showCustomChromeFrame")}},showHoverCardImagesOption_:{type:Boolean,value(){return loadTimeData.getBoolean("showHoverCardImagesOption")}},showManagedThemeDialog_:Boolean,sidePanelOptions_:{readOnly:true,type:Array,value(){return[{value:"true",name:loadTimeData.getString("uiFeatureAlignRight")},{value:"false",name:loadTimeData.getString("uiFeatureAlignLeft")}]}},showTabSearchPositionSettings_:{type:Boolean,value(){return loadTimeData.getBoolean("showTabSearchPositionSettings")}},showTabSearchPositionRestartButton_:{type:Boolean,value:false},showSplitViewDragAndDropSetting_:{type:Boolean,value(){return loadTimeData.getBoolean("showSplitViewDragAndDropSetting")}},showResetPinnedActionsButton_:{type:Boolean,value:false},tabSearchOptions_:{readOnly:true,type:Array,value(){return[{value:"true",name:loadTimeData.getString("uiFeatureAlignRight")},{value:"false",name:loadTimeData.getString("uiFeatureAlignLeft")}]}}}}static get observers(){return["defaultFontSizeChanged_(prefs.webkit.webprefs.default_font_size.value)","themeChanged_("+"prefs.extensions.theme.id.value, systemTheme_, isForcedTheme_)","updateShowTabSearchRestartButton_("+"prefs.tab_search.is_right_aligned.value)","systemThemePrefChanged_(prefs.extensions.theme.system_theme.value)","toolbarPinningStateChanged_(prefs.toolbar.pinned_actions.value,"+"prefs.browser.show_home_button.value,"+"prefs.browser.show_forward_button.value)"]}appearanceBrowserProxy_=AppearanceBrowserProxyImpl.getInstance();colorSchemeModeHandler_=CustomizeColorSchemeModeBrowserProxy.getInstance().handler;colorSchemeModeCallbackRouter_=CustomizeColorSchemeModeBrowserProxy.getInstance().callbackRouter;setColorSchemeModeListenerId_=null;ready(){super.ready();this.$.defaultFontSize.menuOptions=this.fontSizeOptions_;this.appearanceBrowserProxy_.getDefaultZoom().then((zoom=>{this.defaultZoom_=zoom}));this.pageZoomLevels_=JSON.parse(loadTimeData.getString("presetZoomFactors"));this.setColorSchemeModeListenerId_=this.colorSchemeModeCallbackRouter_.setColorSchemeMode.addListener((colorSchemeMode=>{this.selectedColorSchemeMode_=this.colorSchemeModeOptions_.find((mode=>colorSchemeMode===mode.value))?.value}));this.colorSchemeModeHandler_.initializeColorSchemeMode()}disconnectedCallback(){super.disconnectedCallback();assert(this.setColorSchemeModeListenerId_);this.colorSchemeModeCallbackRouter_.removeListener(this.setColorSchemeModeListenerId_)}formatZoom_(zoom){return Math.round(zoom*100)}getShowHomeSubLabel_(showHomepage,isNtp,homepageValue){if(!showHomepage){return this.i18n("homeButtonDisabled")}if(isNtp){return this.i18n("homePageNtp")}return homepageValue||this.i18n("customWebAddress")}onCustomizeFontsClick_(){Router.getInstance().navigateTo(routes.FONTS)}onDisableExtension_(){this.dispatchEvent(new CustomEvent("refresh-pref",{bubbles:true,composed:true,detail:"homepage"}))}defaultFontSizeChanged_(value){this.set("prefs.webkit.webprefs.default_fixed_font_size.value",value-SIZE_DIFFERENCE_FIXED_STANDARD)}onThemeClick_(){this.appearanceBrowserProxy_.openCustomizeChrome()}onCustomizeToolbarClick_(){this.appearanceBrowserProxy_.openCustomizeChromeToolbarSection()}onUseDefaultClick_(){if(this.isForcedTheme_){this.showManagedThemeDialog_=true;return}this.appearanceBrowserProxy_.useDefaultTheme()}onResetPinnedToolbarActionsClick_(){this.appearanceBrowserProxy_.resetPinnedToolbarActions()}systemThemePrefChanged_(systemTheme){this.systemTheme_=systemTheme}showUseClassic_(themeId){return!!themeId||this.systemTheme_!==SystemTheme.DEFAULT}showUseGtk_(themeId){return(!!themeId||this.systemTheme_!==SystemTheme.GTK)&&!this.appearanceBrowserProxy_.isChildAccount()}showUseQt_(themeId){return(!!themeId||this.systemTheme_!==SystemTheme.QT)&&!this.appearanceBrowserProxy_.isChildAccount()}showThemesSecondary_(themeId){return!!themeId||!this.appearanceBrowserProxy_.isChildAccount()}onUseGtkClick_(){if(this.isForcedTheme_){this.showManagedThemeDialog_=true;return}this.appearanceBrowserProxy_.useGtkTheme()}onUseQtClick_(){if(this.isForcedTheme_){this.showManagedThemeDialog_=true;return}this.appearanceBrowserProxy_.useQtTheme()}showColorSchemeMode_(themeId){return!!themeId||this.systemTheme_!==SystemTheme.GTK&&this.systemTheme_!==SystemTheme.QT}themeChanged_(themeId){if(this.prefs===undefined||this.systemTheme_===undefined){return}if(themeId.length>0&&themeId!==AUTOGENERATED_THEME_ID&&themeId!==USER_COLOR_THEME_ID&&!this.isForcedTheme_){assert(this.systemTheme_===SystemTheme.DEFAULT);this.appearanceBrowserProxy_.getThemeInfo(themeId).then((info=>{this.themeSublabel_=info.name}));this.themeUrl_="https://chrome.google.com/webstore/detail/"+themeId;return}this.themeUrl_="";if(themeId===AUTOGENERATED_THEME_ID||themeId===USER_COLOR_THEME_ID||this.isForcedTheme_){this.themeSublabel_=this.i18n("chromeColors");return}let i18nId;switch(this.systemTheme_){case SystemTheme.GTK:i18nId="gtkTheme";break;case SystemTheme.QT:i18nId="qtTheme";break;default:i18nId="classicTheme";break}this.themeSublabel_=this.i18n(i18nId)}computeIsForcedTheme_(){return!!this.getPref("autogenerated.theme.policy.color").controlledBy}async toolbarPinningStateChanged_(){this.showResetPinnedActionsButton_=!await this.appearanceBrowserProxy_.pinnedToolbarActionsAreDefault()}isSelectedColorSchemeMode_(colorSchemeMode){return colorSchemeMode===this.selectedColorSchemeMode_}onColorSchemeModeChange_(){this.colorSchemeModeHandler_.setColorSchemeMode(parseInt(this.$.colorSchemeModeSelect.value,10))}onZoomLevelChange_(){chrome.settingsPrivate.setDefaultZoom(parseFloat(this.$.zoomLevel.value))}zoomValuesEqual_(zoom1,zoom2){return Math.abs(zoom1-zoom2)<=.001}showHr_(previousIsVisible,nextIsVisible){return previousIsVisible&&nextIsVisible}onHoverCardImagesToggleChange_(event){const enabled=event.target.checked;this.appearanceBrowserProxy_.recordHoverCardImagesEnabledChanged(enabled)}onManagedDialogClosed_(){this.showManagedThemeDialog_=false}onTabSearchPositionRestartClick_(e){e.stopPropagation();this.performRestart(RestartType.RESTART)}updateShowTabSearchRestartButton_(newValue){this.showTabSearchPositionRestartButton_=newValue!==loadTimeData.getBoolean("tabSearchIsRightAlignedAtStartup")}getFocusConfig(){const map=new Map;if(routes.FONTS){map.set(routes.FONTS.path,"#customize-fonts-subpage-trigger")}return map}getAssociatedControlFor(childViewId){assert(childViewId==="fonts");const control=this.shadowRoot.querySelector("#customize-fonts-subpage-trigger");assert(control);return control}}customElements.define(SettingsAppearancePageElement.is,SettingsAppearancePageElement);function getTemplate$B(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-appearance-page slot="view" id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.APPEARANCE.path]]">
  </settings-appearance-page>

  <settings-appearance-fonts-page slot="view" id="fonts"
      data-parent-view-id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.FONTS.path]]">
  </settings-appearance-fonts-page>
</cr-view-manager>
<!--_html_template_end_-->`}const SettingsAppearancePageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsAppearancePageIndexElement extends SettingsAppearancePageIndexElementBase{static get is(){return"settings-appearance-page-index"}static get template(){return getTemplate$B()}static get properties(){return{prefs:Object,routes_:{type:Object,value:()=>routes}}}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.APPEARANCE:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.FONTS:this.$.viewManager.switchView("fonts","no-animation","no-animation");break;case routes.BASIC:this.$.viewManager.switchView("parent","no-animation","no-animation");break}}))}}customElements.define(SettingsAppearancePageIndexElement.is,SettingsAppearancePageIndexElement);function getTemplate$A(){return html$1`<!--_html_template_start_-->    <style include="settings-shared">cr-link-row{--cr-icon-button-margin-start:20px}cr-link-row:not([hidden])~cr-link-row{border-top:var(--cr-separator-line)}
    </style>
    <settings-section page-title="$i18n{autofillPageTitle}">
      <div route-path="default">
        <cr-link-row id="passwordManagerButton"
            label="$i18n{localPasswordManager}" on-click="onPasswordsClick_"
            role-description="$i18n{subpageArrowRoleDescription}"
            start-icon="cr20:password" external>
        </cr-link-row>
        <cr-link-row id="paymentManagerButton"
            start-icon="settings20:credit-card" label="$i18n{creditCards}"
            on-click="onPaymentsClick_"
            role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
        <cr-link-row id="addressesManagerButton"
            start-icon="settings:location-on" label="$i18n{addressesTitle}"
            sub-label="[[addressesSublabel_()]]"
            on-click="onAddressesClick_"
            role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
        <template is="dom-if" if="[[autofillAiAvailable_]]">
          <cr-link-row id="autofillAiManagerButton"
              start-icon="settings20:text-analysis"
              label="$i18n{autofillAiPageTitle}"
              sub-label="$i18n{autofillAiDescription}"
              on-click="onAutofillAiClick_"></cr-link-row>
        </template>
      </div>
    </settings-section>
<!--_html_template_end_-->`}const SettingsAutofillPageElementBase=SettingsViewMixin(PrefsMixin(I18nMixin(PolymerElement)));class SettingsAutofillPageElement extends SettingsAutofillPageElementBase{static get is(){return"settings-autofill-page"}static get template(){return getTemplate$A()}static get properties(){return{autofillAiAvailable_:{type:Boolean,value(){return loadTimeData.getBoolean("showAutofillAiControl")}}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();onAddressesClick_(){this.metricsBrowserProxy_.recordAutofillSettingsReferrer("Autofill.AddressesSettingsPage.VisitReferrer",AutofillSettingsReferrer.AUTOFILL_AND_PASSWORDS_PAGE);Router.getInstance().navigateTo(routes.ADDRESSES)}onPaymentsClick_(){this.metricsBrowserProxy_.recordAutofillSettingsReferrer("Autofill.PaymentMethodsSettingsPage.VisitReferrer",AutofillSettingsReferrer.AUTOFILL_AND_PASSWORDS_PAGE);Router.getInstance().navigateTo(routes.PAYMENTS)}onPasswordsClick_(){PasswordManagerImpl.getInstance().recordPasswordsPageAccessInSettings();PasswordManagerImpl.getInstance().showPasswordManager(PasswordManagerPage.PASSWORDS)}onAutofillAiClick_(){this.metricsBrowserProxy_.recordAutofillSettingsReferrer("Autofill.FormsAiSettingsPage.VisitReferrer",AutofillSettingsReferrer.AUTOFILL_AND_PASSWORDS_PAGE);Router.getInstance().navigateTo(routes.AUTOFILL_AI)}addressesSublabel_(){return loadTimeData.getBoolean("plusAddressEnabled")?this.i18n("addressesSublabel"):""}getFocusConfig(){const map=new Map;if(routes.PAYMENTS){map.set(routes.PAYMENTS.path,"#paymentManagerButton")}if(routes.ADDRESSES){map.set(routes.ADDRESSES.path,"#addressesManagerButton")}return map}getAssociatedControlFor(childViewId){const ids=["addresses","autofillAi","payments"];assert(ids.includes(childViewId));let triggerId=null;switch(childViewId){case"addresses":triggerId="addressesManagerButton";break;case"autofillAi":assert(this.autofillAiAvailable_);triggerId="autofillAiManagerButton";break;case"payments":triggerId="paymentManagerButton";break}assert(triggerId);const control=this.shadowRoot.querySelector(`#${triggerId}`);assert(control);return control}}customElements.define(SettingsAutofillPageElement.is,SettingsAutofillPageElement);function getTemplate$z(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-autofill-page slot="view" id="parent" prefs="{{prefs}}">
  </settings-autofill-page>

  <settings-payments-section slot="view" id="payments" prefs="{{prefs}}"
      data-parent-view-id="parent">
  </settings-payments-section>

  <settings-autofill-section slot="view" id="addresses" prefs="{{prefs}}"
      data-parent-view-id="parent">
  </settings-autofill-section>

  <template is="dom-if" if="[[autofillAiAvailable_]]">
    <settings-autofill-ai-section slot="view" id="autofillAi" prefs="{{prefs}}"
        data-parent-view-id="parent">
    </settings-autofill-ai-section>
  </template>


</cr-view-manager>
<!--_html_template_end_-->`}const SettingsAutofillPageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsAutofillPageIndexElement extends SettingsAutofillPageIndexElementBase{static get is(){return"settings-autofill-page-index"}static get template(){return getTemplate$z()}static get properties(){return{prefs:Object,autofillAiAvailable_:{type:Boolean,value(){return loadTimeData.getBoolean("showAutofillAiControl")}}}}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.AUTOFILL:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.PAYMENTS:this.$.viewManager.switchView("payments","no-animation","no-animation");break;case routes.ADDRESSES:this.$.viewManager.switchView("addresses","no-animation","no-animation");break;case routes.AUTOFILL_AI:assert(this.autofillAiAvailable_);this.$.viewManager.switchView("autofillAi","no-animation","no-animation");break;case routes.BASIC:this.$.viewManager.switchView("parent","no-animation","no-animation");break}}))}}customElements.define(SettingsAutofillPageIndexElement.is,SettingsAutofillPageIndexElement);function getTemplate$y(){return html$1`<!--_html_template_start_-->    <style include="settings-shared"></style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[dialogTitle_]]</div>
      <div slot="body">
        <cr-input id="url" label="$i18n{onStartupSiteUrl}"
            value="{{url_}}" on-input="validate_" spellcheck="false"
            maxlength="[[urlLimit_]]" invalid="[[hasError_(error_)]]" autofocus
            error-message="[[errorMessage_('$i18nPolymer{onStartupInvalidUrl}',
                '$i18nPolymer{onStartupUrlTooLong}', error_)]]">
        </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelClick_"
            id="cancel">$i18n{cancel}</cr-button>
        <cr-button id="actionButton" class="action-button"
            on-click="onActionButtonClick_">[[actionButtonText_]]</cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}class StartupUrlsPageBrowserProxyImpl{loadStartupPages(){chrome.send("onStartupPrefsPageLoad")}useCurrentPages(){chrome.send("setStartupPagesToCurrentPages")}validateStartupPage(url){return sendWithPromise("validateStartupPage",url)}addStartupPage(url){return sendWithPromise("addStartupPage",url)}editStartupPage(modelIndex,url){return sendWithPromise("editStartupPage",modelIndex,url)}removeStartupPage(index){chrome.send("removeStartupPage",[index])}static getInstance(){return instance$5||(instance$5=new StartupUrlsPageBrowserProxyImpl)}static setInstance(obj){instance$5=obj}}let instance$5=null;var UrlInputError;(function(UrlInputError){UrlInputError[UrlInputError["NONE"]=0]="NONE";UrlInputError[UrlInputError["INVALID_URL"]=1]="INVALID_URL";UrlInputError[UrlInputError["TOO_LONG"]=2]="TOO_LONG"})(UrlInputError||(UrlInputError={}));class SettingsStartupUrlDialogElement extends PolymerElement{static get is(){return"settings-startup-url-dialog"}static get template(){return getTemplate$y()}static get properties(){return{error_:{type:Number,value:UrlInputError.NONE},url_:String,urlLimit_:{readOnly:true,type:Number,value:100*1024},model:Object,dialogTitle_:String,actionButtonText_:String}}browserProxy_=StartupUrlsPageBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();if(this.model){this.dialogTitle_=loadTimeData.getString("onStartupEditPage");this.actionButtonText_=loadTimeData.getString("save");this.$.actionButton.disabled=false;this.url_=this.model.url}else{this.dialogTitle_=loadTimeData.getString("onStartupAddNewPage");this.actionButtonText_=loadTimeData.getString("add");this.$.actionButton.disabled=true}this.$.dialog.showModal()}hasError_(){return this.error_!==UrlInputError.NONE}errorMessage_(invalidUrl,tooLong){return["",invalidUrl,tooLong][this.error_]}onCancelClick_(){this.$.dialog.close()}onActionButtonClick_(){const whenDone=this.model?this.browserProxy_.editStartupPage(this.model.modelIndex,this.url_):this.browserProxy_.addStartupPage(this.url_);whenDone.then((success=>{if(success){this.$.dialog.close()}}))}validate_(){if(this.url_.length===0){this.$.actionButton.disabled=true;this.error_=UrlInputError.NONE;return}if(this.url_.length>=this.urlLimit_){this.$.actionButton.disabled=true;this.error_=UrlInputError.TOO_LONG;return}this.browserProxy_.validateStartupPage(this.url_).then((isValid=>{this.$.actionButton.disabled=!isValid;this.error_=isValid?UrlInputError.NONE:UrlInputError.INVALID_URL}))}}customElements.define(SettingsStartupUrlDialogElement.is,SettingsStartupUrlDialogElement);function getTemplate$x(){return html$1`<!--_html_template_start_-->    <style include="settings-shared">.hide-overflow{overflow:hidden}
    </style>
    <div class="list-item" focus-row-container>
      <site-favicon url="[[model.url]]"></site-favicon>
      <div class="middle hide-overflow">
        <div class="text-elide">[[model.title]]</div>
        <div class="text-elide secondary">[[model.url]]</div>
      </div>
      <template is="dom-if" if="[[editable]]">
        <cr-icon-button class="icon-more-vert" id="dots" on-click="onDotsClick_"
            title="$i18n{moreActions}" focus-row-control focus-type="menu">
        </cr-icon-button>
        <cr-lazy-render id="menu">
          <template>
            <cr-action-menu role-description="$i18n{menu}">
              <button class="dropdown-item" on-click="onEditClick_">
                $i18n{edit}
              </button>
              <button class="dropdown-item" id="remove"
                  on-click="onRemoveClick_">
                $i18n{onStartupRemove}
              </button>
            </cr-action-menu>
          </template>
        </cr-lazy-render>
      </template>
    </div>
<!--_html_template_end_-->`}const EDIT_STARTUP_URL_EVENT="edit-startup-url";const SettingsStartupUrlEntryElementBase=FocusRowMixin(PolymerElement);class SettingsStartupUrlEntryElement extends SettingsStartupUrlEntryElementBase{static get is(){return"settings-startup-url-entry"}static get template(){return getTemplate$x()}static get properties(){return{editable:{type:Boolean,reflectToAttribute:true},model:Object}}onRemoveClick_(){this.shadowRoot.querySelector("cr-action-menu").close();StartupUrlsPageBrowserProxyImpl.getInstance().removeStartupPage(this.model.modelIndex)}onEditClick_(e){e.preventDefault();this.shadowRoot.querySelector("cr-action-menu").close();this.dispatchEvent(new CustomEvent(EDIT_STARTUP_URL_EVENT,{bubbles:true,composed:true,detail:{model:this.model,anchor:this.shadowRoot.querySelector("#dots")}}))}onDotsClick_(){const actionMenu=this.shadowRoot.querySelector("#menu").get();const dots=this.shadowRoot.querySelector("#dots");assert(dots);actionMenu.showAt(dots)}}customElements.define(SettingsStartupUrlEntryElement.is,SettingsStartupUrlEntryElement);function getTemplate$w(){return html$1`<!--_html_template_start_-->    <style include="settings-shared action-link">#editOptions>div{border-top:var(--cr-separator-line)}#outer{display:flex;flex-direction:column;max-height:355px}#container settings-startup-url-entry{cursor:default}
    </style>
    <div id="outer" class="flex list-frame">
      <div id="container" class="scroll-container" scrollable>
        <iron-list items="[[startupPages_]]" scroll-target="container"
            preserve-focus risk-selection class="cr-separators">
          <template>
            <settings-startup-url-entry model="[[item]]" first$="[[!index]]"
                tabindex$="[[tabIndex]]" iron-list-tab-index="[[tabIndex]]"
                last-focused="{{lastFocused_}}" list-blurred="{{listBlurred_}}"
                focus-row-index="[[index]]" editable="[[shouldAllowUrlsEdit_(
                    prefs.session.startup_urls.enforcement)]]">
            </settings-startup-url-entry>
          </template>
        </iron-list>
      </div>
    </div>
    <div id="editOptions" class="list-frame">
      <template is="dom-if" if="[[shouldAllowUrlsEdit_(
          prefs.session.startup_urls.enforcement)]]" restamp>
        <div class="list-item" id="addPage">
          <a is="action-link" class="list-button" on-click="onAddPageClick_">
            $i18n{onStartupAddNewPage}
          </a>
        </div>
        <div class="list-item" id="useCurrentPages">
          <a is="action-link" class="list-button"
              on-click="onUseCurrentPagesClick_">
            $i18n{onStartupUseCurrent}
          </a>
        </div>
      </template>
      <template is="dom-if" if="[[prefs.session.startup_urls.extensionId]]"
          restamp>
        <extension-controlled-indicator
            extension-id="[[prefs.session.startup_urls.extensionId]]"
            extension-name="[[prefs.session.startup_urls.controlledByName]]"
            extension-can-be-disabled="[[
                prefs.session.startup_urls.extensionCanBeDisabled]]">
        </extension-controlled-indicator>
      </template>
    </div>
    <template is="dom-if" if="[[showStartupUrlDialog_]]" restamp>
      <settings-startup-url-dialog model="[[startupUrlDialogModel_]]"
          on-close="destroyUrlDialog_">
      </settings-startup-url-dialog>
    </template>
<!--_html_template_end_-->`}const SettingsStartupUrlsPageElementBase=ScrollableMixin(WebUiListenerMixin(PolymerElement));class SettingsStartupUrlsPageElement extends SettingsStartupUrlsPageElementBase{static get is(){return"settings-startup-urls-page"}static get template(){return getTemplate$w()}static get properties(){return{prefs:Object,startupPages_:Array,showStartupUrlDialog_:Boolean,startupUrlDialogModel_:Object,lastFocused_:Object,listBlurred_:Boolean}}browserProxy_=StartupUrlsPageBrowserProxyImpl.getInstance();startupUrlDialogAnchor_;constructor(){super();this.startupUrlDialogAnchor_=null}connectedCallback(){super.connectedCallback();this.addWebUiListener("update-startup-pages",(startupPages=>{if(this.startupUrlDialogModel_){this.destroyUrlDialog_()}this.startupPages_=startupPages;this.updateScrollableContents()}));this.browserProxy_.loadStartupPages();this.addEventListener(EDIT_STARTUP_URL_EVENT,(event=>{const e=event;this.startupUrlDialogModel_=e.detail.model;this.startupUrlDialogAnchor_=e.detail.anchor;this.showStartupUrlDialog_=true;e.stopPropagation()}))}onAddPageClick_(e){e.preventDefault();this.showStartupUrlDialog_=true;this.startupUrlDialogAnchor_=this.shadowRoot.querySelector("#addPage a[is=action-link]")}destroyUrlDialog_(){this.showStartupUrlDialog_=false;this.startupUrlDialogModel_=null;if(this.startupUrlDialogAnchor_){focusWithoutInk(this.startupUrlDialogAnchor_);this.startupUrlDialogAnchor_=null}}onUseCurrentPagesClick_(){this.browserProxy_.useCurrentPages()}shouldAllowUrlsEdit_(){return this.get("prefs.session.startup_urls.enforcement")!==chrome.settingsPrivate.Enforcement.ENFORCED}}customElements.define(SettingsStartupUrlsPageElement.is,SettingsStartupUrlsPageElement);class OnStartupBrowserProxyImpl{getNtpExtension(){return sendWithPromise("getNtpExtension")}static getInstance(){return instance$4||(instance$4=new OnStartupBrowserProxyImpl)}static setInstance(obj){instance$4=obj}}let instance$4=null;function getTemplate$v(){return html$1`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared"></style>
  <settings-section page-title="$i18n{onStartup}"
      class="cr-centered-card-container">
    <div class="cr-row first">
      <settings-radio-group id="onStartupRadioGroup"
          class="flex"
          pref="{{prefs.session.restore_on_startup}}"
          group-aria-label="$i18n{onStartup}">
        <controlled-radio-button name="[[getName_(prefValuesEnum_.OPEN_NEW_TAB)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupOpenNewTab}"
            no-extension-indicator>
        </controlled-radio-button>
        <template is="dom-if" if="[[ntpExtension_]]">
          <extension-controlled-indicator
              extension-id="[[ntpExtension_.id]]"
              extension-name="[[ntpExtension_.name]]"
              extension-can-be-disabled="[[ntpExtension_.canBeDisabled]]">
          </extension-controlled-indicator>
        </template>
        <controlled-radio-button name="[[getName_(prefValuesEnum_.CONTINUE)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupContinue}">
        </controlled-radio-button>
        <controlled-radio-button name="[[getName_(prefValuesEnum_.OPEN_SPECIFIC)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupOpenSpecific}">
        </controlled-radio-button>
        <controlled-radio-button name="[[getName_(
          prefValuesEnum_.CONTINUE_AND_OPEN_SPECIFIC)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupContinueAndOpenSpecific}"
            hidden="[[!showContinueAndOpenSpecific_(
              prefs.session.restore_on_startup)]]">
        </controlled-radio-button>
      </settings-radio-group>
    </div>
    <template is="dom-if"
        if="[[showStartupUrls_(prefs.session.restore_on_startup.value)]]">
      <settings-startup-urls-page prefs="[[prefs]]">
      </settings-startup-urls-page>
    </template>
  </settings-section>
<!--_html_template_end_-->`}var PrefValues;(function(PrefValues){PrefValues[PrefValues["CONTINUE"]=1]="CONTINUE";PrefValues[PrefValues["OPEN_NEW_TAB"]=5]="OPEN_NEW_TAB";PrefValues[PrefValues["OPEN_SPECIFIC"]=4]="OPEN_SPECIFIC";PrefValues[PrefValues["CONTINUE_AND_OPEN_SPECIFIC"]=6]="CONTINUE_AND_OPEN_SPECIFIC"})(PrefValues||(PrefValues={}));const SettingsOnStartupPageElementBase=WebUiListenerMixin(PolymerElement);class SettingsOnStartupPageElement extends SettingsOnStartupPageElementBase{static get is(){return"settings-on-startup-page"}static get template(){return getTemplate$v()}static get properties(){return{prefs:{type:Object,notify:true},ntpExtension_:Object,prefValuesEnum_:{readOnly:true,type:Object,value:PrefValues}}}connectedCallback(){super.connectedCallback();const updateNtpExtension=ntpExtension=>{this.ntpExtension_=ntpExtension};OnStartupBrowserProxyImpl.getInstance().getNtpExtension().then(updateNtpExtension);this.addWebUiListener("update-ntp-extension",updateNtpExtension)}getName_(value){return value.toString()}showStartupUrls_(restoreOnStartup){return restoreOnStartup===PrefValues.OPEN_SPECIFIC||restoreOnStartup===PrefValues.CONTINUE_AND_OPEN_SPECIFIC}showContinueAndOpenSpecific_(pref){return pref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED||pref.enforcement===chrome.settingsPrivate.Enforcement.RECOMMENDED}async searchContents(query){const searchRequest=await getSearchManager().search(query,this);return searchRequest.getSearchResult()}}customElements.define(SettingsOnStartupPageElement.is,SettingsOnStartupPageElement);function getTemplate$u(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">.sync-row{align-items:center;flex:auto}#profile-icon{background:center/cover no-repeat;border-radius:20px;flex-shrink:0;height:40px;width:40px}#sync-setup{--cr-secondary-text-color:var(--settings-error-color)}#sync-not-allowed{border-top:var(--cr-separator-line);background:var(--google-grey-100)}#sync-not-allowed-text{margin-left:8px}cr-link-row{--cr-link-row-icon-width:40px;border-top:var(--cr-separator-line)}.icon-container{display:flex;flex-shrink:0;justify-content:center;width:40px}#toast{left:0;z-index:1}:host-context([dir='rtl']) #toast{left:auto;right:0}settings-sync-account-control[showing-promo]::part(banner){border-top-left-radius:var(--cr-card-border-radius);border-top-right-radius:var(--cr-card-border-radius)}settings-sync-account-control[showing-promo]::part(title){font-size:1.1rem;line-height:1.625rem}@media (prefers-color-scheme:dark){#sync-not-allowed{background:var(--google-grey-800)}}
    </style>
    <settings-section page-title="$i18n{peoplePageTitle}">
      <div>


        <template is="dom-if" if="[[shouldShowSyncAccountControl_(
            syncStatus.syncSystemEnabled, syncStatus.signedInStatus)]]" restamp>
          <settings-sync-account-control
              sync-status="[[syncStatus]]"
              prefs="{{prefs}}"
              promo-label-with-account="$i18n{peopleSignInPrompt}"
              promo-label-with-no-account="$i18n{peopleSignInPrompt}"
              promo-secondary-label-with-account=
                  "$i18n{peopleSignInPromptSecondaryWithAccount}"
              promo-secondary-label-with-no-account=
                  "$i18n{peopleSignInPromptSecondaryWithNoAccount}">
          </settings-sync-account-control>
        </template>
        <template is="dom-if" if="[[!shouldShowSyncAccountControl_(
            syncStatus.syncSystemEnabled, signinAllowed_)]]" restamp>
          <template is="dom-if" if="[[!shouldLinkToAccountSettingsPage_(
              syncStatus.signedInState)]]" restamp>
            <div id="profile-row" class="cr-row first two-line"
                actionable$="[[isProfileActionable_]]"
                on-click="onProfileClick_">
              <template is="dom-if" if="[[syncStatus]]">
                <div id="profile-icon"
                    style="background-image: [[getIconImageSet_(
                        profileIconUrl_)]]">
                </div>
                <div class="flex cr-row-gap cr-padded-text text-elide">
                  <span id="profile-name">[[profileName_]]</span>
                </div>
                <cr-icon-button class="subpage-arrow"
                    aria-label="$i18n{editPerson}"
                    aria-describedby="profile-name"
                    aria-roledescription="$i18n{subpageArrowRoleDescription}">
                </cr-icon-button>
              </template>
            </div>
          </template>
          <template is="dom-if" if="[[shouldLinkToAccountSettingsPage_(
              syncStatus.signedInState)]]" restamp>
            <cr-link-row id="account-subpage-row" on-click="onAccountClick_">
              <div id="profile-icon"
                  style="background-image: [[getIconImageSet_(
                      primaryAccountIconUrl_)]]">
              </div>
              <div class="cr-row-gap cr-padded-text flex no-min-width">
                <div id="account-name" class="text-elide">
                  [[primaryAccountName_]]
                </div>
                <div id="account-subtitle" class="secondary">
                  [[getAccountRowSubtitle_(primaryAccountEmail_, syncStatus)]]
                </div>
              </div>
            </cr-link-row>
          </template>
        </template> <!-- if="[[!shouldShowSyncAccountControl_()]]" -->

        <cr-link-row id="sync-setup"
            label="$i18n{syncAndNonPersonalizedServices}"
            on-click="onSyncClick_"
            role-description="$i18n{subpageArrowRoleDescription}"
            hidden="[[shouldHideSyncSetupLinkRow_(syncStatus)]]">
        </cr-link-row>
        <template is="dom-if" if="[[shouldHideSyncSetupLinkRow_(syncStatus)]]"
            restamp>
          <cr-link-row id="google-services"
              label="$i18n{googleServicesPageTitle}"
              on-click="onGoogleServicesClick_"
              role-description="$i18n{subpageArrowRoleDescription}">
          </cr-link-row>
        </template>

        <template is="dom-if" if="[[signinAllowed_]]">
          <cr-link-row id="manage-google-account"
              label="$i18n{manageGoogleAccount}"
              hidden="[[!shouldShowGoogleAccount_]]"
              on-click="openGoogleAccount_" external></cr-link-row>

          <cr-link-row id="edit-profile"
              label="$i18n{profileNameAndPicture}"
              on-click="onProfileClick_" ></cr-link-row>
        </template>

        <cr-link-row id="importDataDialogTrigger"
            label="$i18n{importTitle}"
            on-click="onImportDataClick_"></cr-link-row>

        <template is="dom-if" if="[[isDasherlessProfile_]]">
          <div id="sync-not-allowed" class="cr-row continuation">
            <cr-icon id="info-icon" icon="cr:info-outline"></cr-icon>
            <div id="sync-not-allowed-text" class="flex cr-padded-text">
              $i18n{syncUnavailableForNonGoogleAccount}
            </div>
          </div>
        </template>




      </div>
    </settings-section>


    <template is="dom-if" if="[[showSignoutDialog_]]" restamp>
      <settings-signout-dialog sync-status="[[syncStatus]]"
          on-close="onDisconnectDialogClosed_">
      </settings-signout-dialog>
    </template>

    <template is="dom-if" if="[[showImportDataDialog_]]" restamp>
      <settings-import-data-dialog prefs="{{prefs}}"
          on-close="onImportDataDialogClosed_">
      </settings-import-data-dialog>
    </template>

    <cr-toast duration="3000" id="toast">
      <span>$i18n{syncSettingsSavedToast}</span>
    </cr-toast>
<!--_html_template_end_-->`}const SettingsPeoplePageElementBase=SettingsViewMixin(RouteObserverMixin(WebUiListenerMixin(PolymerElement)));class SettingsPeoplePageElement extends SettingsPeoplePageElementBase{static get is(){return"settings-people-page"}static get template(){return getTemplate$u()}static get properties(){return{prefs:{type:Object,notify:true},signinAllowed_:{type:Boolean,value(){return loadTimeData.getBoolean("signinAllowed")}},isDasherlessProfile_:{type:Boolean,value(){return loadTimeData.getBoolean("isDasherlessProfile")}},storedAccounts:Object,syncStatus:Object,authToken_:{type:String,value:""},profileIconUrl_:String,isProfileActionable_:{type:Boolean,value(){{return true}},readOnly:true},profileName_:String,shouldShowGoogleAccount_:{type:Boolean,value:false,computed:"computeShouldShowGoogleAccount_(storedAccounts, syncStatus,"+"storedAccounts.length, syncStatus.signedIn, syncStatus.hasError)"},replaceSyncPromosWithSignInPromos_:{type:Boolean,value:()=>loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")},showImportDataDialog_:{type:Boolean,value:false},showSignoutDialog_:Boolean,primaryAccountName_:String,primaryAccountEmail_:String,primaryAccountIconUrl_:String}}syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();{ProfileInfoBrowserProxyImpl.getInstance().getProfileInfo().then(this.handleProfileInfo_.bind(this));this.addWebUiListener("profile-info-changed",this.handleProfileInfo_.bind(this))}this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));this.addWebUiListener("sync-status-changed",this.handleSyncStatus_.bind(this));this.syncBrowserProxy_.getStoredAccounts().then(this.handleStoredAccounts_.bind(this));this.addWebUiListener("stored-accounts-updated",this.handleStoredAccounts_.bind(this));this.addWebUiListener("sync-settings-saved",(()=>{this.$.toast.show()}))}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);this.showImportDataDialog_=Router.getInstance().getCurrentRoute()===routes.IMPORT_DATA;if(Router.getInstance().getCurrentRoute()===routes.SIGN_OUT){if(this.syncStatus&&!this.isSyncing_()){Router.getInstance().navigateToPreviousRoute()}else{this.showSignoutDialog_=true}}}handleProfileInfo_(info){this.profileName_=info.name;this.profileIconUrl_=info.iconUrl}handleSyncStatus_(syncStatus){const shouldRecordSigninImpression=!this.syncStatus&&syncStatus&&this.signinAllowed_&&!this.isSyncing_();this.syncStatus=syncStatus;if(shouldRecordSigninImpression&&!this.shouldShowSyncAccountControl_()){chrome.metricsPrivate.recordUserAction("Signin_Impression_FromSettings")}}computeShouldShowGoogleAccount_(){if(this.replaceSyncPromosWithSignInPromos_){return false}if(this.storedAccounts===undefined||this.syncStatus===undefined){return false}return(this.storedAccounts.length>0||this.isSyncing_())&&!this.syncStatus.hasError}onProfileClick_(){Router.getInstance().navigateTo(routes.MANAGE_PROFILE)}onDisconnectDialogClosed_(){this.showSignoutDialog_=false;if(Router.getInstance().getCurrentRoute()===routes.SIGN_OUT){Router.getInstance().navigateToPreviousRoute()}}onSyncClick_(){Router.getInstance().navigateTo(routes.SYNC)}onAccountClick_(){Router.getInstance().navigateTo(routes.ACCOUNT)}onGoogleServicesClick_(){Router.getInstance().navigateTo(routes.GOOGLE_SERVICES)}onImportDataClick_(){Router.getInstance().navigateTo(routes.IMPORT_DATA)}onImportDataDialogClosed_(){Router.getInstance().navigateToPreviousRoute();focusWithoutInk(this.$.importDataDialogTrigger)}shouldLinkToAccountSettingsPage_(){return this.replaceSyncPromosWithSignInPromos_&&!!this.syncStatus&&this.syncStatus.signedInState===SignedInState.SIGNED_IN}shouldShowSyncAccountControl_(){if(this.syncStatus===undefined){return false}return!!this.syncStatus.syncSystemEnabled&&this.signinAllowed_&&!this.shouldLinkToAccountSettingsPage_()}handleStoredAccounts_(accounts){this.storedAccounts=accounts;if(accounts.length===0){return}this.primaryAccountName_=accounts[0].fullName;this.primaryAccountEmail_=accounts[0].email;this.primaryAccountIconUrl_=accounts[0].avatarImage}openGoogleAccount_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("googleAccountUrl"));chrome.metricsPrivate.recordUserAction("ManageGoogleAccount_Clicked")}getIconImageSet_(iconUrl){return getImage(iconUrl)}isSyncing_(){return!!this.syncStatus&&this.syncStatus.signedInState===SignedInState.SYNCING}shouldHideSyncSetupLinkRow_(){return this.replaceSyncPromosWithSignInPromos_&&(!this.syncStatus||this.syncStatus.signedInState!==SignedInState.SYNCING)}getAccountRowSubtitle_(){if(!!this.syncStatus&&!!this.syncStatus.statusText&&this.syncStatus.statusAction===StatusAction.ENTER_PASSPHRASE){return loadTimeData.substituteString(this.syncStatus.statusText,this.primaryAccountEmail_)}return this.primaryAccountEmail_}getFocusConfig(){const map=new Map;if(routes.SYNC){map.set(routes.SYNC.path,"#sync-setup")}if(routes.MANAGE_PROFILE){map.set(routes.MANAGE_PROFILE.path,loadTimeData.getBoolean("signinAllowed")?"#edit-profile":"#profile-row .subpage-arrow")}if(routes.ACCOUNT){map.set(routes.ACCOUNT.path,"#account-subpage-row")}if(routes.GOOGLE_SERVICES){map.set(routes.GOOGLE_SERVICES.path,"#google-services")}return map}getAssociatedControlFor(childViewId){const ids=["sync","syncControls","manageProfile","account","googleServices"];assert(ids.includes(childViewId));let triggerId=null;switch(childViewId){case"sync":case"syncControls":triggerId="sync-setup";break;case"manageProfile":triggerId=this.signinAllowed_?"edit-profile":"profile-row";break;case"account":assert(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos"));triggerId="account-subpage-row";break;case"googleServices":assert(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos"));triggerId="google-services";break}assert(triggerId);const control=this.shadowRoot.querySelector(`#${triggerId}`);assert(control);return control}}customElements.define(SettingsPeoplePageElement.is,SettingsPeoplePageElement);function getTemplate$t(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-people-page slot="view" id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.PEOPLE.path]]">
  </settings-people-page>

  <settings-sync-page slot="view" id="sync"
      data-parent-view-id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.SYNC.path]]">
  </settings-sync-page>

  <settings-sync-controls-page slot="view" id="syncControls"
      data-parent-view-id="parent" route-path$="[[routes_.SYNC_ADVANCED.path]]">
  </settings-sync-controls-page>


   <settings-manage-profile slot="view" id="manageProfile"
       data-parent-view-id="parent" profile-name="[[profileName_]]"
       route-path$="[[routes_.MANAGE_PROFILE.path]]">
   </settings-manage-profile>

   <template is="dom-if" if="[[replaceSyncPromosWithSignInPromos_]]"
      restamp>
    <!-- TODO(crbug.com/452589374): Remove the no-search attributes once a
     proper solution for making these pages unavailable asynchronously is
     implemented. -->
     <settings-account-page slot="view" id="account" no-search
         data-parent-view-id="parent" prefs="{{prefs}}"
         route-path$="[[routes_.ACCOUNT.path]]">
     </settings-account-page>

     <settings-google-services-page slot="view" id="googleServices"
         no-search data-parent-view-id="parent" prefs="{{prefs}}"
         route-path$="[[routes_.GOOGLE_SERVICES.path]]">
     </settings-google-services-page>
   </template>

</cr-view-manager>
<!--_html_template_end_-->`}const SettingsPeoplePageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsPeoplePageIndexElement extends SettingsPeoplePageIndexElementBase{static get is(){return"settings-people-page-index"}static get template(){return getTemplate$t()}static get properties(){return{prefs:Object,routes_:{type:Object,value:()=>routes},replaceSyncPromosWithSignInPromos_:{type:Boolean,value:()=>loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")}}}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.PEOPLE:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.BASIC:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.SYNC:this.$.viewManager.switchView("sync","no-animation","no-animation");break;case routes.SYNC_ADVANCED:this.$.viewManager.switchView("syncControls","no-animation","no-animation");break;case routes.IMPORT_DATA:case routes.SIGN_OUT:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.ACCOUNT:assert(this.replaceSyncPromosWithSignInPromos_);this.$.viewManager.switchView("account","no-animation","no-animation");break;case routes.GOOGLE_SERVICES:assert(this.replaceSyncPromosWithSignInPromos_);this.$.viewManager.switchView("googleServices","no-animation","no-animation");break;case routes.MANAGE_PROFILE:this.$.viewManager.switchView("manageProfile","no-animation","no-animation");break}}))}}customElements.define(SettingsPeoplePageIndexElement.is,SettingsPeoplePageIndexElement);function getTemplate$s(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.battery-saver-radio-group{padding-block-end:var(--cr-section-vertical-padding)}</style>
<settings-section

    page-title="$i18n{batteryPageTitle}">
  <template is="dom-if" if="[[isBatterySaverModeManagedByOs_]]">
    <cr-link-row id="batterySaverOSSettingsLinkRow"
        label="$i18n{batterySaverModeLabel}"
        sub-label="$i18n{batterySaverModeLinkOsDescription}"
        on-click="openOsPowerSettings_"
        external>
    </cr-link-row>
  </template>
  <template is="dom-if" if="[[!isBatterySaverModeManagedByOs_]]">
    <settings-toggle-button id="toggleButton" on-change="onChange_"
        pref="{{prefs.performance_tuning.battery_saver_mode.state}}"
        label="$i18n{batterySaverModeLabel}"
        sub-label-with-link="$i18n{batterySaverModeDescription}"
        on-sub-label-link-clicked="onBatterySaverLearnMoreLinkClick_"
        numeric-unchecked-values="[[numericUncheckedValues_]]"
        numeric-checked-value="[[batterySaverModeStateEnum_.ENABLED_BELOW_THRESHOLD]]">
    </settings-toggle-button>
    <cr-collapse id="radioGroupCollapse"
        opened="[[isBatterySaverModeEnabled_(prefs.performance_tuning.battery_saver_mode.state.value)]]">
      <div class="cr-row continuation battery-saver-radio-group">
        <settings-radio-group id="radioGroup" on-change="onChange_"
            pref="{{prefs.performance_tuning.battery_saver_mode.state}}"
            group-aria-label="$i18n{batterySaverModeRadioGroupAriaLabel}">
          <controlled-radio-button
              label="$i18n{batterySaverModeEnabledBelowThresholdLabel}"
              name="[[batterySaverModeStateEnum_.ENABLED_BELOW_THRESHOLD]]"
              pref="[[prefs.performance_tuning.battery_saver_mode.state]]">
          </controlled-radio-button>
          <controlled-radio-button id="enabledOnBatteryButton"
              label="$i18n{batterySaverModeEnabledOnBatteryLabel}"
              name="[[batterySaverModeStateEnum_.ENABLED_ON_BATTERY]]"
              pref="[[prefs.performance_tuning.battery_saver_mode.state]]">
          </controlled-radio-button>
        </settings-radio-group>
      </div>
    </cr-collapse>
  </template>
</settings-section>
<!--_html_template_end_-->`}var BatterySaverModeState;(function(BatterySaverModeState){BatterySaverModeState[BatterySaverModeState["DISABLED"]=0]="DISABLED";BatterySaverModeState[BatterySaverModeState["ENABLED_BELOW_THRESHOLD"]=1]="ENABLED_BELOW_THRESHOLD";BatterySaverModeState[BatterySaverModeState["ENABLED_ON_BATTERY"]=2]="ENABLED_ON_BATTERY";BatterySaverModeState[BatterySaverModeState["ENABLED"]=3]="ENABLED";BatterySaverModeState[BatterySaverModeState["COUNT"]=4]="COUNT"})(BatterySaverModeState||(BatterySaverModeState={}));var MemorySaverModeAggressiveness;(function(MemorySaverModeAggressiveness){MemorySaverModeAggressiveness[MemorySaverModeAggressiveness["CONSERVATIVE"]=0]="CONSERVATIVE";MemorySaverModeAggressiveness[MemorySaverModeAggressiveness["MEDIUM"]=1]="MEDIUM";MemorySaverModeAggressiveness[MemorySaverModeAggressiveness["AGGRESSIVE"]=2]="AGGRESSIVE";MemorySaverModeAggressiveness[MemorySaverModeAggressiveness["COUNT"]=3]="COUNT"})(MemorySaverModeAggressiveness||(MemorySaverModeAggressiveness={}));var MemorySaverModeExceptionListAction;(function(MemorySaverModeExceptionListAction){MemorySaverModeExceptionListAction[MemorySaverModeExceptionListAction["ADD_MANUAL"]=0]="ADD_MANUAL";MemorySaverModeExceptionListAction[MemorySaverModeExceptionListAction["EDIT"]=1]="EDIT";MemorySaverModeExceptionListAction[MemorySaverModeExceptionListAction["REMOVE"]=2]="REMOVE";MemorySaverModeExceptionListAction[MemorySaverModeExceptionListAction["ADD_FROM_CURRENT"]=3]="ADD_FROM_CURRENT";MemorySaverModeExceptionListAction[MemorySaverModeExceptionListAction["COUNT"]=4]="COUNT"})(MemorySaverModeExceptionListAction||(MemorySaverModeExceptionListAction={}));var MemorySaverModeState;(function(MemorySaverModeState){MemorySaverModeState[MemorySaverModeState["DISABLED"]=0]="DISABLED";MemorySaverModeState[MemorySaverModeState["DEPRECATED"]=1]="DEPRECATED";MemorySaverModeState[MemorySaverModeState["ENABLED"]=2]="ENABLED";MemorySaverModeState[MemorySaverModeState["COUNT"]=3]="COUNT"})(MemorySaverModeState||(MemorySaverModeState={}));class PerformanceMetricsProxyImpl{recordBatterySaverModeChanged(state){chrome.metricsPrivate.recordEnumerationValue("PerformanceControls.BatterySaver.SettingsChangeMode",state,BatterySaverModeState.COUNT)}recordMemorySaverModeChanged(state){chrome.metricsPrivate.recordEnumerationValue("PerformanceControls.MemorySaver.SettingsChangeMode",state,MemorySaverModeState.COUNT)}recordMemorySaverModeAggressivenessChanged(aggressiveness){chrome.metricsPrivate.recordEnumerationValue("PerformanceControls.MemorySaver.SettingsChangeAggressiveness",aggressiveness,MemorySaverModeAggressiveness.COUNT)}recordDiscardRingTreatmentEnabledChanged(enabled){chrome.metricsPrivate.recordBoolean("PerformanceControls.MemorySaver.DiscardRingTreatment",enabled)}recordExceptionListAction(action){chrome.metricsPrivate.recordEnumerationValue("PerformanceControls.MemorySaver.SettingsChangeExceptionList",action,MemorySaverModeExceptionListAction.COUNT)}recordPerformanceInterventionToggleButtonChanged(enabled){chrome.metricsPrivate.recordBoolean("PerformanceControls.Intervention.SettingsChangeNotification",enabled)}static getInstance(){return instance$3||(instance$3=new PerformanceMetricsProxyImpl)}static setInstance(obj){instance$3=obj}}let instance$3=null;const BATTERY_SAVER_MODE_PREF="performance_tuning.battery_saver_mode.state";const SettingsBatteryPageElementBase=PrefsMixin(PolymerElement);class SettingsBatteryPageElement extends SettingsBatteryPageElementBase{static get is(){return"settings-battery-page"}static get template(){return getTemplate$s()}static get properties(){return{batterySaverModeStateEnum_:{readOnly:true,type:Object,value:BatterySaverModeState},isBatterySaverModeManagedByOs_:{type:Boolean,value(){return loadTimeData.getBoolean("isBatterySaverModeManagedByOS")}},numericUncheckedValues_:{type:Array,value:()=>[BatterySaverModeState.DISABLED]}}}metricsProxy_=PerformanceMetricsProxyImpl.getInstance();isBatterySaverModeEnabled_(value){return value!==BatterySaverModeState.DISABLED}onChange_(){this.metricsProxy_.recordBatterySaverModeChanged(this.getPref(BATTERY_SAVER_MODE_PREF).value)}onBatterySaverLearnMoreLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("batterySaverLearnMoreUrl"))}}customElements.define(SettingsBatteryPageElement.is,SettingsBatteryPageElement);function getTemplate$r(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.memory-saver-radio-group{padding-block-end:var(--cr-section-vertical-padding)}</style>
<settings-section

    page-title="$i18n{memoryPageTitle}">
  <settings-toggle-button id="toggleButton" on-change="onMemorySaverModeChange_"
      pref="{{prefs.performance_tuning.high_efficiency_mode.state}}"
      label="$i18n{memorySaverModeLabel}"
      sub-label-with-link="$i18n{memorySaverModeDescription}"
      on-sub-label-link-clicked="onMemorySaverLearnMoreLinkClick_"
      numeric-unchecked-values="[[numericUncheckedValues_]]"
      numeric-checked-value="[[numericCheckedValue_]]">
  </settings-toggle-button>
  <cr-collapse id="radioGroupCollapse" opened="[[isMemorySaverModeEnabled_(
          prefs.performance_tuning.high_efficiency_mode.state.value)]]">
    <div class="cr-row continuation memory-saver-radio-group">
      <settings-radio-group id="radioGroup"
        on-change="onMemorySaverModeAggressivenessChange_" pref="{{
              prefs.performance_tuning.high_efficiency_mode.aggressiveness}}"
        group-aria-label="$i18n{memorySaverModeRadioGroupAriaLabel}">
        <controlled-radio-button id="conservativeButton"
          label="$i18n{memorySaverModeConservativeLabel}"
          name$="[[memorySaverModeAggressivenessEnum_.CONSERVATIVE]]" pref="[[
                prefs.performance_tuning.high_efficiency_mode.aggressiveness]]">
          <div class="cr-secondary-text">
            $i18n{memorySaverModeConservativeDescription}
          </div>
        </controlled-radio-button>
        <controlled-radio-button id="mediumButton"
          label="$i18n{memorySaverModeMediumLabel}"
          name$="[[memorySaverModeAggressivenessEnum_.MEDIUM]]" pref="[[
                prefs.performance_tuning.high_efficiency_mode.aggressiveness]]">
          <div class="cr-secondary-text">
            $i18n{memorySaverModeMediumDescription}
          </div>
        </controlled-radio-button>
        <controlled-radio-button id="aggressiveButton"
          label="$i18n{memorySaverModeAggressiveLabel}"
          name$="[[memorySaverModeAggressivenessEnum_.AGGRESSIVE]]" pref="[[
                prefs.performance_tuning.high_efficiency_mode.aggressiveness]]">
          <div class="cr-secondary-text">
            $i18n{memorySaverModeAggressiveDescription}
          </div>
        </controlled-radio-button>
      </settings-radio-group>
    </div>
  </cr-collapse>
</settings-section>
<!--_html_template_end_-->`}const MEMORY_SAVER_MODE_PREF="performance_tuning.high_efficiency_mode.state";const MEMORY_SAVER_MODE_AGGRESSIVENESS_PREF="performance_tuning.high_efficiency_mode.aggressiveness";const SettingsMemoryPageElementBase=PrefsMixin(PolymerElement);class SettingsMemoryPageElement extends SettingsMemoryPageElementBase{static get is(){return"settings-memory-page"}static get template(){return getTemplate$r()}static get properties(){return{memorySaverModeAggressivenessEnum_:{readOnly:true,type:Object,value:MemorySaverModeAggressiveness},numericUncheckedValues_:{type:Array,value:()=>[MemorySaverModeState.DISABLED]},numericCheckedValue_:{type:Number,value:()=>MemorySaverModeState.ENABLED}}}metricsProxy_=PerformanceMetricsProxyImpl.getInstance();onMemorySaverModeChange_(){this.metricsProxy_.recordMemorySaverModeChanged(this.getPref(MEMORY_SAVER_MODE_PREF).value)}onMemorySaverModeAggressivenessChange_(){this.metricsProxy_.recordMemorySaverModeAggressivenessChanged(this.getPref(MEMORY_SAVER_MODE_AGGRESSIVENESS_PREF).value)}isMemorySaverModeEnabled_(value){return value!==MemorySaverModeState.DISABLED}onMemorySaverLearnMoreLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("memorySaverLearnMoreUrl"))}}customElements.define(SettingsMemoryPageElement.is,SettingsMemoryPageElement);const WINDOWS_EPOCH=Date.UTC(1601,0,1,0,0,0,0);const UNIX_EPOCH=Date.UTC(1970,0,1,0,0,0,0);function convertDateToWindowsEpoch(date=Date.now()){const epochDeltaMs=UNIX_EPOCH-WINDOWS_EPOCH;return`${(date+epochDeltaMs)*1e3}`}function getTemplate$q(){return html$1`<!--_html_template_start_--><cr-input id="input" label="$i18n{addSite}" aria-label="$i18n{editSiteTitle}"
    placeholder="example.com" value="{{rule}}" on-input="validate"
    error-message="[[errorMessage]]" invalid="[[inputInvalid]]"
    spellcheck="false" autofocus>
</cr-input>
<!--_html_template_end_-->`}var PerformanceFeedbackCategory;(function(PerformanceFeedbackCategory){PerformanceFeedbackCategory["NOTIFICATIONS"]="performance_notifications";PerformanceFeedbackCategory["TABS"]="performance_tabs";PerformanceFeedbackCategory["BATTERY"]="performance_battery";PerformanceFeedbackCategory["SPEED"]="performance_speed"})(PerformanceFeedbackCategory||(PerformanceFeedbackCategory={}));class PerformanceBrowserProxyImpl{getCurrentOpenSites(){return sendWithPromise("getCurrentOpenSites")}getDeviceHasBattery(){return sendWithPromise("getDeviceHasBattery")}openFeedbackDialog(categoryTag){chrome.send("openPerformanceFeedbackDialog",[categoryTag])}validateTabDiscardExceptionRule(rule){return sendWithPromise("validateTabDiscardExceptionRule",rule)}static getInstance(){return instance$2||(instance$2=new PerformanceBrowserProxyImpl)}static setInstance(obj){instance$2=obj}}let instance$2=null;const MAX_TAB_DISCARD_EXCEPTION_RULE_LENGTH=10*1024;const TAB_DISCARD_EXCEPTIONS_PREF="performance_tuning.tab_discarding.exceptions_with_time";const TAB_DISCARD_EXCEPTIONS_MANAGED_PREF="performance_tuning.tab_discarding.exceptions_managed";const ExceptionValidationMixin=dedupingMixin((superClass=>{const superClassBase=I18nMixin(superClass);class ExceptionValidationMixin extends superClassBase{static get properties(){return{errorMessage:{type:String,value:""},inputInvalid:{type:Boolean,value:false},rule:String,submitDisabled:{type:Boolean,value:true,notify:true}}}browserProxy_=PerformanceBrowserProxyImpl.getInstance();validate(){const rule=this.rule.trim();if(!rule){this.inputInvalid=false;this.submitDisabled=true;this.errorMessage="";return}if(rule.length>MAX_TAB_DISCARD_EXCEPTION_RULE_LENGTH){this.inputInvalid=true;this.submitDisabled=true;this.errorMessage=this.i18n("onStartupUrlTooLong");return}this.browserProxy_.validateTabDiscardExceptionRule(rule).then((valid=>{this.inputInvalid=!valid;this.submitDisabled=!valid;this.errorMessage=valid?"":this.i18n("onStartupInvalidUrl")}))}}return ExceptionValidationMixin}));const ExceptionEditInputElementBase=ExceptionValidationMixin(ListPropertyUpdateMixin(PrefsMixin(PolymerElement)));class ExceptionEditInputElement extends ExceptionEditInputElementBase{static get is(){return"tab-discard-exception-edit-input"}static get template(){return getTemplate$q()}static get properties(){return{ruleToEdit:{type:String,value:""}}}metricsProxy_=PerformanceMetricsProxyImpl.getInstance();ready(){super.ready();this.rule=this.ruleToEdit;this.submitDisabled=false}submit(){assert(!this.submitDisabled);const rule=this.rule.trim();if(rule!==this.ruleToEdit){this.deletePrefDictEntry(TAB_DISCARD_EXCEPTIONS_PREF,this.ruleToEdit);this.setPrefDictEntry(TAB_DISCARD_EXCEPTIONS_PREF,rule,convertDateToWindowsEpoch())}this.metricsProxy_.recordExceptionListAction(MemorySaverModeExceptionListAction.EDIT)}setRuleToEditForTesting(){this.rule=this.ruleToEdit}}customElements.define(ExceptionEditInputElement.is,ExceptionEditInputElement);function getTemplate$p(){return html$1`<!--_html_template_start_--><cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">$i18n{editSiteTitle}</div>
  <div slot="body">
    <tab-discard-exception-edit-input id="input" prefs="{{prefs}}"
        rule-to-edit="[[ruleToEdit]]"
        submit-disabled="{{submitDisabled}}">
    </tab-discard-exception-edit-input>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="actionButton" class="action-button" on-click="onSubmitClick_"
        disabled$="[[submitDisabled]]"
        aria-label="$i18n{tabDiscardingExceptionsSaveButtonAriaLabel}">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}const ExceptionEditDialogElementBase=PrefsMixin(PolymerElement);class ExceptionEditDialogElement extends ExceptionEditDialogElementBase{static get is(){return"tab-discard-exception-edit-dialog"}static get template(){return getTemplate$p()}static get properties(){return{ruleToEdit:{type:String,value:""}}}onCancelClick_(){this.$.dialog.cancel()}onSubmitClick_(){this.$.dialog.close();this.$.input.submit()}setRuleToEditForTesting(rule){this.ruleToEdit=rule;this.$.input.setRuleToEditForTesting()}}customElements.define(ExceptionEditDialogElement.is,ExceptionEditDialogElement);function getTemplate$o(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-policy-pref-indicator::part(tooltip){clip:rect(0 0 0 0);height:1px;overflow:hidden;width:1px}cr-policy-pref-indicator{padding-inline-end:8px}</style>
<div class="list-item">
  <div class="start text-elide">[[entry.site]]</div>
  <template is="dom-if" if="[[entry.managed]]">
    <cr-policy-pref-indicator
        pref="[[prefs.performance_tuning.tab_discarding.exceptions_managed]]"
        on-mouseenter="onShowTooltip_" on-focus="onShowTooltip_">
    </cr-policy-pref-indicator>
  </template>
  <template is="dom-if" if="[[!entry.managed]]">
    <cr-icon-button class="icon-more-vert" title="$i18n{moreActions}"
        on-click="onMenuClick_" aria-label="$i18n{moreActions}">
    </cr-icon-button>
  </template>
</div><!--_html_template_end_-->`}const ExceptionEntryElementBase=BaseMixin(PolymerElement);class ExceptionEntryElement extends ExceptionEntryElementBase{static get is(){return"tab-discard-exception-entry"}static get template(){return getTemplate$o()}static get properties(){return{entry:Object,prefs:Object}}onMenuClick_(e){this.fire("menu-click",{target:e.target,site:this.entry.site})}onShowTooltip_(){const indicator=this.shadowRoot.querySelector("cr-policy-pref-indicator");assert(!!indicator);this.fire("show-tooltip",{target:indicator,text:indicator.indicatorTooltip})}}customElements.define(ExceptionEntryElement.is,ExceptionEntryElement);function getTemplate$n(){return html$1`<!--_html_template_start_--><cr-input id="input" label="$i18n{addSite}" aria-label="$i18n{addSiteTitle}"
    placeholder="example.com" value="{{rule}}" on-input="validate"
    error-message="[[errorMessage]]" invalid="[[inputInvalid]]"
    spellcheck="false" autofocus>
</cr-input>
<!--_html_template_end_-->`}const ExceptionAddInputElementBase=ExceptionValidationMixin(ListPropertyUpdateMixin(PrefsMixin(PolymerElement)));class ExceptionAddInputElement extends ExceptionAddInputElementBase{static get is(){return"tab-discard-exception-add-input"}static get template(){return getTemplate$n()}metricsProxy_=PerformanceMetricsProxyImpl.getInstance();submit(){assert(!this.submitDisabled);const rule=this.rule.trim();this.setPrefDictEntry(TAB_DISCARD_EXCEPTIONS_PREF,rule,convertDateToWindowsEpoch());this.metricsProxy_.recordExceptionListAction(MemorySaverModeExceptionListAction.ADD_MANUAL)}}customElements.define(ExceptionAddInputElement.is,ExceptionAddInputElement);function getTemplate$m(){return html$1`<!--_html_template_start_--><style include="settings-shared">#container{height:calc(5 * var(--cr-section-min-height))}#emptyText{padding-inline-end:20px;padding-inline-start:20px;padding-top:20px}.label-slot{align-items:center;display:flex}.checkbox-label{margin-inline-start:10px}</style>
<div id="container" scrollable>
  <iron-list id="list" scroll-target="container" role="listbox"
      items="[[currentSites_]]" hidden$="[[!currentSites_.length]]">
    <template>
      <settings-checkbox-list-entry role="option"
          checked="[[isSelectedSite_(item)]]" tabindex="[[tabIndex]]"
          aria-posinset$="[[getAriaPosinset_(index)]]"
          aria-setsize$="[[currentSites_.length]]"
          aria-description="$i18n{tabDiscardingExceptionsActiveSiteAriaDescription}"
          on-change="onToggleSelection_">
        <div class="label-slot">
          <site-favicon url="[[item]]"></site-favicon>
          <div class="checkbox-label text-elide">[[item]]</div>
        </div>
      </settings-checkbox-list-entry>
    </template>
  </iron-list>
  <div id="emptyText" hidden="[[currentSites_.length]]">
    $i18n{tabDiscardingExceptionsAddDialogCurrentTabsEmpty}
  </div>
</div>
<!--_html_template_end_-->`}const ExceptionCurrentSitesListElementBase=ListPropertyUpdateMixin(ScrollableMixin(PrefsMixin(PolymerElement)));class ExceptionCurrentSitesListElement extends ExceptionCurrentSitesListElementBase{static get is(){return"tab-discard-exception-current-sites-list"}static get template(){return getTemplate$m()}static get properties(){return{currentSites_:{type:Array,value:[]},selectedSites_:{type:Array,value(){return new Set}},submitDisabled:{type:Boolean,notify:true},updateIntervalMS_:{type:Number,value:1e3},visible:{type:Boolean,value:true,observer:"onVisibilityChanged_"}}}browserProxy_=PerformanceBrowserProxyImpl.getInstance();metricsProxy_=PerformanceMetricsProxyImpl.getInstance();onVisibilityChangedListener_;updateIntervalID_=undefined;async connectedCallback(){super.connectedCallback();await this.updateCurrentSites_();this.dispatchEvent(new CustomEvent("sites-populated",{detail:{length:this.currentSites_.length}}));this.onVisibilityChanged_();this.onVisibilityChangedListener_=this.onVisibilityChanged_.bind(this);document.addEventListener("visibilitychange",this.onVisibilityChangedListener_)}disconnectedCallback(){document.removeEventListener("visibilitychange",this.onVisibilityChangedListener_);this.stopUpdatingCurrentSites_()}notifyResize(){this.$.list.notifyResize()}onVisibilityChanged_(){if(this.visible&&document.visibilityState==="visible"){this.startUpdatingCurrentSites_()}else{this.stopUpdatingCurrentSites_()}}startUpdatingCurrentSites_(){this.updateCurrentSites_().then((()=>{if(this.updateIntervalID_===undefined){this.updateIntervalID_=setInterval(this.updateCurrentSites_.bind(this),this.updateIntervalMS_)}}))}stopUpdatingCurrentSites_(){if(this.updateIntervalID_!==undefined){clearInterval(this.updateIntervalID_);this.updateIntervalID_=undefined}}setUpdateIntervalForTesting(updateIntervalMS){this.updateIntervalMS_=updateIntervalMS;this.stopUpdatingCurrentSites_();this.startUpdatingCurrentSites_()}getIsUpdatingForTesting(){return this.updateIntervalID_!==undefined}async updateCurrentSites_(){const existingSites=new Set(Object.keys(this.getPref(TAB_DISCARD_EXCEPTIONS_PREF).value));const currentSites=(await this.browserProxy_.getCurrentOpenSites()).filter((rule=>!existingSites.has(rule)));this.selectedSites_=new Set(currentSites.filter(this.isSelectedSite_.bind(this)));this.computeSubmitDisabled_();this.updateList("currentSites_",(x=>x),currentSites);if(this.currentSites_.length){this.updateScrollableContents()}}computeSubmitDisabled_(){this.submitDisabled=!this.selectedSites_.size}getAriaPosinset_(index){return index+1}isSelectedSite_(site){return this.selectedSites_.has(site)}onToggleSelection_(e){if(e.detail){this.selectedSites_.add(e.model.item)}else{this.selectedSites_.delete(e.model.item)}this.computeSubmitDisabled_()}submit(){assert(!this.submitDisabled);this.selectedSites_.forEach((rule=>{this.setPrefDictEntry(TAB_DISCARD_EXCEPTIONS_PREF,rule,convertDateToWindowsEpoch())}));this.metricsProxy_.recordExceptionListAction(MemorySaverModeExceptionListAction.ADD_FROM_CURRENT)}}customElements.define(ExceptionCurrentSitesListElement.is,ExceptionCurrentSitesListElement);function getTemplate$l(){return html$1`<!--_html_template_start_--><style>cr-tabs{--cr-tabs-font-size:100%;--cr-tabs-height:40px}#dialog{--border-top-color:var(--google-grey-300);--cr-dialog-body-border-top:1px solid var(--border-top-color)}@media (prefers-color-scheme:dark){#dialog{--border-top-color:var(--cr-separator-color)}}#dialog::part(wrapper){overflow:hidden}#dialog [slot=title]{padding-bottom:8px}#dialog::part(body-container){height:calc(5 * var(--cr-section-min-height) + 2px)}#body{padding-inline-end:0;padding-inline-start:0}#helpText{padding-bottom:20px}#helpText>a{color:var(--cr-link-color)}#inputPage{padding-inline-end:20px;padding-inline-start:20px;padding-top:20px}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">$i18n{addSitesTitle}</div>
  <div slot="header">
    <cr-tabs id="tabs" tab-names="[[tabNames_]]" selected="{{selectedTab_}}">
    </cr-tabs>
  </div>
  <div id="body" slot="body">
    <cr-page-selector selected="[[selectedTab_]]"
        on-iron-select="onSelectedTabChanged_">
      <tab-discard-exception-current-sites-list id="list" prefs="{{prefs}}"
          on-sites-populated="onSitesPopulated_"
          visible="[[isAddCurrentSitesTabSelected_(selectedTab_)]]"
          submit-disabled="{{submitDisabledList_}}">
      </tab-discard-exception-current-sites-list>
      <div id="inputPage">
        <div id="helpText">
          $i18nRaw{tabDiscardingExceptionsAddDialogHelp}
        </div>
        <tab-discard-exception-add-input id="input" prefs="{{prefs}}"
            submit-disabled="{{submitDisabledManual_}}">
        </tab-discard-exception-add-input>
      </div>
    </cr-page-selector>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        on-click="onCancelClick_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="actionButton" class="action-button" on-click="onSubmitClick_"
        disabled$="[[isSubmitDisabled_(
            submitDisabledList_, submitDisabledManual_, selectedTab_)]]"
        aria-label="$i18n{tabDiscardingExceptionsAddButtonAriaLabel}">
      $i18n{add}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}var ExceptionAddDialogTabs;(function(ExceptionAddDialogTabs){ExceptionAddDialogTabs[ExceptionAddDialogTabs["CURRENT_SITES"]=0]="CURRENT_SITES";ExceptionAddDialogTabs[ExceptionAddDialogTabs["MANUAL"]=1]="MANUAL"})(ExceptionAddDialogTabs||(ExceptionAddDialogTabs={}));const ExceptionTabbedAddDialogElementBase=PrefsMixin(PolymerElement);class ExceptionTabbedAddDialogElement extends ExceptionTabbedAddDialogElementBase{static get is(){return"tab-discard-exception-tabbed-add-dialog"}static get template(){return getTemplate$l()}static get properties(){return{selectedTab_:{type:Number,value:NONE_SELECTED},tabNames_:{type:Array,value:[loadTimeData.getString("tabDiscardingExceptionsAddDialogCurrentTabs"),loadTimeData.getString("tabDiscardingExceptionsAddDialogManual")]},submitDisabledList_:Boolean,submitDisabledManual_:Boolean}}onSelectedTabChanged_(){setTimeout((()=>this.$.list.notifyResize()),0)}onSitesPopulated_(e){if(e.detail.length>0){this.selectedTab_=ExceptionAddDialogTabs.CURRENT_SITES}else if(this.selectedTab_===NONE_SELECTED){this.selectedTab_=ExceptionAddDialogTabs.MANUAL}this.$.dialog.showModal()}isAddCurrentSitesTabSelected_(){return this.selectedTab_===ExceptionAddDialogTabs.CURRENT_SITES}onCancelClick_(){this.$.dialog.cancel()}onSubmitClick_(){this.$.dialog.close();if(this.isAddCurrentSitesTabSelected_()){this.$.list.submit()}else{this.$.input.submit()}}isSubmitDisabled_(){if(this.isAddCurrentSitesTabSelected_()){return this.submitDisabledList_}return this.submitDisabledManual_}}customElements.define(ExceptionTabbedAddDialogElement.is,ExceptionTabbedAddDialogElement);function getTemplate$k(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.cr-padded-text{flex:1}.list-frame{padding-inline-start:var(--cr-section-indent-width)}#outer{display:flex;flex-direction:column}#outer>tab-discard-exception-entry:not(:first-of-type){border-top:var(--cr-separator-line)}#expandButton{padding-inline-end:0;padding-inline-start:0;--cr-icon-button-margin-end:0}</style>
<div class="cr-row continuation">
  <div class="cr-padded-text">
    $i18n{tabDiscardingExceptionsHeader}
    <div class="secondary">$i18n{tabDiscardingExceptionsDescription}</div>
  </div>
  <cr-button id="addButton" on-click="onAddClick_"
      aria-label="$i18n{tabDiscardingExceptionsAddButtonAriaLabel}">
    $i18n{add}
  </cr-button>
</div>
<div id="noSitesAdded" class="list-frame" hidden$="[[hasSites_(siteList_.*)]]">
  <div class="list-item secondary">$i18n{noSitesAdded}</div>
</div>
<div id="outer" class="list-frame" role="list"
    hidden$="[[!hasSites_(siteList_.*)]]">
  <template is="dom-repeat" id="list" items="[[getSiteList_(siteList_.*)]]">
    <tab-discard-exception-entry prefs="[[prefs]]" entry="[[item]]"
        role="listitem"
        on-menu-click="onMenuClick_" on-show-tooltip="onShowTooltip_">
    </tab-discard-exception-entry>
  </template>
  <cr-expand-button id="expandButton" no-hover class="hr"
      hidden$="[[!hasOverflowSites_(siteList_.*)]]"
      expanded="{{overflowSiteListExpanded}}">
    <div>$i18n{tabDiscardingExceptionsAdditionalSites}</div>
  </cr-expand-button>
  <cr-collapse id="collapse" hidden$="[[!hasOverflowSites_(siteList_.*)]]"
      opened="[[overflowSiteListExpanded]]">
    <template is="dom-repeat" id="overflowList"
        items="[[getOverflowSiteList_(siteList_.*)]]">
      <div class="hr">
        <tab-discard-exception-entry prefs="[[prefs]]" entry="[[item]]"
            role="listitem"
            on-menu-click="onMenuClick_" on-show-tooltip="onShowTooltip_">
        </tab-discard-exception-entry>
      </div>
    </template>
  </cr-collapse>
</div>
<cr-tooltip id="tooltip"
    fit-to-visible-bounds manual-mode position="top">
  [[tooltipText_]]
</cr-tooltip>
<cr-lazy-render id="menu">
  <template>
    <cr-action-menu role-description="$i18n{menu}">
      <button id="edit" class="dropdown-item" role="menuitem"
          on-click="onEditClick_">
        $i18n{edit}
      </button>
      <button id="delete" class="dropdown-item" role="menuitem"
          on-click="onDeleteClick_">
        $i18n{siteSettingsActionReset}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>
<template is="dom-if" if="[[showTabbedAddDialog_]]" restamp>
  <tab-discard-exception-tabbed-add-dialog prefs="{{prefs}}"
      on-close="onTabbedAddDialogClose_">
  </tab-discard-exception-tabbed-add-dialog>
</template>
<template is="dom-if" if="[[showEditDialog_]]" restamp>
  <tab-discard-exception-edit-dialog prefs="{{prefs}}"
      on-close="onEditDialogClose_" rule-to-edit="[[selectedRule_]]">
  </tab-discard-exception-edit-dialog>
</template>
<!--_html_template_end_-->`}const TAB_DISCARD_EXCEPTIONS_OVERFLOW_SIZE=5;const ExceptionListElementBase=TooltipMixin(ListPropertyUpdateMixin(PrefsMixin(PolymerElement)));class ExceptionListElement extends ExceptionListElementBase{static get is(){return"tab-discard-exception-list"}static get template(){return getTemplate$k()}static get properties(){return{siteList_:{type:Array,value:[]},overflowSiteListExpanded:{type:Boolean,value:false},selectedRule_:{type:String,value:""},showTabbedAddDialog_:{type:Boolean,value:false},showEditDialog_:{type:Boolean,value:false},tooltipText_:String}}static get observers(){return[`onPrefsChanged_(prefs.${TAB_DISCARD_EXCEPTIONS_PREF}.value.*,`+`prefs.${TAB_DISCARD_EXCEPTIONS_MANAGED_PREF}.value.*)`]}metricsProxy_=PerformanceMetricsProxyImpl.getInstance();hasSites_(){return this.siteList_.length>0}hasOverflowSites_(){return this.siteList_.length>TAB_DISCARD_EXCEPTIONS_OVERFLOW_SIZE}getSiteList_(){return this.siteList_.slice(-TAB_DISCARD_EXCEPTIONS_OVERFLOW_SIZE).reverse()}getOverflowSiteList_(){return this.siteList_.slice(0,-TAB_DISCARD_EXCEPTIONS_OVERFLOW_SIZE).reverse()}onAddClick_(){assert(!this.showEditDialog_);this.showTabbedAddDialog_=true}onMenuClick_(e){e.stopPropagation();this.selectedRule_=e.detail.site;this.$.menu.get().showAt(e.detail.target)}onEditClick_(){assert(this.selectedRule_);assert(!this.showTabbedAddDialog_);this.showEditDialog_=true;this.$.menu.get().close()}onDeleteClick_(){this.deletePrefDictEntry(TAB_DISCARD_EXCEPTIONS_PREF,this.selectedRule_);this.metricsProxy_.recordExceptionListAction(MemorySaverModeExceptionListAction.REMOVE);this.$.menu.get().close()}onTabbedAddDialogClose_(){this.showTabbedAddDialog_=false}onEditDialogClose_(){this.showEditDialog_=false}onPrefsChanged_(){const newSites=[];for(const pref of[TAB_DISCARD_EXCEPTIONS_MANAGED_PREF,TAB_DISCARD_EXCEPTIONS_PREF]){const prefObject=this.getPref(pref);let sites=prefObject.value;if(sites.constructor.name==="Object"){sites=Object.keys(sites)}const siteToExceptionEntry=site=>({site:site,managed:prefObject.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED});newSites.push(...sites.map(siteToExceptionEntry))}this.updateList("siteList_",(entry=>entry.site),newSites)}onShowTooltip_(e){this.tooltipText_=e.detail.text;this.showTooltipAtTarget(this.$.tooltip,e.detail.target)}}customElements.define(ExceptionListElement.is,ExceptionListElement);function getTemplate$j(){return html$1`<!--_html_template_start_--><settings-section

    page-title="$i18n{generalPageTitle}">
  <settings-toggle-button id="performanceInterventionToggleButton"
    on-change="onPerformanceInterventionToggleButtonChange_"
    pref="{{prefs.performance_tuning.intervention_notification.enabled}}"
    label="$i18n{performanceInterventionEnabledLabel}"
    sub-label-with-link="$i18n{performanceInterventionEnabledDescription}"
    on-sub-label-link-clicked="onPerformanceInterventionLearnMoreLinkClick_">
  </settings-toggle-button>
  <settings-toggle-button id="discardRingTreatmentToggleButton"
    on-change="onDiscardRingChange_"
    pref="{{prefs.performance_tuning.discard_ring_treatment.enabled}}"
    label="$i18n{discardRingTreatmentEnabledLabel}"
    sub-label-with-link="
          $i18n{discardRingTreatmentEnabledDescriptionWithLearnLink}"
    on-sub-label-link-clicked="onDiscardRingTreatmentLearnMoreLinkClick_">
  </settings-toggle-button>
  <cr-link-row
      label="$i18n{tabHoverPreviewCardLinkTitle}"
      sub-label="$i18n{tabHoverPreviewCardLinkSubtitle}"
      on-click="onTabHoverPreviewCardLinkClick_" external>
  </cr-link-row>
  <tab-discard-exception-list id="exceptionList" prefs="{{prefs}}">
  </tab-discard-exception-list>
</settings-section>
<!--_html_template_end_-->`}const DISCARD_RING_PREF="performance_tuning.discard_ring_treatment.enabled";const PERFORMANCE_INTERVENTION_NOTIFICATION_PREF="performance_tuning.intervention_notification.enabled";const INACTIVE_TAB_SETTING_ELEMENT_ID="kInactiveTabSettingElementId";const SettingsPerformancePageElementBase=HelpBubbleMixin(PrefsMixin(PolymerElement));class SettingsPerformancePageElement extends SettingsPerformancePageElementBase{static get is(){return"settings-performance-page"}static get template(){return getTemplate$j()}metricsProxy_=PerformanceMetricsProxyImpl.getInstance();ready(){super.ready();afterNextRender(this,(()=>{const discardRingTreatmentToggleButton=this.shadowRoot.querySelector("#discardRingTreatmentToggleButton");if(discardRingTreatmentToggleButton){this.registerHelpBubble(INACTIVE_TAB_SETTING_ELEMENT_ID,discardRingTreatmentToggleButton.getBubbleAnchor())}}))}onDiscardRingChange_(){this.metricsProxy_.recordDiscardRingTreatmentEnabledChanged(this.getPref(DISCARD_RING_PREF).value)}onDiscardRingTreatmentLearnMoreLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("discardRingTreatmentLearnMoreUrl"))}onPerformanceInterventionLearnMoreLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("performanceInterventionLearnMoreUrl"))}onTabHoverPreviewCardLinkClick_(){Router.getInstance().navigateTo(routes.APPEARANCE)}onPerformanceInterventionToggleButtonChange_(){this.metricsProxy_.recordPerformanceInterventionToggleButtonChanged(this.getPref(PERFORMANCE_INTERVENTION_NOTIFICATION_PREF).value)}}customElements.define(SettingsPerformancePageElement.is,SettingsPerformancePageElement);function getTemplate$i(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared settings-columned-section">.settings-section-bottom-padding{padding-block-end:var(--cr-section-vertical-padding)}settings-collapse-radio-button[hidden]+settings-collapse-radio-button{--settings-collapse-separator-line:0}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}</style>
<settings-section

    page-title="$i18n{speedPageTitle}">

  <settings-toggle-button id="preloadingToggle"
      pref="{{prefs.net.network_prediction_options}}"
      label="$i18n{preloadingPageTitle}"
      sub-label-with-link="$i18n{preloadingToggleSummary}"
      on-sub-label-link-clicked="onPreloadingLearnMoreLinkClick_"
      numeric-unchecked-values="[[numericUncheckedValues_]]"
      numeric-checked-value="[[networkPredictionOptionsEnum_.STANDARD]]"
      on-change="onPreloadingStateChange_">
  </settings-toggle-button>
  <cr-collapse
      opened="[[isPreloadingEnabled_(
          prefs.net.network_prediction_options.value)]]">
    <div class="cr-row continuation settings-section-bottom-padding">
      <settings-radio-group id="preloadingRadioGroup"
          pref="{{prefs.net.network_prediction_options}}"
          selectable-elements="settings-collapse-radio-button"
          on-change="onPreloadingStateChange_">
        <settings-collapse-radio-button id="preloadingExtended"
            name="[[networkPredictionOptionsEnum_.EXTENDED]]"
            pref="[[prefs.net.network_prediction_options]]"
            label="$i18n{preloadingPageExtendedPreloadingTitle}"
            sub-label="$i18n{preloadingPageExtendedPreloadingSummary}"
            expand-aria-label="
                $i18n{preloadingPageExtendedPreloadingExpandA11yLabel}"
            no-automatic-collapse>
          <div slot="collapse" class="settings-columned-section">
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingWhenOn}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageExtendedPreloadingWhenOnBulletOne}
                </li>
                <li class="secondary">
                  $i18n{preloadingPageExtendedPreloadingWhenOnBulletTwo}
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingConsider}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageThingsToConsiderBulletOne}
                </li>
                <li class="secondary">
                  $i18n{preloadingPageExtendedPreloadingThingsToConsiderBulletTwo}
                </li>
              </ul>
            </div>
          </div>
        </settings-collapse-radio-button>
        <settings-collapse-radio-button id="preloadingStandard"
            name="[[networkPredictionOptionsEnum_.STANDARD]]"
            pref="[[prefs.net.network_prediction_options]]"
            label="$i18n{preloadingPageStandardPreloadingTitle}"
            sub-label="$i18n{preloadingPageStandardPreloadingSummary}"
            expand-aria-label="
                $i18n{preloadingPageStandardPreloadingExpandA11yLabel}"
            info-opened="{{infoOpened_}}"
            no-automatic-collapse>
          <div slot="collapse" class="settings-columned-section">
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingWhenOn}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageStandardPreloadingWhenOnBulletOne}
                </li>
                <li class="secondary">
                  $i18n{preloadingPageStandardPreloadingWhenOnBulletTwo}
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingConsider}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageThingsToConsiderBulletOne}
                </li>
              </ul>
            </div>
          </div>
        </settings-collapse-radio-button>
      </settings-radio-group>
    </div>
  </cr-collapse>
</settings-section>
<!--_html_template_end_-->`}const SpeedPageElementBase=PrefsMixin(PolymerElement);class SpeedPageElement extends SpeedPageElementBase{static get is(){return"settings-speed-page"}static get template(){return getTemplate$i()}static get properties(){return{networkPredictionOptionsEnum_:{type:Object,value:NetworkPredictionOptions},numericUncheckedValues_:{type:Array,value:()=>[NetworkPredictionOptions.DISABLED]}}}ready(){super.ready();CrSettingsPrefs.initialized.then((()=>{const prefValue=this.getPref("net.network_prediction_options").value;if(prefValue===NetworkPredictionOptions.WIFI_ONLY_DEPRECATED){this.setPrefValue("net.network_prediction_options",NetworkPredictionOptions.STANDARD)}}))}isPreloadingEnabled_(value){return value!==NetworkPredictionOptions.DISABLED}onPreloadingStateChange_(){this.$.preloadingExtended.updateCollapsed();this.$.preloadingStandard.updateCollapsed()}onPreloadingLearnMoreLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("preloadingLearnMoreUrl"))}}customElements.define(SpeedPageElement.is,SpeedPageElement);function getTemplate$h(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}cr-view-manager [slot=view]:not(.closing){position:initial}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-performance-page slot="view" id="performance" prefs="{{prefs}}">
  </settings-performance-page>

  <settings-memory-page slot="view" id="memory" prefs="{{prefs}}">
  </settings-memory-page>

  <settings-battery-page slot="view" id="battery" prefs="{{prefs}}"
      hidden="[[!showBatterySettings_]]">
  </settings-battery-page>

  <settings-speed-page slot="view" id="speed" prefs="{{prefs}}">
  </settings-speed-page>
</cr-view-manager>
<!--_html_template_end_-->`}const SettingsPerformancePageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(WebUiListenerMixin(PolymerElement)));class SettingsPerformancePageIndexElement extends SettingsPerformancePageIndexElementBase{static get is(){return"settings-performance-page-index"}static get template(){return getTemplate$h()}static get properties(){return{prefs:Object,showBatterySettings_:{type:Boolean,value:false}}}showDefaultViews_(){this.$.viewManager.switchViews(["performance","memory","battery","speed"],"no-animation","no-animation")}connectedCallback(){super.connectedCallback();this.addWebUiListener("device-has-battery-changed",this.onDeviceHasBatteryChanged_.bind(this));PerformanceBrowserProxyImpl.getInstance().getDeviceHasBattery().then(this.onDeviceHasBatteryChanged_.bind(this))}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.PERFORMANCE:this.showDefaultViews_();break;case routes.BASIC:this.showDefaultViews_();break}}))}onDeviceHasBatteryChanged_(deviceHasBattery){this.showBatterySettings_=deviceHasBattery}}customElements.define(SettingsPerformancePageIndexElement.is,SettingsPerformancePageIndexElement);function getTemplate$g(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">#wrapper{align-items:center;display:flex;justify-content:space-between;padding:0 20px}#controlsColumn{margin-top:4px}h2{color:var(--cr-primary-text-color);font-size:22px;padding-top:0}#title{font-weight:400}#bodyText{padding-block-end:16px}#startButton{margin-bottom:4px;margin-inline-end:16px}</style>
<div id="wrapper">
  <div id="controlsColumn">
    <h2 id="title">$i18n{privacyGuidePromoHeader}</h2>
    <div id="bodyText" class="cr-secondary-text">
      $i18n{privacyGuidePromoBody}
    </div>
    <cr-button class="action-button" id="startButton" role="button"
        aria-describedby="title bodyText" on-click="onPrivacyGuideStartClick_">
      $i18n{privacyGuidePromoStartButton}
    </cr-button>
    <cr-button id="noThanksButton" role="button"
        on-click="onNoThanksButtonClick_">
      $i18n{noThanks}
    </cr-button>
  </div>
  <picture>
    <source class="banner"
        srcset="./images/privacy_guide/promo_banner_dark.svg"
        media="(prefers-color-scheme: dark)">
    <img class="banner" alt=""
        src="./images/privacy_guide/promo_banner.svg">
  </picture>
</div>
<!--_html_template_end_-->`}const PrivacyGuidePromoElementBase=PrefsMixin(PolymerElement);class PrivacyGuidePromoElement extends PrivacyGuidePromoElementBase{static get is(){return"settings-privacy-guide-promo"}static get template(){return getTemplate$g()}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();onPrivacyGuideStartClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.StartPromo");this.metricsBrowserProxy_.recordPrivacyGuideEntryExitHistogram(PrivacyGuideInteractions.PROMO_ENTRY);Router.getInstance().navigateTo(routes.PRIVACY_GUIDE)}onNoThanksButtonClick_(){this.setPrefValue("privacy_guide.viewed",true)}}customElements.define(PrivacyGuidePromoElement.is,PrivacyGuidePromoElement);function getTemplate$f(){return html$1`<!--_html_template_start_-->  <style include="cr-shared-style cr-hidden-style settings-shared"></style>
  <settings-section page-title="$i18n{privacyPageTitle}">
    <template is="dom-if" if="[[showClearBrowsingDataDialog_]]" restamp>
      <template is="dom-if" if="[[!enableDeleteBrowsingDataRevamp_]]" restamp>
        <settings-clear-browsing-data-dialog prefs="{{prefs}}"
            on-close="onCbdDialogClosed_">
        </settings-clear-browsing-data-dialog>
      </template>
      <template is="dom-if" if="[[enableDeleteBrowsingDataRevamp_]]" restamp>
        <settings-clear-browsing-data-dialog-v2 prefs="{{prefs}}"
            on-close="onCbdDialogClosed_"
            on-browsing-data-deleted="onBrowsingDataDeleted_">
        </settings-clear-browsing-data-dialog-v2>
      </template>
    </template>
    <template is="dom-if" if="[[showPrivacyGuideDialog_]]" restamp>
      <settings-privacy-guide-dialog id="privacyGuideDialog" prefs="{{prefs}}"
          on-close="onPrivacyGuideDialogClosed_">
      </settings-privacy-guide-dialog>
    </template>
    <cr-link-row id="clearBrowsingData"
        start-icon="cr:delete"
        label="$i18n{clearBrowsingData}"
        sub-label="$i18n{clearBrowsingDataDescription}"
        on-click="onClearBrowsingDataClick_"></cr-link-row>
    <template is="dom-if" if="[[isPrivacyGuideAvailable]]">
      <cr-link-row id="privacyGuideLinkRow" class="hr"
          start-icon="privacy20:signpost"
          label="$i18n{privacyGuideLabel}"
          sub-label="$i18n{privacyGuideSublabel}"
          on-click="onPrivacyGuideClick_"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
    </template>
    <cr-link-row id="thirdPartyCookiesLinkRow"
        start-icon="privacy:cookie"
        class="hr" label="$i18n{thirdPartyCookiesLinkRowLabel}"
        sub-label="[[computeThirdPartyCookiesSublabel_(
            prefs.profile.cookie_controls_mode.*,
            prefs.tracking_protection.block_all_3pc_toggle_enabled.*
            )]]"
        on-click="onCookiesClick_"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
    <template is="dom-if" if="[[enableIncognitoTrackingProtections_]]">
      <cr-link-row id="incognitoTrackingProtectionsLinkRow" class="hr"
          start-icon="settings:visibility-off"
          label="$i18n{incognitoTrackingProtectionsPageEntrypointLabel}"
          sub-label="$i18n{incognitoTrackingProtectionsPageEntrypointSublabel}"
          on-click="onIncognitoTrackingProtectionsClick_"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
    </template>
    <template is="dom-if" if=
        "[[shouldShowAdPrivacy_(
            isPrivacySandboxRestricted_,
            isPrivacySandboxRestrictedNoticeEnabled_)]]">
      <cr-link-row id="privacySandboxLinkRow"
          start-icon="privacy20:ads-click"
          class="hr"
          label="$i18n{adPrivacyLinkRowLabel}"
          sub-label="[[computeAdPrivacySublabel_(
              isPrivacySandboxRestricted_,
              isPrivacySandboxRestrictedNoticeEnabled_)]]"
          on-click="onPrivacySandboxClick_"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
    </template>
    <cr-link-row id="securityLinkRow" start-icon="privacy:lock"
        class="hr" label="$i18n{securityPageTitle}"
        sub-label="$i18n{securityPageDescription}"
        on-click="onSecurityPageClick_"
        role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
    <cr-link-row id="siteSettingsLinkRow" start-icon="privacy:page-info"
        class="hr" label="$i18n{siteSettings}"
        sub-label="$i18n{siteSettingsSublabel}"
        on-click="onSiteSettingsLinkRowClick_"
        role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
    <cr-toast id="deleteBrowsingDataToast" duration="5000">
      <div>[[dbdDeletionConfirmationToastLabel_]]</div>
    </cr-toast>
  </settings-section>
<!--_html_template_end_-->`}const SettingsPrivacyPageElementBase=PrivacyGuideAvailabilityMixin(SettingsViewMixin(RouteObserverMixin(I18nMixin(PrefsMixin(PolymerElement)))));class SettingsPrivacyPageElement extends SettingsPrivacyPageElementBase{static get is(){return"settings-privacy-page"}static get template(){return getTemplate$f()}static get properties(){return{showClearBrowsingDataDialog_:Boolean,showPrivacyGuideDialog_:Boolean,enableDeleteBrowsingDataRevamp_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableDeleteBrowsingDataRevamp")},isPrivacySandboxRestricted_:{type:Boolean,value:()=>loadTimeData.getBoolean("isPrivacySandboxRestricted")},isPrivacySandboxRestrictedNoticeEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("isPrivacySandboxRestrictedNoticeEnabled")},enableIncognitoTrackingProtections_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableIncognitoTrackingProtections")},dbdDeletionConfirmationToastLabel_:{type:String,value:""},shouldShowDbdDeletionConfirmationToast_:{type:Boolean,value:false}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);this.showClearBrowsingDataDialog_=Router.getInstance().getCurrentRoute()===routes.CLEAR_BROWSER_DATA;this.showPrivacyGuideDialog_=Router.getInstance().getCurrentRoute()===routes.PRIVACY_GUIDE&&this.isPrivacyGuideAvailable}onClearBrowsingDataClick_(){this.interactedWithPage_();Router.getInstance().navigateTo(routes.CLEAR_BROWSER_DATA)}onCookiesClick_(){this.interactedWithPage_();Router.getInstance().navigateTo(routes.COOKIES)}onCbdDialogClosed_(){Router.getInstance().navigateTo(routes.CLEAR_BROWSER_DATA.parent);if(this.shouldShowDbdDeletionConfirmationToast_){assert(this.dbdDeletionConfirmationToastLabel_);const toast=this.shadowRoot.querySelector("#deleteBrowsingDataToast");assert(toast);toast.show();this.shouldShowDbdDeletionConfirmationToast_=false}afterNextRender(this,(()=>{const toFocus=this.shadowRoot.querySelector("#clearBrowsingData");assert(toFocus);focusWithoutInk(toFocus)}))}onPrivacyGuideDialogClosed_(){Router.getInstance().navigateToPreviousRoute();const toFocus=this.shadowRoot.querySelector("#privacyGuideLinkRow");assert(toFocus);focusWithoutInk(toFocus)}onSiteSettingsLinkRowClick_(){this.interactedWithPage_();Router.getInstance().navigateTo(routes.SITE_SETTINGS)}onSecurityPageClick_(){this.interactedWithPage_();this.metricsBrowserProxy_.recordAction("SafeBrowsing.Settings.ShowedFromParentSettings");Router.getInstance().navigateTo(routes.SECURITY)}onPrivacySandboxClick_(){this.interactedWithPage_();this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.OpenedFromSettingsParent");Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX)}onIncognitoTrackingProtectionsClick_(){this.interactedWithPage_();this.metricsBrowserProxy_.recordAction("Settings.TrackingProtections.OpenedFromPrivacyPage");Router.getInstance().navigateTo(routes.INCOGNITO_TRACKING_PROTECTIONS)}onPrivacyGuideClick_(){this.metricsBrowserProxy_.recordPrivacyGuideEntryExitHistogram(PrivacyGuideInteractions.SETTINGS_LINK_ROW_ENTRY);this.metricsBrowserProxy_.recordAction("Settings.PrivacyGuide.StartPrivacySettings");Router.getInstance().navigateTo(routes.PRIVACY_GUIDE,undefined,true)}interactedWithPage_(){HatsBrowserProxyImpl.getInstance().trustSafetyInteractionOccurred(TrustSafetyInteraction.USED_PRIVACY_CARD)}computeAdPrivacySublabel_(){const restricted=this.isPrivacySandboxRestricted_&&this.isPrivacySandboxRestrictedNoticeEnabled_;return restricted?this.i18n("adPrivacyRestrictedLinkRowSubLabel"):this.i18n("adPrivacyLinkRowSubLabel")}computeThirdPartyCookiesSublabel_(){if(loadTimeData.getBoolean("is3pcdCookieSettingsRedesignEnabled")){if(this.getPref("tracking_protection.block_all_3pc_toggle_enabled").value){return this.i18n("thirdPartyCookiesLinkRowSublabelDisabled")}return this.i18n("thirdPartyCookiesLinkRowSublabelLimited")}const currentCookieSetting=this.getPref("profile.cookie_controls_mode").value;switch(currentCookieSetting){case CookieControlsMode.OFF:case CookieControlsMode.INCOGNITO_ONLY:return this.i18n("thirdPartyCookiesLinkRowSublabelEnabled");case CookieControlsMode.BLOCK_THIRD_PARTY:return this.i18n("thirdPartyCookiesLinkRowSublabelDisabled");default:assertNotReached()}}shouldShowAdPrivacy_(){return!this.isPrivacySandboxRestricted_||this.isPrivacySandboxRestrictedNoticeEnabled_}onBrowsingDataDeleted_(e){this.dbdDeletionConfirmationToastLabel_=e.detail.deletionConfirmationText;this.shouldShowDbdDeletionConfirmationToast_=true}getFocusConfig(){const map=new Map;if(routes.COOKIES){map.set(routes.COOKIES.path,"#thirdPartyCookiesLinkRow")}if(routes.INCOGNITO_TRACKING_PROTECTIONS){map.set(routes.INCOGNITO_TRACKING_PROTECTIONS.path,"#incognitoTrackingProtectionsLinkRow")}if(routes.PRIVACY_GUIDE){map.set(routes.PRIVACY_GUIDE.path,"#privacyGuideLinkRow")}if(routes.PRIVACY_SANDBOX){map.set(routes.PRIVACY_SANDBOX.path,"#privacySandboxLinkRow")}if(routes.SECURITY){map.set(routes.SECURITY.path,"#securityLinkRow")}if(routes.SITE_SETTINGS){map.set(routes.SITE_SETTINGS.path,"#siteSettingsLinkRow")}return map}getAssociatedControlFor(childViewId){let triggerId=null;switch(childViewId){case"cookies":triggerId="thirdPartyCookiesLinkRow";break;case"incognitoTrackingProtections":triggerId="incognitoTrackingProtectionsLinkRow";break;case"security":case"securityKeys":triggerId="securityLinkRow";break;case"siteSettings":case"siteSettingsAds":case"siteSettingsAll":case"siteSettingsAr":case"siteSettingsAutomaticDownloads":case"siteSettingsAutomaticFullscreen":case"siteSettingsAutoPictureInPicture":case"siteSettingsAutoVerify":case"siteSettingsBackgroundSync":case"siteSettingsBluetoothDevices":case"siteSettingsBluetoothScanning":case"siteSettingsCamera":case"siteSettingsCapturedSurfaceControl":case"siteSettingsClipboard":case"siteSettingsFederatedIdentityApi":case"siteSettingsFilesystemWrite":case"siteSettingsFilesystemWriteDetails":case"siteSettingsHandlers":case"siteSettingsHandTracking":case"siteSettingsHidDevices":case"siteSettingsIdleDetection":case"siteSettingsImages":case"siteSettingsJavascript":case"siteSettingsJavascriptOptimizer":case"siteSettingsKeyboardLock":case"siteSettingsLocalFonts":case"siteSettingsLocalNetworkAccess":case"siteSettingsLocation":case"siteSettingsMicrophone":case"siteSettingsMidiDevices":case"siteSettingsMixedscript":case"siteSettingsNotifications":case"siteSettingsPaymentHandler":case"siteSettingsPdfDocuments":case"siteSettingsPopups":case"siteSettingsProtectedContent":case"siteSettingsSensors":case"siteSettingsSerialPorts":case"siteSettingsSiteData":case"siteSettingsSiteDetails":case"siteSettingsSound":case"siteSettingsStorageAccess":case"siteSettingsUsbDevices":case"siteSettingsVr":case"siteSettingsWebAppInstallation":case"siteSettingsWebPrinting":case"siteSettingsWindowManagement":case"siteSettingsZoomLevels":triggerId="siteSettingsLinkRow";break;case"privacySandbox":case"privacySandboxAdMeasurement":case"privacySandboxFledge":case"privacySandboxManageTopics":case"privacySandboxTopics":triggerId="privacySandboxLinkRow";break;default:assertNotReached()}assert(triggerId);const control=this.shadowRoot.querySelector(`#${triggerId}`);assert(control);return control}}customElements.define(SettingsPrivacyPageElement.is,SettingsPrivacyPageElement);function getTemplate$e(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}cr-view-manager [slot=view]:not(.closing){position:initial}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">

  <template is="dom-if" if="[[isPrivacyGuideAvailable]]" restamp>
    <settings-section slot="view" id="privacyGuidePromo" page-title=""
        hidden$="[[!showPrivacyGuidePromo_]]">
      <settings-privacy-guide-promo prefs="{{prefs}}">
      </settings-privacy-guide-promo>
    </settings-section>
  </template>

  <template is="dom-if" if="[[showPage_(pageVisibility_.safetyHub)]]">
    <template is="dom-if" if="[[renderView_(
        routes_.PRIVACY, currentRoute, inSearchMode)]]" update-when-false>
      <settings-safety-hub-entry-point slot="view" id="safetyHubEntryPoint">
      </settings-safety-hub-entry-point>
    </template>

    <template is="dom-if" if="[[renderView_(
        routes_.SAFETY_HUB, currentRoute, inSearchMode)]]"
        update-when-false>
      <!-- TODO(crbug.com/40267370): Make the page searchable.-->
      <settings-safety-hub-page slot="view" id="safetyHub" no-search
          data-parent-view-id="safetyHubEntryPoint" prefs="{{prefs}}"
          route-path$="[[routes_.SAFETY_HUB.path]]">
      </settings-safety-hub-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderPrivacyView_(currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-privacy-page slot="view" id="privacy" prefs="{{prefs}}"
        route-path$="[[routes_.PRIVACY.path]]">
    </settings-privacy-page>
  </template>

  <template is="dom-if" if="[[isAdPrivacyAvailable_]]" restamp>
    <template is="dom-if" if="[[renderView_(
        routes_.PRIVACY_SANDBOX, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-privacy-sandbox-page slot="view" id="privacySandbox"
          data-parent-view-id="privacy" prefs="{{prefs}}"
          route-path$="[[routes_.PRIVACY_SANDBOX.path]]">
      </settings-privacy-sandbox-page>
    </template>

    <template is="dom-if" if="[[renderView_(
        routes_.PRIVACY_SANDBOX_AD_MEASUREMENT, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-privacy-sandbox-ad-measurement-subpage slot="view"
          id="privacySandboxAdMeasurement" data-parent-view-id="privacy"
          prefs="{{prefs}}"
          route-path$="[[routes_.PRIVACY_SANDBOX_AD_MEASUREMENT.path]]">
      </settings-privacy-sandbox-ad-measurement-subpage>
    </template>
  </template>

  <template is="dom-if" if="[[!isPrivacySandboxRestricted_]]" restamp>
    <template is="dom-if" if="[[renderView_(
        routes_.PRIVACY_SANDBOX_FLEDGE, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-privacy-sandbox-fledge-subpage slot="view"
          id="privacySandboxFledge" data-parent-view-id="privacy"
          prefs="{{prefs}}"
          route-path$="[[routes_.PRIVACY_SANDBOX_FLEDGE.path]]">
      </settings-privacy-sandbox-fledge-subpage>
    </template>

    <template is="dom-if" if="[[renderView_(
          routes_.PRIVACY_SANDBOX_TOPICS, currentRoute, inSearchMode)]]"
          update-when-false>
      <settings-privacy-sandbox-topics-subpage slot="view"
          id="privacySandboxTopics" data-parent-view-id="privacy"
          prefs="{{prefs}}"
          route-path$="[[routes_.PRIVACY_SANDBOX_TOPICS.path]]">
      </settings-privacy-sandbox-topics-subpage>
    </template>

    <template is="dom-if" if="[[renderView_(
          routes_.PRIVACY_SANDBOX_MANAGE_TOPICS, currentRoute, inSearchMode)]]"
          update-when-false>
      <settings-privacy-sandbox-manage-topics-subpage slot="view"
          id="privacySandboxManageTopics" data-parent-view-id="privacy"
          prefs="{{prefs}}"
          route-path$="[[routes_.PRIVACY_SANDBOX_MANAGE_TOPICS.path]]">
      </settings-privacy-sandbox-manage-topics-subpage>
    </template>
  </template>

  <!-- Keep entries below sorted based on the route name. -->

  <template is="dom-if" if="[[renderView_(
      routes_.COOKIES, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-cookies-page slot="view" id="cookies"
        data-parent-view-id="privacy" prefs="{{prefs}}"
        route-path$="[[routes_.COOKIES.path]]">
    </settings-cookies-page>
  </template>

  <template is="dom-if" if="[[enableIncognitoTrackingProtections_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.INCOGNITO_TRACKING_PROTECTIONS, currentRoute, inSearchMode)]]"
        update-when-false>
      <incognito-tracking-protections-page slot="view"
          id="incognitoTrackingProtections" data-parent-view-id="privacy"
          prefs="{{prefs}}"
          route-path$="[[routes_.INCOGNITO_TRACKING_PROTECTIONS.path]]">
      </incognito-tracking-protections-page>
    </template>
  </template>

  <template is="dom-if" if="[[!enableBundledSecuritySettings_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SECURITY, currentRoute, inSearchMode)]]" update-when-false>
      <settings-security-page slot="view"
          id="security" data-parent-view-id="privacy" prefs="{{prefs}}"
          route-path$="[[routes_.SECURITY.path]]">
      </settings-security-page>
    </template>
  </template>

  <template is="dom-if" if="[[enableBundledSecuritySettings_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SECURITY, currentRoute, inSearchMode)]]" update-when-false>
      <settings-security-page-v2 slot="view"
          id="security" data-parent-view-id="privacy" prefs="{{prefs}}"
          route-path$="[[routes_.SECURITY.path]]">
      </settings-security-page-v2>
    </template>
  </template>

  <template is="dom-if" if="[[enableSecurityKeysSubpage_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SECURITY_KEYS, currentRoute, inSearchMode)]]"
        update-when-false>
      <security-keys-subpage slot="view" id="securityKeys"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SECURITY_KEYS.path]]">
      </security-keys-subpage>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-site-settings-page slot="view" id="siteSettings"
        data-parent-view-id="privacy" prefs="{{prefs}}"
        route-path$="[[routes_.SITE_SETTINGS.path]]">
    </settings-site-settings-page>
  </template>

  <template is="dom-if" if="[[enableSafeBrowsingSubresourceFilter_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_ADS, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-ads-page slot="view" id="siteSettingsAds"
          data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_ADS.path]]">
      </settings-ads-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_ALL, currentRoute, inSearchMode)]]"
      update-when-false>
    <all-sites slot="view" id="siteSettingsAll" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_ALL.path]]">
    </all-sites>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_AR, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-ar-page slot="view" id="siteSettingsAr"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_AR.path]]">
    </settings-ar-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_AUTO_VERIFY, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-anti-abuse-page slot="view" id="siteSettingsAutoVerify"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_AUTO_VERIFY.path]]">
    </settings-anti-abuse-page>
  </template>

  <template is="dom-if" if="[[enableAutoPictureInPicture_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE, currentRoute,
        inSearchMode)]]" update-when-false>
      <settings-auto-picture-in-picture-page slot="view"
          id="siteSettingsAutoPictureInPicture" data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE.path]]">
      </settings-auto-picture-in-picture-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_AUTOMATIC_DOWNLOADS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-automatic-downloads-page slot="view"
        id="siteSettingsAutomaticDownloads" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_AUTOMATIC_DOWNLOADS.path]]">
    </settings-automatic-downloads-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_AUTOMATIC_FULLSCREEN, currentRoute,
      inSearchMode)]]" update-when-false>
    <settings-automatic-full-screen-page slot="view"
        id="siteSettingsAutomaticFullscreen" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_AUTOMATIC_FULLSCREEN.path]]">
    </settings-automatic-full-screen-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_BACKGROUND_SYNC, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-background-sync-page slot="view"
        id="siteSettingsBackgroundSync" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_BACKGROUND_SYNC.path]]">
    </settings-background-sync-page>
  </template>

  <template is="dom-if" if="[[enableWebBluetoothNewPermissionsBackend_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_BLUETOOTH_DEVICES, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-bluetooth-devices-page slot="view"
          id="siteSettingsBluetoothDevices"
          route-path$="[[routes_.SITE_SETTINGS_BLUETOOTH_DEVICES.path]]"
          data-parent-view-id="privacy">
      </settings-bluetooth-devices-page>
    </template>
  </template>

  <template is="dom-if" if="[[enableExperimentalWebPlatformFeatures_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_BLUETOOTH_SCANNING, currentRoute,
        inSearchMode)]]" update-when-false>
      <settings-bluetooth-scanning-page slot="view"
          id="siteSettingsBluetoothScanning" data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_BLUETOOTH_SCANNING.path]]">
      </settings-bluetooth-scanning-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_CAMERA, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-camera-page slot="view" id="siteSettingsCamera"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_CAMERA.path]]">
    </settings-camera-page>
  </template>

  <template is="dom-if" if="[[enableCapturedSurfaceControl_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_CAPTURED_SURFACE_CONTROL, currentRoute,
        inSearchMode)]]" update-when-false>
      <settings-captured-surface-control-page slot="view"
          id="siteSettingsCapturedSurfaceControl" data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_CAPTURED_SURFACE_CONTROL.path]]">
      </settings-captured-surface-control-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_CLIPBOARD, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-clipboard-page slot="view"
        id="siteSettingsClipboard" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_CLIPBOARD.path]]">
    </settings-clipboard-page>
  </template>

  <template is="dom-if" if="[[enableFederatedIdentityApiContentSetting_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_FEDERATED_IDENTITY_API, currentRoute,
        inSearchMode)]]"
        update-when-false>
      <settings-federated-identity-api-page slot="view"
          id="siteSettingsFederatedIdentityApi"
          route-path$="[[routes_.SITE_SETTINGS_FEDERATED_IDENTITY_API.path]]"
          data-parent-view-id="privacy">
      </settings-federated-identity-api-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_FILE_SYSTEM_WRITE, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-filesystem-page slot="view"
        id="siteSettingsFilesystemWrite"
        route-path$="[[routes_.SITE_SETTINGS_FILE_SYSTEM_WRITE.path]]"
        data-parent-view-id="privacy">
    </settings-filesystem-page>
  </template>

  <template is="dom-if" if="[[enablePersistentPermissions_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_FILE_SYSTEM_WRITE_DETAILS, currentRoute,
        inSearchMode)]]" update-when-false>
      <file-system-site-details slot="view"
          id="siteSettingsFilesystemWriteDetails"
          route-path$="[[routes_.SITE_SETTINGS_FILE_SYSTEM_WRITE_DETAILS.path]]"
          data-parent-view-id="privacy">
      </file-system-site-details>
    </template>
  </template>

  <template is="dom-if" if="[[enableHandTrackingContentSetting_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_HAND_TRACKING, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-hand-tracking-page slot="view" id="siteSettingsHandTracking"
          route-path$="[[routes_.SITE_SETTINGS_HAND_TRACKING.path]]"
          data-parent-view-id="privacy">
      </settings-hand-tracking-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_HANDLERS, currentRoute, inSearchMode)]]"
      update-when-false>
    <protocol-handlers slot="view" id="siteSettingsHandlers"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_HANDLERS.path]]"
        toggle-off-label="$i18n{siteSettingsHandlersBlocked}"
        toggle-on-label="$i18n{siteSettingsHandlersAskRecommended}">
    </protocol-handlers>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_HID_DEVICES, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-hid-devices-page slot="view" id="siteSettingsHidDevices"
        route-path$="[[routes_.SITE_SETTINGS_HID_DEVICES.path]]"
        data-parent-view-id="privacy">
    </settings-hid-devices-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_IDLE_DETECTION, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-idle-detection-page slot="view" id="siteSettingsIdleDetection"
        route-path$="[[routes_.SITE_SETTINGS_IDLE_DETECTION.path]]"
        data-parent-view-id="privacy">
    </settings-idle-detection-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_IMAGES, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-images-page slot="view" id="siteSettingsImages"
        route-path$="[[routes_.SITE_SETTINGS_IMAGES.path]]"
        data-parent-view-id="privacy">
    </settings-images-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_MIXEDSCRIPT, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-insecure-content-page slot="view"
        id="siteSettingsMixedscript"
        route-path$="[[routes_.SITE_SETTINGS_MIXEDSCRIPT.path]]"
        data-parent-view-id="privacy">
    </settings-insecure-content-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_JAVASCRIPT, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-javascript-page slot="view"
        id="siteSettingsJavascript" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_JAVASCRIPT.path]]">
    </settings-javascript-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-v8-page slot="view" id="siteSettingsJavascriptOptimizer"
      data-parent-view-id="privacy" prefs="{{prefs}}"
      route-path$="[[routes_.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER.path]]">
    </settings-v8-page>
  </template>

  <template is="dom-if" if="[[enableKeyboardLockPrompt_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_KEYBOARD_LOCK, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-keyboard-lock-page slot="view" id="siteSettingsKeyboardLock"
          data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_KEYBOARD_LOCK.path]]">
      </settings-keyboard-lock-page>
    </template>
  </template>

  <template is="dom-if" if="[[enableLocalNetworkAccessSetting_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_LOCAL_NETWORK_ACCESS, currentRoute,
        inSearchMode)]]" update-when-false>
      <settings-local-network-access-page slot="view"
          id="siteSettingsLocalNetworkAccess" data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_LOCAL_NETWORK_ACCESS.path]]">
      </settings-local-network-access-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_LOCAL_FONTS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-local-fonts-page slot="view" id="siteSettingsLocalFonts"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_LOCAL_FONTS.path]]">
    </settings-local-fonts-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_LOCATION, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-geolocation-page slot="view" id="siteSettingsLocation"
        data-parent-view-id="privacy" prefs="{{prefs}}"
        route-path$="[[routes_.SITE_SETTINGS_LOCATION.path]]">
    </settings-location-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_MICROPHONE, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-microphone-page slot="view"
        id="siteSettingsMicrophone" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_MICROPHONE.path]]">
    </settings-microphone-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_MIDI_DEVICES, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-midi-devices-page slot="view"
        id="siteSettingsMidiDevices" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_MIDI_DEVICES.path]]">
    </settings-midi-devices-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_NOTIFICATIONS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-notifications-page slot="view" id="siteSettingsNotifications"
        route-path$="[[routes_.SITE_SETTINGS_NOTIFICATIONS.path]]"
        data-parent-view-id="privacy" prefs="{{prefs}}">
    </settings-notifications-page>
  </template>

  <template is="dom-if" if="[[enablePaymentHandlerContentSetting_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_PAYMENT_HANDLER, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-payment-handler-page slot="view"
          id="siteSettingsPaymentHandler" data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_PAYMENT_HANDLER.path]]">
      </settings-payment-handler-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_PDF_DOCUMENTS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-pdf-documents-page slot="view" id="siteSettingsPdfDocuments"
        data-parent-view-id="privacy" prefs="{{prefs}}"
        route-path$="[[routes_.SITE_SETTINGS_PDF_DOCUMENTS.path]]">
    </settings-pdf-documents-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_POPUPS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-popups-page slot="view"
        id="siteSettingsPopups" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_POPUPS.path]]">
    </settings-popups-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_PROTECTED_CONTENT, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-protected-content-page slot="view"
        id="siteSettingsProtectedContent" data-parent-view-id="privacy"
        prefs="{{prefs}}"
        route-path$="[[routes_.SITE_SETTINGS_PROTECTED_CONTENT.path]]">
    </settings-protected-content-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_SENSORS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-sensors-page slot="view"
        id="siteSettingsSensors" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_SENSORS.path]]">
    </settings-sensors-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_SERIAL_PORTS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-serial-ports-page slot="view"
        id="siteSettingsSerialPorts" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_SERIAL_PORTS.path]]">
    </settings-serial-ports-page>
  </template>



  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_SOUND, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-sound-page slot="view"
        id="siteSettingsSound" data-parent-view-id="privacy"
        prefs="{{prefs}}" route-path$="[[routes_.SITE_SETTINGS_SOUND.path]]">
    </settings-sound-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_SITE_DATA, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-site-data slot="view" id="siteSettingsSiteData"
        data-parent-view-id="privacy" prefs="{{prefs}}"
        route-path$="[[routes_.SITE_SETTINGS_SITE_DATA.path]]">
    </settings-site-data>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_SITE_DETAILS, currentRoute, inSearchMode)]]"
      update-when-false>
    <site-details slot="view" id="siteSettingsSiteDetails"
        data-parent-view-id="privacy" prefs="{{prefs}}"
        route-path$="[[routes_.SITE_SETTINGS_SITE_DETAILS.path]]">
    </site-details>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_STORAGE_ACCESS, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-storage-access-page slot="view" id="siteSettingsStorageAccess"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_STORAGE_ACCESS.path]]">
    </settings-storage-access-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_USB_DEVICES, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-usb-devices-page slot="view" id="siteSettingsUsbDevices"
        route-path$="[[routes_.SITE_SETTINGS_USB_DEVICES.path]]"
        data-parent-view-id="privacy">
    </settings-usb-devices-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_VR, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-vr-page slot="view" id="siteSettingsVr" data-parent-view-id="privacy"
      route-path$="[[routes_.SITE_SETTINGS_VR.path]]">
    </settings-vr-page>
  </template>

  <template is="dom-if" if="[[enableWebAppInstallation_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_WEB_APP_INSTALLATION, currentRoute,
        inSearchMode)]]" update-when-false>
      <settings-web-applications-page slot="view"
          id="siteSettingsWebAppInstallation" data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_WEB_APP_INSTALLATION.path]]">
      </settings-web-applications-page>
    </template>
  </template>

  <template is="dom-if" if="[[enableWebPrintingContentSetting_]]">
    <template is="dom-if" if="[[renderView_(
        routes_.SITE_SETTINGS_WEB_PRINTING, currentRoute, inSearchMode)]]"
        update-when-false>
      <settings-web-printing-page slot="view"
          id="siteSettingsWebPrinting" data-parent-view-id="privacy"
          route-path$="[[routes_.SITE_SETTINGS_WEB_PRINTING.path]]">
      </settings-web-printing-page>
    </template>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_WINDOW_MANAGEMENT, currentRoute, inSearchMode)]]"
      update-when-false>
    <settings-window-management-page slot="view"
        id="siteSettingsWindowManagement" data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_WINDOW_MANAGEMENT.path]]">
    </settings-window-management-page>
  </template>

  <template is="dom-if" if="[[renderView_(
      routes_.SITE_SETTINGS_ZOOM_LEVELS, currentRoute, inSearchMode)]]"
      update-when-false>
    <zoom-levels slot="view" id="siteSettingsZoomLevels"
        data-parent-view-id="privacy"
        route-path$="[[routes_.SITE_SETTINGS_ZOOM_LEVELS.path]]">
    </zoom-levels>
  </template>

</cr-view-manager>
<!--_html_template_end_-->`}const SettingsPrivacyPageIndexElementBase=SearchableViewContainerMixin(PrivacyGuideAvailabilityMixin(PrefsMixin(RouteObserverMixin(PolymerElement))));class SettingsPrivacyPageIndexElement extends SettingsPrivacyPageIndexElementBase{static get is(){return"settings-privacy-page-index"}static get template(){return getTemplate$e()}static get properties(){return{prefs:Object,pageVisibility_:{type:Object,value:()=>pageVisibility||{}},routes_:{type:Object,value:()=>routes},showPrivacyGuidePromo_:{type:Boolean,value:false},enableAutoPictureInPicture_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableAutoPictureInPicture")},enableBundledSecuritySettings_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableBundledSecuritySettings")},enableCapturedSurfaceControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableCapturedSurfaceControl")},enableFederatedIdentityApiContentSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableFederatedIdentityApiContentSetting")},enableExperimentalWebPlatformFeatures_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableExperimentalWebPlatformFeatures")},enableHandTrackingContentSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableHandTrackingContentSetting")},enableIncognitoTrackingProtections_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableIncognitoTrackingProtections")},enablePaymentHandlerContentSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("enablePaymentHandlerContentSetting")},enablePersistentPermissions_:{type:Boolean,readOnly:true,value:()=>loadTimeData.getBoolean("enablePersistentPermissions")},enableSecurityKeysSubpage_:{type:Boolean,readOnly:true,value:()=>loadTimeData.getBoolean("enableSecurityKeysSubpage")},enableSafeBrowsingSubresourceFilter_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableSafeBrowsingSubresourceFilter")},enableKeyboardLockPrompt_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableKeyboardLockPrompt")},enableLocalNetworkAccessSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableLocalNetworkAccessSetting")},enableWebAppInstallation_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableWebAppInstallation")},enableWebBluetoothNewPermissionsBackend_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableWebBluetoothNewPermissionsBackend")},enableWebPrintingContentSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableWebPrintingContentSetting")},isAdPrivacyAvailable_:{type:Boolean,readOnly:true,value:()=>!loadTimeData.getBoolean("isPrivacySandboxRestricted")||loadTimeData.getBoolean("isPrivacySandboxRestrictedNoticeEnabled")},isPrivacySandboxRestricted_:{type:Boolean,readOnly:true,value:()=>loadTimeData.getBoolean("isPrivacySandboxRestricted")}}}static get observers(){return["updatePrivacyGuidePromoVisibility_(isPrivacyGuideAvailable, prefs.privacy_guide.viewed.value)"]}pendingViewSwitching_=new PromiseResolver;privacyGuidePromoWasShown_;privacyGuideBrowserProxy_=PrivacyGuideBrowserProxyImpl.getInstance();beforeNextRenderPromise_(){return new Promise((res=>{beforeNextRender(this,res)}))}getDefaultViews_(){const defaultViews=["privacy"];if(this.isPrivacyGuideAvailable){defaultViews.push("privacyGuidePromo")}if(this.showPage_(this.pageVisibility_.safetyHub)){defaultViews.push("safetyHubEntryPoint")}return defaultViews}isRouteHostedWithinPrivacyView_(route){const nestedRoutes=[routes.CLEAR_BROWSER_DATA];if(loadTimeData.getBoolean("showPrivacyGuide")){nestedRoutes.push(routes.PRIVACY_GUIDE)}return nestedRoutes.includes(route)}getViewIdsForRoute_(route){switch(route){case routes.PRIVACY:return this.getDefaultViews_();case routes.BASIC:return this.inSearchMode?this.getDefaultViews_():[];default:{if(this.isRouteHostedWithinPrivacyView_(route)){return["privacy"]}if(routes.PRIVACY.contains(route)){const view=this.$.viewManager.querySelector(`[slot='view'][route-path='${route.path}']`);return view?[view.id]:null}return[]}}}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(newRoute===routes.PRIVACY){this.updatePrivacyGuidePromoVisibility_()}this.pendingViewSwitching_=new PromiseResolver;queueMicrotask((async()=>{let viewIds=this.getViewIdsForRoute_(newRoute);if(viewIds!==null&&viewIds.length===0){this.pendingViewSwitching_.resolve();return}const allViewsExist=viewIds!==null&&this.$.viewManager.querySelectorAll(viewIds.join(",")).length===viewIds.length;if(!allViewsExist){await this.beforeNextRenderPromise_();if(this.currentRoute!==newRoute||!this.isConnected){this.pendingViewSwitching_.resolve();return}viewIds=this.getViewIdsForRoute_(newRoute)}assert(viewIds!==null,`No views found for route ${newRoute.path}`);await this.$.viewManager.switchViews(viewIds,"no-animation","no-animation");this.pendingViewSwitching_.resolve()}))}whenViewSwitchingDone(){return this.pendingViewSwitching_.promise}showPage_(visibility){return visibility!==false}renderView_(route){return this.inSearchMode||!!this.currentRoute&&this.currentRoute===route}renderPrivacyView_(){return this.inSearchMode||!!this.currentRoute&&(this.currentRoute===routes.PRIVACY||this.isRouteHostedWithinPrivacyView_(this.currentRoute))}updatePrivacyGuidePromoVisibility_(){if(!this.isPrivacyGuideAvailable||this.prefs===undefined||this.getPref("privacy_guide.viewed").value||this.privacyGuideBrowserProxy_.getPromoImpressionCount()>=MAX_PRIVACY_GUIDE_PROMO_IMPRESSION||this.currentRoute!==routes.PRIVACY){this.showPrivacyGuidePromo_=false;return}this.showPrivacyGuidePromo_=true;if(!this.privacyGuidePromoWasShown_){this.privacyGuideBrowserProxy_.incrementPromoImpressionCount();this.privacyGuidePromoWasShown_=true}}}customElements.define(SettingsPrivacyPageIndexElement.is,SettingsPrivacyPageIndexElement);function getTemplate$d(){return html$1`<!--_html_template_start_--><style include="settings-shared">#prefs{padding-inline-start:40px}#v2buttons{display:flex;width:100%}#learnMoreV2{margin-inline-end:auto}</style>
<cr-dialog id="dialog" close-text="$i18n{close}"
    ignore-popstate on-cancel="onCancel_">
  <div slot="title">
    <div hidden="[[!showResetProfileBannerV2]]">
      $i18n{resetAutomatedDialogV2Title}
    </div>
    <div hidden="[[showResetProfileBannerV2]]">
      $i18n{resetAutomatedDialogTitle}
    </div>
  </div>
  <div slot="body">
    <div hidden="[[!showResetProfileBannerV2]]">
      $i18n{resetAutomatedDialogV2Body}
      <div id="tamperedPrefsList" hidden="[[!showTamperedPrefsList]]">
        <ul id="prefs">
          <template is="dom-repeat" items="[[tamperedPrefs]]">
            <li>[[item]]</li>
          </template>
        </ul>
      </div>
    </div>
    <div hidden="[[showResetProfileBannerV2]]">
      <span id="description">
        $i18n{resetProfileBannerDescription}
        <a id="learnMore"
            aria-label="$i18n{resetLearnMoreAccessibilityText}"
            aria-description="$i18n{opensInNewTab}"
            href="$i18nRaw{resetProfileBannerLearnMoreUrl}"
            target="_blank">$i18n{learnMore}</a>
      </span>
    </div>
  </div>
  <div slot="button-container">
    <div id="v2buttons" hidden="[[!showResetProfileBannerV2]]">
      <cr-button id="learnMoreV2"
          aria-label="$i18n{resetLearnMoreAccessibilityText}"
          on-click="onLearnMoreClick_">
        $i18n{learnMore}
      </cr-button>
      <cr-button class="action-button" id="confirm"
          on-click="onConfirmClick_">
        $i18n{gotIt}
      </cr-button>
    </div>
    <div hidden="[[showResetProfileBannerV2]]">
      <cr-button class="cancel-button" on-click="onOkClick_" id="ok">
        $i18n{ok}
      </cr-button>
      <cr-button class="action-button" on-click="onResetClick_" id="reset">
        $i18n{resetProfileBannerButton}
      </cr-button>
    </div>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}const SettingsResetProfileBannerElementBase=I18nMixin(PolymerElement);class SettingsResetProfileBannerElement extends SettingsResetProfileBannerElementBase{static get is(){return"settings-reset-profile-banner"}static get template(){return getTemplate$d()}static get properties(){return{showResetProfileBannerV2:{type:Boolean,value:()=>loadTimeData.getBoolean("showResetProfileBannerV2")},tamperedPrefs:{type:Array,value:()=>[]},showTamperedPrefsList:{type:Boolean,value:false}}}browserProxy_=ResetBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();if(this.showResetProfileBannerV2){this.browserProxy_.getTamperedPreferencePaths().then((prefs=>{if(prefs.length>0){this.tamperedPrefs=prefs;this.showTamperedPrefsList=true;this.$.dialog.showModal();this.browserProxy_.onShowResetProfileDialog()}}))}else{this.$.dialog.showModal();this.browserProxy_.onShowResetProfileDialog()}}onOkClick_(){this.$.dialog.close();this.browserProxy_.onHideResetProfileBanner()}onCancel_(){this.browserProxy_.onHideResetProfileBanner()}onResetClick_(){this.$.dialog.close();Router.getInstance().navigateTo(routes.RESET_DIALOG)}onConfirmClick_(){this.$.dialog.close();this.browserProxy_.onHideResetProfileBanner()}onLearnMoreClick_(){window.open(this.i18n("resetProfileBannerLearnMoreUrl"))}}customElements.define(SettingsResetProfileBannerElement.is,SettingsResetProfileBannerElement);function getTemplate$c(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{--favicon-size:0}#search-wrapper{align-items:center;display:flex;min-height:var(--cr-section-min-height)}.default-search-engine .cr-row{--cr-section-min-height:55px;gap:12px;padding:0}.default-search-engine{padding-top:var(--cr-section-vertical-padding)}.search-engine-name{margin-inline-end:auto}site-favicon{--site-favicon-border-radius:4px;--site-favicon-height:var(--favicon-size);--site-favicon-width:var(--favicon-size)}settings-search-engine-list-dialog{--search-engine-icon-size:var(--favicon-size)}
</style>
<settings-section page-title="$i18n{searchPageTitle}">
  <div route-path="default">
    <!-- Omnibox search engine -->
    <div class="cr-row first">
      <div class="default-search-engine flex">
        $i18n{searchPageTitle}
        <div class="secondary">
          $i18n{searchEngineChoiceEntryPointSubtitle}
          <a href="$i18n{searchExplanationLearnMoreURL}"
              aria-description="$i18n{opensInNewTab}"
              aria-label="$i18n{searchExplanationLearnMoreA11yLabel}"
              target="_blank">
            $i18n{learnMore}
          </a>
        </div>
        <template is="dom-if" if="[[isDefaultSearchControlledByPolicy_(
            prefs.default_search_provider_data.template_url_data)]]">
          <cr-policy-pref-indicator pref="[[
              prefs.default_search_provider_data.template_url_data]]">
          </cr-policy-pref-indicator>
        </template>
        <div class="cr-row first">
          <site-favicon favicon-url="[[defaultSearchEngine_.iconURL]]"
              url="[[defaultSearchEngine_.url]]"
              icon-path="[[defaultSearchEngine_.iconPath]]">
          </site-favicon>
          <div class="search-engine-name">[[defaultSearchEngine_.name]]</div>
          <cr-button id="openDialogButton"
              on-click="onOpenDialogButtonClick_"
              disabled$="[[isDefaultSearchEngineEnforced_(
                  prefs.default_search_provider_data.template_url_data)]]">
            $i18n{searchEnginesChange}
          </cr-button>
        </div>
      </div>
      <template is="dom-if" if="[[showSearchEngineListDialog_]]" restamp>
        <settings-search-engine-list-dialog
            search-engines="[[searchEngines_]]"
            on-close="onSearchEngineListDialogClose_"
            on-search-engine-changed="onDefaultSearchEngineChangedInDialog_">
        </settings-search-engine-list-dialog>
      </template>
      <cr-toast id="confirmationToast" duration="10000">
        <div>[[confirmationToastLabel_]]</div>
      </cr-toast>
    </div>
    <template is="dom-if"
        if="[[prefs.default_search_provider_data.template_url_data.extensionId]]">
      <div class="cr-row continuation">
        <extension-controlled-indicator
            class="flex"
            extension-id="[[
                prefs.default_search_provider_data.template_url_data.extensionId]]"
            extension-name="[[
                prefs.default_search_provider_data.template_url_data.controlledByName]]"
            extension-can-be-disabled="[[
                prefs.default_search_provider_data.template_url_data.extensionCanBeDisabled]]"
            on-disable-extension="onDisableExtension_">
        </extension-controlled-indicator>
      </div>
    </template>

    <!-- Manage search engines -->
    <cr-link-row class="hr" id="enginesSubpageTrigger"
        label="$i18n{searchEnginesManageSiteSearch}"
        on-click="onManageSearchEnginesClick_"
        role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
  </div>
</settings-section>
<!--_html_template_end_-->`}const SettingsSearchPageElementBase=SettingsViewMixin(WebUiListenerMixin(I18nMixin(PolymerElement)));class SettingsSearchPageElement extends SettingsSearchPageElementBase{static get is(){return"settings-search-page"}static get template(){return getTemplate$c()}static get properties(){return{prefs:Object,searchEngines_:Array,defaultSearchEngine_:{type:Object,computed:"computeDefaultSearchEngine_(searchEngines_)"},showSearchEngineListDialog_:Boolean,confirmationToastLabel_:String}}browserProxy_=SearchEnginesBrowserProxyImpl.getInstance();isEeaChoiceCountry_=loadTimeData.getBoolean("isEeaChoiceCountry");ready(){super.ready();const updateSearchEngines=searchEngines=>{this.searchEngines_=searchEngines.defaults};this.browserProxy_.getSearchEnginesList().then(updateSearchEngines);this.addWebUiListener("search-engines-changed",updateSearchEngines)}connectedCallback(){super.connectedCallback();this.setFaviconSize_()}onDisableExtension_(){this.dispatchEvent(new CustomEvent("refresh-pref",{bubbles:true,composed:true,detail:"default_search_provider.enabled"}))}onManageSearchEnginesClick_(){Router.getInstance().navigateTo(routes.SEARCH_ENGINES)}isDefaultSearchControlledByPolicy_(pref){return pref.controlledBy===chrome.settingsPrivate.ControlledBy.USER_POLICY}isDefaultSearchEngineEnforced_(pref){return pref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED}computeDefaultSearchEngine_(){if(!this.searchEngines_.length){return null}return this.searchEngines_.find((engine=>engine.default))}onOpenDialogButtonClick_(){this.showSearchEngineListDialog_=true;chrome.metricsPrivate.recordUserAction("ChooseDefaultSearchEngine")}onDefaultSearchEngineChangedInDialog_(e){this.confirmationToastLabel_=this.i18n("searchEnginesConfirmationToastLabel",e.detail.searchEngine.name);this.shadowRoot.querySelector("#confirmationToast").show()}onSearchEngineListDialogClose_(){this.showSearchEngineListDialog_=false}setFaviconSize_(){this.style.setProperty("--favicon-size",this.isEeaChoiceCountry_?"24px":"16px")}getFocusConfig(){return new Map([[routes.SEARCH_ENGINES.path,"#enginesSubpageTrigger"]])}getAssociatedControlFor(childViewId){assert(childViewId==="searchEngines");const control=this.shadowRoot.querySelector("#enginesSubpageTrigger");assert(control);return control}}customElements.define(SettingsSearchPageElement.is,SettingsSearchPageElement);function getTemplate$b(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-search-page slot="view" id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.SEARCH.path]]">
  </settings-search-page>

  <settings-search-engines-page slot="view" id="searchEngines"
      data-parent-view-id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.SEARCH_ENGINES.path]]">
  </settings-search-engines-page>
</cr-view-manager>
<!--_html_template_end_-->`}const SettingsSearchPageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsSearchPageIndexElement extends SettingsSearchPageIndexElementBase{static get is(){return"settings-search-page-index"}static get template(){return getTemplate$b()}static get properties(){return{prefs:Object,routes_:{type:Object,value:()=>routes}}}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.SEARCH:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.SEARCH_ENGINES:this.$.viewManager.switchView("searchEngines","no-animation","no-animation");break;case routes.BASIC:this.$.viewManager.switchView("parent","no-animation","no-animation");break}}))}}customElements.define(SettingsSearchPageIndexElement.is,SettingsSearchPageIndexElement);function getTemplate$a(){return html$1`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#profile-icon{background:center/cover no-repeat;border-radius:20px;flex-shrink:0;height:40px;width:40px}cr-link-row{--cr-link-row-icon-width:40px;border-top:var(--cr-separator-line)}settings-sync-account-control[showing-promo]::part(banner){border-top-left-radius:var(--cr-card-border-radius);border-top-right-radius:var(--cr-card-border-radius)}settings-sync-account-control[showing-promo]::part(title){font-size:1.1rem;line-height:1.625rem}#account-card{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow);flex:1;margin-bottom:20px;margin-top:16px;overflow:hidden}@media (forced-colors:active){#account-card{border:var(--cr-border-hcm)}}
    </style>


  <template is="dom-if" if="[[shouldShowSyncAccountControl_(
      syncStatus.syncSystemEnabled, syncStatus.signedInStatus)]]" restamp>
    <div id="account-card">
      <settings-sync-account-control
          sync-status="[[syncStatus]]"
          prefs="{{prefs}}"
          promo-label-with-account="$i18n{peopleSignInPrompt}"
          promo-label-with-no-account="$i18n{peopleSignInPrompt}"
          promo-secondary-label-with-account=
              "$i18n{peopleSignInPromptSecondaryWithAccount}"
          promo-secondary-label-with-no-account=
              "$i18n{peopleSignInPromptSecondaryWithNoAccount}">
      </settings-sync-account-control>
    </div>
  </template>
  <template is="dom-if" if="[[shouldLinkToAccountSettingsPage_(
      syncStatus.signedInState)]]" restamp>
    <div id="account-card">
      <cr-link-row id="account-subpage-row" on-click="onAccountClick_">
        <div id="profile-icon"
            style="background-image: [[getIconImageSet_(
                primaryAccountIconUrl_)]]">
        </div>
        <div class="cr-row-gap cr-padded-text flex no-min-width">
          <div id="account-name" class="text-elide">
            [[primaryAccountName_]]
          </div>
          <div id="account-subtitle" class="secondary">
            [[getAccountRowSubtitle_(primaryAccountEmail_, syncStatus)]]
          </div>
        </div>
      </cr-link-row>
    </div>
  </template>



<!--_html_template_end_-->`}const SettingsAccountCardElementBase=WebUiListenerMixin(PolymerElement);class SettingsAccountCardElement extends SettingsAccountCardElementBase{static get is(){return"settings-account-card"}static get template(){return getTemplate$a()}static get properties(){return{prefs:{type:Object,notify:true},signinAllowed_:{type:Boolean,value(){return loadTimeData.getBoolean("signinAllowed")}},syncStatus:Object,storedAccounts:Object,replaceSyncPromosWithSignInPromos_:{type:Boolean,value:()=>loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")},primaryAccountName_:String,primaryAccountEmail_:String,primaryAccountIconUrl_:String}}syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));this.addWebUiListener("sync-status-changed",this.handleSyncStatus_.bind(this));this.syncBrowserProxy_.getStoredAccounts().then(this.handleStoredAccounts_.bind(this));this.addWebUiListener("stored-accounts-updated",this.handleStoredAccounts_.bind(this))}handleSyncStatus_(syncStatus){const shouldRecordSigninImpression=!this.syncStatus&&syncStatus&&this.signinAllowed_&&!this.isSyncing_();this.syncStatus=syncStatus;if(shouldRecordSigninImpression&&!this.shouldShowSyncAccountControl_()){chrome.metricsPrivate.recordUserAction("Signin_Impression_FromSettings")}}onAccountClick_(){Router.getInstance().navigateTo(routes.ACCOUNT)}shouldLinkToAccountSettingsPage_(){return this.replaceSyncPromosWithSignInPromos_&&!!this.syncStatus&&this.syncStatus.signedInState===SignedInState.SIGNED_IN}shouldShowSyncAccountControl_(){if(this.syncStatus===undefined){return false}return!!this.syncStatus.syncSystemEnabled&&this.signinAllowed_&&!this.shouldLinkToAccountSettingsPage_()}handleStoredAccounts_(accounts){this.storedAccounts=accounts;if(accounts.length===0){return}this.primaryAccountName_=accounts[0].fullName;this.primaryAccountEmail_=accounts[0].email;this.primaryAccountIconUrl_=accounts[0].avatarImage}getAccountRowSubtitle_(){if(!!this.syncStatus&&!!this.syncStatus.statusText&&this.syncStatus.statusAction===StatusAction.ENTER_PASSPHRASE){return loadTimeData.substituteString(this.syncStatus.statusText,this.primaryAccountEmail_)}return this.primaryAccountEmail_}getIconImageSet_(iconUrl){return getImage(iconUrl)}isSyncing_(){return!!this.syncStatus&&this.syncStatus.signedInState===SignedInState.SYNCING}}customElements.define(SettingsAccountCardElement.is,SettingsAccountCardElement);function getTemplate$9(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{background-color:var(--cr-card-background-color);box-shadow:var(--cr-card-shadow);border-radius:var(--cr-card-border-radius)}hr{border:none;border-top:1px solid var(--cr-separator-color);margin:0 20px}.chips-container{padding:8px;display:grid;grid-template-columns:repeat(auto-fill,minmax(180px,1fr));gap:16px}cr-chip{--chip-icon-size_:var(--cr-icon-size);--color-chip-border:transparent;--color-chip-icon:var(--cr-secondary-text-color);--cr-chip-border-radius:20px;--cr-chip-height:36px;display:flex;flex-direction:column}cr-chip span{font-weight:normal}cr-chip cr-icon{width:var(--chip-icon-size_);height:var(--chip-icon-size_);margin-inline-start:8px;margin-inline-end:10px}.counter{color:var(--cr-secondary-text-color)}</style>

<cr-link-row label="[[cardTitle]]" external="[[isExternal]]">
</cr-link-row>
<hr>
<div class="chips-container">
  <template is="dom-repeat" items="[[chips]]">
    <cr-chip>
      <cr-icon icon="[[item.icon]]"></cr-icon>
      <span>[[item.label]]</span>
      <span class="counter" hidden$="[[!item.counter]]">
        ([[item.counter]])
      </span>
    </cr-chip>
  </template>
</div>
<!--_html_template_end_-->`}class CategoryReferenceCardElement extends PolymerElement{static get is(){return"category-reference-card"}static get template(){return getTemplate$9()}static get properties(){return{cardTitle:String,chips:{type:Array,value:()=>[]},isExternal:{type:Boolean}}}focus(){this.shadowRoot.querySelector("cr-link-row").focus()}}customElements.define(CategoryReferenceCardElement.is,CategoryReferenceCardElement);function getTemplate$8(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared settings-columned-section">#header-text{border-inline-end:var(--cr-separator-line)}#expandedContent{border-top:var(--cr-separator-line)}</style>

<cr-expand-button class="cr-row first" expanded="{{expanded_}}">
  <div id="header-text">
    <div>$i18n{yourSavedInfoAutofillSettingsLabel}</div>
    <div class="cr-secondary-text">
      $i18n{yourSavedInfoAutofillSettingsDescription}
    </div>
  </div>
</cr-expand-button>
<cr-collapse id="expandedContent" opened="[[expanded_]]">
  <settings-toggle-button id="optInToggle"
      on-settings-boolean-control-change="onOptInToggleChange_"
      disabled="[[!enhancedAutofillEligibleUser_]]"
      pref="{{enhancedAutofillOptedIn_}}" no-extension-indicator
      label="$i18n{autofillAiPageTitle}"
      sub-label="$i18n{autofillAiToggleSubLabel}">
  </settings-toggle-button>

  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingWhenOn}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:sync-saved-locally" aria-hidden="true">
          </cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiWhenOnSavedInfo}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:text-analysis" aria-hidden="true">
          </cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiWhenOnUseToFill}
          </div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiToConsiderDataUsage}
          </div>
        </li>
        <template is="dom-if" if="[[showLoggingInfoBullet_(
            prefs.optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed.value)]]"
            restamp>
          <settings-ai-logging-info-bullet
              id="enterpriseInfoBullet"
              pref=
                  "[[prefs.optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed]]"
              logging-managed-disabled-custom-label=
                  "$i18n{autofillAiSubpageSublabelLoggingManagedDisabled}">
          </settings-ai-logging-info-bullet>
        </template>
      </ul>
    </div>
  </div>
</cr-collapse>
<!--_html_template_end_-->`}class CollapsibleCardElement extends(SettingsViewMixin(PrefsMixin(PolymerElement))){static get is(){return"collapsible-autofill-settings-card"}static get template(){return getTemplate$8()}static get properties(){return{expanded_:{type:Boolean,value:false},enhancedAutofillEligibleUser_:{type:Boolean,value(){return loadTimeData.getBoolean("userEligibleForAutofillAi")}},enhancedAutofillOptedIn_:{type:Object,value:()=>({type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false})}}}static get observers(){return["onAutofillAiPrefChanged_(prefs.autofill.profile_enabled.value)"]}entityInstancesChangedListener_=null;entityDataManager_=EntityDataManagerProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.entityDataManager_.getOptInStatus().then((enhancedAutofillOptedIn=>{this.set("enhancedAutofillOptedIn_.value",this.enhancedAutofillEligibleUser_&&enhancedAutofillOptedIn)}));const policyDisabled=this.getPref(AiEnterpriseFeaturePrefName.AUTOFILL_AI).value===ModelExecutionEnterprisePolicyValue.DISABLE;if(policyDisabled){this.set("enhancedAutofillOptedIn_.enforcement",chrome.settingsPrivate.Enforcement.ENFORCED);this.set("enhancedAutofillOptedIn_.controlledBy",chrome.settingsPrivate.ControlledBy.USER_POLICY)}}disconnectedCallback(){super.disconnectedCallback();if(this.entityInstancesChangedListener_){this.entityDataManager_.removeEntityInstancesChangedListener(this.entityInstancesChangedListener_);this.entityInstancesChangedListener_=null}}async onOptInToggleChange_(){this.enhancedAutofillEligibleUser_=await this.entityDataManager_.setOptInStatus(this.$.optInToggle.checked);if(!this.enhancedAutofillEligibleUser_){this.set("enhancedAutofillOptedIn_.value",false)}}showLoggingInfoBullet_(prefValue){return prefValue!==ModelExecutionEnterprisePolicyValue.ALLOW}async onAutofillAiPrefChanged_(prefValue){const enhancedAutofillOptedIn=await this.entityDataManager_.getOptInStatus();this.set("enhancedAutofillOptedIn_.value",this.enhancedAutofillEligibleUser_&&enhancedAutofillOptedIn&&prefValue)}}customElements.define(CollapsibleCardElement.is,CollapsibleCardElement);({$:mojo.internal.Enum()});var EntityTypeName;(function(EntityTypeName){EntityTypeName[EntityTypeName["MIN_VALUE"]=0]="MIN_VALUE";EntityTypeName[EntityTypeName["MAX_VALUE"]=6]="MAX_VALUE";EntityTypeName[EntityTypeName["kPassport"]=0]="kPassport";EntityTypeName[EntityTypeName["kDriversLicense"]=1]="kDriversLicense";EntityTypeName[EntityTypeName["kVehicle"]=2]="kVehicle";EntityTypeName[EntityTypeName["kNationalIdCard"]=3]="kNationalIdCard";EntityTypeName[EntityTypeName["kKnownTravelerNumber"]=4]="kKnownTravelerNumber";EntityTypeName[EntityTypeName["kRedressNumber"]=5]="kRedressNumber";EntityTypeName[EntityTypeName["kFlightReservation"]=6]="kFlightReservation"})(EntityTypeName||(EntityTypeName={}));class SavedInfoHandlerImpl{getPasswordCount(){return sendWithPromise("getPasswordCount")}getLoyaltyCardsCount(){return sendWithPromise("getLoyaltyCardsCount")}static getInstance(){return instance$1||(instance$1=new SavedInfoHandlerImpl)}static setInstance(obj){instance$1=obj}}let instance$1=null;function getTemplate$7(){return html$1`<!--_html_template_start_--><style include="settings-shared">#title{color:var(--cr-primary-text-color);font-size:1.375rem;font-weight:500;letter-spacing:0.02em;margin-bottom:8px;margin-top:24px;outline:none;text-align:center}#subtitle{font-size:0.813rem;line-height:1.25rem;margin:8px auto 4px auto;max-width:400px;text-align:center}.section-header{color:var(--cr-primary-text-color);font-size:0.88rem;font-weight:400;letter-spacing:0.02em;margin-bottom:12px;margin-top:var(--cr-section-vertical-margin);outline:none;padding-bottom:4px;padding-top:8px}.card-container{display:flex;flex-direction:column;gap:16px}</style>

<h1 id="title">$i18n{yourSavedInfoPageTitle}</h1>
<div id="subtitle" class="secondary">$i18n{yourSavedInfoPageDescription}</div>
<settings-account-card prefs="{{prefs}}">
</settings-account-card>

<h2 id="yourSavedInfoPageTitle" class="section-header">
  $i18n{yourSavedInfoPageTitle}
</h2>
<div class="card-container">
  <category-reference-card card-title="$i18n{localPasswordManager}"
      is-external chips="[[passwordsCardData_]]"
      on-click="onPasswordManagerExternalLinkClick_">
  </category-reference-card>
  <category-reference-card id="paymentManagerButton"
      card-title="$i18n{paymentsTitle}" chips="[[paymentsCardData_]]"
      on-click="onPaymentManagerClick_">
  </category-reference-card>
  <category-reference-card id="addressesManagerButton"
      card-title="$i18n{contactInfoTitle}" chips="[[addressesCardData_]]"
      on-click="onAddressesManagerClick_">
  </category-reference-card>
  <category-reference-card id="identityManagerButton"
      card-title="$i18n{identityDocsCardTitle}"
      chips="[[identityCardData_]]" on-click="onIdentityManagerClick_">
  </category-reference-card>
  <category-reference-card id="travelManagerButton"
      card-title="$i18n{travelCardTitle}" chips="[[travelCardData_]]"
      on-click="onTravelManagerClick_">
  </category-reference-card>
</div>

<settings-section page-title="$i18n{yourSavedInfoAutofillSettingsLabel}">
  <collapsible-autofill-settings-card prefs="{{prefs}}">
  </collapsible-autofill-settings-card>
</settings-section>

<settings-section page-title="$i18n{yourSavedInfoRelatedServicesTitle}">
  <div route-path="default">
    <cr-link-row id="passwordManagerButton" label="$i18n{localPasswordManager}"
        on-click="onPasswordManagerExternalLinkClick_"
        start-icon="cr20:password" external>
    </cr-link-row>
    <cr-link-row id="googleWalletButton" label="$i18n{googleWalletTitle}"
        on-click="onGoogleWalletExternalLinkClick_"
        start-icon="settings20:wallet" external>
    </cr-link-row>
    <cr-link-row id="googleAccountButton" label="$i18n{googleAccount}"
        on-click="onGoogleAccountExternalLinkClick_"
        start-icon="settings20:googleg" external>
    </cr-link-row>
  </div>
</settings-section>
<!--_html_template_end_-->`}const SettingsYourSavedInfoPageElementBase=WebUiListenerMixin(SettingsViewMixin(PrefsMixin(I18nMixin(PolymerElement))));class SettingsYourSavedInfoPageElement extends SettingsYourSavedInfoPageElementBase{static get is(){return"settings-your-saved-info-page"}static get template(){return getTemplate$7()}static get properties(){return{prefs:Object,passwordsCardData_:{type:Array,computed:"computePasswordsCardData_(passwordsCount, passkeysCount)"},paymentsCardData_:{type:Array,computed:"computePaymentsCardData_(creditCardsCount, ibansCount, payOverTimeIssuersCount, loyaltyCardsCount, enableIbans_, enablePayOverTime_)"},addressesCardData_:{type:Array,computed:"computeAddressesCardData_(addressesCount)"},identityCardData_:{type:Array,computed:"computeIdentityCardData_(driversLicensesCount, nationalIdCardsCount, passportsCount)"},travelCardData_:{type:Array,computed:"computeTravelCardData_(flightReservationsCount, travelInfoCount, vehiclesCount)"},enableIbans_:{type:Boolean,value(){return loadTimeData.getBoolean("showIbansSettings")}},enablePayOverTime_:{type:Boolean,value(){return loadTimeData.getBoolean("shouldShowPayOverTimeSettings")}},passwordsCount:Number,passkeysCount:Number,addressesCount:Number,creditCardsCount:Number,ibansCount:Number,payOverTimeIssuersCount:Number,passportsCount:Number,driversLicensesCount:Number,vehiclesCount:Number,nationalIdCardsCount:Number,travelInfoCount:Number,flightReservationsCount:Number,loyaltyCardsCount:Number}}paymentsManager_=PaymentsManagerImpl.getInstance();autofillManager_=AutofillManagerImpl.getInstance();autofillAiEntityManager_=EntityDataManagerProxyImpl.getInstance();setPersonalDataListener_=null;onAutofillAiEntitiesChangedListener_=null;connectedCallback(){super.connectedCallback();this.setupDataTypeCounters()}setupDataTypeCounters(){const setPasswordCount=count=>{this.passwordsCount=count.passwordCount;this.passkeysCount=count.passkeyCount};this.addWebUiListener("password-count-changed",setPasswordCount);SavedInfoHandlerImpl.getInstance().getPasswordCount().then(setPasswordCount);const setAddressesListener=addresses=>{this.addressesCount=addresses.length};this.autofillManager_.getAddressList().then(setAddressesListener);const setCreditCardsListener=creditCards=>{this.creditCardsCount=creditCards.length};const setIbansListener=ibans=>{this.ibansCount=ibans.length};const setPayOverTimeListener=payOverTimeIssuers=>{this.payOverTimeIssuersCount=payOverTimeIssuers.length};this.paymentsManager_.getCreditCardList().then(setCreditCardsListener);this.paymentsManager_.getIbanList().then(setIbansListener);this.paymentsManager_.getPayOverTimeIssuerList().then(setPayOverTimeListener);const setPersonalDataListener=(addresses,creditCards,ibans,payOverTimeIssuers,_accountInfo)=>{this.addressesCount=addresses.length;this.creditCardsCount=creditCards.length;this.ibansCount=ibans.length;this.payOverTimeIssuersCount=payOverTimeIssuers.length};this.setPersonalDataListener_=setPersonalDataListener;this.autofillManager_.setPersonalDataManagerListener(setPersonalDataListener);this.onAutofillAiEntitiesChangedListener_=this.onAutofillAiEntitiesChanged.bind(this);this.autofillAiEntityManager_.addEntityInstancesChangedListener(this.onAutofillAiEntitiesChangedListener_);this.autofillAiEntityManager_.loadEntityInstances().then(this.onAutofillAiEntitiesChangedListener_);const setLoyaltyCardsCount=loyaltyCardsCount=>{this.loyaltyCardsCount=loyaltyCardsCount};this.addWebUiListener("loyalty-cards-count-changed",setLoyaltyCardsCount);SavedInfoHandlerImpl.getInstance().getLoyaltyCardsCount().then(setLoyaltyCardsCount)}onAutofillAiEntitiesChanged(entities){const entityCounts=new Map;for(const entity of entities){const newCount=(entityCounts.get(entity.type.typeName)||0)+1;entityCounts.set(entity.type.typeName,newCount)}this.passportsCount=entityCounts.get(EntityTypeName.kPassport)??0;this.driversLicensesCount=entityCounts.get(EntityTypeName.kDriversLicense)??0;this.vehiclesCount=entityCounts.get(EntityTypeName.kVehicle)??0;this.nationalIdCardsCount=entityCounts.get(EntityTypeName.kNationalIdCard)??0;this.travelInfoCount=(entityCounts.get(EntityTypeName.kKnownTravelerNumber)??0)+(entityCounts.get(EntityTypeName.kRedressNumber)??0);this.flightReservationsCount=entityCounts.get(EntityTypeName.kFlightReservation)??0}disconnectedCallback(){super.disconnectedCallback();if(this.setPersonalDataListener_){this.autofillManager_.removePersonalDataManagerListener(this.setPersonalDataListener_);this.setPersonalDataListener_=null}if(this.onAutofillAiEntitiesChangedListener_){this.autofillAiEntityManager_.removeEntityInstancesChangedListener(this.onAutofillAiEntitiesChangedListener_);this.onAutofillAiEntitiesChangedListener_=null}}getFocusConfig(){const map=new Map;if(routes.PAYMENTS){map.set(routes.PAYMENTS.path,"#paymentManagerButton")}if(routes.ADDRESSES){map.set(routes.ADDRESSES.path,"#addressesManagerButton")}return map}getAssociatedControlFor(childViewId){const ids=["addresses","payments"];assert(ids.includes(childViewId));let triggerId=null;switch(childViewId){case"addresses":triggerId="addressesManagerButton";break;case"payments":triggerId="paymentManagerButton";break}assert(triggerId);const control=this.shadowRoot.querySelector(`#${triggerId}`);assert(control);return control}computePasswordsCardData_(){return[{label:this.i18n("passwordsLabel"),icon:"cr20:password",counter:this.passwordsCount},{label:this.i18n("passkeysLabel"),icon:"settings20:passkey",counter:this.passkeysCount}]}computePaymentsCardData_(){const cardData=[{label:this.i18n("creditAndDebitCardTitle"),icon:"settings20:credit-card",counter:this.creditCardsCount}];if(this.enableIbans_){cardData.push({label:this.i18n("ibanTitle"),icon:"settings20:iban",counter:this.ibansCount})}if(this.enablePayOverTime_){cardData.push({label:this.i18n("autofillPayOverTimeSettingsLabel"),icon:"settings20:hourglass",counter:this.payOverTimeIssuersCount})}cardData.push({label:this.i18n("loyaltyCardsTitle"),icon:"settings20:loyalty-programs",counter:this.loyaltyCardsCount});return cardData}computeAddressesCardData_(){return[{label:this.i18n("addresses"),icon:"settings:email",counter:this.addressesCount}]}computeIdentityCardData_(){return[{label:this.i18n("yourSavedInfoDriverLicenseChip"),icon:"settings20:id-card",counter:this.driversLicensesCount},{label:this.i18n("yourSavedInfoNationalIdChip"),icon:"settings20:id-card",counter:this.nationalIdCardsCount},{label:this.i18n("yourSavedInfoPassportChip"),icon:"settings20:passport",counter:this.passportsCount}]}computeTravelCardData_(){return[{label:this.i18n("yourSavedInfoFlightReservationsChip"),icon:"firstLevelTopics20:travel",counter:this.flightReservationsCount},{label:this.i18n("yourSavedInfoTravelInfoChip"),icon:"privacy20:person-check",counter:this.travelInfoCount},{label:this.i18n("yourSavedInfoVehiclesChip"),icon:"firstLevelTopics20:directions-car",counter:this.vehiclesCount}]}onPaymentManagerClick_(){Router.getInstance().navigateTo(routes.PAYMENTS)}onAddressesManagerClick_(){Router.getInstance().navigateTo(routes.ADDRESSES)}onIdentityManagerClick_(){Router.getInstance().navigateTo(routes.BASIC)}onTravelManagerClick_(){Router.getInstance().navigateTo(routes.BASIC)}onPasswordManagerExternalLinkClick_(){PasswordManagerImpl.getInstance().recordPasswordsPageAccessInSettings();PasswordManagerImpl.getInstance().showPasswordManager(PasswordManagerPage.PASSWORDS)}onGoogleWalletExternalLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("googleWalletUrl"))}onGoogleAccountExternalLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("googleAccountUrl"))}}customElements.define(SettingsYourSavedInfoPageElement.is,SettingsYourSavedInfoPageElement);function getTemplate$6(){return html$1`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">

  <settings-your-saved-info-page slot="view" id="parent" prefs="{{prefs}}">
  </settings-your-saved-info-page>

  <settings-autofill-section slot="view" id="addresses" prefs="{{prefs}}"
      data-parent-view-id="parent">
  </settings-autofill-section>



  <settings-payments-section slot="view" id="payments" prefs="{{prefs}}"
      data-parent-view-id="parent">
  </settings-payments-section>

</cr-view-manager>
<!--_html_template_end_-->`}const SettingsYourSavedInfoPageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsYourSavedInfoPageIndexElement extends SettingsYourSavedInfoPageIndexElementBase{static get is(){return"settings-your-saved-info-page-index"}static get template(){return getTemplate$6()}static get properties(){return{prefs:Object}}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.YOUR_SAVED_INFO:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.BASIC:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.ADDRESSES:this.$.viewManager.switchView("addresses","no-animation","no-animation");break;case routes.PAYMENTS:this.$.viewManager.switchView("payments","no-animation","no-animation");break}}))}}customElements.define(SettingsYourSavedInfoPageIndexElement.is,SettingsYourSavedInfoPageIndexElement);class DefaultBrowserBrowserProxyImpl{requestDefaultBrowserState(){return sendWithPromise("requestDefaultBrowserState")}setAsDefaultBrowser(pin){chrome.send("setAsDefaultBrowser",[pin])}static getInstance(){return instance||(instance=new DefaultBrowserBrowserProxyImpl)}static setInstance(obj){instance=obj}}let instance=null;function getTemplate$5(){return html$1`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared"></style>
  <settings-section page-title="$i18n{defaultBrowser}"
      class="cr-centered-card-container">
    <template is="dom-if" if="[[maySetDefaultBrowser_]]">
      <div class="cr-row first">
        <div class="flex cr-padded-text">
          <div id="canBeDefaultBrowser">$i18n{defaultBrowser}</div>
          <div class="secondary" id="makeDefaultLabel">
            [[getMakeDefaultLabel(canPin_)]]
          </div>
        </div>
        <div class="separator"></div>
        <cr-button on-click="onSetDefaultBrowserClick_">
          $i18n{defaultBrowserMakeDefaultButton}
        </cr-button>
      </div>
    </template>
    <template is="dom-if" if="[[!maySetDefaultBrowser_]]">
      <div class="cr-row first">
        <div class="flex cr-padded-text" hidden$="[[!isDefault_]]"
            id="isDefault">
          $i18n{defaultBrowserDefault}
        </div>
        <div class="flex cr-padded-text" hidden$="[[!isSecondaryInstall_]]"
            id="isSecondaryInstall">
          $i18n{defaultBrowserSecondary}
        </div>
        <div class="cr-padded-text" hidden$="[[!isUnknownError_]]"
            id="isUnknownError">
          $i18n{defaultBrowserError}
        </div>
      </div>
    </template>
  </settings-section>
<!--_html_template_end_-->`}const SettingsDefaultBrowserPageElementBase=WebUiListenerMixin(PolymerElement);class SettingsDefaultBrowserPageElement extends SettingsDefaultBrowserPageElementBase{static get is(){return"settings-default-browser-page"}static get template(){return getTemplate$5()}static get properties(){return{canPin_:Boolean,isDefault_:Boolean,isSecondaryInstall_:Boolean,isUnknownError_:Boolean,maySetDefaultBrowser_:Boolean}}browserProxy_=DefaultBrowserBrowserProxyImpl.getInstance();ready(){super.ready();this.addWebUiListener("browser-default-state-changed",this.updateDefaultBrowserState_.bind(this));this.browserProxy_.requestDefaultBrowserState().then(this.updateDefaultBrowserState_.bind(this))}updateDefaultBrowserState_(defaultBrowserState){this.canPin_=defaultBrowserState.canPin;this.isDefault_=false;this.isSecondaryInstall_=false;this.isUnknownError_=false;this.maySetDefaultBrowser_=false;if(defaultBrowserState.isDefault){this.isDefault_=true}else if(!defaultBrowserState.canBeDefault){this.isSecondaryInstall_=true}else if(!defaultBrowserState.isDisabledByPolicy&&!defaultBrowserState.isUnknownError){this.maySetDefaultBrowser_=true}else{this.isUnknownError_=true}}getMakeDefaultLabel(){return loadTimeData.getString(this.canPin_?"defaultBrowserMakeDefaultAndPin":"defaultBrowserMakeDefault")}onSetDefaultBrowserClick_(){this.browserProxy_.setAsDefaultBrowser(this.canPin_)}async searchContents(query){const searchRequest=await getSearchManager().search(query,this);return searchRequest.getSearchResult()}}customElements.define(SettingsDefaultBrowserPageElement.is,SettingsDefaultBrowserPageElement);let lazyLoadPromise=null;function ensureLazyLoaded(){if(lazyLoadPromise===null){const script=document.createElement("script");script.type="module";script.src=getTrustedScriptURL`./lazy_load.js`;document.body.appendChild(script);lazyLoadPromise=Promise.all(["settings-appearance-page","settings-autofill-section","settings-payments-section","settings-clear-browsing-data-dialog","settings-clear-browsing-data-dialog-v2","settings-search-engines-page","settings-a11y-page","settings-downloads-page","settings-languages-page","settings-reset-page","settings-system-page","settings-edit-dictionary-page"].map((name=>customElements.whenDefined(name)))).then((()=>{}))}return lazyLoadPromise}function getTemplate$4(){return html$1`<!--_html_template_start_--><style include="cr-shared-style">#noSearchResults{margin-top:80px;text-align:center}#noSearchResults div:first-child{font-size:123%;margin-bottom:10px}managed-footnote{border-top:none;margin-bottom:calc(-21px - 8px);padding-bottom:16px;padding-top:12px;position:relative;z-index:1}cr-view-manager{display:block;position:relative}cr-view-manager [hidden-by-search]{display:none}</style>
<div id="noSearchResults" hidden$="[[!showNoResultsFound_]]">
  <div>$i18n{searchNoResults}</div>
  <div>$i18nRaw{searchNoResultsHelp}</div>
</div>
<template is="dom-if" if="[[showManagedHeader_(inSearchMode_, lastRoute_)]]"
    restamp>
  <managed-footnote></managed-footnote>
</template>


  <template is="dom-if" if="[[showPage_(pageVisibility_.languages)]]">
    <settings-languages languages="{{languages_}}" prefs="{{prefs}}">
    </settings-languages>
  </template>


<template is="dom-if" if="[[showResetProfileBanner_]]" restamp>
  <settings-reset-profile-banner on-close="onResetProfileBannerClose_">
  </settings-reset-profile-banner>
</template>

<cr-view-manager id="switcher"
    show-all$="[[shouldShowAll_(inSearchMode_, lastRoute_)]]">
  <template is="dom-if" if="[[showPage_(pageVisibility_.people)]]">
    <div slot="view" id="people">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.PEOPLE, lastRoute_, inSearchMode_)]]">
        <settings-people-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-people-page-index>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showPage_(pageVisibility_.privacy)]]">
    <div slot="view" id="privacy">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.PRIVACY, lastRoute_, inSearchMode_)]]">
        <settings-privacy-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-privacy-page-index>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showAutofillPage_(pageVisibility_.autofill)]]">
    <div slot="view" id="autofill">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.AUTOFILL, lastRoute_, inSearchMode_)]]">
        <settings-autofill-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-autofill-page-index>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showYourSavedInfoPage_(
      pageVisibility_.yourSavedInfo)]]">
    <div slot="view" id="yourSavedInfo">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.YOUR_SAVED_INFO, lastRoute_, inSearchMode_)]]">
        <settings-your-saved-info-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-your-saved-info-page-index>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showPage_(pageVisibility_.performance)]]">
    <div slot="view" id="performance">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.PERFORMANCE, lastRoute_, inSearchMode_)]]">
        <settings-performance-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-performance-page-index>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showAiPage_(pageVisibility_.ai)]]">
    <div slot="view" id="ai">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.AI, lastRoute_, inSearchMode_)]]">
        <settings-ai-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-ai-page-index>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showPage_(pageVisibility_.appearance)]]">
    <div slot="view" id="appearance">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.APPEARANCE, lastRoute_, inSearchMode_)]]">
        <settings-appearance-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-appearance-page-index>
      </template>
    </div>
  </template>

  <div slot="view" id="search">
    <template is="dom-if" if="[[renderPlugin_(
        routes_.SEARCH, lastRoute_, inSearchMode_)]]">
      <settings-search-page-index prefs="{{prefs}}"
          in-search-mode="[[inSearchMode_]]">
      </settings-search-page-index>
    </template>
  </div>


  <template is="dom-if" if="[[showPage_(pageVisibility_.defaultBrowser)]]">
    <div slot="view" id="defaultBrowser">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.DEFAULT_BROWSER, lastRoute_, inSearchMode_)]]">
        <settings-default-browser-page></settings-default-browser-page>
      </template>
    </div>
  </template>


  <template is="dom-if" if="[[showPage_(pageVisibility_.onStartup)]]">
    <div slot="view" id="onStartup">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.ON_STARTUP, lastRoute_, inSearchMode_)]]">
        <settings-on-startup-page prefs="{{prefs}}">
        </settings-on-startup-page>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showPage_(pageVisibility_.languages)]]">
    <div slot="view" id="languages">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.LANGUAGES, lastRoute_, inSearchMode_)]]">


        <settings-languages-page-index prefs="{{prefs}}"
            languages="[[languages_]]" in-search-mode="[[inSearchMode_]]">
        </settings-languages-page-index>

      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showPage_(pageVisibility_.downloads)]]">
    <div slot="view" id="downloads">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.DOWNLOADS, lastRoute_, inSearchMode_)]]">
        <settings-downloads-page prefs="{{prefs}}"></settings-downloads-page>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[showPage_(pageVisibility_.a11y)]]">
    <div slot="view" id="a11y">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.ACCESSIBILITY, lastRoute_, inSearchMode_)]]">
        <settings-a11y-page-index prefs="{{prefs}}"
            in-search-mode="[[inSearchMode_]]">
        </settings-a11y-page-index>
      </template>
    </div>
  </template>


  <template is="dom-if" if="[[showPage_(pageVisibility_.system)]]">
    <div slot="view" id="system">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.SYSTEM, lastRoute_, inSearchMode_)]]">
        <settings-system-page prefs="{{prefs}}"></settings-system-page>
      </template>
    </div>
  </template>


  <template is="dom-if" if="[[showPage_(pageVisibility_.reset)]]">
    <div slot="view" id="reset">
      <template is="dom-if" if="[[renderPlugin_(
          routes_.RESET, lastRoute_, inSearchMode_)]]">
        <settings-reset-page></settings-reset-page>
      </template>
    </div>
  </template>

  <div slot="view" id="about">
    <template is="dom-if" if="[[renderPlugin_(
        routes_.ABOUT, lastRoute_, inSearchMode_)]]">
      <settings-about-page role="main" class="cr-centered-card-container"
          prefs="{{prefs}}">
      </settings-about-page>
    </template>
  </div>
</cr-view-manager>
<!--_html_template_end_-->`}const SettingsMainElementBase=RouteObserverMixin(PolymerElement);class SettingsMainElement extends SettingsMainElementBase{static get is(){return"settings-main"}static get template(){return getTemplate$4()}static get properties(){return{prefs:{type:Object,notify:true},pageVisibility_:{type:Object,value:()=>pageVisibility||{}},lastRoute_:{type:Object,value:null},routes_:{type:Object,value:()=>routes},inSearchMode_:{type:Boolean,value:false},showNoResultsFound_:{type:Boolean,value:false},showResetProfileBanner_:{type:Boolean,value(){return loadTimeData.getBoolean("showResetProfileBanner")}},toolbarSpinnerActive:{type:Boolean,value:false,notify:true},languages_:Object}}pendingViewSwitching_=new PromiseResolver;topLevelEquivalentRoute_=getTopLevelRoute();connectedCallback(){super.connectedCallback();this.setAttribute("role","main");requestIdleCallback((()=>ensureLazyLoaded()))}beforeNextRenderPromise_(){return new Promise((res=>{beforeNextRender(this,res)}))}async currentRouteChanged(route){this.pendingViewSwitching_=new PromiseResolver;if(routes.ADVANCED&&routes.ADVANCED.contains(route)){ensureLazyLoaded()}const effectiveRoute=route===routes.BASIC?this.topLevelEquivalentRoute_:route;if(this.lastRoute_===effectiveRoute){this.pendingViewSwitching_.resolve();return}this.lastRoute_=effectiveRoute;const newSection=effectiveRoute.section;let sectionElement=this.$.switcher.querySelector(`#${newSection}`);if(!sectionElement){await this.beforeNextRenderPromise_();if(this.lastRoute_!==effectiveRoute||!this.isConnected){this.pendingViewSwitching_.resolve();return}sectionElement=this.$.switcher.querySelector(`#${newSection}`)}assert(sectionElement);await this.$.switcher.switchView(sectionElement.id,"no-animation","no-animation");this.pendingViewSwitching_.resolve()}whenViewSwitchingDone(){return this.pendingViewSwitching_.promise}searchContents(query){this.inSearchMode_=true;this.toolbarSpinnerActive=true;if(query===""){this.$.switcher.toggleAttribute("show-all",false)}flush();const toSearch=Array.from(this.$.switcher.querySelectorAll("[slot=view] > *:not(dom-if)"));const promises=toSearch.map((element=>customElements.whenDefined(element.tagName.toLowerCase()).then((()=>element.searchContents(query).then((result=>{element.toggleAttribute("hidden-by-search",query===""?false:result.matchCount===0);return result}))))));return Promise.all(promises).then((results=>{const result=combineSearchResults(results);if(result.canceled){return}this.toolbarSpinnerActive=false;this.inSearchMode_=!result.wasClearSearch;this.showNoResultsFound_=this.inSearchMode_&&result.matchCount===0;if(this.inSearchMode_){getInstance().announce(this.showNoResultsFound_?loadTimeData.getString("searchNoResults"):loadTimeData.getStringF("searchResults",query))}}))}renderPlugin_(route){return this.inSearchMode_||!!this.lastRoute_&&route.contains(this.lastRoute_)}showPage_(visibility){return visibility!==false}showAiPage_(visibility){return loadTimeData.getBoolean("showAiPage")&&this.showPage_(visibility)}showAutofillPage_(visibility){return!loadTimeData.getBoolean("enableYourSavedInfoSettingsPage")&&this.showPage_(visibility)}showYourSavedInfoPage_(visibility){return loadTimeData.getBoolean("enableYourSavedInfoSettingsPage")&&this.showPage_(visibility)}showManagedHeader_(){return!this.inSearchMode_&&!!this.lastRoute_&&this.lastRoute_!==routes.ABOUT&&!this.lastRoute_.isSubpage()}shouldShowAll_(){return this.inSearchMode_&&!!this.lastRoute_&&!this.lastRoute_.isSubpage()}onResetProfileBannerClose_(){this.showResetProfileBanner_=false}}customElements.define(SettingsMainElement.is,SettingsMainElement);function getHtml(){return html`<slot></slot>`}const CrMenuSelectorBase=CrSelectableMixin(CrLitElement);class CrMenuSelector extends CrMenuSelectorBase{static get is(){return"cr-menu-selector"}render(){return getHtml.bind(this)()}connectedCallback(){super.connectedCallback();FocusOutlineManager.forDocument(document)}firstUpdated(changedProperties){super.firstUpdated(changedProperties);this.setAttribute("role","menu");this.addEventListener("focusin",this.onFocusin_.bind(this));this.addEventListener("keydown",this.onKeydown_.bind(this));this.addEventListener("iron-deselect",(e=>this.onIronDeselected_(e)));this.addEventListener("iron-select",(e=>this.onIronSelected_(e)))}getAllFocusableItems_(){return Array.from(this.querySelectorAll("[role=menuitem]:not([disabled]):not([hidden])"))}onFocusin_(e){const focusMovedWithKeyboard=FocusOutlineManager.forDocument(document).visible;const focusMovedFromOutside=e.relatedTarget===null||!this.contains(e.relatedTarget);if(focusMovedWithKeyboard&&focusMovedFromOutside){this.getAllFocusableItems_()[0].focus()}}onIronDeselected_(e){e.detail.item.removeAttribute("aria-current")}onIronSelected_(e){e.detail.item.setAttribute("aria-current","page")}onKeydown_(event){const items=this.getAllFocusableItems_();assert(items.length>=1);const currentFocusedIndex=items.indexOf(this.querySelector(":focus"));let newFocusedIndex=currentFocusedIndex;switch(event.key){case"Tab":if(event.shiftKey){items[0].focus()}else{items[items.length-1].focus({preventScroll:true})}return;case"ArrowDown":newFocusedIndex=(currentFocusedIndex+1)%items.length;break;case"ArrowUp":newFocusedIndex=(currentFocusedIndex+items.length-1)%items.length;break;case"Home":newFocusedIndex=0;break;case"End":newFocusedIndex=items.length-1;break}if(newFocusedIndex===currentFocusedIndex){return}event.preventDefault();items[newFocusedIndex].focus()}}customElements.define(CrMenuSelector.is,CrMenuSelector);const styleMod=document.createElement("dom-module");styleMod.appendChild(html$1`
  <template>
    <style>
.cr-nav-menu-item{--iron-icon-fill-color:var(--google-grey-700);--iron-icon-height:20px;--iron-icon-width:20px;--cr-icon-ripple-size:20px;align-items:center;border-end-end-radius:100px;border-start-end-radius:100px;box-sizing:border-box;color:var(--google-grey-900);display:flex;font-size:14px;font-weight:500;line-height:14px;margin-inline-end:2px;margin-inline-start:1px;min-height:40px;overflow:hidden;padding-block-end:10px;padding-block-start:10px;padding-inline-start:23px;padding-inline-end:16px;position:relative;text-decoration:none}:host-context(cr-drawer) .cr-nav-menu-item{margin-inline-end:8px}.cr-nav-menu-item:hover{background:var(--google-grey-200)}.cr-nav-menu-item[selected]{--iron-icon-fill-color:var(--google-blue-600);background:var(--google-blue-50);color:var(--google-blue-700)}@media (prefers-color-scheme:dark){.cr-nav-menu-item{--iron-icon-fill-color:var(--google-grey-500);color:white}.cr-nav-menu-item:hover{--iron-icon-fill-color:white;background:var(--google-grey-800)}.cr-nav-menu-item[selected]{--iron-icon-fill-color:black;background:var(--google-blue-300);color:var(--google-grey-900)}}.cr-nav-menu-item:focus{outline:auto 5px -webkit-focus-ring-color;z-index:1}.cr-nav-menu-item:focus:not([selected]):not(:hover){background:transparent}.cr-nav-menu-item cr-icon,.cr-nav-menu-item iron-icon{flex-shrink:0;margin-inline-end:20px;pointer-events:none;vertical-align:top}
    </style>
  </template>
`.content);styleMod.register("cr-nav-menu-item-style");function getTemplate$3(){return html$1`<!--_html_template_start_-->    <style include="cr-hidden-style cr-icons cr-nav-menu-item-style">:host{box-sizing:border-box;display:block;padding-bottom:5px;padding-top:8px}:host *{-webkit-tap-highlight-color:transparent}#menu{color:var(--google-grey-700);display:flex;flex-direction:column;min-width:fit-content}#extensionsLink>.cr-icon{height:var(--cr-icon-size);margin-inline-end:14px;width:var(--cr-icon-size)}.menu-separator{border-bottom:1px solid rgba(0,0,0,0.08);margin-bottom:8px;margin-top:8px}@media (prefers-color-scheme:dark){#menu{color:var(--cr-primary-text-color)}.menu-separator{border-bottom:var(--cr-separator-line)}}
    </style>

    <div role="navigation">
      <cr-menu-selector id="menu" selectable="a:not(#extensionsLink)"
          attr-for-selected="href" on-iron-activate="onSelectorActivate_"
          on-click="onLinkClick_" selected-attribute="selected">
        <a role="menuitem"
            id="people" href="/people" hidden="[[!pageVisibility_.people]]"
            class="cr-nav-menu-item">

          <cr-icon icon="settings:person"></cr-icon>


          $i18n{peoplePageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" id="yourSavedInfo" href="/yourSavedInfo"
            hidden="[[!showYourSavedInfoPageMenuItem_(
                enableYourSavedInfoSettingsPage_,
                pageVisibility_.yourSavedInfo)]]"
            class="cr-nav-menu-item">
          <cr-icon icon="settings20:saved-info"></cr-icon>
          $i18n{yourSavedInfoPageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" id="autofill" href="/autofill"
            hidden="[[!showAutofillPageMenuItem_(
                enableYourSavedInfoSettingsPage_,
                pageVisibility_.autofill)]]"
            on-click="onAutofillClick_"
            class="cr-nav-menu-item">
          <cr-icon icon="[[autofillIcon_]]"></cr-icon>
          $i18n{autofillPageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" href="/privacy"
            hidden="[[!pageVisibility_.privacy]]"
            class="cr-nav-menu-item">
          <cr-icon icon="settings:security"></cr-icon>
          $i18n{privacyPageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" id="performance" href="/performance"
            class="cr-nav-menu-item"
            hidden="[[!pageVisibility_.performance]]">
          <cr-icon icon="settings:navigation-performance"></cr-icon>
          $i18n{performancePageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" href="/ai"
            hidden="[[!showAiPageMenuItem_(showAiPage_, pageVisibility_.ai)]]"
            on-click="onAiPageClick_"
            class="cr-nav-menu-item">
          <cr-icon icon="settings20:magic"></cr-icon>
          $i18n{aiInnovationsPageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" id="appearance" href="/appearance"
            hidden="[[!pageVisibility_.appearance]]"
            class="cr-nav-menu-item">
          <cr-icon icon="settings:palette"></cr-icon>
          $i18n{appearancePageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" href="/search" class="cr-nav-menu-item">
          <cr-icon icon="settings:search"></cr-icon>
          $i18n{searchPageTitle}
          <cr-ripple></cr-ripple>
        </a>

        <a role="menuitem" id="defaultBrowser" class="cr-nav-menu-item"
          href="/defaultBrowser"
          hidden="[[!pageVisibility_.defaultBrowser]]">
          <cr-icon icon="settings:web"></cr-icon>
          $i18n{defaultBrowser}
          <cr-ripple></cr-ripple>
        </a>

        <a role="menuitem" id="onStartup" href="/onStartup"
            class="cr-nav-menu-item"
            hidden="[[!pageVisibility_.onStartup]]">
          <cr-icon icon="settings:power-settings"></cr-icon>
          $i18n{onStartup}
          <cr-ripple></cr-ripple>
        </a>
        <div class="menu-separator"></div>
        <a role="menuitem" id="languages" href="/languages"
            class="cr-nav-menu-item"
            hidden="[[!pageVisibility_.languages]]">
          <cr-icon icon="settings:navigation-language"></cr-icon>
          $i18n{languagesPageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" id="downloads" href="/downloads"
            class="cr-nav-menu-item"
            hidden="[[!pageVisibility_.downloads]]">
          <cr-icon icon="settings:download"></cr-icon>
          $i18n{downloadsPageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" id="accessibility" href="/accessibility"
            class="cr-nav-menu-item"
            hidden="[[!pageVisibility_.a11y]]">
          <cr-icon icon="settings:accessibility"></cr-icon>
          $i18n{a11yPageTitle}
          <cr-ripple></cr-ripple>
        </a>

        <a role="menuitem" id="system" href="/system" class="cr-nav-menu-item"
            hidden="[[!pageVisibility_.system]]">
          <cr-icon icon="settings:system"></cr-icon>
          $i18n{systemPageTitle}
          <cr-ripple></cr-ripple>
        </a>

        <a role="menuitem" id="reset" href="/reset"
            hidden="[[!pageVisibility_.reset]]" class="cr-nav-menu-item">
          <cr-icon icon="settings:restore"></cr-icon>
          $i18n{resetPageTitle}
          <cr-ripple></cr-ripple>
        </a>
        <div hidden="[[hideBottomMenuSeparator_(pageVisibility_)]]"
            class="menu-separator"></div>
        <a role="menuitem" id="extensionsLink" class="cr-nav-menu-item"
            href="chrome://extensions" target="_blank"
            hidden="[[!pageVisibility_.extensions]]"
            on-click="onExtensionsLinkClick_"
            title="$i18n{extensionsLinkTooltip}">
          <cr-icon icon="settings:extension"></cr-icon>
          <span>$i18n{extensionsPageTitle}</span>
          <div class="cr-icon icon-external"></div>
          <cr-ripple></cr-ripple>
        </a>
        <a role="menuitem" id="about-menu" href="/help"
            class="cr-nav-menu-item">
          <cr-icon icon="cr:chrome-product"></cr-icon>
          $i18n{aboutPageTitle}
          <cr-ripple></cr-ripple>
        </a>
      </cr-menu-selector>
    </div>
<!--_html_template_end_-->`}const SettingsMenuElementBase=RouteObserverMixin(PolymerElement);class SettingsMenuElement extends SettingsMenuElementBase{static get is(){return"settings-menu"}static get template(){return getTemplate$3()}static get properties(){return{pageVisibility_:{type:Object,value:()=>pageVisibility},showAiPage_:{type:Boolean,value:()=>loadTimeData.getBoolean("showAiPage")},enableYourSavedInfoSettingsPage_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableYourSavedInfoSettingsPage")},autofillIcon_:{type:String,value:()=>loadTimeData.getBoolean("enableYourSavedInfoBranding")?"settings20:saved-info":"settings:assignment"}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();showAiPageMenuItem_(){return this.showAiPage_&&(!this.pageVisibility_||this.pageVisibility_.ai!==false)}showYourSavedInfoPageMenuItem_(){return this.enableYourSavedInfoSettingsPage_&&(!this.pageVisibility_||this.pageVisibility_.yourSavedInfo!==false)}showAutofillPageMenuItem_(){return!this.enableYourSavedInfoSettingsPage_&&(!this.pageVisibility_||this.pageVisibility_.autofill!==false)}currentRouteChanged(newRoute){const anchors=this.shadowRoot.querySelectorAll("a");for(let i=0;i<anchors.length;++i){const pathname=anchors[i].getAttribute("href");const anchorRoute=Router.getInstance().getRouteForPath(pathname);if(anchorRoute&&anchorRoute.contains(newRoute)){this.setSelectedPath_(pathname);return}}this.setSelectedPath_("")}focusFirstItem(){const firstFocusableItem=this.shadowRoot.querySelector("[role=menuitem]:not([hidden])");if(firstFocusableItem){firstFocusableItem.focus()}}onLinkClick_(event){if(event.target.matches("a:not(#extensionsLink)")){event.preventDefault()}}setSelectedPath_(path){this.$.menu.selected=path}onSelectorActivate_(event){const path=event.detail.selected;this.setSelectedPath_(path);const route=Router.getInstance().getRouteForPath(path);assert(route,"settings-menu has an entry with an invalid route.");Router.getInstance().navigateTo(route,undefined,true)}onExtensionsLinkClick_(){chrome.metricsPrivate.recordUserAction("SettingsMenu_ExtensionsLinkClicked")}onAutofillClick_(){this.metricsBrowserProxy_.recordAutofillSettingsReferrer("Autofill.AutofillAndPasswordsSettingsPage.VisitReferrer",AutofillSettingsReferrer.SETTINGS_MENU)}onAiPageClick_(){this.metricsBrowserProxy_.recordAction("SettingsMenu_AiPageEntryPointClicked")}hideBottomMenuSeparator_(){if(!this.pageVisibility_){return false}const visibilities=[this.pageVisibility_.languages,this.pageVisibility_.downloads,this.pageVisibility_.a11y,this.pageVisibility_.system,this.pageVisibility_.reset];return visibilities.every((visibility=>visibility===false))}}customElements.define(SettingsMenuElement.is,SettingsMenuElement);const CrScrollObserverMixin=dedupingMixin((superClass=>{class CrScrollObserverMixin extends superClass{intersectionObserver_=null;topProbe_=null;bottomProbe_=null;connectedCallback(){super.connectedCallback();const container=this.getContainer();this.topProbe_=document.createElement("div");this.bottomProbe_=document.createElement("div");container.prepend(this.topProbe_);container.append(this.bottomProbe_);this.enableScrollObservation(true)}disconnectedCallback(){super.disconnectedCallback();this.enableScrollObservation(false)}getContainer(){const container=this.shadowRoot.querySelector("#container");assert(container);return container}getIntersectionObserver_(){const callback=entries=>{const container=this.getContainer();for(const entry of entries){const target=entry.target;if(target===this.topProbe_){container.classList.toggle("scrolled-to-top",entry.intersectionRatio!==0);const canScroll=entry.intersectionRatio===0||!container.classList.contains("scrolled-to-bottom");container.classList.toggle("can-scroll",canScroll)}if(target===this.bottomProbe_){container.classList.toggle("scrolled-to-bottom",entry.intersectionRatio!==0);const canScroll=entry.intersectionRatio===0||!container.classList.contains("scrolled-to-top");container.classList.toggle("can-scroll",canScroll)}}};return new IntersectionObserver(callback,{root:this.getContainer(),threshold:0})}enableScrollObservation(enable){if(enable===!!this.intersectionObserver_){return}if(!enable){this.intersectionObserver_.disconnect();this.intersectionObserver_=null;return}this.intersectionObserver_=this.getIntersectionObserver_();window.setTimeout((()=>{if(!this.isConnected){return}if(this.intersectionObserver_){assert(this.topProbe_);assert(this.bottomProbe_);this.intersectionObserver_.observe(this.topProbe_);this.intersectionObserver_.observe(this.bottomProbe_)}}))}}return CrScrollObserverMixin}));var CrContainerShadowSide;(function(CrContainerShadowSide){CrContainerShadowSide["TOP"]="top";CrContainerShadowSide["BOTTOM"]="bottom"})(CrContainerShadowSide||(CrContainerShadowSide={}));const CrContainerShadowMixin=dedupingMixin((superClass=>{const superClassBase=CrScrollObserverMixin(superClass);class CrContainerShadowMixin extends superClassBase{dropShadows_=new Map;sides_=[];connectedCallback(){super.connectedCallback();const container=this.shadowRoot.querySelector("#container");assert(container);const hasBottomShadow=container.hasAttribute("show-bottom-shadow");this.sides_=hasBottomShadow?[CrContainerShadowSide.TOP,CrContainerShadowSide.BOTTOM]:[CrContainerShadowSide.TOP];this.sides_.forEach((side=>{const shadow=document.createElement("div");shadow.id=`cr-container-shadow-${side}`;shadow.classList.add("cr-container-shadow");this.dropShadows_.set(side,shadow)}));container.parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.TOP),container);if(hasBottomShadow){container.parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.BOTTOM),container.nextSibling)}}setForceDropShadows(enabled){assert(this.sides_.length>0);for(const side of this.sides_){this.dropShadows_.get(side).classList.toggle("force-shadow",enabled)}}}return CrContainerShadowMixin}));function getTemplate$2(){return html$1`<!--_html_template_start_-->    <style include="cr-page-host-style settings-shared">:host{display:flex;flex-direction:column;height:100%;--settings-menu-width:266px;--settings-main-basis:calc(var(--cr-centered-card-max-width) / var(--cr-centered-card-width-percentage))}cr-toolbar{min-height:56px;--cr-toolbar-center-basis:var(--settings-main-basis)}cr-toolbar:not([narrow]){--cr-toolbar-left-spacer-width:var(--settings-menu-width)}@media (prefers-color-scheme:light){cr-toolbar{--iron-icon-fill-color:white}}#cr-container-shadow-top{z-index:2}#container{align-items:flex-start;display:flex;flex:1;overflow:overlay;position:relative}#left,#main,#right{flex:1 1 0}#left{height:100%;position:sticky;top:0}#left settings-menu{max-height:100%;overflow:auto;overscroll-behavior:contain;width:var(--settings-menu-width)}#main{flex-basis:var(--settings-main-basis)}@media (max-width:980px){#main{min-width:auto;padding:0 3px}}
    </style>
    <settings-prefs id="prefs" prefs="{{prefs}}"></settings-prefs>
    <cr-toolbar id="toolbar"
        page-name="$i18n{settings}"
        clear-label="$i18n{clearSearch}"
        autofocus
        search-prompt="$i18n{searchPrompt}"
        on-cr-toolbar-menu-click="onMenuButtonClick_"
        spinner-active="[[toolbarSpinnerActive_]]"
        menu-label="$i18n{menuButtonLabel}"
        on-search-changed="onSearchChanged_"
        role="banner"
        narrow="{{narrow_}}"
        narrow-threshold="980"
        show-menu="[[narrow_]]">
    </cr-toolbar>
    <cr-drawer id="drawer" on-close="onMenuClose_" heading="$i18n{settings}"
        align="$i18n{textdirection}">
      <div slot="body">
        <template is="dom-if" id="drawerTemplate">
          <settings-menu id="drawerMenu" on-iron-activate="onIronActivate_">
          </settings-menu>
        </template>
      </div>
    </cr-drawer>
    <div id="container" class="no-outline">
      <div id="left" hidden$="[[narrow_]]">
        <settings-menu id="leftMenu" on-iron-activate="onIronActivate_">
        </settings-menu>
      </div>
      <settings-main id="main" prefs="{{prefs}}"
          toolbar-spinner-active="{{toolbarSpinnerActive_}}">
      </settings-main>
      <!-- An additional child of the flex #container to take up space,
           aligned with the right-hand child of the flex toolbar. -->
      <div id="right" hidden$="[[narrow_]]"></div>
    </div>
<!--_html_template_end_-->`}const SettingsUiElementBase=RouteObserverMixin(CrContainerShadowMixin(FindShortcutMixin(PolymerElement)));class SettingsUiElement extends SettingsUiElementBase{static get is(){return"settings-ui"}static get template(){return getTemplate$2()}static get properties(){return{prefs:Object,toolbarSpinnerActive_:{type:Boolean,value:false},narrow_:{type:Boolean,observer:"onNarrowChanged_"},lastSearchQuery_:{type:String,value:""}}}constructor(){super();Router.getInstance().initializeRouteFromUrl()}ready(){super.ready();listenOnce(this.$.drawer,"cr-drawer-opening",(()=>{this.$.drawerTemplate.if=true}));window.addEventListener("popstate",(()=>{this.$.drawer.cancel()}));window.CrPolicyStrings={controlledSettingExtension:loadTimeData.getString("controlledSettingExtension"),controlledSettingExtensionWithoutName:loadTimeData.getString("controlledSettingExtensionWithoutName"),controlledSettingPolicy:loadTimeData.getString("controlledSettingPolicy"),controlledSettingRecommendedMatches:loadTimeData.getString("controlledSettingRecommendedMatches"),controlledSettingRecommendedDiffers:loadTimeData.getString("controlledSettingRecommendedDiffers"),controlledSettingChildRestriction:loadTimeData.getString("controlledSettingChildRestriction"),controlledSettingParent:loadTimeData.getString("controlledSettingParent")};this.addEventListener("refresh-pref",this.onRefreshPref_.bind(this))}connectedCallback(){super.connectedCallback();document.documentElement.classList.remove("loading");document.fonts.load("bold 12px Roboto");setGlobalScrollTarget(this.$.container)}disconnectedCallback(){super.disconnectedCallback();Router.getInstance().resetRouteForTesting();resetGlobalScrollTargetForTesting()}currentRouteChanged(route){if(route===routes.PRIVACY_GUIDE){this.setForceDropShadows(false);this.enableScrollObservation(true)}else if(route.depth<=1){this.setForceDropShadows(false);this.enableScrollObservation(true)}else if(!route.isNavigableDialog){this.enableScrollObservation(false);this.setForceDropShadows(true)}const urlSearchQuery=Router.getInstance().getQueryParameters().get("search")||"";if(urlSearchQuery===this.lastSearchQuery_){return}this.lastSearchQuery_=urlSearchQuery;const toolbar=this.shadowRoot.querySelector("cr-toolbar");const searchField=toolbar.getSearchField();if(urlSearchQuery!==searchField.getValue()){searchField.setValue(urlSearchQuery,true)}this.$.main.searchContents(urlSearchQuery)}handleFindShortcut(modalContextOpen){if(modalContextOpen){return false}this.shadowRoot.querySelector("cr-toolbar").getSearchField().showAndFocus();return true}searchInputHasFocus(){return this.shadowRoot.querySelector("cr-toolbar").getSearchField().isSearchFocused()}onRefreshPref_(e){return this.$.prefs.refresh(e.detail)}onSearchChanged_(e){const query=e.detail;Router.getInstance().navigateTo(routes.BASIC,query.length>0?new URLSearchParams("search="+encodeURIComponent(query)):undefined,true)}onIronActivate_(){this.$.drawer.close()}onMenuButtonClick_(){this.$.drawer.toggle()}onMenuClose_(){if(!this.$.drawer.wasCanceled()){return}this.$.container.setAttribute("tabindex","-1");this.$.container.focus();listenOnce(this.$.container,["blur","pointerdown"],(()=>{this.$.container.removeAttribute("tabindex")}))}onNarrowChanged_(){if(this.$.drawer.open&&!this.narrow_){this.$.drawer.close()}const focusedElement=this.shadowRoot.activeElement;if(this.narrow_&&focusedElement===this.$.leftMenu){this.$.toolbar.focusMenuButton()}else if(!this.narrow_&&this.$.toolbar.isMenuFocused()){this.$.leftMenu.focusFirstItem()}else if(!this.narrow_&&focusedElement===this.shadowRoot.querySelector("#drawerMenu")){const boundCloseListener=()=>{this.$.leftMenu.focusFirstItem();this.$.drawer.removeEventListener("close",boundCloseListener)};this.$.drawer.addEventListener("close",boundCloseListener)}}}customElements.define(SettingsUiElement.is,SettingsUiElement);function getTemplate$1(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">cr-icon{flex-shrink:0}li{column-gap:16px;display:flex;margin:16px 0}</style>
<li>
  <template is="dom-if" if="[[!isLoggingDisabledByPolicy_(pref)]]" restamp>
    <cr-icon icon="settings20:account-box" aria-hidden="true"></cr-icon>
  </template>
  <template is="dom-if" if="[[isLoggingDisabledByPolicy_(pref)]]" restamp>
    <cr-policy-pref-indicator id="policyIndicator" pref="[[pref]]">
    </cr-policy-pref-indicator>
  </template>
  <div class="secondary">[[label_]]</div>
</li><!--_html_template_end_-->`}const SettingsAiLoggingInfoBulletBase=PrefControlMixin(PolymerElement);class SettingsAiLoggingInfoBullet extends SettingsAiLoggingInfoBulletBase{static get is(){return"settings-ai-logging-info-bullet"}static get template(){return getTemplate$1()}static get properties(){return{label_:{type:String,computed:"computeLabel_(pref.value)"},loggingManagedDisabledCustomLabel:{type:String,value:null}}}isLoggingDisabledByPolicy_(){return this.pref?.value===ModelExecutionEnterprisePolicyValue.ALLOW_WITHOUT_LOGGING||this.pref?.value===ModelExecutionEnterprisePolicyValue.DISABLE}computeLabel_(){if(!this.isLoggingDisabledByPolicy_()){return loadTimeData.getString("aiSubpageSublabelReviewers")}if(this.loggingManagedDisabledCustomLabel){return this.loggingManagedDisabledCustomLabel}return loadTimeData.getString("aiSubpageSublabelLoggingManagedDisabled")}}customElements.define(SettingsAiLoggingInfoBullet.is,SettingsAiLoggingInfoBullet);function getTemplate(){return html$1`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{--icon-size:var(--search-engine-icon-size,24px)}.subtitle{font-size:0.75rem;line-height:22px}.title{margin:0 0 16px}.dialog-body{color:var(--cr-primary-text-color)}.search-engine{align-items:center;display:flex;flex-direction:row;gap:16px}site-favicon{--site-favicon-border-radius:4px;--site-favicon-height:var(--icon-size);--site-favicon-width:var(--icon-size)}#setAsDefaultButton{margin-inline-start:12px}#saveGuestChoiceCheckbox{margin-right:auto}cr-dialog{--cr-dialog-body-padding-horizontal:16px;--cr-dialog-button-container-padding-horizontal:24px;--cr-dialog-button-container-padding-bottom:24px;--cr-dialog-button-container-padding-top:24px;--cr-dialog-title-slot-padding-bottom:16px;--cr-dialog-title-slot-padding-end:16px;--cr-dialog-title-slot-padding-start:16px;--cr-dialog-title-slot-padding-top:16px}cr-dialog::part(body-container){max-height:360px}cr-radio-button{--cr-radio-button-size:20px;margin:0 16px}</style>

<cr-dialog id="dialog" on-cancel="onCancelClick_" show-on-attach>
  <div slot="title">
    <div class="title">$i18n{searchPageTitle}</div>
    <div class="subtitle">
      $i18n{searchEnginesSettingsDialogSubtitle}
    </div>
  </div>
  <div slot="body" class="dialog-body">
    <cr-radio-group selected="{{selectedEngineId_}}">
      <template is="dom-repeat" items="[[searchEngines]]">
        <cr-radio-button class="label-first" name="[[item.id]]">
          <div class="search-engine">
            <site-favicon favicon-url="[[item.iconURL]]" url="[[item.url]]"
                 icon-path="[[item.iconPath]]">
            </site-favicon>
            [[item.name]]
          </div>
        </cr-radio-button>
      </template>
    </cr-radio-group>
  </div>
  <div slot="button-container">
    <template is="dom-if" if="[[showSaveGuestChoice_]]" restamp>
      <cr-checkbox id="saveGuestChoiceCheckbox" checked="{{saveGuestChoice_}}">
        $i18n{saveGuestChoiceText}
      </cr-checkbox>
    </template>
    <cr-button id="cancelButton" on-click="onCancelClick_">
      $i18n{searchEnginesCancelButton}
    </cr-button>
    <cr-button id="setAsDefaultButton" class="action-button"
        on-click="onSetAsDefaultClick_" disabled="[[!searchEngines.length]]">
      $i18n{searchEnginesSetAsDefaultButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}const SettingsSearchEngineListDialogElementBase=WebUiListenerMixin(PolymerElement);class SettingsSearchEngineListDialogElement extends SettingsSearchEngineListDialogElementBase{static get is(){return"settings-search-engine-list-dialog"}static get template(){return getTemplate()}static get properties(){return{searchEngines:{type:Array,observer:"searchEnginesChanged_"},selectedEngineId_:{type:String,value:""},showSaveGuestChoice_:{type:Boolean,computed:"computeShowSaveGuestChoice_(saveGuestChoice_)"},saveGuestChoice_:{type:Boolean,value:null,notify:true}}}browserProxy_=SearchEnginesBrowserProxyImpl.getInstance();ready(){super.ready();this.browserProxy_.getSaveGuestChoice().then((saveGuestChoice=>{this.saveGuestChoice_=saveGuestChoice}))}onSetAsDefaultClick_(){const searchEngine=this.searchEngines.find((engine=>engine.id===parseInt(this.selectedEngineId_)));assert(searchEngine);this.browserProxy_.setDefaultSearchEngine(searchEngine.modelIndex,ChoiceMadeLocation.SEARCH_SETTINGS,this.saveGuestChoice_);this.dispatchEvent(new CustomEvent("search-engine-changed",{bubbles:true,composed:true,detail:{searchEngine:searchEngine}}));this.$.dialog.close()}onCancelClick_(){this.$.dialog.close()}searchEnginesChanged_(){if(!this.searchEngines.length){return}const defaultSearchEngine=this.searchEngines.find((searchEngine=>searchEngine.default));assert(defaultSearchEngine);this.selectedEngineId_=defaultSearchEngine.id.toString()}computeShowSaveGuestChoice_(saveGuestChoice){return saveGuestChoice!==null}}customElements.define(SettingsSearchEngineListDialogElement.is,SettingsSearchEngineListDialogElement);export{AboutPageBrowserProxyImpl,AiPageInteractions,AppearanceBrowserProxyImpl,AutofillSettingsReferrer,BATTERY_SAVER_MODE_PREF,BaseMixin,BatterySaverModeState,ChoiceMadeLocation,CollapsibleCardElement,ColorSchemeMode,CrDrawerElement,CrSettingsPrefs,CrToolbarElement,CrToolbarSearchFieldElement,CustomizeColorSchemeModeBrowserProxy,CustomizeColorSchemeModeClientCallbackRouter,CustomizeColorSchemeModeClientRemote,CustomizeColorSchemeModeHandlerRemote,DISCARD_RING_PREF,DefaultBrowserBrowserProxyImpl,EDIT_STARTUP_URL_EVENT,ExceptionAddDialogTabs,ExceptionEditDialogElement,ExceptionEntryElement,ExceptionListElement,ExceptionTabbedAddDialogElement,GlicBrowserProxyImpl,HatsBrowserProxyImpl,HomeUrlInputElement,MAX_TAB_DISCARD_EXCEPTION_RULE_LENGTH,MEMORY_SAVER_MODE_AGGRESSIVENESS_PREF,MEMORY_SAVER_MODE_PREF,MemorySaverModeAggressiveness,MemorySaverModeExceptionListAction,MemorySaverModeState,MetricsBrowserProxyImpl,ModelExecutionEnterprisePolicyValue,OnStartupBrowserProxyImpl,OpenWindowProxyImpl,PERFORMANCE_INTERVENTION_NOTIFICATION_PREF,PasswordManagerImpl,PasswordManagerPage,PerformanceBrowserProxyImpl,PerformanceMetricsProxyImpl,PrefsMixin,PrivacyGuideBrowserProxyImpl,PrivacyGuideInteractions,ProfileInfoBrowserProxyImpl,RelaunchMixin,ResetBrowserProxyImpl,RestartType,Router,ScrollableMixin,SearchEnginesBrowserProxyImpl,SearchableViewContainerMixin,SettingsAboutPageElement,SettingsAiInfoCardElement,SettingsAiLoggingInfoBullet,SettingsAiPageElement,SettingsAiPageIndexElement,SettingsAppearancePageElement,SettingsAppearancePageIndexElement,SettingsAutofillPageElement,SettingsAutofillPageIndexElement,SettingsBatteryPageElement,SettingsDefaultBrowserPageElement,SettingsGlicPageElement,SettingsGlicPageFeaturePrefName,SettingsGlicSubpageElement,SettingsMainElement,SettingsMemoryPageElement,SettingsMenuElement,SettingsOnStartupPageElement,SettingsPeoplePageElement,SettingsPeoplePageIndexElement,SettingsPerformancePageElement,SettingsPerformancePageIndexElement,SettingsPrivacyPageElement,SettingsPrivacyPageIndexElement,SettingsResetProfileBannerElement,SettingsSearchEngineListDialogElement,SettingsSearchPageElement,SettingsSearchPageIndexElement,SettingsStartupUrlDialogElement,SettingsStartupUrlEntryElement,SettingsStartupUrlsPageElement,SettingsUiElement,SettingsViewMixin,SettingsYourSavedInfoPageElement,SettingsYourSavedInfoPageIndexElement,SignedInState,SpeedPageElement,StartupUrlsPageBrowserProxyImpl,StatusAction,SyncBrowserProxyImpl,SystemTheme,TAB_DISCARD_EXCEPTIONS_MANAGED_PREF,TAB_DISCARD_EXCEPTIONS_OVERFLOW_SIZE,TAB_DISCARD_EXCEPTIONS_PREF,TooltipMixin,TrustSafetyInteraction,UpdateStatus,convertDateToWindowsEpoch,getSearchManager,pageVisibility,routes};