import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared"></style>
    <settings-section page-title="$i18n{a11yPageTitle}">
      <div route-path="default">





          <cr-link-row id="captions"
              class="hr"
              label="$i18n{captionsTitle}"
              on-click="onCaptionsClick_"
              role-description="$i18n{subpageArrowRoleDescription}">
          </cr-link-row>



        <settings-toggle-button
            class="hr"
            pref="{{prefs.settings.a11y.focus_highlight}}"
            on-setting-boolean-control-change="onFocusHighlightChange_"
            label="$i18n{focusHighlightLabel}">
        </settings-toggle-button>
        <settings-toggle-button
            class="hr"
            pref="{{prefs.settings.a11y.caretbrowsing.enabled}}"
            on-change="onA11yCaretBrowsingChange_"
            label="$i18n{caretBrowsingTitle}"
            sub-label="$i18n{caretBrowsingSubtitle}">
        </settings-toggle-button>

        <settings-toggle-button
            class="hr"
            hidden$="[[!hasScreenReader_]]"
            pref="{{prefs.settings.a11y.enable_accessibility_image_labels}}"
            on-change="onA11yImageLabelsChange_"
            label="$i18n{accessibleImageLabelsTitle}"
            sub-label="$i18n{accessibleImageLabelsSubtitle}">
        </settings-toggle-button>
        <template is="dom-if" if="[[showAxTreeFixingSection_]]">
          <settings-toggle-button id="axTreeFixing"
              class="hr"
              pref="{{prefs.settings.a11y.enable_ax_tree_fixing}}"
              label="$i18n{axTreeFixingTitle}"
              sub-label="$i18n{axTreeFixingSubtitle}">
          </settings-toggle-button>
        </template>

        <template is="dom-if" if="[[showAxAnnotationsSection_]]">
          <settings-ax-annotations-section
              id="AxAnnotationsSection"
              prefs="{{prefs}}">
          </settings-ax-annotations-section>
        </template>


        <settings-toggle-button
            class="hr"
            pref="{{prefs.settings.a11y.overscroll_history_navigation}}"
            on-change="onOverscrollHistoryNavigationChange_"
            label="$i18n{overscrollHistoryNavigationTitle}"
            sub-label="$i18n{overscrollHistoryNavigationSubtitle}">
        </settings-toggle-button>



        <settings-toggle-button class="hr" id="toastToggle"
          pref="{{prefs.settings.toast.alert_level}}"
          numeric-unchecked-values="[[numericUncheckedToastAlertValues_]]"
          numeric-checked-value="[[toastAlertLevelEnum_.ALL]]"
            on-change="onToastAlertLevelChange_" label="$i18n{toastAlertLevelTitle}"
            sub-label="$i18n{toastAlertLevelDescription}">
        </settings-toggle-button>

        <cr-link-row class="hr" label="$i18n{moreFeaturesLink}"
            on-click="onMoreFeaturesLinkClick_" sub-label="$i18n{a11yWebStore}"
            button-aria-description="$i18n{opensInNewTab}"
            external>
        </cr-link-row>
      </div>
    </settings-section>
<!--_html_template_end_-->`;
}
