import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">#custom-input{--cr-radio-button-disc-margin-block-start:calc((1.54em + 12px) / 2 - 8px);align-items:start}#themeRow cr-button,#toolbarRow cr-button{margin-inline-end:20px}#themeRow .separator,#toolbarRow .separator{margin-inline-start:0}#toolbarRow{border-top:var(--cr-separator-line)}.hover-card-toggles{padding-inline-end:0}.hover-card-toggles settings-toggle-button{padding-inline-start:0}#tabSearchPositionRestart{margin-inline-end:20px}

    </style>
    <settings-section page-title="$i18n{appearancePageTitle}">
      <div route-path="default">
        <div class="settings-row first" id="themeRow"
            hidden="[[!pageVisibility.setTheme]]">
          <cr-link-row id="openTheme" class="first"
              hidden="[[!pageVisibility.setTheme]]"
              label="$i18n{themes}" sub-label="[[themeSublabel_]]"
              on-click="onThemeClick_" external></cr-link-row>


          <div class="settings-row continuation"
              hidden="[[!showThemesSecondary_(
                  prefs.extensions.theme.id.value, systemTheme_)]]"
              id="themesSecondaryActions">
            <div class="separator"></div>
            <template is="dom-if" if="[[showUseClassic_(
                prefs.extensions.theme.id.value, systemTheme_)]]" restamp>
              <cr-button id="useDefault" on-click="onUseDefaultClick_">
                $i18n{useClassicTheme}
              </cr-button>
            </template>
            <template is="dom-if" if="[[showUseGtk_(
                prefs.extensions.theme.id.value, systemTheme_)]]" restamp>
              <cr-button id="useGtk" on-click="onUseGtkClick_">
                $i18n{useGtkTheme}
              </cr-button>
            </template>
            <template is="dom-if" if="[[showUseQt_(
                prefs.extensions.theme.id.value, systemTheme_)]]" restamp>
              <cr-button id="useQt" on-click="onUseQtClick_">
                $i18n{useQtTheme}
              </cr-button>
            </template>
          </div>

        </div>
        <div id="toolbarRow" class="settings-row">
          <cr-link-row id="customizeToolbar"
              label="$i18n{customizeToolbar}"
              on-click="onCustomizeToolbarClick_" external>
          </cr-link-row>
          <template is="dom-if" if="[[showResetPinnedActionsButton_]]">
            <div class="separator"></div>
            <cr-button id="resetPinnedToolbarActions"
                on-click="onResetPinnedToolbarActionsClick_"
                aria-label="$i18n{resetToolbarToDefault}">
              $i18n{resetToDefault}
            </cr-button>
          </template>
        </div>
        <div id="colorSchemeModeRow" class="cr-row"

            hidden="[[!showColorSchemeMode_(prefs.extensions.theme.id.value,
              systemTheme_)]]"

        >
          <div id="colorSchemeModeLabel" class="flex cr-padded-text"
              aria-hidden="true">
            $i18n{colorSchemeMode}
          </div>
          <select id="colorSchemeModeSelect" class="md-select"
              on-change="onColorSchemeModeChange_"
              aria-labelledby="colorSchemeModeLabel">
            <template is="dom-repeat" items="[[colorSchemeModeOptions_]]">
              <option value="[[item.value]]"
                  selected="[[isSelectedColorSchemeMode_(
                      item.value, selectedColorSchemeMode_)]]">
                [[item.name]]
              </option>
            </template>
          </select>
        </div>
        <div
            class="hr"
            hidden="[[!showHr_(
                pageVisibility.setTheme, pageVisibility.homeButton)]]">
        </div>
        <settings-toggle-button elide-label
            hidden="[[!pageVisibility.homeButton]]"
            pref="{{prefs.browser.show_home_button}}"
            label="$i18n{showHomeButton}"
            sub-label="[[getShowHomeSubLabel_(
                prefs.browser.show_home_button.value,
                prefs.homepage_is_newtabpage.value,
                prefs.homepage.value)]]">
        </settings-toggle-button>
        <template is="dom-if" if="[[prefs.browser.show_home_button.value]]">
          <div id="home-button-options" class="list-frame"
              hidden="[[!pageVisibility.homeButton]]">
            <settings-radio-group pref="{{prefs.homepage_is_newtabpage}}">
              <controlled-radio-button class="list-item" name="true"
                  pref="[[prefs.homepage_is_newtabpage]]"
                  label="$i18n{homePageNtp}" no-extension-indicator>
              </controlled-radio-button>
              <controlled-radio-button id="custom-input" class="list-item"
                  name="false" pref="[[prefs.homepage_is_newtabpage]]"
                  no-extension-indicator>
                <!-- TODO(dbeam): this can show double indicators when both
                     homepage and whether to use the NTP as the homepage are
                     managed. -->
                <home-url-input id="customHomePage" pref="{{prefs.homepage}}"
                    can-tab="[[!prefs.homepage_is_newtabpage.value]]">
                </home-url-input>
              </controlled-radio-button>
              <template is="dom-if" if="[[prefs.homepage.extensionId]]">
                <extension-controlled-indicator
                    extension-id="[[prefs.homepage.extensionId]]"
                    extension-can-be-disabled="[[
                        prefs.homepage.extensionCanBeDisabled]]"
                    extension-name="[[prefs.homepage.controlledByName]]"
                    on-disable-extension="onDisableExtension_">
                </extension-controlled-indicator>
              </template>
            </settings-radio-group>
          </div>
        </template>
        <div
            class="hr"
            hidden="[[!showHr_(
                pageVisibility.homeButton, pageVisibility.bookmarksBar)]]">
        </div>
        <settings-toggle-button
            hidden="[[!pageVisibility.bookmarksBar]]"
            pref="{{prefs.bookmark_bar.show_on_all_tabs}}"
            label="$i18n{showBookmarksBar}">
        </settings-toggle-button>

        <settings-toggle-button class="hr" id="showSavedTabGroups"
            pref="{{prefs.bookmark_bar.show_tab_groups}}"
            label="$i18n{showTabGroupsInBookmarksBar}">
        </settings-toggle-button>

        <settings-toggle-button class="hr" id="autoPinNewTabGroups"
            pref="{{prefs.auto_pin_new_tab_groups}}"
            label="$i18n{autoPinNewTabGroups}">
        </settings-toggle-button>

        <template is="dom-if" if="[[showTabSearchPositionSettings_]]" restamp>
          <div class="cr-row" id="tabSearchPositionRow">
            <div class="flex cr-padded-text" aria-hidden="true">
              $i18n{tabSearchPosition}
            </div>
            <template is="dom-if" if="[[showTabSearchPositionRestartButton_]]"
                restamp>
              <cr-button id="tabSearchPositionRestart" role="alert"
                  on-click="onTabSearchPositionRestartClick_">
                $i18n{restart}
              </cr-button>
            </template>
            <settings-dropdown-menu id="tabSearchPositionDropdown"
                label="$i18n{tabSearchPosition}"
                pref="{{prefs.tab_search.is_right_aligned}}"
                menu-options="[[tabSearchOptions_]]">
            </settings-dropdown-menu>
          </div>
        </template>
        <div class="cr-row">
          <div class="flex cr-padded-text" aria-hidden="true">
            $i18n{sidePanelPosition}
          </div>
          <settings-dropdown-menu id="sidePanelPosition"
              label="$i18n{sidePanelPosition}"
              pref="{{prefs.side_panel.is_right_aligned}}"
              menu-options="[[sidePanelOptions_]]">
          </settings-dropdown-menu>
        </div>
        <template is="dom-if" if="[[!showHoverCardImagesOption_]]">
          <div class="hr" hidden="[[!pageVisibility.hoverCard]]"></div>
          <settings-toggle-button id="hoverCardMemoryUsageToggle"
              hidden="[[!pageVisibility.hoverCard]]"
              pref="{{prefs.browser.hovercard.memory_usage_enabled}}"
              label="$i18n{showHoverCardMemoryUsageStandalone}">
          </settings-toggle-button>
        </template>
        <template is="dom-if" if="[[showHoverCardImagesOption_]]">
          <div class="cr-row" hidden="[[!pageVisibility.hoverCard]]">
            $i18n{hoverCardTitle}
          </div>
          <div class="list-frame hover-card-toggles">
            <settings-toggle-button id="hoverCardImagesToggle"
                hidden="[[!pageVisibility.hoverCard]]"
                on-settings-boolean-control-change="onHoverCardImagesToggleChange_"
                pref="{{prefs.browser.hovercard.image_previews_enabled}}"
                label="$i18n{showHoverCardImages}">
            </settings-toggle-button>
            <settings-toggle-button id="hoverCardMemoryUsageToggle" class="hr"
                hidden="[[!pageVisibility.hoverCard]]"
                pref="{{prefs.browser.hovercard.memory_usage_enabled}}"
                label="$i18n{showHoverCardMemoryUsage}">
            </settings-toggle-button>
          </div>
        </template>


        <div class="hr" hidden="[[!pageVisibility.bookmarksBar]]"></div>
        <settings-toggle-button
            hidden="[[!showCustomChromeFrame_]]"
            pref="{{prefs.browser.custom_chrome_frame}}"
            label="$i18n{showWindowDecorations}"
            inverted>
        </settings-toggle-button>

        <div class="cr-row">
          <div class="flex cr-padded-text" aria-hidden="true">
            $i18n{fontSize}
          </div>
          <settings-dropdown-menu id="defaultFontSize" label="$i18n{fontSize}"
              pref="{{prefs.webkit.webprefs.default_font_size}}"
              menu-options="[[fontSizeOptions_]]">
          </settings-dropdown-menu>
        </div>
        <cr-link-row class="hr" id="customize-fonts-subpage-trigger"
            label="$i18n{customizeFonts}" on-click="onCustomizeFontsClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
        <div class="cr-row" hidden="[[!pageVisibility.pageZoom]]">
          <div id="pageZoom" class="flex cr-padded-text" aria-hidden="true">
            $i18n{pageZoom}
          </div>
          <select id="zoomLevel" class="md-select" aria-labelledby="pageZoom"
              on-change="onZoomLevelChange_">
            <template is="dom-repeat" items="[[pageZoomLevels_]]">
              <option value="[[item]]"
                  selected="[[zoomValuesEqual_(item, defaultZoom_)]]">
                [[formatZoom_(item)]]%
              </option>
            </template>
          </select>
        </div>

      </div>
      <settings-toggle-button class="hr" id="splitViewDragAndDrop"
          hidden="[[!showSplitViewDragAndDropSetting_]]"
          pref="{{prefs.browser.split_view_drag_and_drop_enabled}}"
          label="$i18n{allowSplitViewDragAndDrop}">
      </settings-toggle-button>
    </settings-section>
    <template is="dom-if" if="[[showManagedThemeDialog_]]" restamp>
      <managed-dialog on-close="onManagedDialogClosed_"
          title="$i18n{themeManagedDialogTitle}"
          body="$i18n{themeManagedDialogBody}">
      </managed-dialog>
    </template>
<!--_html_template_end_-->`;
}
