import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">cr-input{--cr-input-error-display:block;margin-bottom:0;width:var(--cr-default-input-max-width)}.md-select+.md-select{margin-inline-start:8px}#numberInput{margin-bottom:10px}#month{width:70px}#cvcInput{width:132px}#cvcImage{margin-inline-start:10px}#saved-to-this-device-only-label{margin-bottom:10px;margin-top:0}#year{width:100px}#nicknameInput{--cr-input-width:var(--cr-default-input-max-width);width:fit-content}#charCount{font-size:var(--cr-form-field-label-font-size);line-height:var(--cr-form-field-label-line-height);padding-inline-start:8px}#nicknameInput:not(:focus-within) #charCount{display:none}#expiredError{display:block;font-size:var(--cr-form-field-label-font-size);height:var(--cr-form-field-label-height);line-height:var(--cr-form-field-label-line-height);margin:8px 0;visibility:hidden}:host([expired_]) #expiredError{visibility:visible}#expiredError,:host([expired_]) #expiration{color:var(--google-red-600)}@media (prefers-color-scheme:dark){#expiredError,:host([expired_]) #expiration{color:var(--google-red-300)}}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <cr-input id="numberInput" label="$i18n{creditCardNumber}"
            on-blur="onNumberInputBlurred_"
            invalid="[[showErrorForCardNumber_(cardNumberValidationState_)]]"
            error-message="$i18n{creditCardNumberInvalid}"
            value="{{rawCardNumber_}}" autofocus>
        </cr-input>
        <!-- aria-hidden for creditCardExpiration label since
          creditCardExpirationMonth and creditCardExpirationYear provide
          sufficient labeling. -->
        <label id='expiration' class="cr-form-field-label" aria-hidden="true">
          $i18n{creditCardExpiration}
        </label>
        <select class="md-select" id="month" value="[[expirationMonth_]]"
            on-change="onMonthChange_"
            aria-label="$i18n{creditCardExpirationMonth}"
            aria-invalid$="[[getExpirationAriaInvalid_(expired_)]]">
          <template is="dom-repeat" items="[[monthList_]]">
            <option>[[item]]</option>
          </template>
        </select>
        <select class="md-select" id="year" value="[[expirationYear_]]"
            on-change="onYearChange_"
            aria-label="$i18n{creditCardExpirationYear}"
            aria-invalid$="[[getExpirationAriaInvalid_(expired_)]]">
          <template is="dom-repeat" items="[[yearList_]]">
            <option>[[item]]</option>
          </template>
        </select>
        <div id="expiredError">$i18n{creditCardExpired}</div>
        <template is="dom-if"
            if="[[checkIfCvcStorageIsAvailable_(
                  prefs.autofill.payment_cvc_storage.value,
                  cvcStorageAvailable_)]]">
          <cr-input id="cvcInput" label="$i18n{creditCardCvcInputTitle}"
              placeholder="$i18n{creditCardCvcInputPlaceholder}"
              value="{{cvc_}}">
            <img slot="suffix" id="cvcImage"
                src="[[getCvcImageSource_(sanitizedCardNumber_)]]"
                title="[[getCvcImageTooltip_(sanitizedCardNumber_)]]">
            </img>
          </cr-input>
        </template>
        <!-- Place cardholder name field and nickname field after CVC input.-->
        <cr-input id="nameInput" label="$i18n{creditCardName}"
            value="{{name_}}" spellcheck="false">
        </cr-input>
        <cr-input id="nicknameInput" label="$i18n{creditCardNickname}"
            value="{{nickname_}}" spellcheck="false" maxlength="25"
            on-input="validateNickname_"
            invalid="[[nicknameInvalid_]]"
            error-message="$i18n{creditCardNicknameInvalid}"
            aria-description="[[i18n('inputMaxLengthDescription', 25)]]">
            <div id="charCount" slot="suffix" aria-hidden="true">
              [[computeNicknameCharCount_(nickname_)]]/25
            </div>
        </cr-input>
        <div id="saved-to-this-device-only-label">
          $i18n{savedToThisDeviceOnly}
        </div>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelButtonClick_">$i18n{cancel}</cr-button>
        <cr-button id="saveButton" class="action-button"
            on-click="onSaveButtonClick_"
            disabled="[[!saveEnabled_(nicknameInvalid_, cardNumberValidationState_,
                expired_, name_, sanitizedCardNumber_, nickname_)]]">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}
