import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">:host{--body-container-height:322px}#clearBrowsingDataDialog{--border-top-color:var(--google-grey-300);--cr-dialog-top-container-min-height:42px;--cr-dialog-body-border-top:1px solid var(--border-top-color)}@media (prefers-color-scheme:dark){#clearBrowsingDataDialog{--border-top-color:var(--cr-separator-color)}}#clearBrowsingDataDialog:not(.fully-rendered){visibility:hidden}#clearBrowsingDataDialog [slot=title]{padding-bottom:8px}#clearBrowsingDataDialog::part(body-container){height:var(--body-container-height);min-height:200px}#clearBrowsingDataDialog [slot=body]{padding-top:8px}#clearBrowsingDataDialog [slot=footer]{background:var(--google-grey-50);border-top:none;padding:0}@media (prefers-color-scheme:dark){#clearBrowsingDataDialog [slot=footer]{background:rgb(50,54,57)}}.row{align-items:center;display:flex;min-height:40px}.spinner{margin-bottom:auto;margin-inline-end:16px;margin-top:auto}settings-checkbox{--cr-section-two-line-min-height:48px}#basicTab settings-checkbox+settings-checkbox{--settings-checkbox-margin-top:12px}cr-tabs{--cr-tabs-font-size:100%;--cr-tabs-height:40px}.time-range-row{margin-bottom:12px}.time-range-select{margin-inline-start:12px}.dropdown-error::part(select){border-color:var(--settings-error-color);color:var(--settings-error-color)}.dropdown-error::part(select):focus{outline-color:var(--settings-error-color)}[slot=title] .secondary{font-size:calc(13 / 15 * 100%);padding-top:8px}.divider{border-top:var(--cr-separator-line);margin:0 16px}#footerDescription{color:var(--cr-secondary-text-color);padding:16px}#clearingDataAlert{clip:rect(0,0,0,0);position:fixed}.search-history-box{background-color:var(--google-grey-50);border:1px solid var(--google-grey-200);border-radius:4px;display:flex;margin-top:12px;padding:8px}@media (prefers-color-scheme:dark){.search-history-box{background-color:rgba(0,0,0,.3);border-color:transparent}}.search-history-box-icon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-700));display:flex;flex-shrink:0;margin:auto;padding-inline-end:10px;width:var(--cr-link-row-icon-width,var(--cr-icon-size))}@media (prefers-color-scheme:dark){.search-history-box-icon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-500))}}#nonGoogleSearchHistoryBox{margin-bottom:16px}
    </style>

    <cr-dialog id="clearBrowsingDataDialog"
        close-text="$i18n{close}" ignore-popstate has-tabs ignore-enter-key>
      <div slot="title">
        <div>$i18n{clearBrowsingData}</div>
      </div>
      <div slot="header">
        <cr-tabs id="tabs" tab-names="[[tabsNames_]]"
            selected="{{selectedTabIndex_}}"
            on-selected-changed="recordTabChange_">
        </cr-tabs>
      </div>
      <div slot="body">
        <cr-page-selector id="pages" selected="[[selectedTabIndex_]]"
            on-iron-select="updateClearButtonState_">
          <div id="basicTab">
            <div class="row time-range-row">
              <span class="time-range-label" aria-hidden="true">
                $i18n{clearTimeRange}
              </span>
              <settings-dropdown-menu id="clearFromBasic" no-set-pref
                  class="time-range-select"
                  label="$i18n{clearTimeRange}"
                  pref="{{prefs.browser.clear_data.time_period_basic}}"
                  menu-options="[[clearFromOptions_]]"
                  on-settings-control-change="onTimePeriodChanged_">
              </settings-dropdown-menu>
            </div>
            <!-- Note: whether these checkboxes are checked are ignored if
                 deleting history is disabled (i.e. supervised users, policy),
                 so it's OK to have a hidden checkbox that's also checked (as
                 the C++ accounts for whether a user is allowed to delete
                 history independently). -->
            <settings-checkbox id="browsingCheckboxBasic"
                pref="{{prefs.browser.clear_data.browsing_history_basic}}"
                label="$i18n{clearBrowsingHistory}"
                sub-label-html="[[browsingCheckboxLabel_(isSyncingHistory_,
                    '$i18nPolymer{clearBrowsingHistorySummary}',
                    '$i18nPolymer{clearBrowsingHistorySummarySignedInNoLink}'
                    )]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cookiesCheckboxBasic"
                class="cookies-checkbox"
                pref="{{prefs.browser.clear_data.cookies_basic}}"
                label="$i18n{clearCookies}"
                sub-label="[[cookiesCheckboxLabel_(
                    syncStatus.signedInState,
                    shouldShowCookieException_,
                    '$i18nPolymer{clearCookiesSummary}',
                    '$i18nPolymer{clearCookiesSummarySignedIn}',
                    '$i18nPolymer{clearCookiesSummarySyncing}',
                    '$i18nPolymer{clearCookiesSummarySignedInSupervisedProfile}'
                    )]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cacheCheckboxBasic"
                class="cache-checkbox"
                pref="{{prefs.browser.clear_data.cache_basic}}"
                label="$i18n{clearCache}"
                sub-label="[[counters_.cache_basic]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <div class="search-history-box"
                hidden="[[!showSearchHistoryBox_(syncStatus.signedInState)]]">
              <cr-icon class="search-history-box-icon" aria-hidden="true"
                  icon="settings20:googleg">
              </cr-icon>
              <div id="googleSearchHistoryLabel"
                  inner-h-t-m-l="[[googleSearchHistoryString_]]">
              </div>
            </div>
            <div id="nonGoogleSearchHistoryBox"
                class="search-history-box"
                hidden="[[!isNonGoogleDse_]]">
              <cr-icon class="search-history-box-icon" aria-hidden="true"
                  icon="cr:search">
              </cr-icon>
              <div id="nonGoogleSearchHistoryLabel"
                  inner-h-t-m-l="[[nonGoogleSearchHistoryString_]]">
              </div>
            </div>
          </div>
          <div id="advancedTab">
            <div class="row time-range-row">
              <span class="time-range-label" aria-hidden="true">
                $i18n{clearTimeRange}
              </span>
              <settings-dropdown-menu id="clearFrom" no-set-pref
                  class="time-range-select"
                  label="$i18n{clearTimeRange}"
                  pref="{{prefs.browser.clear_data.time_period}}"
                  menu-options="[[clearFromOptions_]]"
                  on-settings-control-change="onTimePeriodChanged_">
              </settings-dropdown-menu>
            </div>
            <settings-checkbox id="browsingCheckbox"
                pref="{{prefs.browser.clear_data.browsing_history}}"
                label="$i18n{clearBrowsingHistory}"
                sub-label="[[counters_.browsing_history]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="downloadCheckbox"
                pref="{{prefs.browser.clear_data.download_history}}"
                label="$i18n{clearDownloadHistory}"
                sub-label="[[counters_.download_history]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cookiesCheckbox"
                class="cookies-checkbox"
                pref="{{prefs.browser.clear_data.cookies}}"
                label="$i18n{clearCookies}"
                sub-label="[[counters_.cookies]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cacheCheckbox"
                class="cache-checkbox"
                pref="{{prefs.browser.clear_data.cache}}"
                label="$i18n{clearCache}"
                sub-label="[[counters_.cache]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.passwords}}"
                label="$i18n{clearPasswords}"
                sub-label="[[counters_.passwords]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.form_data}}"
                label="$i18n{clearFormData}"
                sub-label="[[counters_.form_data]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.site_settings}}"
                label="$i18nPolymer{siteSettings}"
                sub-label="[[counters_.site_settings]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.hosted_apps_data}}"
                label="$i18n{clearHostedAppData}"
                sub-label="[[counters_.hosted_apps_data]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
          </div>
        </cr-page-selector>
      </div>
      <div slot="button-container">
        <div class="spinner" hidden$="[[!clearingInProgress_]]"></div>
        <cr-button class="cancel-button" autofocus
            disabled="[[clearingInProgress_]]"
            on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="clearButton" class="action-button"
            on-click="clearBrowsingData_"
            disabled="[[isClearButtonDisabled_(clearingInProgress_,
                                               clearButtonDisabled_)]]">
          $i18n{clearData}
        </cr-button>

        <!-- The alert must be inside the dialog for it to be read while the
             dialog is open. -->
        <div id="clearingDataAlert" role="alert">
          [[clearingDataAlertString_]]
        </div>
      </div>

      <template is="dom-if"
          if="[[shouldShowFooter_(
              syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]"
          restamp>
        <div slot="footer">
          <settings-sync-account-control sync-status="[[syncStatus]]"
              prefs="{{prefs}}" hide-buttons hide-banner>
          </settings-sync-account-control>
          <div class="divider"></div>
          <div id="footerDescription" on-click="onSyncDescriptionLinkClicked_">
            <span id="signinInfo"
                hidden="[[!showSigninInfo_(
                    syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]">
              $i18nRaw{clearBrowsingDataSignedIn}
            </span>
            <span id="syncInfo"
                hidden="[[!showSyncInfo_(
                    syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]">
              $i18nRaw{clearBrowsingDataWithSync}
            </span>
            <span id="syncPausedInfo" hidden="[[!isSyncPaused_]]">
              $i18nRaw{clearBrowsingDataWithSyncPaused}
            </span>
            <span id="syncPassphraseErrorInfo"
                hidden="[[!hasPassphraseError_]]">
              $i18nRaw{clearBrowsingDataWithSyncPassphraseError}
            </span>
            <span id="syncOtherErrorInfo" hidden="[[!hasOtherSyncError_]]">
              $i18nRaw{clearBrowsingDataWithSyncError}
            </span>
          </div>
        </div>
      </template>

    </cr-dialog>

    <template is="dom-if" if="[[showHistoryDeletionDialog_]]" restamp>
      <settings-history-deletion-dialog id="historyNotice"
          on-close="onHistoryDeletionDialogClose_">
      </settings-history-deletion-dialog>
    </template>

    <template is="dom-if" if="[[showPasswordsDeletionDialog_]]" restamp>
      <settings-passwords-deletion-dialog id="passwordsNotice"
          on-close="onPasswordsDeletionDialogClose_">
      </settings-passwords-deletion-dialog>
    </template>
<!--_html_template_end_-->`;
}
