// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { getTrustedScriptURL } from 'chrome://resources/js/static_types.js';
let lazyLoadPromise = null;
/** @return Resolves when the lazy load module is imported. */
export function ensureLazyLoaded() {
    if (lazyLoadPromise === null) {
        const script = document.createElement('script');
        script.type = 'module';
        script.src = getTrustedScriptURL `./lazy_load.js`;
        document.body.appendChild(script);
        lazyLoadPromise =
            Promise
                .all([
                'settings-appearance-page', 'settings-autofill-section',
                'settings-payments-section',
                'settings-clear-browsing-data-dialog',
                'settings-clear-browsing-data-dialog-v2',
                'settings-search-engines-page',
                'settings-a11y-page', 'settings-downloads-page',
                // 
                'settings-languages-page',
                // 
                'settings-reset-page',
                // 
                'settings-system-page',
                // 
                // 
                'settings-edit-dictionary-page',
                // 
            ].map(name => customElements.whenDefined(name)))
                .then(() => { });
    }
    return lazyLoadPromise;
}
