import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">:host{display:flex;flex-direction:column}#newWord{width:100%;--cr-input-width:var(--cr-default-input-max-width)}#newWord::part(row-container){justify-content:normal}iron-list .word{flex:1}
  </style>
  <settings-subpage
      page-title="$i18n{editDictionaryPageTitle}"
      no-search$="[[!prefs.browser.enable_spellchecking.value]]"
      route-path$="[[routePath]]">
    <div class="cr-row first" on-keydown="onKeysPress_">
      <cr-input id="newWord" value="{{newWordValue_}}"
          placeholder="$i18n{addDictionaryWordLabel}"
          invalid="[[isWordInvalid_(newWordValue_, words_.*)]]"
          error-message="[[getErrorMessage_(newWordValue_, words_.*)]]"
          spellcheck="false">
        <cr-button on-click="onAddWordClick_" id="addWord" slot="suffix"
            disabled$="[[disableAddButton_(newWordValue_, words_.*)]]">
          $i18n{addDictionaryWordButton}
        </cr-button>
      </cr-input>
    </div>
    <div class="cr-row continuation">
      <h2>$i18n{customDictionaryWords}</h2>
    </div>
    <div class="list-frame">
      <template is="dom-if" if="[[hasWords_]]">
        <iron-list id="list" items="[[words_]]" preserve-focus
            scroll-target="[[subpageScrollTarget]]" risk-selection>
          <template>
            <div class="list-item">
              <div id$="word[[index]]" class="word text-elide">[[item]]</div>
              <cr-icon-button class="icon-clear" on-click="onRemoveWordClick_"
                  tabindex$="[[tabIndex]]"
                  title="$i18n{deleteDictionaryWordButton}"
                  aria-describedby$="word[[index]]">
              </cr-icon-button>
            </div>
          </template>
        </iron-list>
      </template>
      <div id="noWordsLabel" class="list-item" hidden$="[[hasWords_]]">
        $i18n{noCustomDictionaryWordsFound}
      </div>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}
