import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}cr-view-manager [slot=view]:not(.closing){position:initial}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-languages-page slot="view" id="languages" prefs="{{prefs}}"
      languages="[[languages]]" route-path$="[[routes_.LANGUAGES.path]]">
  </settings-languages-page>

  <settings-spell-check-page slot="view" id="spellCheck" prefs="{{prefs}}"
      languages="[[languages]]" route-path$="[[routes_.SPELL_CHECK.path]]">
  </settings-spell-check-page>

  <settings-translate-page slot="view" id="translate" prefs="{{prefs}}"
      languages="[[languages]]">
  </settings-translate-page>


  <settings-edit-dictionary-page slot="view" id="editDictionary"
      data-parent-view-id="spellCheck" prefs="{{prefs}}"
      route-path$="[[routes_.EDIT_DICTIONARY.path]]">
  </settings-edit-dictionary-page>

</cr-view-manager>
<!--_html_template_end_-->`;
}
