import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared action-link">.name-with-error-list{padding:14px 0}.name-with-error-list div{color:var(--google-red-500);margin-top:8px}@media (prefers-color-scheme:dark){.name-with-error-list div{color:var(--settings-error-color)}}cr-icon[icon='cr:error']{--iron-icon-fill-color:var(--settings-error-color);height:var(--cr-icon-size);margin-inline-end:8px;width:var(--cr-icon-size)}.name-with-error-list[disabled]{pointer-events:none}cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}.spell-check-radio-group{padding-block-end:var(--cr-section-vertical-padding)}.spell-check-radio-button{--cr-radio-button-label-spacing:calc(var(--cr-section-indent-width) - var(--cr-radio-button-size))}.spell-check-radio-button.enhanced{align-items:start;--cr-radio-button-disc-margin-block-start:calc((1.5em - var(--cr-radio-button-size)) / 2)}.enhanced-spellcheck-description{padding-inline-end:150px}.spell-check-languages .list-item:last-of-type{border-bottom:var(--cr-separator-line)}</style>
<settings-section page-title="$i18n{spellCheckTitle}">
  <div route-path="default">
    <settings-toggle-button id="enableSpellcheckingToggle" class="hr"
        label="$i18n{offerToEnableSpellCheck}"
        sub-label="[[getSpellCheckSubLabel_(spellCheckLanguages_)]]"
        pref="{{prefs.browser.enable_spellchecking}}"
        disabled="[[!spellCheckLanguages_.length]]"
        on-settings-boolean-control-change="onSpellCheckToggleChange_">
    </settings-toggle-button>

    <cr-collapse id="spellCheckCollapse"
        opened="[[prefs.browser.enable_spellchecking.value]]">
 <!-- _google_chrome -->

      <div id="spellCheckLanguagesList"
          hidden="[[hideSpellCheckLanguages_]]">
        <div class="cr-row continuation">
          $i18n{spellCheckLanguagesListTitle}
        </div>
        <div class="list-frame vertical-list spell-check-languages" role="list">
          <template is="dom-repeat" items="[[spellCheckLanguages_]]">
            <div class="list-item" role="listitem">
              <div class="start name-with-error-list"
                  on-click="onSpellCheckNameClick_" actionable
                  disabled$="[[isSpellCheckNameClickDisabled_(
                      item, item.*)]]">
                [[item.language.displayName]]
                <div hidden="[[!errorsGreaterThan_(
                    item.downloadDictionaryFailureCount, 0)]]">
                  <cr-icon icon="cr:error"></cr-icon>
                  $i18n{languagesDictionaryDownloadError}
                </div>
                <div hidden="[[!errorsGreaterThan_(
                    item.downloadDictionaryFailureCount, 1)]]">
                  $i18n{languagesDictionaryDownloadErrorHelp}
                </div>
              </div>
              <cr-button on-click="onRetryDictionaryDownloadClick_"
                  hidden="[[!errorsGreaterThan_(
                      item.downloadDictionaryFailureCount, 0)]]">
                $i18n{retry}
              </cr-button>
              <template is="dom-if" if="[[!item.isManaged]]" restamp>
                <cr-toggle on-change="onSpellCheckLanguageChange_"
                    disabled="[[!item.language.supportsSpellcheck]]"
                    checked="[[item.spellCheckEnabled]]"
                    aria-label$="[[item.language.displayName]]"
                    hidden="[[errorsGreaterThan_(
                        item.downloadDictionaryFailureCount, 0)]]">
                </cr-toggle>
              </template>
              <template is="dom-if" if="[[item.isManaged]]" restamp>
                <cr-policy-pref-indicator
                    pref="[[getIndicatorPrefForManagedSpellcheckLanguage_(
                        item.spellCheckEnabled)]]"
                    hidden="[[errorsGreaterThan_(
                        item.downloadDictionaryFailureCount, 0)]]">
                </cr-policy-pref-indicator>
                <cr-toggle disabled="true"
                    checked="[[item.spellCheckEnabled]]"
                    aria-label$="[[item.language.displayName]]"
                    hidden="[[errorsGreaterThan_(
                        item.downloadDictionaryFailureCount, 0)]]">
                </cr-toggle>
              </template>
            </div>
          </template>
        </div>
      </div>
      <cr-link-row on-click="onEditDictionaryClick_"
          id="spellCheckSubpageTrigger" label="$i18n{manageSpellCheck}"
          role-description="$i18n{subpageArrowRoleDescription}">
      </cr-link-row>
 <!-- not is_macosx -->
    </cr-collapse>
 <!-- _google_chrome or not is_macosx -->
  </div>
</settings-section>
<!--_html_template_end_-->`;
}
