import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared settings-columned-section">.settings-section-bottom-padding{padding-block-end:var(--cr-section-vertical-padding)}settings-collapse-radio-button[hidden]+settings-collapse-radio-button{--settings-collapse-separator-line:0}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}</style>
<settings-section

    page-title="$i18n{speedPageTitle}">

  <settings-toggle-button id="preloadingToggle"
      pref="{{prefs.net.network_prediction_options}}"
      label="$i18n{preloadingPageTitle}"
      sub-label-with-link="$i18n{preloadingToggleSummary}"
      on-sub-label-link-clicked="onPreloadingLearnMoreLinkClick_"
      numeric-unchecked-values="[[numericUncheckedValues_]]"
      numeric-checked-value="[[networkPredictionOptionsEnum_.STANDARD]]"
      on-change="onPreloadingStateChange_">
  </settings-toggle-button>
  <cr-collapse
      opened="[[isPreloadingEnabled_(
          prefs.net.network_prediction_options.value)]]">
    <div class="cr-row continuation settings-section-bottom-padding">
      <settings-radio-group id="preloadingRadioGroup"
          pref="{{prefs.net.network_prediction_options}}"
          selectable-elements="settings-collapse-radio-button"
          on-change="onPreloadingStateChange_">
        <settings-collapse-radio-button id="preloadingExtended"
            name="[[networkPredictionOptionsEnum_.EXTENDED]]"
            pref="[[prefs.net.network_prediction_options]]"
            label="$i18n{preloadingPageExtendedPreloadingTitle}"
            sub-label="$i18n{preloadingPageExtendedPreloadingSummary}"
            expand-aria-label="
                $i18n{preloadingPageExtendedPreloadingExpandA11yLabel}"
            no-automatic-collapse>
          <div slot="collapse" class="settings-columned-section">
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingWhenOn}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageExtendedPreloadingWhenOnBulletOne}
                </li>
                <li class="secondary">
                  $i18n{preloadingPageExtendedPreloadingWhenOnBulletTwo}
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingConsider}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageThingsToConsiderBulletOne}
                </li>
                <li class="secondary">
                  $i18n{preloadingPageExtendedPreloadingThingsToConsiderBulletTwo}
                </li>
              </ul>
            </div>
          </div>
        </settings-collapse-radio-button>
        <settings-collapse-radio-button id="preloadingStandard"
            name="[[networkPredictionOptionsEnum_.STANDARD]]"
            pref="[[prefs.net.network_prediction_options]]"
            label="$i18n{preloadingPageStandardPreloadingTitle}"
            sub-label="$i18n{preloadingPageStandardPreloadingSummary}"
            expand-aria-label="
                $i18n{preloadingPageStandardPreloadingExpandA11yLabel}"
            info-opened="{{infoOpened_}}"
            no-automatic-collapse>
          <div slot="collapse" class="settings-columned-section">
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingWhenOn}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageStandardPreloadingWhenOnBulletOne}
                </li>
                <li class="secondary">
                  $i18n{preloadingPageStandardPreloadingWhenOnBulletTwo}
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">
                $i18n{columnHeadingConsider}
              </h2>
              <ul>
                <li class="secondary">
                  $i18n{preloadingPageThingsToConsiderBulletOne}
                </li>
              </ul>
            </div>
          </div>
        </settings-collapse-radio-button>
      </settings-radio-group>
    </div>
  </cr-collapse>
</settings-section>
<!--_html_template_end_-->`;
}
