import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style settings-shared site-settings-shared"></style>

<settings-subpage page-title="$i18n{siteSettingsProtectedContent}"
    route-path$="[[routePath]]">


  <div class="radio-group">
    <div class="secondary">
      $i18n{siteSettingsProtectedContentDescription}
    </div>
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div class="secondary radio-sub-heading">
      $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <settings-radio-group
        pref="{{prefs.webkit.webprefs.encrypted_media_enabled}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.webkit.webprefs.encrypted_media_enabled]]"
          label="$i18n{siteSettingsProtectedContentAllowed}"
          name="true"
          disabled$="[[isGuest_]]"
          icon="privacy:sync-saved-locally">
      </settings-collapse-radio-button>
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.webkit.webprefs.encrypted_media_enabled]]"
          label="$i18n{siteSettingsProtectedContentBlocked}"
          sub-label="$i18n{siteSettingsProtectedContentBlockedSubLabel}"
          name="false"
          disabled$="[[isGuest_]]"
          icon="privacy:sync-saved-locally-off">
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>

</settings-subpage>
<!--_html_template_end_-->`;
}
