// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"./icons.html.js";import"//bookmarks-side-panel.top-chrome/shared/sp_shared_style.css.js";import"//resources/cr_elements/cr_action_menu/cr_action_menu.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import{PriceTrackingBrowserProxyImpl}from"//resources/cr_components/commerce/price_tracking_browser_proxy.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{afterNextRender,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ActionSource}from"./bookmarks.mojom-webui.js";import{BookmarksApiProxyImpl}from"./bookmarks_api_proxy.js";import{getTemplate}from"./power_bookmarks_context_menu.html.js";import{editingDisabledByPolicy}from"./power_bookmarks_service.js";export var MenuItemId;(function(MenuItemId){MenuItemId[MenuItemId["OPEN_NEW_TAB"]=0]="OPEN_NEW_TAB";MenuItemId[MenuItemId["OPEN_NEW_WINDOW"]=1]="OPEN_NEW_WINDOW";MenuItemId[MenuItemId["OPEN_INCOGNITO"]=2]="OPEN_INCOGNITO";MenuItemId[MenuItemId["OPEN_NEW_TAB_GROUP"]=3]="OPEN_NEW_TAB_GROUP";MenuItemId[MenuItemId["EDIT"]=4]="EDIT";MenuItemId[MenuItemId["ADD_TO_BOOKMARKS_BAR"]=5]="ADD_TO_BOOKMARKS_BAR";MenuItemId[MenuItemId["REMOVE_FROM_BOOKMARKS_BAR"]=6]="REMOVE_FROM_BOOKMARKS_BAR";MenuItemId[MenuItemId["TRACK_PRICE"]=7]="TRACK_PRICE";MenuItemId[MenuItemId["RENAME"]=8]="RENAME";MenuItemId[MenuItemId["DELETE"]=9]="DELETE";MenuItemId[MenuItemId["DIVIDER"]=10]="DIVIDER";MenuItemId[MenuItemId["OPEN_SPLIT_VIEW"]=11]="OPEN_SPLIT_VIEW"})(MenuItemId||(MenuItemId={}));export class PowerBookmarksContextMenuElement extends PolymerElement{static get is(){return"power-bookmarks-context-menu"}static get template(){return getTemplate()}static get properties(){return{bookmarks_:{type:Array,value:()=>[]},priceTracked_:Boolean,priceTrackingEligible_:Boolean,isInSplitView_:Boolean}}bookmarksApi_=BookmarksApiProxyImpl.getInstance();priceTrackingProxy_=PriceTrackingBrowserProxyImpl.getInstance();showAt(target,bookmarks,priceTracked,priceTrackingEligible,isInSplitView,onShown=()=>{}){this.bookmarks_=bookmarks;this.priceTracked_=priceTracked;this.priceTrackingEligible_=priceTrackingEligible;this.isInSplitView_=isInSplitView;afterNextRender(this,(()=>{this.$.menu.showAt(target);onShown()}))}showAtPosition(event,bookmarks,priceTracked,priceTrackingEligible,isInSplitView,onShown=()=>{}){this.bookmarks_=bookmarks;this.priceTracked_=priceTracked;this.priceTrackingEligible_=priceTrackingEligible;this.isInSplitView_=isInSplitView;const menuMargin=20;const doc=document.scrollingElement;const minX=doc.scrollLeft+menuMargin;const maxX=doc.scrollLeft+doc.clientWidth-menuMargin;afterNextRender(this,(()=>{this.$.menu.showAtPosition({top:event.clientY,left:event.clientX,minX:minX,maxX:maxX});onShown()}))}isOpen(){return this.$.menu.open}getMenuItemsForBookmarks_(){let bookmarkCount=0;this.bookmarks_.forEach((bookmark=>{if(bookmark.url){bookmarkCount+=1}else if(bookmark.children){bookmarkCount+=bookmark.children.filter((child=>!!child.url)).length}}));const menuItems=[{id:MenuItemId.OPEN_NEW_TAB,label:bookmarkCount<2?loadTimeData.getString("menuOpenNewTab"):loadTimeData.getStringF("menuOpenNewTabWithCount",bookmarkCount),disabled:bookmarkCount===0},{id:MenuItemId.OPEN_NEW_WINDOW,label:bookmarkCount<2?loadTimeData.getString("menuOpenNewWindow"):loadTimeData.getStringF("menuOpenNewWindowWithCount",bookmarkCount),disabled:bookmarkCount===0}];if(!loadTimeData.getBoolean("incognitoMode")&&loadTimeData.getBoolean("isIncognitoModeAvailable")){menuItems.push({id:MenuItemId.OPEN_INCOGNITO,label:bookmarkCount<2?loadTimeData.getString("menuOpenIncognito"):loadTimeData.getStringF("menuOpenIncognitoWithCount",bookmarkCount),disabled:bookmarkCount===0})}if(loadTimeData.getBoolean("splitViewEnabled")&&bookmarkCount===1&&this.bookmarks_[0].url){menuItems.push({id:MenuItemId.OPEN_SPLIT_VIEW,label:loadTimeData.getString("menuOpenSplitView"),disabled:this.isInSplitView_})}if(this.bookmarks_.length!==1||!this.bookmarks_[0].url){menuItems.push({id:MenuItemId.OPEN_NEW_TAB_GROUP,label:bookmarkCount<2?loadTimeData.getString("menuOpenNewTabGroup"):loadTimeData.getStringF("menuOpenNewTabGroupWithCount",bookmarkCount),disabled:bookmarkCount===0})}if(this.bookmarks_.length!==1){menuItems.push({id:MenuItemId.DIVIDER},{id:MenuItemId.EDIT,label:loadTimeData.getString("tooltipMove")},{id:MenuItemId.DIVIDER},{id:MenuItemId.DELETE,label:loadTimeData.getString("tooltipDelete")});return menuItems}else if(this.bookmarks_[0].id===loadTimeData.getString("bookmarksBarId")){return menuItems}if(this.bookmarks_[0].url||this.bookmarks_[0].parentId===loadTimeData.getString("bookmarksBarId")||this.bookmarks_[0].parentId===loadTimeData.getString("otherBookmarksId")||this.bookmarks_[0].parentId===loadTimeData.getString("mobileBookmarksId")){menuItems.push({id:MenuItemId.DIVIDER})}if(this.bookmarks_[0].url){menuItems.push({id:MenuItemId.EDIT,label:loadTimeData.getString("menuEdit")})}if(this.bookmarks_[0].parentId===loadTimeData.getString("bookmarksBarId")){menuItems.push({id:MenuItemId.REMOVE_FROM_BOOKMARKS_BAR,label:loadTimeData.getString("menuMoveToAllBookmarks")})}else if(this.bookmarks_[0].parentId===loadTimeData.getString("otherBookmarksId")||this.bookmarks_[0].parentId===loadTimeData.getString("mobileBookmarksId")){menuItems.push({id:MenuItemId.ADD_TO_BOOKMARKS_BAR,label:loadTimeData.getString("menuMoveToBookmarksBar")})}if(this.priceTrackingEligible_){menuItems.push({id:MenuItemId.DIVIDER},{id:MenuItemId.TRACK_PRICE,label:this.priceTracked_?loadTimeData.getString("menuUntrackPrice"):loadTimeData.getString("menuTrackPrice")})}menuItems.push({id:MenuItemId.DIVIDER});if(!this.bookmarks_[0].url){menuItems.push({id:MenuItemId.RENAME,label:loadTimeData.getString("menuRename")})}menuItems.push({id:MenuItemId.DELETE,label:loadTimeData.getString("tooltipDelete")});return menuItems}showDivider_(menuItem){return menuItem.id===MenuItemId.DIVIDER}dispatchDisabledFeatureEvent_(){this.dispatchEvent(new CustomEvent("disabled-feature"))}onMousedown_(e){if(e.composedPath()[0].tagName!=="DIALOG"){return}this.$.menu.close()}onMenuItemClicked_(event){event.preventDefault();event.stopPropagation();switch(event.model.item.id){case MenuItemId.OPEN_NEW_TAB:this.bookmarksApi_.contextMenuOpenBookmarkInNewTab(this.bookmarks_.map((bookmark=>bookmark.id)),ActionSource.kBookmark);break;case MenuItemId.OPEN_NEW_WINDOW:this.bookmarksApi_.contextMenuOpenBookmarkInNewWindow(this.bookmarks_.map((bookmark=>bookmark.id)),ActionSource.kBookmark);break;case MenuItemId.OPEN_INCOGNITO:this.bookmarksApi_.contextMenuOpenBookmarkInIncognitoWindow(this.bookmarks_.map((bookmark=>bookmark.id)),ActionSource.kBookmark);break;case MenuItemId.OPEN_NEW_TAB_GROUP:this.bookmarksApi_.contextMenuOpenBookmarkInNewTabGroup(this.bookmarks_.map((bookmark=>bookmark.id)),ActionSource.kBookmark);break;case MenuItemId.OPEN_SPLIT_VIEW:this.bookmarksApi_.contextMenuOpenBookmarkInSplitView(this.bookmarks_.map((bookmark=>bookmark.id)),ActionSource.kBookmark);break;case MenuItemId.ADD_TO_BOOKMARKS_BAR:assert(this.bookmarks_.length===1);if(editingDisabledByPolicy(this.bookmarks_)){this.dispatchDisabledFeatureEvent_()}else{this.bookmarksApi_.contextMenuAddToBookmarksBar(this.bookmarks_[0].id,ActionSource.kBookmark)}break;case MenuItemId.REMOVE_FROM_BOOKMARKS_BAR:assert(this.bookmarks_.length===1);if(editingDisabledByPolicy(this.bookmarks_)){this.dispatchDisabledFeatureEvent_()}else{this.bookmarksApi_.contextMenuRemoveFromBookmarksBar(this.bookmarks_[0].id,ActionSource.kBookmark)}break;case MenuItemId.TRACK_PRICE:assert(this.bookmarks_.length===1);if(editingDisabledByPolicy(this.bookmarks_)){this.dispatchDisabledFeatureEvent_()}else{if(this.priceTracked_){this.priceTrackingProxy_.untrackPriceForBookmark(BigInt(this.bookmarks_[0].id));chrome.metricsPrivate.recordUserAction("Commerce.PriceTracking.SidePanel.Untrack.ContextMenu")}else{this.priceTrackingProxy_.trackPriceForBookmark(BigInt(this.bookmarks_[0].id));chrome.metricsPrivate.recordUserAction("Commerce.PriceTracking.SidePanel.Track.ContextMenu")}}break;case MenuItemId.EDIT:this.dispatchEvent(new CustomEvent("edit-clicked",{bubbles:true,composed:true,detail:{bookmarks:this.bookmarks_}}));break;case MenuItemId.RENAME:assert(this.bookmarks_.length===1);if(editingDisabledByPolicy(this.bookmarks_)){this.dispatchDisabledFeatureEvent_()}else{this.dispatchEvent(new CustomEvent("rename-clicked",{bubbles:true,composed:true,detail:{id:this.bookmarks_[0].id}}))}break;case MenuItemId.DELETE:if(editingDisabledByPolicy(this.bookmarks_)){this.dispatchDisabledFeatureEvent_()}else{this.bookmarksApi_.contextMenuDelete(this.bookmarks_.map((bookmark=>bookmark.id)),ActionSource.kBookmark);this.dispatchEvent(new CustomEvent("delete-clicked",{bubbles:true,composed:true,detail:{bookmarks:this.bookmarks_}}))}break}this.$.menu.close()}}customElements.define(PowerBookmarksContextMenuElement.is,PowerBookmarksContextMenuElement);