// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"../tab.js";import"../tab_group.js";import{TabStripService}from"/tab_strip_api/tab_strip_api.mojom-webui.js";import{TabStripObservation}from"/tab_strip_api/tab_strip_observation.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{Color as TabGroupColor}from"../tab_group_types.mojom-webui.js";import{getTemplate}from"../tab_list.html.js";import{SplitTabElement}from"./split_tab_playground.js";import{TabGroupElement}from"./tab_group_playground.js";import{TabElement}from"./tab_playground.js";export class TabListPlaygroundElement extends CustomElement{animationPromises;pinnedTabsElement_;unpinnedTabsElement_;tabStripService_;tabStripObservation_;static get template(){return getTemplate()}constructor(){super();this.animationPromises=Promise.resolve();this.pinnedTabsElement_=this.getRequiredElement("#pinnedTabs");this.unpinnedTabsElement_=this.getRequiredElement("#unpinnedTabs");this.tabStripService_=TabStripService.getRemote();this.tabStripObservation_=new TabStripObservation(this)}getIndexOfTab(tabElement){return Array.prototype.indexOf.call(this.$all("tabstrip-tab"),tabElement)}shouldPreventDrag(isDraggingTab){if(isDraggingTab){return this.$all("tabstrip-tab").length===1}else{return this.pinnedTabsElement_.childElementCount+this.unpinnedTabsElement_.childElementCount===1}}connectedCallback(){this.fetchAndUpdateTabs_()}addAnimationPromise_(promise){this.animationPromises=this.animationPromises.then((()=>promise))}disconnectedCallback(){}placeElement_(element,index,pinned,parentId){element.remove();if(pinned){this.pinnedTabsElement_.insertBefore(element,this.pinnedTabsElement_.childNodes[index]);return}let elementToInsert=element;let parentElement=this.unpinnedTabsElement_;if(element instanceof TabElement&&parentId){let tabGroupElement=this.findNodeElement_(parentId);if(tabGroupElement){parentElement=tabGroupElement}else{tabGroupElement=this.createTabGroupElement_(parentId);tabGroupElement.appendChild(element);elementToInsert=tabGroupElement}}let elementAtIndex=null;if(parentElement===this.unpinnedTabsElement_){const topLevelChildren=Array.from(this.unpinnedTabsElement_.children).filter((e=>e instanceof TabElement||e instanceof TabGroupElement));elementAtIndex=topLevelChildren[index]||null}else{elementAtIndex=parentElement.children[index]||null}if(elementAtIndex){if(elementAtIndex.parentElement instanceof TabGroupElement&&elementAtIndex.previousElementSibling===null&&elementAtIndex.parentElement!==parentElement){elementAtIndex=elementAtIndex.parentElement}elementAtIndex.parentElement.insertBefore(elementToInsert,elementAtIndex)}else{parentElement.appendChild(elementToInsert)}}onTabsCreated(tabsCreatedEvent){const tabsCreated=tabsCreatedEvent.tabs;tabsCreated.forEach((container=>{const tab=container.tab;const tabElement=this.createTabElement_(tab,false);const position=container.position;this.placeElement_(tabElement,position.index,false,null)}))}onTabsClosed(onTabsClosedEvent){const tabsClosed=onTabsClosedEvent.tabs;tabsClosed.forEach((tabId=>{const element=this.findNodeElement_(tabId);if(element instanceof TabElement){this.addAnimationPromise_(element.slideOut())}}))}onDataChanged(onDataChangedEvent){const data=onDataChangedEvent.data;if(data.tab){const tab=data.tab;const element=this.findNodeElement_(tab.id);if(element instanceof TabElement){element.tab=tab}}else if(data.tabGroup){const tabGroup=data.tabGroup;if(tabGroup){this.findOrCreateTabGroupElement_(tabGroup.id).updateVisuals(this.toTabGroupVisualData_(tabGroup))}}}onNodeMoved(event){const element=this.findNodeElement_(event.id);if(!element){console.error("Moved element not found:",event.id);return}let parentId=event.to.parentId;if(element instanceof TabGroupElement){parentId=null}this.placeElement_(element,event.to.index,false,parentId)}onCollectionCreated(event){if(event.data.splitTab){this.createSplitTabElement_(event.data.splitTab)}else if(event.data.tabGroup){}}onDragEnd_(draggedElement,x,y){draggedElement.style.display="none";const dropTarget=this.shadowRoot.elementFromPoint(x,y);draggedElement.style.display="";if(!dropTarget){return}let targetParent=dropTarget;while(targetParent&&!targetParent.matches("tabstrip-tab-group-playground, #unpinnedTabs")){targetParent=targetParent.parentElement}if(!targetParent){return}let dropTargetElement=dropTarget;while(dropTargetElement&&dropTargetElement.parentElement!==targetParent){dropTargetElement=dropTargetElement.parentElement}const sourceParent=draggedElement.parentElement;const originalIndex=Array.from(sourceParent.children).indexOf(draggedElement);let parentId=null;if(draggedElement instanceof TabGroupElement){targetParent=this.unpinnedTabsElement_;parentId=null}else if(targetParent.matches("tabstrip-tab-group-playground")){parentId=targetParent.getAttribute("data-node-id");targetParent=targetParent.shadowRoot.querySelector("#tabs")}let targetIdx=Array.from(targetParent.children).indexOf(dropTargetElement);if(targetIdx===-1){targetIdx=targetParent.children.length}else{const targetRect=dropTargetElement.getBoundingClientRect();const isAfterMiddle=x>targetRect.left+targetRect.width/2;if(isAfterMiddle){targetIdx++}}if(sourceParent===targetParent&&originalIndex<targetIdx){targetIdx--}this.tabStripService_.moveNode(draggedElement.dataset["nodeId"],{parentId:parentId,index:targetIdx})}findNodeElement_(nodeId){if(!nodeId){return null}return this.shadowRoot.querySelector(`[data-node-id="${nodeId}"]`)}clearChildren_(element){while(element.firstChild){element.removeChild(element.firstChild)}}fetchAndUpdateTabs_(){this.tabStripService_.getTabs().then((tabsSnapshot=>{this.tabStripObservation_.bind(tabsSnapshot.stream.handle);console.info("Bound TabsObserver stream to callback router.");this.clearChildren_(this.pinnedTabsElement_);this.clearChildren_(this.unpinnedTabsElement_);if(tabsSnapshot.tabStrip){this.buildTree_(tabsSnapshot.tabStrip,this.shadowRoot)}}))}buildTree_(container,parentDomElement){const data=container.data;let currentElement=null;let childTargetElement=parentDomElement;if(data.tabGroup){const tabGroupElement=this.createTabGroupElement_(data.tabGroup.id);tabGroupElement.updateVisuals(this.toTabGroupVisualData_(data.tabGroup));currentElement=tabGroupElement;childTargetElement=tabGroupElement}else if(data.splitTab){currentElement=this.createSplitTabElement_(data.splitTab);childTargetElement=currentElement}else if(data.tab){const isPinned=parentDomElement===this.pinnedTabsElement_;currentElement=this.createTabElement_(data.tab,isPinned)}else if(data.pinnedTabs){childTargetElement=this.pinnedTabsElement_}else if(data.unpinnedTabs){childTargetElement=this.unpinnedTabsElement_}if(currentElement){parentDomElement.appendChild(currentElement)}container.children.forEach((child=>this.buildTree_(child,childTargetElement)))}createTabElement_(tab,isPinned){const tabElement=new TabElement;tabElement.tab=tab;tabElement.isPinned=isPinned;tabElement.setAttribute("data-node-id",tab.id);tabElement.dragEndHandler=this.onDragEnd_.bind(this);return tabElement}createTabGroupElement_(nodeId){const tabGroupElement=new TabGroupElement;tabGroupElement.setAttribute("data-node-id",nodeId);tabGroupElement.dragEndHandler=this.onDragEnd_.bind(this);this.unpinnedTabsElement_.appendChild(tabGroupElement);return tabGroupElement}createSplitTabElement_(splitTab){console.info("createSplitTabElement");const splitTabElement=new SplitTabElement;splitTabElement.setAttribute("data-node-id",splitTab.id);splitTabElement.dragEndHandler=this.onDragEnd_.bind(this);return splitTabElement}findOrCreateTabGroupElement_(groupId){let tabGroupElement=this.findNodeElement_(groupId);if(!tabGroupElement){tabGroupElement=this.createTabGroupElement_(groupId)}return tabGroupElement}toTabGroupVisualData_(group){const colorMap=new Map([[TabGroupColor.kGrey,"128, 128, 128"],[TabGroupColor.kBlue,"0, 0, 255"],[TabGroupColor.kRed,"255, 0, 0"],[TabGroupColor.kYellow,"255, 255, 0"],[TabGroupColor.kGreen,"0, 128, 0"],[TabGroupColor.kPink,"255, 192, 203"],[TabGroupColor.kPurple,"128, 0, 128"],[TabGroupColor.kCyan,"0, 255, 255"],[TabGroupColor.kOrange,"255, 165, 0"]]);return{title:group.data.title,color:colorMap.get(group.data.color),textColor:"255, 255, 255"}}}customElements.define("tabstrip-playground-tab-list",TabListPlaygroundElement);