// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CustomElement}from"chrome://resources/js/custom_element.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getTemplate}from"./tab_group.html.js";import{TabsApiProxyImpl}from"./tabs_api_proxy.js";export class TabGroupElement extends CustomElement{static get template(){return getTemplate()}tabsApi_;chip_;isValidDragOverTarget_;constructor(){super();this.tabsApi_=TabsApiProxyImpl.getInstance();this.chip_=this.getRequiredElement("#chip");this.chip_.addEventListener("click",(()=>this.onClickChip_()));this.chip_.addEventListener("keydown",(e=>this.onKeydownChip_(e)));this.isValidDragOverTarget_=true}get isValidDragOverTarget(){return!this.hasAttribute("dragging_")&&this.isValidDragOverTarget_}set isValidDragOverTarget(isValid){this.isValidDragOverTarget_=isValid}getDragImage(){return this.getRequiredElement("#dragImage")}getDragImageCenter(){return this.getRequiredElement("#dragHandle")}onClickChip_(){if(!this.dataset["groupId"]){return}const boundingBox=this.getRequiredElement("#chip").getBoundingClientRect();this.tabsApi_.showEditDialogForGroup(this.dataset["groupId"],boundingBox.left,boundingBox.top,boundingBox.width,boundingBox.height)}onKeydownChip_(event){if(event.key==="Enter"||event.key===" "){this.onClickChip_()}}setDragging(enabled){this.toggleAttribute("getting-drag-image_",enabled);requestAnimationFrame((()=>{this.toggleAttribute("dragging",enabled)}))}setDraggedOut(isDraggedOut){this.toggleAttribute("dragged-out_",isDraggedOut)}isDraggedOut(){return this.hasAttribute("dragged-out_")}setTouchPressed(isTouchPressed){this.toggleAttribute("touch_pressed_",isTouchPressed)}updateVisuals(visualData){this.getRequiredElement("#title").innerText=visualData.title;this.style.setProperty("--tabstrip-tab-group-color-rgb",visualData.color);this.style.setProperty("--tabstrip-tab-group-text-color-rgb",visualData.textColor);if(visualData.title){this.chip_.setAttribute("aria-label",loadTimeData.getStringF("namedGroupLabel","",visualData.title,"",""))}else{this.chip_.setAttribute("aria-label",loadTimeData.getStringF("unnamedGroupLabel","","",""))}}}customElements.define("tabstrip-tab-group",TabGroupElement);export function isTabGroupElement(element){return element.tagName==="TABSTRIP-TAB-GROUP"}export function isDragHandle(element){return element.id==="dragHandle"}