// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{isRTL}from"chrome://resources/js/util.js";export const TRANSLATE_ANIMATION_THRESHOLD_PX=30;export const SWIPE_START_THRESHOLD_PX=100;export const SWIPE_FINISH_THRESHOLD_PX=200;const SWIPE_VELOCITY_THRESHOLD=.2;export class TabSwiper{element_;animation_;animationInitiated_;currentPointerDownEvent_=null;pointerDownListener_;pointerMoveListener_;pointerLeaveListener_;pointerUpListener_;constructor(element){this.element_=element;this.animation_=this.createAnimation_();this.animationInitiated_=false;this.pointerDownListener_=e=>this.onPointerDown_(e);this.pointerMoveListener_=e=>this.onPointerMove_(e);this.pointerLeaveListener_=e=>this.onPointerLeave_(e);this.pointerUpListener_=e=>this.onPointerUp_(e)}clearPointerEvents_(){this.currentPointerDownEvent_=null;this.element_.removeEventListener("pointerleave",this.pointerLeaveListener_);this.element_.removeEventListener("pointermove",this.pointerMoveListener_);this.element_.removeEventListener("pointerup",this.pointerUpListener_)}createAnimation_(){const paddingInlineEnd=isRTL()?"paddingLeft":"paddingRight";const animation=new Animation(new KeyframeEffect(this.element_,[{opacity:1,maxWidth:"var(--tabstrip-tab-width)",[paddingInlineEnd]:"var(--tabstrip-tab-spacing)",transform:`translateY(0)`},{offset:TRANSLATE_ANIMATION_THRESHOLD_PX/SWIPE_FINISH_THRESHOLD_PX,transform:`translateY(0)`},{maxWidth:"var(--tabstrip-tab-width)",offset:SWIPE_START_THRESHOLD_PX/SWIPE_FINISH_THRESHOLD_PX,[paddingInlineEnd]:"var(--tabstrip-tab-spacing)",opacity:1},{maxWidth:"0px",opacity:0,[paddingInlineEnd]:0,transform:`translateY(-${SWIPE_FINISH_THRESHOLD_PX}px)`}],{duration:SWIPE_FINISH_THRESHOLD_PX,fill:"both"}));animation.cancel();animation.onfinish=()=>{this.element_.dispatchEvent(new CustomEvent("swipe"))};return animation}onPointerDown_(event){if(this.currentPointerDownEvent_||event.pointerType!=="touch"){return}this.animation_.currentTime=0;this.animationInitiated_=false;this.currentPointerDownEvent_=event;this.element_.addEventListener("pointerleave",this.pointerLeaveListener_);this.element_.addEventListener("pointermove",this.pointerMoveListener_);this.element_.addEventListener("pointerup",this.pointerUpListener_)}onPointerLeave_(event){if(this.currentPointerDownEvent_.pointerId!==event.pointerId){return}this.clearPointerEvents_()}onPointerMove_(event){if(this.currentPointerDownEvent_.pointerId!==event.pointerId||event.movementY===0){return}const yDiff=this.currentPointerDownEvent_.clientY-event.clientY;const animationTime=yDiff;this.animation_.currentTime=Math.max(0,Math.min(SWIPE_FINISH_THRESHOLD_PX,animationTime));if(!this.animationInitiated_&&Math.abs(yDiff)>TRANSLATE_ANIMATION_THRESHOLD_PX){this.animationInitiated_=true;this.element_.setPointerCapture(event.pointerId)}}onPointerUp_(event){if(this.currentPointerDownEvent_.pointerId!==event.pointerId){return}const pixelsSwiped=Number(this.animation_.currentTime);const swipedEnoughToClose=pixelsSwiped>SWIPE_START_THRESHOLD_PX;const wasHighVelocity=pixelsSwiped/(event.timeStamp-this.currentPointerDownEvent_.timeStamp)>SWIPE_VELOCITY_THRESHOLD;if(pixelsSwiped===SWIPE_FINISH_THRESHOLD_PX){this.animation_.finish()}else if(swipedEnoughToClose||wasHighVelocity){this.animation_.play()}else{this.animation_.cancel();this.animation_.currentTime=0}this.clearPointerEvents_()}reset(){this.animation_.cancel()}startObserving(){this.element_.addEventListener("pointerdown",this.pointerDownListener_)}stopObserving(){this.element_.removeEventListener("pointerdown",this.pointerDownListener_)}wasSwiping(){return this.animationInitiated_}}