// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { CustomElement } from 'chrome://resources/js/custom_element.js';
import { getTemplate } from './split_tab_playground.html.js';
import { isTabElement } from './tab_playground.js';
export class SplitTabElement extends CustomElement {
    static get template() {
        return getTemplate();
    }
    container_;
    slot_;
    dragHandler_ = () => { };
    constructor() {
        super();
        this.container_ = this.getRequiredElement('#container');
        this.container_.addEventListener('dragend', (event) => this.dragHandler_(this, event.clientX, event.clientY));
        this.slot_ = this.getRequiredElement('#slot');
        this.slot_.addEventListener('slotchange', () => this.onSlotChange_());
    }
    set dragEndHandler(handler) {
        this.dragHandler_ = handler;
    }
    onSlotChange_() {
        const assignedElements = this.slot_.assignedElements();
        for (const element of assignedElements) {
            if (isTabElement(element)) {
                element.draggable = false;
            }
        }
    }
}
customElements.define('tabstrip-split-tab-playground', SplitTabElement);
export function isSplitTabElement(element) {
    return element.tagName === 'TABSTRIP-SPLIT-TAB-PLAYGROUND';
}
