// chrome/browser/ui/webui/tab_strip/tab_strip.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { TabAlertStateSpec as tabs_mojom_TabAlertStateSpec, TabNetworkStateSpec as tabs_mojom_TabNetworkStateSpec } from './tabs.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'tab_strip.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "tab_strip.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'tab_strip.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getGroupVisualData() {
        return this.proxy.sendMessage(0, PageHandler_GetGroupVisualData_ParamsSpec.$, PageHandler_GetGroupVisualData_ResponseParamsSpec.$, [], false);
    }
    getTabs() {
        return this.proxy.sendMessage(1, PageHandler_GetTabs_ParamsSpec.$, PageHandler_GetTabs_ResponseParamsSpec.$, [], false);
    }
    closeTab(tabId, tabWasSwiped) {
        this.proxy.sendMessage(2, PageHandler_CloseTab_ParamsSpec.$, null, [
            tabId,
            tabWasSwiped
        ], false);
    }
    groupTab(tabId, groupId) {
        this.proxy.sendMessage(3, PageHandler_GroupTab_ParamsSpec.$, null, [
            tabId,
            groupId
        ], false);
    }
    moveGroup(groupId, toIndex) {
        this.proxy.sendMessage(4, PageHandler_MoveGroup_ParamsSpec.$, null, [
            groupId,
            toIndex
        ], false);
    }
    moveTab(tabId, toIndex) {
        this.proxy.sendMessage(5, PageHandler_MoveTab_ParamsSpec.$, null, [
            tabId,
            toIndex
        ], false);
    }
    setThumbnailTracked(tabId, thumbnailTracked) {
        this.proxy.sendMessage(6, PageHandler_SetThumbnailTracked_ParamsSpec.$, null, [
            tabId,
            thumbnailTracked
        ], false);
    }
    ungroupTab(tabId) {
        this.proxy.sendMessage(7, PageHandler_UngroupTab_ParamsSpec.$, null, [
            tabId
        ], false);
    }
    getLayout() {
        return this.proxy.sendMessage(8, PageHandler_GetLayout_ParamsSpec.$, PageHandler_GetLayout_ResponseParamsSpec.$, [], false);
    }
    showEditDialogForGroup(groupId, locationX, locationY, width, height) {
        this.proxy.sendMessage(9, PageHandler_ShowEditDialogForGroup_ParamsSpec.$, null, [
            groupId,
            locationX,
            locationY,
            width,
            height
        ], false);
    }
    showTabContextMenu(tabId, locationX, locationY) {
        this.proxy.sendMessage(10, PageHandler_ShowTabContextMenu_ParamsSpec.$, null, [
            tabId,
            locationX,
            locationY
        ], false);
    }
    showBackgroundContextMenu(locationX, locationY) {
        this.proxy.sendMessage(11, PageHandler_ShowBackgroundContextMenu_ParamsSpec.$, null, [
            locationX,
            locationY
        ], false);
    }
    closeContainer() {
        this.proxy.sendMessage(12, PageHandler_CloseContainer_ParamsSpec.$, null, [], false);
    }
    reportTabActivationDuration(durationMs) {
        this.proxy.sendMessage(13, PageHandler_ReportTabActivationDuration_ParamsSpec.$, null, [
            durationMs
        ], false);
    }
    reportTabDataReceivedDuration(tabCount, durationMs) {
        this.proxy.sendMessage(14, PageHandler_ReportTabDataReceivedDuration_ParamsSpec.$, null, [
            tabCount,
            durationMs
        ], false);
    }
    reportTabCreationDuration(tabCount, durationMs) {
        this.proxy.sendMessage(15, PageHandler_ReportTabCreationDuration_ParamsSpec.$, null, [
            tabCount,
            durationMs
        ], false);
    }
    activateTab(tabId) {
        this.proxy.sendMessage(16, PageHandler_ActivateTab_ParamsSpec.$, null, [
            tabId
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetGroupVisualData_ParamsSpec.$, PageHandler_GetGroupVisualData_ResponseParamsSpec.$, impl.getGroupVisualData.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_GetTabs_ParamsSpec.$, PageHandler_GetTabs_ResponseParamsSpec.$, impl.getTabs.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_CloseTab_ParamsSpec.$, null, impl.closeTab.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_GroupTab_ParamsSpec.$, null, impl.groupTab.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_MoveGroup_ParamsSpec.$, null, impl.moveGroup.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_MoveTab_ParamsSpec.$, null, impl.moveTab.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_SetThumbnailTracked_ParamsSpec.$, null, impl.setThumbnailTracked.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_UngroupTab_ParamsSpec.$, null, impl.ungroupTab.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_GetLayout_ParamsSpec.$, PageHandler_GetLayout_ResponseParamsSpec.$, impl.getLayout.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_ShowEditDialogForGroup_ParamsSpec.$, null, impl.showEditDialogForGroup.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_ShowTabContextMenu_ParamsSpec.$, null, impl.showTabContextMenu.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_ShowBackgroundContextMenu_ParamsSpec.$, null, impl.showBackgroundContextMenu.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_CloseContainer_ParamsSpec.$, null, impl.closeContainer.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_ReportTabActivationDuration_ParamsSpec.$, null, impl.reportTabActivationDuration.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_ReportTabDataReceivedDuration_ParamsSpec.$, null, impl.reportTabDataReceivedDuration.bind(impl), false);
        this.helper_internal_.registerHandler(15, PageHandler_ReportTabCreationDuration_ParamsSpec.$, null, impl.reportTabCreationDuration.bind(impl), false);
        this.helper_internal_.registerHandler(16, PageHandler_ActivateTab_ParamsSpec.$, null, impl.activateTab.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "tab_strip.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getGroupVisualData;
    getTabs;
    closeTab;
    groupTab;
    moveGroup;
    moveTab;
    setThumbnailTracked;
    ungroupTab;
    getLayout;
    showEditDialogForGroup;
    showTabContextMenu;
    showBackgroundContextMenu;
    closeContainer;
    reportTabActivationDuration;
    reportTabDataReceivedDuration;
    reportTabCreationDuration;
    activateTab;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getGroupVisualData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetGroupVisualData_ParamsSpec.$, PageHandler_GetGroupVisualData_ResponseParamsSpec.$, this.getGroupVisualData.createReceiverHandler(true /* expectsResponse */), false);
        this.getTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_GetTabs_ParamsSpec.$, PageHandler_GetTabs_ResponseParamsSpec.$, this.getTabs.createReceiverHandler(true /* expectsResponse */), false);
        this.closeTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_CloseTab_ParamsSpec.$, null, this.closeTab.createReceiverHandler(false /* expectsResponse */), false);
        this.groupTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_GroupTab_ParamsSpec.$, null, this.groupTab.createReceiverHandler(false /* expectsResponse */), false);
        this.moveGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_MoveGroup_ParamsSpec.$, null, this.moveGroup.createReceiverHandler(false /* expectsResponse */), false);
        this.moveTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_MoveTab_ParamsSpec.$, null, this.moveTab.createReceiverHandler(false /* expectsResponse */), false);
        this.setThumbnailTracked =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_SetThumbnailTracked_ParamsSpec.$, null, this.setThumbnailTracked.createReceiverHandler(false /* expectsResponse */), false);
        this.ungroupTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_UngroupTab_ParamsSpec.$, null, this.ungroupTab.createReceiverHandler(false /* expectsResponse */), false);
        this.getLayout =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_GetLayout_ParamsSpec.$, PageHandler_GetLayout_ResponseParamsSpec.$, this.getLayout.createReceiverHandler(true /* expectsResponse */), false);
        this.showEditDialogForGroup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_ShowEditDialogForGroup_ParamsSpec.$, null, this.showEditDialogForGroup.createReceiverHandler(false /* expectsResponse */), false);
        this.showTabContextMenu =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_ShowTabContextMenu_ParamsSpec.$, null, this.showTabContextMenu.createReceiverHandler(false /* expectsResponse */), false);
        this.showBackgroundContextMenu =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_ShowBackgroundContextMenu_ParamsSpec.$, null, this.showBackgroundContextMenu.createReceiverHandler(false /* expectsResponse */), false);
        this.closeContainer =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_CloseContainer_ParamsSpec.$, null, this.closeContainer.createReceiverHandler(false /* expectsResponse */), false);
        this.reportTabActivationDuration =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_ReportTabActivationDuration_ParamsSpec.$, null, this.reportTabActivationDuration.createReceiverHandler(false /* expectsResponse */), false);
        this.reportTabDataReceivedDuration =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_ReportTabDataReceivedDuration_ParamsSpec.$, null, this.reportTabDataReceivedDuration.createReceiverHandler(false /* expectsResponse */), false);
        this.reportTabCreationDuration =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, PageHandler_ReportTabCreationDuration_ParamsSpec.$, null, this.reportTabCreationDuration.createReceiverHandler(false /* expectsResponse */), false);
        this.activateTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, PageHandler_ActivateTab_ParamsSpec.$, null, this.activateTab.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'tab_strip.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    layoutChanged(layout) {
        this.proxy.sendMessage(0, Page_LayoutChanged_ParamsSpec.$, null, [
            layout
        ], false);
    }
    receivedKeyboardFocus() {
        this.proxy.sendMessage(1, Page_ReceivedKeyboardFocus_ParamsSpec.$, null, [], false);
    }
    contextMenuClosed() {
        this.proxy.sendMessage(2, Page_ContextMenuClosed_ParamsSpec.$, null, [], false);
    }
    longPress() {
        this.proxy.sendMessage(3, Page_LongPress_ParamsSpec.$, null, [], false);
    }
    tabGroupVisualsChanged(groupId, tabGroup) {
        this.proxy.sendMessage(4, Page_TabGroupVisualsChanged_ParamsSpec.$, null, [
            groupId,
            tabGroup
        ], false);
    }
    tabGroupMoved(groupId, index) {
        this.proxy.sendMessage(5, Page_TabGroupMoved_ParamsSpec.$, null, [
            groupId,
            index
        ], false);
    }
    tabGroupClosed(groupId) {
        this.proxy.sendMessage(6, Page_TabGroupClosed_ParamsSpec.$, null, [
            groupId
        ], false);
    }
    tabGroupStateChanged(tabId, index, groupId) {
        this.proxy.sendMessage(7, Page_TabGroupStateChanged_ParamsSpec.$, null, [
            tabId,
            index,
            groupId
        ], false);
    }
    tabCloseCancelled(tabId) {
        this.proxy.sendMessage(8, Page_TabCloseCancelled_ParamsSpec.$, null, [
            tabId
        ], false);
    }
    tabCreated(tab) {
        this.proxy.sendMessage(9, Page_TabCreated_ParamsSpec.$, null, [
            tab
        ], false);
    }
    tabRemoved(tabId) {
        this.proxy.sendMessage(10, Page_TabRemoved_ParamsSpec.$, null, [
            tabId
        ], false);
    }
    tabMoved(tabId, toIndex, inPinned) {
        this.proxy.sendMessage(11, Page_TabMoved_ParamsSpec.$, null, [
            tabId,
            toIndex,
            inPinned
        ], false);
    }
    tabReplaced(tabId, newTabId) {
        this.proxy.sendMessage(12, Page_TabReplaced_ParamsSpec.$, null, [
            tabId,
            newTabId
        ], false);
    }
    tabActiveChanged(tabId) {
        this.proxy.sendMessage(13, Page_TabActiveChanged_ParamsSpec.$, null, [
            tabId
        ], false);
    }
    tabUpdated(tab) {
        this.proxy.sendMessage(14, Page_TabUpdated_ParamsSpec.$, null, [
            tab
        ], false);
    }
    tabThumbnailUpdated(tabId, dataUri) {
        this.proxy.sendMessage(15, Page_TabThumbnailUpdated_ParamsSpec.$, null, [
            tabId,
            dataUri
        ], false);
    }
    showContextMenu() {
        this.proxy.sendMessage(16, Page_ShowContextMenu_ParamsSpec.$, null, [], false);
    }
    themeChanged() {
        this.proxy.sendMessage(17, Page_ThemeChanged_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_LayoutChanged_ParamsSpec.$, null, impl.layoutChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_ReceivedKeyboardFocus_ParamsSpec.$, null, impl.receivedKeyboardFocus.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_ContextMenuClosed_ParamsSpec.$, null, impl.contextMenuClosed.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_LongPress_ParamsSpec.$, null, impl.longPress.bind(impl), false);
        this.helper_internal_.registerHandler(4, Page_TabGroupVisualsChanged_ParamsSpec.$, null, impl.tabGroupVisualsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(5, Page_TabGroupMoved_ParamsSpec.$, null, impl.tabGroupMoved.bind(impl), false);
        this.helper_internal_.registerHandler(6, Page_TabGroupClosed_ParamsSpec.$, null, impl.tabGroupClosed.bind(impl), false);
        this.helper_internal_.registerHandler(7, Page_TabGroupStateChanged_ParamsSpec.$, null, impl.tabGroupStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(8, Page_TabCloseCancelled_ParamsSpec.$, null, impl.tabCloseCancelled.bind(impl), false);
        this.helper_internal_.registerHandler(9, Page_TabCreated_ParamsSpec.$, null, impl.tabCreated.bind(impl), false);
        this.helper_internal_.registerHandler(10, Page_TabRemoved_ParamsSpec.$, null, impl.tabRemoved.bind(impl), false);
        this.helper_internal_.registerHandler(11, Page_TabMoved_ParamsSpec.$, null, impl.tabMoved.bind(impl), false);
        this.helper_internal_.registerHandler(12, Page_TabReplaced_ParamsSpec.$, null, impl.tabReplaced.bind(impl), false);
        this.helper_internal_.registerHandler(13, Page_TabActiveChanged_ParamsSpec.$, null, impl.tabActiveChanged.bind(impl), false);
        this.helper_internal_.registerHandler(14, Page_TabUpdated_ParamsSpec.$, null, impl.tabUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(15, Page_TabThumbnailUpdated_ParamsSpec.$, null, impl.tabThumbnailUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(16, Page_ShowContextMenu_ParamsSpec.$, null, impl.showContextMenu.bind(impl), false);
        this.helper_internal_.registerHandler(17, Page_ThemeChanged_ParamsSpec.$, null, impl.themeChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "tab_strip.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    layoutChanged;
    receivedKeyboardFocus;
    contextMenuClosed;
    longPress;
    tabGroupVisualsChanged;
    tabGroupMoved;
    tabGroupClosed;
    tabGroupStateChanged;
    tabCloseCancelled;
    tabCreated;
    tabRemoved;
    tabMoved;
    tabReplaced;
    tabActiveChanged;
    tabUpdated;
    tabThumbnailUpdated;
    showContextMenu;
    themeChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.layoutChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_LayoutChanged_ParamsSpec.$, null, this.layoutChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.receivedKeyboardFocus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_ReceivedKeyboardFocus_ParamsSpec.$, null, this.receivedKeyboardFocus.createReceiverHandler(false /* expectsResponse */), false);
        this.contextMenuClosed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_ContextMenuClosed_ParamsSpec.$, null, this.contextMenuClosed.createReceiverHandler(false /* expectsResponse */), false);
        this.longPress =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_LongPress_ParamsSpec.$, null, this.longPress.createReceiverHandler(false /* expectsResponse */), false);
        this.tabGroupVisualsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Page_TabGroupVisualsChanged_ParamsSpec.$, null, this.tabGroupVisualsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabGroupMoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Page_TabGroupMoved_ParamsSpec.$, null, this.tabGroupMoved.createReceiverHandler(false /* expectsResponse */), false);
        this.tabGroupClosed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Page_TabGroupClosed_ParamsSpec.$, null, this.tabGroupClosed.createReceiverHandler(false /* expectsResponse */), false);
        this.tabGroupStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Page_TabGroupStateChanged_ParamsSpec.$, null, this.tabGroupStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabCloseCancelled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Page_TabCloseCancelled_ParamsSpec.$, null, this.tabCloseCancelled.createReceiverHandler(false /* expectsResponse */), false);
        this.tabCreated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, Page_TabCreated_ParamsSpec.$, null, this.tabCreated.createReceiverHandler(false /* expectsResponse */), false);
        this.tabRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, Page_TabRemoved_ParamsSpec.$, null, this.tabRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.tabMoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, Page_TabMoved_ParamsSpec.$, null, this.tabMoved.createReceiverHandler(false /* expectsResponse */), false);
        this.tabReplaced =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, Page_TabReplaced_ParamsSpec.$, null, this.tabReplaced.createReceiverHandler(false /* expectsResponse */), false);
        this.tabActiveChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, Page_TabActiveChanged_ParamsSpec.$, null, this.tabActiveChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, Page_TabUpdated_ParamsSpec.$, null, this.tabUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.tabThumbnailUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, Page_TabThumbnailUpdated_ParamsSpec.$, null, this.tabThumbnailUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.showContextMenu =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, Page_ShowContextMenu_ParamsSpec.$, null, this.showContextMenu.createReceiverHandler(false /* expectsResponse */), false);
        this.themeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, Page_ThemeChanged_ParamsSpec.$, null, this.themeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TabSpec = { $: {} };
export const TabGroupVisualDataSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetGroupVisualData_ParamsSpec = { $: {} };
export const PageHandler_GetGroupVisualData_ResponseParamsSpec = { $: {} };
export const PageHandler_GetTabs_ParamsSpec = { $: {} };
export const PageHandler_GetTabs_ResponseParamsSpec = { $: {} };
export const PageHandler_CloseTab_ParamsSpec = { $: {} };
export const PageHandler_GroupTab_ParamsSpec = { $: {} };
export const PageHandler_MoveGroup_ParamsSpec = { $: {} };
export const PageHandler_MoveTab_ParamsSpec = { $: {} };
export const PageHandler_SetThumbnailTracked_ParamsSpec = { $: {} };
export const PageHandler_UngroupTab_ParamsSpec = { $: {} };
export const PageHandler_GetLayout_ParamsSpec = { $: {} };
export const PageHandler_GetLayout_ResponseParamsSpec = { $: {} };
export const PageHandler_ShowEditDialogForGroup_ParamsSpec = { $: {} };
export const PageHandler_ShowTabContextMenu_ParamsSpec = { $: {} };
export const PageHandler_ShowBackgroundContextMenu_ParamsSpec = { $: {} };
export const PageHandler_CloseContainer_ParamsSpec = { $: {} };
export const PageHandler_ReportTabActivationDuration_ParamsSpec = { $: {} };
export const PageHandler_ReportTabDataReceivedDuration_ParamsSpec = { $: {} };
export const PageHandler_ReportTabCreationDuration_ParamsSpec = { $: {} };
export const PageHandler_ActivateTab_ParamsSpec = { $: {} };
export const Page_LayoutChanged_ParamsSpec = { $: {} };
export const Page_ReceivedKeyboardFocus_ParamsSpec = { $: {} };
export const Page_ContextMenuClosed_ParamsSpec = { $: {} };
export const Page_LongPress_ParamsSpec = { $: {} };
export const Page_TabGroupVisualsChanged_ParamsSpec = { $: {} };
export const Page_TabGroupMoved_ParamsSpec = { $: {} };
export const Page_TabGroupClosed_ParamsSpec = { $: {} };
export const Page_TabGroupStateChanged_ParamsSpec = { $: {} };
export const Page_TabCloseCancelled_ParamsSpec = { $: {} };
export const Page_TabCreated_ParamsSpec = { $: {} };
export const Page_TabRemoved_ParamsSpec = { $: {} };
export const Page_TabMoved_ParamsSpec = { $: {} };
export const Page_TabReplaced_ParamsSpec = { $: {} };
export const Page_TabActiveChanged_ParamsSpec = { $: {} };
export const Page_TabUpdated_ParamsSpec = { $: {} };
export const Page_TabThumbnailUpdated_ParamsSpec = { $: {} };
export const Page_ShowContextMenu_ParamsSpec = { $: {} };
export const Page_ThemeChanged_ParamsSpec = { $: {} };
mojo.internal.Struct(TabSpec.$, 'Tab', [
    mojo.internal.StructField('active', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('alertStates', 8, 0, mojo.internal.Array(tabs_mojom_TabAlertStateSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('blocked', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('crashed', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('faviconUrl', 16, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('activeFaviconUrl', 24, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('groupId', 32, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('index', 40, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDefaultFavicon', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('networkState', 44, 0, tabs_mojom_TabNetworkStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pinned', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shouldHideThrobber', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showIcon', 0, 6, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 48, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 56, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 72],]);
mojo.internal.Struct(TabGroupVisualDataSpec.$, 'TabGroupVisualData', [
    mojo.internal.StructField('color', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('textColor', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetGroupVisualData_ParamsSpec.$, 'PageHandler_GetGroupVisualData_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetGroupVisualData_ResponseParamsSpec.$, 'PageHandler_GetGroupVisualData_ResponseParams', [
    mojo.internal.StructField('data', 0, 0, mojo.internal.Map(mojo.internal.String, TabGroupVisualDataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetTabs_ParamsSpec.$, 'PageHandler_GetTabs_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTabs_ResponseParamsSpec.$, 'PageHandler_GetTabs_ResponseParams', [
    mojo.internal.StructField('tabs', 0, 0, mojo.internal.Array(TabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_CloseTab_ParamsSpec.$, 'PageHandler_CloseTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabWasSwiped', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GroupTab_ParamsSpec.$, 'PageHandler_GroupTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('groupId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_MoveGroup_ParamsSpec.$, 'PageHandler_MoveGroup_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('toIndex', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_MoveTab_ParamsSpec.$, 'PageHandler_MoveTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('toIndex', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetThumbnailTracked_ParamsSpec.$, 'PageHandler_SetThumbnailTracked_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('thumbnailTracked', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_UngroupTab_ParamsSpec.$, 'PageHandler_UngroupTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetLayout_ParamsSpec.$, 'PageHandler_GetLayout_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetLayout_ResponseParamsSpec.$, 'PageHandler_GetLayout_ResponseParams', [
    mojo.internal.StructField('layout', 0, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ShowEditDialogForGroup_ParamsSpec.$, 'PageHandler_ShowEditDialogForGroup_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locationX', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locationY', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('width', 16, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 20, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_ShowTabContextMenu_ParamsSpec.$, 'PageHandler_ShowTabContextMenu_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locationX', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locationY', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ShowBackgroundContextMenu_ParamsSpec.$, 'PageHandler_ShowBackgroundContextMenu_Params', [
    mojo.internal.StructField('locationX', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locationY', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_CloseContainer_ParamsSpec.$, 'PageHandler_CloseContainer_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ReportTabActivationDuration_ParamsSpec.$, 'PageHandler_ReportTabActivationDuration_Params', [
    mojo.internal.StructField('durationMs', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ReportTabDataReceivedDuration_ParamsSpec.$, 'PageHandler_ReportTabDataReceivedDuration_Params', [
    mojo.internal.StructField('tabCount', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('durationMs', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ReportTabCreationDuration_ParamsSpec.$, 'PageHandler_ReportTabCreationDuration_Params', [
    mojo.internal.StructField('tabCount', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('durationMs', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ActivateTab_ParamsSpec.$, 'PageHandler_ActivateTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_LayoutChanged_ParamsSpec.$, 'Page_LayoutChanged_Params', [
    mojo.internal.StructField('layout', 0, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ReceivedKeyboardFocus_ParamsSpec.$, 'Page_ReceivedKeyboardFocus_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_ContextMenuClosed_ParamsSpec.$, 'Page_ContextMenuClosed_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_LongPress_ParamsSpec.$, 'Page_LongPress_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_TabGroupVisualsChanged_ParamsSpec.$, 'Page_TabGroupVisualsChanged_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabGroup', 8, 0, TabGroupVisualDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_TabGroupMoved_ParamsSpec.$, 'Page_TabGroupMoved_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('index', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_TabGroupClosed_ParamsSpec.$, 'Page_TabGroupClosed_Params', [
    mojo.internal.StructField('groupId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabGroupStateChanged_ParamsSpec.$, 'Page_TabGroupStateChanged_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('index', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('groupId', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_TabCloseCancelled_ParamsSpec.$, 'Page_TabCloseCancelled_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabCreated_ParamsSpec.$, 'Page_TabCreated_Params', [
    mojo.internal.StructField('tab', 0, 0, TabSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabRemoved_ParamsSpec.$, 'Page_TabRemoved_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabMoved_ParamsSpec.$, 'Page_TabMoved_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('toIndex', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inPinned', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_TabReplaced_ParamsSpec.$, 'Page_TabReplaced_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('newTabId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabActiveChanged_ParamsSpec.$, 'Page_TabActiveChanged_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabUpdated_ParamsSpec.$, 'Page_TabUpdated_Params', [
    mojo.internal.StructField('tab', 0, 0, TabSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabThumbnailUpdated_ParamsSpec.$, 'Page_TabThumbnailUpdated_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dataUri', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Page_ShowContextMenu_ParamsSpec.$, 'Page_ShowContextMenu_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_ThemeChanged_ParamsSpec.$, 'Page_ThemeChanged_Params', [], [[0, 8],]);
