// components/attribution_reporting/registration_header_error.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/attribution_reporting/registration_header_error.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('attributionReporting.mojom');
  var os_registration_error$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/os_registration_error.mojom', 'os_registration_error.mojom.js');
  }
  var source_registration_error$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/source_registration_error.mojom', 'source_registration_error.mojom.js');
  }
  var trigger_registration_error$ =
      mojo.internal.exposeNamespace('attributionReporting.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/attribution_reporting/trigger_registration_error.mojom', 'trigger_registration_error.mojom.js');
  }



  function RegistrationHeaderError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RegistrationHeaderError.prototype.initDefaults_ = function() {
    this.headerValue = null;
    this.errorDetails = null;
  };
  RegistrationHeaderError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RegistrationHeaderError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RegistrationHeaderError.headerValue
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RegistrationHeaderError.errorDetails
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, RegistrationHeaderErrorDetails, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RegistrationHeaderError.encodedSize = codec.kStructHeaderSize + 24;

  RegistrationHeaderError.decode = function(decoder) {
    var packed;
    var val = new RegistrationHeaderError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.headerValue =
        decoder.decodeStruct(codec.String);
    val.errorDetails =
        decoder.decodeStruct(RegistrationHeaderErrorDetails);
    return val;
  };

  RegistrationHeaderError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RegistrationHeaderError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.headerValue);
    encoder.encodeStruct(RegistrationHeaderErrorDetails, val.errorDetails);
  };

  function RegistrationHeaderErrorDetails(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  RegistrationHeaderErrorDetails.Tags = {
    sourceError: 0,
    triggerError: 1,
    osSourceError: 2,
    osTriggerError: 3,
  };

  RegistrationHeaderErrorDetails.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  RegistrationHeaderErrorDetails.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "sourceError",
        "triggerError",
        "osSourceError",
        "osTriggerError",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a RegistrationHeaderErrorDetails member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(RegistrationHeaderErrorDetails.prototype, "sourceError", {
    get: function() {
      if (this.$tag != RegistrationHeaderErrorDetails.Tags.sourceError) {
        throw new ReferenceError(
            "RegistrationHeaderErrorDetails.sourceError is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = RegistrationHeaderErrorDetails.Tags.sourceError;
      this.$data = value;
    }
  });
  Object.defineProperty(RegistrationHeaderErrorDetails.prototype, "triggerError", {
    get: function() {
      if (this.$tag != RegistrationHeaderErrorDetails.Tags.triggerError) {
        throw new ReferenceError(
            "RegistrationHeaderErrorDetails.triggerError is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = RegistrationHeaderErrorDetails.Tags.triggerError;
      this.$data = value;
    }
  });
  Object.defineProperty(RegistrationHeaderErrorDetails.prototype, "osSourceError", {
    get: function() {
      if (this.$tag != RegistrationHeaderErrorDetails.Tags.osSourceError) {
        throw new ReferenceError(
            "RegistrationHeaderErrorDetails.osSourceError is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = RegistrationHeaderErrorDetails.Tags.osSourceError;
      this.$data = value;
    }
  });
  Object.defineProperty(RegistrationHeaderErrorDetails.prototype, "osTriggerError", {
    get: function() {
      if (this.$tag != RegistrationHeaderErrorDetails.Tags.osTriggerError) {
        throw new ReferenceError(
            "RegistrationHeaderErrorDetails.osTriggerError is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = RegistrationHeaderErrorDetails.Tags.osTriggerError;
      this.$data = value;
    }
  });


    RegistrationHeaderErrorDetails.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case RegistrationHeaderErrorDetails.Tags.sourceError:
          encoder.encodeStruct(codec.Int32, val.sourceError);
          break;
        case RegistrationHeaderErrorDetails.Tags.triggerError:
          encoder.encodeStruct(codec.Int32, val.triggerError);
          break;
        case RegistrationHeaderErrorDetails.Tags.osSourceError:
          encoder.encodeStruct(codec.Int32, val.osSourceError);
          break;
        case RegistrationHeaderErrorDetails.Tags.osTriggerError:
          encoder.encodeStruct(codec.Int32, val.osTriggerError);
          break;
      }
      encoder.align();
    };


    RegistrationHeaderErrorDetails.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new RegistrationHeaderErrorDetails();
      var tag = decoder.readUint32();
      switch (tag) {
        case RegistrationHeaderErrorDetails.Tags.sourceError:
          result.sourceError = decoder.decodeStruct(new codec.Enum(source_registration_error$.SourceRegistrationError));
          break;
        case RegistrationHeaderErrorDetails.Tags.triggerError:
          result.triggerError = decoder.decodeStruct(new codec.Enum(trigger_registration_error$.TriggerRegistrationError));
          break;
        case RegistrationHeaderErrorDetails.Tags.osSourceError:
          result.osSourceError = decoder.decodeStruct(new codec.Enum(os_registration_error$.OsRegistrationError));
          break;
        case RegistrationHeaderErrorDetails.Tags.osTriggerError:
          result.osTriggerError = decoder.decodeStruct(new codec.Enum(os_registration_error$.OsRegistrationError));
          break;
      }
      decoder.align();

      return result;
    };


    RegistrationHeaderErrorDetails.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case RegistrationHeaderErrorDetails.Tags.sourceError:
          

    // validate RegistrationHeaderErrorDetails.sourceError
    err = messageValidator.validateEnum(data_offset, source_registration_error$.SourceRegistrationError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case RegistrationHeaderErrorDetails.Tags.triggerError:
          

    // validate RegistrationHeaderErrorDetails.triggerError
    err = messageValidator.validateEnum(data_offset, trigger_registration_error$.TriggerRegistrationError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case RegistrationHeaderErrorDetails.Tags.osSourceError:
          

    // validate RegistrationHeaderErrorDetails.osSourceError
    err = messageValidator.validateEnum(data_offset, os_registration_error$.OsRegistrationError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case RegistrationHeaderErrorDetails.Tags.osTriggerError:
          

    // validate RegistrationHeaderErrorDetails.osTriggerError
    err = messageValidator.validateEnum(data_offset, os_registration_error$.OsRegistrationError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  RegistrationHeaderErrorDetails.encodedSize = 16;
  exports.RegistrationHeaderError = RegistrationHeaderError;
  exports.RegistrationHeaderErrorDetails = RegistrationHeaderErrorDetails;
})();