// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{addWebUiListener}from"chrome://resources/js/cr.js";import{$,getRequiredElement}from"chrome://resources/js/util.js";let isRecording=false;let keyPressState=0;function setIfExists(info,prop,elementId){const element=$(elementId);if(!element){return}if(info[prop]!==undefined){element.textContent=info[prop]}else{element.textContent=""}}function setRegisteredAppIdsIfExists(info,prop,elementId){const element=$(elementId);if(!element){return}if(info[prop]===undefined||!Array.isArray(info[prop])){return}const registeredAppIds=new Map;info[prop].forEach((registeredAppId=>{registeredAppIds.set(registeredAppId,(registeredAppIds.get(registeredAppId)||0)+1)}));const list=[];for(const[registeredAppId,count]of registeredAppIds.entries()){list.push(registeredAppId+(count>1?` (x${count})`:``))}element.textContent=list.join(", ")}function displayDeviceInfo(info){setIfExists(info,"androidId","android-id");setIfExists(info,"androidSecret","android-secret");setIfExists(info,"profileServiceCreated","profile-service-created");setIfExists(info,"gcmEnabled","gcm-enabled");setIfExists(info,"gcmClientCreated","gcm-client-created");setIfExists(info,"gcmClientState","gcm-client-state");setIfExists(info,"connectionClientCreated","connection-client-created");setIfExists(info,"connectionState","connection-state");setIfExists(info,"lastCheckin","last-checkin");setIfExists(info,"nextCheckin","next-checkin");setIfExists(info,"sendQueueSize","send-queue-size");setIfExists(info,"resendQueueSize","resend-queue-size");setRegisteredAppIdsIfExists(info,"registeredAppIds","registered-app-ids")}function removeAllChildNodes(element){element.textContent=""}function addRows(table,list){for(const info of list){const row=document.createElement("tr");let cell=document.createElement("td");const d=new Date(info[0]);cell.textContent=d.toString();row.appendChild(cell);for(let j=1;j<info.length;++j){cell=document.createElement("td");cell.textContent=info[j];row.appendChild(cell)}table.appendChild(row)}}function refreshAll(){chrome.send("getGcmInternalsInfo",[false])}function setRecording(){isRecording=!isRecording;chrome.send("setGcmInternalsRecording",[isRecording])}function clearLogs(){chrome.send("getGcmInternalsInfo",[true])}function initialize(){addWebUiListener("set-gcm-internals-info",setGcmInternalsInfo);getRequiredElement("recording").disabled=true;getRequiredElement("refresh").onclick=refreshAll;getRequiredElement("recording").onclick=setRecording;getRequiredElement("clear-logs").onclick=clearLogs;chrome.send("getGcmInternalsInfo",[false]);chrome.send("setGcmInternalsRecording",[true])}function handleKeyPress(event){const PHRASE="secret";if(PHRASE.charCodeAt(keyPressState)===event.keyCode){if(++keyPressState<PHRASE.length){return}getRequiredElement("android-secret-container").classList.remove("invisible")}keyPressState=0}function refreshLogTable(tableId,data){const element=$(tableId);if(!element){return}removeAllChildNodes(element);if(data!==undefined){addRows(element,data)}}function setGcmInternalsInfo(infos){const recordingEl=getRequiredElement("recording");recordingEl.textContent=infos.isRecording?"Stop Recording":"Start Recording";recordingEl.disabled=false;if(infos.deviceInfo!==undefined){displayDeviceInfo(infos.deviceInfo)}refreshLogTable("checkin-info",infos.checkinInfo);refreshLogTable("connection-info",infos.connectionInfo);refreshLogTable("registration-info",infos.registrationInfo);refreshLogTable("receive-info",infos.receiveInfo);refreshLogTable("decryption-failure-info",infos.decryptionFailureInfo);refreshLogTable("send-info",infos.sendInfo)}document.addEventListener("DOMContentLoaded",initialize);document.addEventListener("keypress",handleKeyPress);