// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{getTemplate}from"./app.html.js";import{StructuredMetricsBrowserProxyImpl}from"./structured_metrics_browser_proxy.js";import{updateStructuredMetricsEvents,updateStructuredMetricsSummary}from"./structured_utils.js";function getSearchParams(){return window.location.search.substring(1)}export class StructuredMetricsInternalsAppElement extends CustomElement{static get is(){return"structured-metrics-internals-app"}static get template(){return getTemplate()}browserProxy_=StructuredMetricsBrowserProxyImpl.getInstance();summaryIntervalId_;initPromise;textSearch;searchQuery=null;searchError=false;constructor(){super();this.textSearch=this.getRequiredElement("#search-bar");this.initSearchParams_();this.initPromise=this.init_();this.summaryIntervalId_=setInterval((()=>this.updateStructuredMetricsSummary_()),5e3)}disconnectedCallback(){clearInterval(this.summaryIntervalId_)}async init_(){await this.updateStructuredMetricsSummary_();await this.updateStructuredMetricsEvents_();const eventRefreshButton=this.getRequiredElement("#sm-refresh-events");eventRefreshButton.addEventListener("click",(()=>this.updateStructuredMetricsEvents_()))}async updateStructuredMetricsSummary_(){const summary=await this.browserProxy_.fetchStructuredMetricsSummary();const template=this.getRequiredElement("#summary-row-template");const smSummaryBody=this.getRequiredElement("#sm-summary-body");updateStructuredMetricsSummary(smSummaryBody,summary,template)}async updateStructuredMetricsEvents_(){const events=await this.browserProxy_.fetchStructuredMetricsEvents();const eventTemplate=this.getRequiredElement("#structured-metrics-event-row-template");const eventDetailsTemplate=this.getRequiredElement("#structured-metrics-event-details-template");const kvTemplate=this.getRequiredElement("#summary-row-template");const eventTableBody=this.getRequiredElement("#sm-events-body");updateStructuredMetricsEvents(eventTableBody,events,this.searchQuery,eventTemplate,eventDetailsTemplate,kvTemplate)}initSearchParams_(){const searchString=this.sanitizeUrlToSearch_();this.searchQuery=this.parseSearchString_(searchString);this.textSearch.value=searchString;this.textSearch.addEventListener("search",(()=>{this.updateSearchCriteria_()}))}updateSearchCriteria_(){window.location.search="?"+this.sanitizeSearchToUrl_()}sanitizeSearchToUrl_(){return this.textSearch.value.replace(/\s+/gi,"&").replace(/:/gi,"=")}sanitizeUrlToSearch_(){return getSearchParams().replace(/&/gi," ").replace(/=/gi,":")}parseSearchString_(text){if(this.searchError){this.hideSearchErrorMessage_()}if(text.length===0){return null}if(text.indexOf(":")===-1){return null}const categories=new Map;const validSearchKeys=["project","event","metric"];text.split(" ").forEach((cat=>{const[key,value]=cat.split(":",2);if(key!==undefined&&value!==undefined){if(validSearchKeys.find((value=>value===key))===undefined){this.setSearchErrorMessage_(`invalid search key: ${key}. valid keys are project, event, metric`);return}categories.set(key,value)}}));return categories}hideSearchErrorMessage_(){this.searchError=false;const errorMsg=this.getRequiredElement("#search-error-msg");assert(errorMsg);errorMsg.style.display="none"}setSearchErrorMessage_(msg){this.searchError=true;const errorMsg=this.getRequiredElement("#search-error-msg");assert(errorMsg);errorMsg.innerText=msg;errorMsg.style.display="block"}}customElements.define(StructuredMetricsInternalsAppElement.is,StructuredMetricsInternalsAppElement);