// components/schema_org/common/metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/schema_org/common/metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('schemaOrg.mojom');



  function Property(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Property.prototype.initDefaults_ = function() {
    this.name = null;
    this.values = null;
  };
  Property.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Property.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Property.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Property.values
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, Values, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Property.encodedSize = codec.kStructHeaderSize + 24;

  Property.decode = function(decoder) {
    var packed;
    var val = new Property();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.values =
        decoder.decodeStruct(Values);
    return val;
  };

  Property.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Property.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(Values, val.values);
  };
  function Entity(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Entity.prototype.initDefaults_ = function() {
    this.type = null;
    this.properties = null;
  };
  Entity.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Entity.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Entity.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Entity.properties
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(Property), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Entity.encodedSize = codec.kStructHeaderSize + 16;

  Entity.decode = function(decoder) {
    var packed;
    var val = new Entity();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(codec.String);
    val.properties =
        decoder.decodeArrayPointer(new codec.PointerTo(Property));
    return val;
  };

  Entity.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Entity.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeArrayPointer(new codec.PointerTo(Property), val.properties);
  };

  function Values(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  Values.Tags = {
    boolValues: 0,
    longValues: 1,
    stringValues: 2,
    entityValues: 3,
  };

  Values.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  Values.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "boolValues",
        "longValues",
        "stringValues",
        "entityValues",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a Values member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(Values.prototype, "boolValues", {
    get: function() {
      if (this.$tag != Values.Tags.boolValues) {
        throw new ReferenceError(
            "Values.boolValues is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Values.Tags.boolValues;
      this.$data = value;
    }
  });
  Object.defineProperty(Values.prototype, "longValues", {
    get: function() {
      if (this.$tag != Values.Tags.longValues) {
        throw new ReferenceError(
            "Values.longValues is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Values.Tags.longValues;
      this.$data = value;
    }
  });
  Object.defineProperty(Values.prototype, "stringValues", {
    get: function() {
      if (this.$tag != Values.Tags.stringValues) {
        throw new ReferenceError(
            "Values.stringValues is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Values.Tags.stringValues;
      this.$data = value;
    }
  });
  Object.defineProperty(Values.prototype, "entityValues", {
    get: function() {
      if (this.$tag != Values.Tags.entityValues) {
        throw new ReferenceError(
            "Values.entityValues is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Values.Tags.entityValues;
      this.$data = value;
    }
  });


    Values.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case Values.Tags.boolValues:
          encoder.encodeArrayPointer(codec.PackedBool, val.boolValues);
          break;
        case Values.Tags.longValues:
          encoder.encodeArrayPointer(codec.Int64, val.longValues);
          break;
        case Values.Tags.stringValues:
          encoder.encodeArrayPointer(codec.String, val.stringValues);
          break;
        case Values.Tags.entityValues:
          encoder.encodeArrayPointer(new codec.PointerTo(Entity), val.entityValues);
          break;
      }
      encoder.align();
    };


    Values.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new Values();
      var tag = decoder.readUint32();
      switch (tag) {
        case Values.Tags.boolValues:
          result.boolValues = decoder.decodeArrayPointer(codec.PackedBool);
          break;
        case Values.Tags.longValues:
          result.longValues = decoder.decodeArrayPointer(codec.Int64);
          break;
        case Values.Tags.stringValues:
          result.stringValues = decoder.decodeArrayPointer(codec.String);
          break;
        case Values.Tags.entityValues:
          result.entityValues = decoder.decodeArrayPointer(new codec.PointerTo(Entity));
          break;
      }
      decoder.align();

      return result;
    };


    Values.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case Values.Tags.boolValues:
          

    // validate Values.boolValues
    err = messageValidator.validateArrayPointer(data_offset, 1, codec.PackedBool, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case Values.Tags.longValues:
          

    // validate Values.longValues
    err = messageValidator.validateArrayPointer(data_offset, 8, codec.Int64, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case Values.Tags.stringValues:
          

    // validate Values.stringValues
    err = messageValidator.validateArrayPointer(data_offset, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case Values.Tags.entityValues:
          

    // validate Values.entityValues
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(Entity), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  Values.encodedSize = 16;
  exports.Property = Property;
  exports.Entity = Entity;
  exports.Values = Values;
})();