// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getRequiredElement}from"chrome://resources/js/util.js";function truncateString(str){const maxLength=60;if(str.length<=maxLength){return str}return str.substring(0,maxLength)+"..."}function handleVariationInfo({variationsList:variationsList,variationsCmd:variationsCmd}){getRequiredElement("variations-section").hidden=!variationsList.length;for(const item of variationsList){getRequiredElement("variations-list").appendChild(document.createTextNode(item));getRequiredElement("variations-list").appendChild(document.createElement("br"))}const includeVariationsCmd=location.search.includes("show-variations-cmd");if(variationsCmd!==""){getRequiredElement("variations-cmd-section").hidden=false;getRequiredElement("copy-variations-to-clipboard").hidden=includeVariationsCmd;if(includeVariationsCmd){getRequiredElement("variations-cmd").textContent=variationsCmd}else{getRequiredElement("variations-cmd").textContent=truncateString(variationsCmd);getRequiredElement("variations-cmd").dataset["value"]=variationsCmd}}}function handlePathInfo({execPath:execPath,profilePath:profilePath}){getRequiredElement("executable_path").textContent=execPath;getRequiredElement("profile_path").textContent=profilePath}async function copyVersionToClipboard(){await navigator.clipboard.writeText(getRequiredElement("copy-content").innerText);announceCopy("copy_notice")}async function copyVariationsToClipboard(){const cmdLine=getRequiredElement("variations-cmd").dataset["value"];await navigator.clipboard.writeText(cmdLine);announceCopy("copy_variations_notice")}function announceCopy(id){const messagesDiv=getRequiredElement("messages");messagesDiv.innerHTML=window.trustedTypes.emptyHTML;const div=document.createElement("div");div.innerText=loadTimeData.getString(id);messagesDiv.append(div)}function initialize(){chrome.send("requestVersionInfo");const includeVariationsCmd=location.search.includes("show-variations-cmd");sendWithPromise("requestVariationInfo",includeVariationsCmd).then(handleVariationInfo);sendWithPromise("requestPathInfo").then(handlePathInfo);if(getRequiredElement("variations-seed").textContent!==""){getRequiredElement("variations-seed-section").hidden=false}if(getRequiredElement("sanitizer").textContent!==""){getRequiredElement("sanitizer-section").hidden=false}getRequiredElement("copy-to-clipboard").addEventListener("click",copyVersionToClipboard);getRequiredElement("copy-variations-to-clipboard").addEventListener("click",copyVariationsToClipboard)}document.addEventListener("DOMContentLoaded",initialize);