// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./private_aggregation_internals_table.js";import{assert}from"chrome://resources/js/assert.js";import{Factory as PrivateAggregationInternalsFactory,HandlerRemote as PrivateAggregationInternalsHandlerRemote,ObserverReceiver,ReportStatus}from"./private_aggregation_internals.mojom-webui.js";import{TableModel}from"./table_model.js";function compareDefault(a,b){return a<b?-1:a>b?1:0}function bucketReplacer(_key,value){if(_key==="bucket"){return(value["high"]*2n**64n+value["low"]).toString()}else{return value}}class ValueColumn{compare;header;minWidth;getValue;constructor(header,getValue,minWidth,compare){this.header=header;this.getValue=getValue;this.minWidth=minWidth;this.compare=compare??((a,b)=>compareDefault(getValue(a),getValue(b)))}render(td,row){if(this.minWidth){td.style.minWidth=this.minWidth}td.textContent=`${this.getValue(row)}`}renderHeader(th){th.textContent=`${this.header}`}}class DateColumn extends ValueColumn{constructor(header,getValue){super(header,getValue)}render(td,row){td.innerText=this.getValue(row).toLocaleString()}}class CodeColumn extends ValueColumn{constructor(header,getValue){super(header,getValue)}render(td,row){const code=td.ownerDocument.createElement("code");code.innerText=this.getValue(row);const pre=td.ownerDocument.createElement("pre");pre.appendChild(code);td.appendChild(pre)}}class Selectable{selectCheckbox;constructor(){this.selectCheckbox=document.createElement("input");this.selectCheckbox.type="checkbox"}}class SelectionColumn{compare;model;selectAllCheckbox;selectionChangedListeners;header;rowChangedListener;constructor(model){this.compare=null;this.model=model;this.header=null;this.selectAllCheckbox=document.createElement("input");this.selectAllCheckbox.type="checkbox";this.selectAllCheckbox.addEventListener("input",(()=>{const checked=this.selectAllCheckbox.checked;this.model.getRows().forEach((row=>{if(!row.selectCheckbox.disabled){row.selectCheckbox.checked=checked}}));this.notifySelectionChanged(checked)}));this.rowChangedListener=()=>this.onChange();this.model.rowsChangedListeners.add(this.rowChangedListener);this.selectionChangedListeners=new Set}render(td,row){td.appendChild(row.selectCheckbox)}renderHeader(th){th.appendChild(this.selectAllCheckbox)}onChange(){let anySelectable=false;let anySelected=false;let anyUnselected=false;this.model.getRows().forEach((row=>{row.selectCheckbox.addEventListener("input",this.rowChangedListener);if(row.selectCheckbox.disabled){return}anySelectable=true;if(row.selectCheckbox.checked){anySelected=true}else{anyUnselected=true}}));this.selectAllCheckbox.disabled=!anySelectable;this.selectAllCheckbox.checked=anySelected&&!anyUnselected;this.selectAllCheckbox.indeterminate=anySelected&&anyUnselected;this.notifySelectionChanged(anySelected)}notifySelectionChanged(anySelected){this.selectionChangedListeners.forEach((f=>f(anySelected)))}}function reportStatusToText(status){switch(status){case ReportStatus.kPending:return"Pending";case ReportStatus.kSent:return"Sent";case ReportStatus.kFailedToAssemble:return"Failed to assemble";case ReportStatus.kFailedToSend:return"Failed to send"}}class Report extends Selectable{id;reportBody;reportUrl;reportTime;status;apiIdentifier;apiVersion;contributions;constructor(mojo){super();this.id=mojo.id;this.reportBody=mojo.reportBody;this.reportUrl=mojo.reportUrl.url;this.reportTime=new Date(mojo.reportTime);this.apiIdentifier=mojo.apiIdentifier;this.apiVersion=mojo.apiVersion;if(mojo.status!==ReportStatus.kPending||mojo.id===undefined){this.selectCheckbox.disabled=true}this.status=reportStatusToText(mojo.status);this.contributions=JSON.stringify(mojo.contributions,bucketReplacer," ")}}class ReportTableModel extends TableModel{sendReportsButton;selectionColumn;handledReports=[];storedReports=[];constructor(sendReportsButton){super();this.sendReportsButton=sendReportsButton;this.selectionColumn=new SelectionColumn(this);this.cols=[this.selectionColumn,new ValueColumn("Status",(e=>e.status)),new ValueColumn("Report URL",(e=>e.reportUrl),"250px"),new DateColumn("Report Time",(e=>e.reportTime)),new ValueColumn("API identifier",(e=>e.apiIdentifier),"90px"),new ValueColumn("API version",(e=>e.apiVersion)),new CodeColumn("Contributions",(e=>e.contributions)),new CodeColumn("Report Body",(e=>e.reportBody))];this.sortIdx=3;assert(this.cols[this.sortIdx].header==="Report Time");this.emptyRowText="No sent or pending reports.";this.sendReportsButton.addEventListener("click",(()=>this.sendReports_()));this.selectionColumn.selectionChangedListeners.add((anySelected=>{this.sendReportsButton.disabled=!anySelected}))}getRows(){return this.handledReports.concat(this.storedReports)}setStoredReports(storedReports){this.storedReports=storedReports;this.notifyRowsChanged()}addHandledReport(report){if(this.handledReports.length>=1e3){this.handledReports=[]}this.handledReports.push(report);this.notifyRowsChanged()}clear(){this.storedReports=[];this.handledReports=[];this.notifyRowsChanged()}sendReports_(){const ids=[];this.storedReports.forEach((report=>{if(!report.selectCheckbox.disabled&&report.selectCheckbox.checked){ids.push(report.id)}}));if(ids.length===0){return}const previousText=this.sendReportsButton.innerText;this.sendReportsButton.disabled=true;this.sendReportsButton.innerText="Sending...";pageHandler.sendReports(ids).then((()=>{this.sendReportsButton.innerText=previousText}))}}let pageHandler=null;let reportTableModel=null;function updateReports(){pageHandler.getReports().then((response=>{reportTableModel.setStoredReports(response.reports.map((mojo=>new Report(mojo))))}))}function clearStorage(){reportTableModel.clear();pageHandler.clearStorage()}class Observer{onRequestStorageModified(){updateReports()}onReportHandled(mojo){reportTableModel.addHandledReport(new Report(mojo))}}document.addEventListener("DOMContentLoaded",(()=>{pageHandler=new PrivateAggregationInternalsHandlerRemote;const sendReports=document.querySelector("#send-reports");reportTableModel=new ReportTableModel(sendReports);const refresh=document.querySelector("#refresh");refresh.addEventListener("click",updateReports);const clearData=document.querySelector("#clear-data");clearData.addEventListener("click",clearStorage);const reportTable=document.querySelector("#reportTable");reportTable.setModel(reportTableModel);PrivateAggregationInternalsFactory.getRemote().create(new ObserverReceiver(new Observer).$.bindNewPipeAndPassRemote(),pageHandler.$.bindNewPipeAndPassReceiver());updateReports()}));