// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{BigBufferSpec as mojoBase_mojom_BigBufferSpec}from"//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js";import{TimeSpec as mojoBase_mojom_TimeSpec}from"//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";import{TokenSpec as mojoBase_mojom_TokenSpec}from"//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js";export const ReportUploadStateSpec={$:mojo.internal.Enum()};export var ReportUploadState;(function(ReportUploadState){ReportUploadState[ReportUploadState["MIN_VALUE"]=0]="MIN_VALUE";ReportUploadState[ReportUploadState["MAX_VALUE"]=3]="MAX_VALUE";ReportUploadState[ReportUploadState["kNotUploaded"]=0]="kNotUploaded";ReportUploadState[ReportUploadState["kPending"]=1]="kPending";ReportUploadState[ReportUploadState["kPending_UserRequested"]=2]="kPending_UserRequested";ReportUploadState[ReportUploadState["kUploaded"]=3]="kUploaded"})(ReportUploadState||(ReportUploadState={}));export const SkipUploadReasonSpec={$:mojo.internal.Enum()};export var SkipUploadReason;(function(SkipUploadReason){SkipUploadReason[SkipUploadReason["MIN_VALUE"]=0]="MIN_VALUE";SkipUploadReason[SkipUploadReason["MAX_VALUE"]=5]="MAX_VALUE";SkipUploadReason[SkipUploadReason["kNoSkip"]=0]="kNoSkip";SkipUploadReason[SkipUploadReason["kSizeLimitExceeded"]=1]="kSizeLimitExceeded";SkipUploadReason[SkipUploadReason["kNotAnonymized"]=2]="kNotAnonymized";SkipUploadReason[SkipUploadReason["kScenarioQuotaExceeded"]=3]="kScenarioQuotaExceeded";SkipUploadReason[SkipUploadReason["kUploadTimedOut"]=4]="kUploadTimedOut";SkipUploadReason[SkipUploadReason["kLocalScenario"]=5]="kLocalScenario"})(SkipUploadReason||(SkipUploadReason={}));export const TracingScenarioStateSpec={$:mojo.internal.Enum()};export var TracingScenarioState;(function(TracingScenarioState){TracingScenarioState[TracingScenarioState["MIN_VALUE"]=0]="MIN_VALUE";TracingScenarioState[TracingScenarioState["MAX_VALUE"]=7]="MAX_VALUE";TracingScenarioState[TracingScenarioState["kDisabled"]=0]="kDisabled";TracingScenarioState[TracingScenarioState["kEnabled"]=1]="kEnabled";TracingScenarioState[TracingScenarioState["kSetup"]=2]="kSetup";TracingScenarioState[TracingScenarioState["kStarting"]=3]="kStarting";TracingScenarioState[TracingScenarioState["kRecording"]=4]="kRecording";TracingScenarioState[TracingScenarioState["kStopping"]=5]="kStopping";TracingScenarioState[TracingScenarioState["kFinalizing"]=6]="kFinalizing";TracingScenarioState[TracingScenarioState["kCloning"]=7]="kCloning"})(TracingScenarioState||(TracingScenarioState={}));export class TracesInternalsHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"traces_internals.mojom.TracesInternalsHandlerFactory",scope)}}export class TracesInternalsHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(TracesInternalsHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(page,handler){this.proxy.sendMessage(0,TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,null,[page,handler],false)}}export class TracesInternalsHandlerFactoryReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TracesInternalsHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,null,impl.createPageHandler.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class TracesInternalsHandlerFactory{static get $interfaceName(){return"traces_internals.mojom.TracesInternalsHandlerFactory"}static getRemote(){let remote=new TracesInternalsHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class TracesInternalsHandlerFactoryCallbackRouter{helper_internal_;$;router_;createPageHandler;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TracesInternalsHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.createPageHandler=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,null,this.createPageHandler.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"traces_internals.mojom.PageHandler",scope)}}export class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}startTraceSession(configPb,enablePrivacyFilters){return this.proxy.sendMessage(0,PageHandler_StartTraceSession_ParamsSpec.$,PageHandler_StartTraceSession_ResponseParamsSpec.$,[configPb,enablePrivacyFilters],false)}cloneTraceSession(){return this.proxy.sendMessage(1,PageHandler_CloneTraceSession_ParamsSpec.$,PageHandler_CloneTraceSession_ResponseParamsSpec.$,[],false)}stopTraceSession(){return this.proxy.sendMessage(2,PageHandler_StopTraceSession_ParamsSpec.$,PageHandler_StopTraceSession_ResponseParamsSpec.$,[],false)}getTrackEventCategories(){return this.proxy.sendMessage(3,PageHandler_GetTrackEventCategories_ParamsSpec.$,PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,[],false)}getBufferUsage(){return this.proxy.sendMessage(4,PageHandler_GetBufferUsage_ParamsSpec.$,PageHandler_GetBufferUsage_ResponseParamsSpec.$,[],false)}getAllTraceReports(){return this.proxy.sendMessage(5,PageHandler_GetAllTraceReports_ParamsSpec.$,PageHandler_GetAllTraceReports_ResponseParamsSpec.$,[],false)}deleteSingleTrace(uuid){return this.proxy.sendMessage(6,PageHandler_DeleteSingleTrace_ParamsSpec.$,PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,[uuid],false)}deleteAllTraces(){return this.proxy.sendMessage(7,PageHandler_DeleteAllTraces_ParamsSpec.$,PageHandler_DeleteAllTraces_ResponseParamsSpec.$,[],false)}userUploadSingleTrace(uuid){return this.proxy.sendMessage(8,PageHandler_UserUploadSingleTrace_ParamsSpec.$,PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,[uuid],false)}downloadTrace(uuid){return this.proxy.sendMessage(9,PageHandler_DownloadTrace_ParamsSpec.$,PageHandler_DownloadTrace_ResponseParamsSpec.$,[uuid],false)}getAllScenarios(){return this.proxy.sendMessage(10,PageHandler_GetAllScenarios_ParamsSpec.$,PageHandler_GetAllScenarios_ResponseParamsSpec.$,[],false)}setEnabledScenarios(newConfig){return this.proxy.sendMessage(11,PageHandler_SetEnabledScenarios_ParamsSpec.$,PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,[newConfig],false)}setScenariosConfigFromString(configString){return this.proxy.sendMessage(12,PageHandler_SetScenariosConfigFromString_ParamsSpec.$,PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,[configString],false)}setScenariosConfigFromBuffer(configPb){return this.proxy.sendMessage(13,PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,[configPb],false)}getPrivacyFilterEnabled(){return this.proxy.sendMessage(14,PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,[],false)}setPrivacyFilterEnabled(enable){this.proxy.sendMessage(15,PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,null,[enable],false)}}export class PageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandler_StartTraceSession_ParamsSpec.$,PageHandler_StartTraceSession_ResponseParamsSpec.$,impl.startTraceSession.bind(impl),false);this.helper_internal_.registerHandler(1,PageHandler_CloneTraceSession_ParamsSpec.$,PageHandler_CloneTraceSession_ResponseParamsSpec.$,impl.cloneTraceSession.bind(impl),false);this.helper_internal_.registerHandler(2,PageHandler_StopTraceSession_ParamsSpec.$,PageHandler_StopTraceSession_ResponseParamsSpec.$,impl.stopTraceSession.bind(impl),false);this.helper_internal_.registerHandler(3,PageHandler_GetTrackEventCategories_ParamsSpec.$,PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,impl.getTrackEventCategories.bind(impl),false);this.helper_internal_.registerHandler(4,PageHandler_GetBufferUsage_ParamsSpec.$,PageHandler_GetBufferUsage_ResponseParamsSpec.$,impl.getBufferUsage.bind(impl),false);this.helper_internal_.registerHandler(5,PageHandler_GetAllTraceReports_ParamsSpec.$,PageHandler_GetAllTraceReports_ResponseParamsSpec.$,impl.getAllTraceReports.bind(impl),false);this.helper_internal_.registerHandler(6,PageHandler_DeleteSingleTrace_ParamsSpec.$,PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,impl.deleteSingleTrace.bind(impl),false);this.helper_internal_.registerHandler(7,PageHandler_DeleteAllTraces_ParamsSpec.$,PageHandler_DeleteAllTraces_ResponseParamsSpec.$,impl.deleteAllTraces.bind(impl),false);this.helper_internal_.registerHandler(8,PageHandler_UserUploadSingleTrace_ParamsSpec.$,PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,impl.userUploadSingleTrace.bind(impl),false);this.helper_internal_.registerHandler(9,PageHandler_DownloadTrace_ParamsSpec.$,PageHandler_DownloadTrace_ResponseParamsSpec.$,impl.downloadTrace.bind(impl),false);this.helper_internal_.registerHandler(10,PageHandler_GetAllScenarios_ParamsSpec.$,PageHandler_GetAllScenarios_ResponseParamsSpec.$,impl.getAllScenarios.bind(impl),false);this.helper_internal_.registerHandler(11,PageHandler_SetEnabledScenarios_ParamsSpec.$,PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,impl.setEnabledScenarios.bind(impl),false);this.helper_internal_.registerHandler(12,PageHandler_SetScenariosConfigFromString_ParamsSpec.$,PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,impl.setScenariosConfigFromString.bind(impl),false);this.helper_internal_.registerHandler(13,PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,impl.setScenariosConfigFromBuffer.bind(impl),false);this.helper_internal_.registerHandler(14,PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,impl.getPrivacyFilterEnabled.bind(impl),false);this.helper_internal_.registerHandler(15,PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,null,impl.setPrivacyFilterEnabled.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandler{static get $interfaceName(){return"traces_internals.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerCallbackRouter{helper_internal_;$;router_;startTraceSession;cloneTraceSession;stopTraceSession;getTrackEventCategories;getBufferUsage;getAllTraceReports;deleteSingleTrace;deleteAllTraces;userUploadSingleTrace;downloadTrace;getAllScenarios;setEnabledScenarios;setScenariosConfigFromString;setScenariosConfigFromBuffer;getPrivacyFilterEnabled;setPrivacyFilterEnabled;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.startTraceSession=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandler_StartTraceSession_ParamsSpec.$,PageHandler_StartTraceSession_ResponseParamsSpec.$,this.startTraceSession.createReceiverHandler(true),false);this.cloneTraceSession=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PageHandler_CloneTraceSession_ParamsSpec.$,PageHandler_CloneTraceSession_ResponseParamsSpec.$,this.cloneTraceSession.createReceiverHandler(true),false);this.stopTraceSession=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PageHandler_StopTraceSession_ParamsSpec.$,PageHandler_StopTraceSession_ResponseParamsSpec.$,this.stopTraceSession.createReceiverHandler(true),false);this.getTrackEventCategories=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PageHandler_GetTrackEventCategories_ParamsSpec.$,PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,this.getTrackEventCategories.createReceiverHandler(true),false);this.getBufferUsage=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PageHandler_GetBufferUsage_ParamsSpec.$,PageHandler_GetBufferUsage_ResponseParamsSpec.$,this.getBufferUsage.createReceiverHandler(true),false);this.getAllTraceReports=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PageHandler_GetAllTraceReports_ParamsSpec.$,PageHandler_GetAllTraceReports_ResponseParamsSpec.$,this.getAllTraceReports.createReceiverHandler(true),false);this.deleteSingleTrace=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,PageHandler_DeleteSingleTrace_ParamsSpec.$,PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,this.deleteSingleTrace.createReceiverHandler(true),false);this.deleteAllTraces=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,PageHandler_DeleteAllTraces_ParamsSpec.$,PageHandler_DeleteAllTraces_ResponseParamsSpec.$,this.deleteAllTraces.createReceiverHandler(true),false);this.userUploadSingleTrace=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,PageHandler_UserUploadSingleTrace_ParamsSpec.$,PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,this.userUploadSingleTrace.createReceiverHandler(true),false);this.downloadTrace=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,PageHandler_DownloadTrace_ParamsSpec.$,PageHandler_DownloadTrace_ResponseParamsSpec.$,this.downloadTrace.createReceiverHandler(true),false);this.getAllScenarios=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,PageHandler_GetAllScenarios_ParamsSpec.$,PageHandler_GetAllScenarios_ResponseParamsSpec.$,this.getAllScenarios.createReceiverHandler(true),false);this.setEnabledScenarios=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,PageHandler_SetEnabledScenarios_ParamsSpec.$,PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,this.setEnabledScenarios.createReceiverHandler(true),false);this.setScenariosConfigFromString=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,PageHandler_SetScenariosConfigFromString_ParamsSpec.$,PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,this.setScenariosConfigFromString.createReceiverHandler(true),false);this.setScenariosConfigFromBuffer=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,this.setScenariosConfigFromBuffer.createReceiverHandler(true),false);this.getPrivacyFilterEnabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,this.getPrivacyFilterEnabled.createReceiverHandler(true),false);this.setPrivacyFilterEnabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,null,this.setPrivacyFilterEnabled.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"traces_internals.mojom.Page",scope)}}export class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onTraceComplete(trace,uuid){this.proxy.sendMessage(0,Page_OnTraceComplete_ParamsSpec.$,null,[trace,uuid],false)}}export class PageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Page_OnTraceComplete_ParamsSpec.$,null,impl.onTraceComplete.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Page{static get $interfaceName(){return"traces_internals.mojom.Page"}static getRemote(){let remote=new PageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageCallbackRouter{helper_internal_;$;router_;onTraceComplete;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onTraceComplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnTraceComplete_ParamsSpec.$,null,this.onTraceComplete.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const ClientTraceReportSpec={$:{}};export const ScenarioSpec={$:{}};export const TraceCategorySpec={$:{}};export const TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec={$:{}};export const PageHandler_StartTraceSession_ParamsSpec={$:{}};export const PageHandler_StartTraceSession_ResponseParamsSpec={$:{}};export const PageHandler_CloneTraceSession_ParamsSpec={$:{}};export const PageHandler_CloneTraceSession_ResponseParamsSpec={$:{}};export const PageHandler_StopTraceSession_ParamsSpec={$:{}};export const PageHandler_StopTraceSession_ResponseParamsSpec={$:{}};export const PageHandler_GetTrackEventCategories_ParamsSpec={$:{}};export const PageHandler_GetTrackEventCategories_ResponseParamsSpec={$:{}};export const PageHandler_GetBufferUsage_ParamsSpec={$:{}};export const PageHandler_GetBufferUsage_ResponseParamsSpec={$:{}};export const PageHandler_GetAllTraceReports_ParamsSpec={$:{}};export const PageHandler_GetAllTraceReports_ResponseParamsSpec={$:{}};export const PageHandler_DeleteSingleTrace_ParamsSpec={$:{}};export const PageHandler_DeleteSingleTrace_ResponseParamsSpec={$:{}};export const PageHandler_DeleteAllTraces_ParamsSpec={$:{}};export const PageHandler_DeleteAllTraces_ResponseParamsSpec={$:{}};export const PageHandler_UserUploadSingleTrace_ParamsSpec={$:{}};export const PageHandler_UserUploadSingleTrace_ResponseParamsSpec={$:{}};export const PageHandler_DownloadTrace_ParamsSpec={$:{}};export const PageHandler_DownloadTrace_ResponseParamsSpec={$:{}};export const PageHandler_GetAllScenarios_ParamsSpec={$:{}};export const PageHandler_GetAllScenarios_ResponseParamsSpec={$:{}};export const PageHandler_SetEnabledScenarios_ParamsSpec={$:{}};export const PageHandler_SetEnabledScenarios_ResponseParamsSpec={$:{}};export const PageHandler_SetScenariosConfigFromString_ParamsSpec={$:{}};export const PageHandler_SetScenariosConfigFromString_ResponseParamsSpec={$:{}};export const PageHandler_SetScenariosConfigFromBuffer_ParamsSpec={$:{}};export const PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec={$:{}};export const PageHandler_GetPrivacyFilterEnabled_ParamsSpec={$:{}};export const PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec={$:{}};export const PageHandler_SetPrivacyFilterEnabled_ParamsSpec={$:{}};export const Page_OnTraceComplete_ParamsSpec={$:{}};mojo.internal.Struct(ClientTraceReportSpec.$,"ClientTraceReport",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_TokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("creationTime",8,0,mojoBase_mojom_TimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("scenarioName",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("uploadRuleName",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("upload_rule_value_$flag",32,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"upload_rule_value_$value",originalFieldName:"uploadRuleValue"},undefined),mojo.internal.StructField("upload_rule_value_$value",36,0,mojo.internal.Int32,0,false,0,{isPrimary:false,originalFieldName:"uploadRuleValue"},undefined),mojo.internal.StructField("totalSize",40,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("uploadState",48,0,ReportUploadStateSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("uploadTime",56,0,mojoBase_mojom_TimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("skipReason",52,0,SkipUploadReasonSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("hasTraceContent",32,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,72]]);mojo.internal.Struct(ScenarioSpec.$,"Scenario",[mojo.internal.StructField("scenarioName",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("description",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isLocalScenario",16,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isEnabled",16,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("currentState",20,0,TracingScenarioStateSpec.$,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(TraceCategorySpec.$,"TraceCategory",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isGroup",8,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("description",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("tags",24,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(TracesInternalsHandlerFactory_CreatePageHandler_ParamsSpec.$,"TracesInternalsHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_StartTraceSession_ParamsSpec.$,"PageHandler_StartTraceSession_Params",[mojo.internal.StructField("configPb",0,0,mojoBase_mojom_BigBufferSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("enablePrivacyFilters",16,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_StartTraceSession_ResponseParamsSpec.$,"PageHandler_StartTraceSession_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_CloneTraceSession_ParamsSpec.$,"PageHandler_CloneTraceSession_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_CloneTraceSession_ResponseParamsSpec.$,"PageHandler_CloneTraceSession_ResponseParams",[mojo.internal.StructField("trace",0,0,mojoBase_mojom_BigBufferSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("uuid",16,0,mojoBase_mojom_TokenSpec.$,null,true,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_StopTraceSession_ParamsSpec.$,"PageHandler_StopTraceSession_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_StopTraceSession_ResponseParamsSpec.$,"PageHandler_StopTraceSession_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTrackEventCategories_ParamsSpec.$,"PageHandler_GetTrackEventCategories_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetTrackEventCategories_ResponseParamsSpec.$,"PageHandler_GetTrackEventCategories_ResponseParams",[mojo.internal.StructField("categories",0,0,mojo.internal.Array(TraceCategorySpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetBufferUsage_ParamsSpec.$,"PageHandler_GetBufferUsage_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetBufferUsage_ResponseParamsSpec.$,"PageHandler_GetBufferUsage_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("percentFull",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("dataLoss",0,1,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetAllTraceReports_ParamsSpec.$,"PageHandler_GetAllTraceReports_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetAllTraceReports_ResponseParamsSpec.$,"PageHandler_GetAllTraceReports_ResponseParams",[mojo.internal.StructField("reports",0,0,mojo.internal.Array(ClientTraceReportSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_DeleteSingleTrace_ParamsSpec.$,"PageHandler_DeleteSingleTrace_Params",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_TokenSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_DeleteSingleTrace_ResponseParamsSpec.$,"PageHandler_DeleteSingleTrace_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_DeleteAllTraces_ParamsSpec.$,"PageHandler_DeleteAllTraces_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_DeleteAllTraces_ResponseParamsSpec.$,"PageHandler_DeleteAllTraces_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_UserUploadSingleTrace_ParamsSpec.$,"PageHandler_UserUploadSingleTrace_Params",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_TokenSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_UserUploadSingleTrace_ResponseParamsSpec.$,"PageHandler_UserUploadSingleTrace_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_DownloadTrace_ParamsSpec.$,"PageHandler_DownloadTrace_Params",[mojo.internal.StructField("uuid",0,0,mojoBase_mojom_TokenSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_DownloadTrace_ResponseParamsSpec.$,"PageHandler_DownloadTrace_ResponseParams",[mojo.internal.StructField("trace",0,0,mojoBase_mojom_BigBufferSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_GetAllScenarios_ParamsSpec.$,"PageHandler_GetAllScenarios_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetAllScenarios_ResponseParamsSpec.$,"PageHandler_GetAllScenarios_ResponseParams",[mojo.internal.StructField("config",0,0,mojo.internal.Array(ScenarioSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetEnabledScenarios_ParamsSpec.$,"PageHandler_SetEnabledScenarios_Params",[mojo.internal.StructField("newConfig",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetEnabledScenarios_ResponseParamsSpec.$,"PageHandler_SetEnabledScenarios_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetScenariosConfigFromString_ParamsSpec.$,"PageHandler_SetScenariosConfigFromString_Params",[mojo.internal.StructField("configString",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetScenariosConfigFromString_ResponseParamsSpec.$,"PageHandler_SetScenariosConfigFromString_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetScenariosConfigFromBuffer_ParamsSpec.$,"PageHandler_SetScenariosConfigFromBuffer_Params",[mojo.internal.StructField("configPb",0,0,mojoBase_mojom_BigBufferSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_SetScenariosConfigFromBuffer_ResponseParamsSpec.$,"PageHandler_SetScenariosConfigFromBuffer_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetPrivacyFilterEnabled_ParamsSpec.$,"PageHandler_GetPrivacyFilterEnabled_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetPrivacyFilterEnabled_ResponseParamsSpec.$,"PageHandler_GetPrivacyFilterEnabled_ResponseParams",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetPrivacyFilterEnabled_ParamsSpec.$,"PageHandler_SetPrivacyFilterEnabled_Params",[mojo.internal.StructField("enable",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnTraceComplete_ParamsSpec.$,"Page_OnTraceComplete_Params",[mojo.internal.StructField("trace",0,0,mojoBase_mojom_BigBufferSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("uuid",16,0,mojoBase_mojom_TokenSpec.$,null,true,0,undefined,undefined)],[[0,32]]);